/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.cpp.valgrind.ValgrindHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValgrindOutputConsumer
implements Consumer<String>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ValgrindOutputConsumer.class.getName());
    private PipedOutputStream myPipedOutputStream;
    private PipedInputStream myPipedInputStream;
    private SAXParser myParser;
    private Future<?> myParseTask;

    public ValgrindOutputConsumer(@NotNull ValgrindHandler handler) {
        if (handler == null) {
            ValgrindOutputConsumer.$$$reportNull$$$0(0);
        }
        try {
            this.myPipedOutputStream = new PipedOutputStream();
            this.myPipedInputStream = new PipedInputStream(this.myPipedOutputStream);
            this.myParser = SAXParserFactory.newInstance().newSAXParser();
            this.myParseTask = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (handler == null) {
                    ValgrindOutputConsumer.$$$reportNull$$$0(1);
                }
                try {
                    this.myParser.parse((InputStream)this.myPipedInputStream, (DefaultHandler)handler);
                }
                catch (IOException | SAXException e) {
                    LOG.warn((Throwable)e);
                }
            });
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void consume(String s) {
        try {
            this.myPipedOutputStream.write(s.getBytes(StandardCharsets.UTF_8));
            this.myPipedOutputStream.flush();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void dispose() {
        ValgrindOutputConsumer.tryClose(this.myPipedOutputStream);
        ValgrindOutputConsumer.tryStop(this.myParseTask);
        ValgrindOutputConsumer.tryClose(this.myPipedInputStream);
    }

    private static void tryClose(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void tryStop(@Nullable Future<?> task) {
        try {
            if (task != null) {
                task.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "handler";
        objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindOutputConsumer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

