/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ValgrindSettings", storages={@Storage(value="other.xml")})
public class ValgrindSettings
implements PersistentStateComponent<ValgrindSettings> {
    @NotNull
    private String myValgrindPath;
    @NotNull
    private String myAnalysisOptions;
    @NotNull
    private List<String> mySuppressionFiles;

    public ValgrindSettings() {
        File detectedValgrindExecutable = PathEnvironmentVariableUtil.findInPath((String)"valgrind");
        this.myValgrindPath = detectedValgrindExecutable != null ? detectedValgrindExecutable.getPath() : "";
        this.myAnalysisOptions = ValgrindSettings.getDefaultAnalysisOptions();
        this.mySuppressionFiles = Collections.emptyList();
    }

    @Nullable
    public ValgrindSettings getState() {
        return this;
    }

    public void loadState(@NotNull ValgrindSettings state) {
        if (state == null) {
            ValgrindSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @NotNull
    public static ValgrindSettings getInstance() {
        ValgrindSettings valgrindSettings = (ValgrindSettings)ServiceManager.getService(ValgrindSettings.class);
        if (valgrindSettings == null) {
            ValgrindSettings.$$$reportNull$$$0(1);
        }
        return valgrindSettings;
    }

    @NotNull
    public synchronized String getValgrindPath() {
        String string = this.myValgrindPath;
        if (string == null) {
            ValgrindSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public synchronized void setValgrindPath(@NotNull String valgrindPath) {
        if (valgrindPath == null) {
            ValgrindSettings.$$$reportNull$$$0(3);
        }
        this.myValgrindPath = valgrindPath;
    }

    @NotNull
    public synchronized String getAnalysisOptions() {
        String string = this.myAnalysisOptions;
        if (string == null) {
            ValgrindSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public synchronized void setAnalysisOptions(@NotNull String analysisOptions) {
        if (analysisOptions == null) {
            ValgrindSettings.$$$reportNull$$$0(5);
        }
        this.myAnalysisOptions = analysisOptions;
    }

    @NotNull
    public synchronized List<String> getSuppressionFiles() {
        List<String> list = this.mySuppressionFiles;
        if (list == null) {
            ValgrindSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    public synchronized void setSuppressionFiles(@NotNull List<String> suppressionFiles) {
        if (suppressionFiles == null) {
            ValgrindSettings.$$$reportNull$$$0(7);
        }
        this.mySuppressionFiles = ContainerUtil.newUnmodifiableList(suppressionFiles);
    }

    @NotNull
    public static String getDefaultAnalysisOptions() {
        if ("--leak-check=full --leak-resolution=med  --track-origins=yes" == null) {
            ValgrindSettings.$$$reportNull$$$0(8);
        }
        return "--leak-check=full --leak-resolution=med  --track-origins=yes";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ValgrindSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valgrindPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressionFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValgrindPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAnalysisOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValgrindPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAnalysisOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSuppressionFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

