/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindNavigationData;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindStack;
import com.jetbrains.cidr.cpp.valgrind.model.ValgrindTreeDataModel;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindTreeNode;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindUtil {
    private ValgrindUtil() {
    }

    public static boolean isAvailableForPlatform() {
        Application application = ApplicationManager.getApplication();
        if (application.isInternal()) {
            return true;
        }
        return !SystemInfo.isWindows || WSLCidrUtil.hasAvailableDistributions();
    }

    @Nullable
    public static Document getDocument(@Nullable PsiFile file, @NotNull Project project2) {
        if (project2 == null) {
            ValgrindUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)project2).getDocument(file);
    }

    public static JTextArea createTextArea(@NotNull String text) {
        if (text == null) {
            ValgrindUtil.$$$reportNull$$$0(1);
        }
        JTextArea textArea = new JTextArea(text);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFocusable(true);
        textArea.setOpaque(false);
        textArea.setBackground(UIManager.getColor("Label.background"));
        textArea.setBorder(UIManager.getBorder("Label.border"));
        textArea.setFont(UIManager.getFont("Label.font"));
        return textArea;
    }

    @Nullable
    public static ValgrindFrame getInnermostNavigatableStackFrame(@NotNull ValgrindStack stack) {
        if (stack == null) {
            ValgrindUtil.$$$reportNull$$$0(2);
        }
        return stack.getFrames().stream().filter(frame -> StringUtil.isNotEmpty((String)frame.getDirectory()) && StringUtil.isNotEmpty((String)frame.getFile())).findFirst().orElse(null);
    }

    public static void removeNode(@NotNull ValgrindTreeNode node, @NotNull ValgrindTreeDataModel dataModel) {
        ValgrindTreeNode parentNode;
        if (node == null) {
            ValgrindUtil.$$$reportNull$$$0(3);
        }
        if (dataModel == null) {
            ValgrindUtil.$$$reportNull$$$0(4);
        }
        ValgrindTreeNode nodeToRemove = node;
        for (parentNode = (ValgrindTreeNode)node.getParent(); parentNode != null && parentNode != dataModel.getRoot() && parentNode.getChildCount() == 1; parentNode = (ValgrindTreeNode)parentNode.getParent()) {
            nodeToRemove = parentNode;
        }
        dataModel.removeNodeFromParent(nodeToRemove);
        dataModel.nodeChanged(parentNode);
    }

    @Nullable
    public static ValgrindNavigationData getNavigationData(@NotNull ValgrindFrame frame) {
        if (frame == null) {
            ValgrindUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)frame.getDirectory()) || StringUtil.isEmpty((String)frame.getFile())) {
            return null;
        }
        String filePath = FileUtil.join((String[])new String[]{frame.getDirectory(), frame.getFile()});
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
        if (document == null) {
            return null;
        }
        int lineNumber = StringUtil.parseInt((String)frame.getLine(), (int)-1) - 1;
        return new ValgrindNavigationData(virtualFile, document, lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTextArea";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInnermostNavigatableStackFrame";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNavigationData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

