/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.valgrind.ValgrindDataKeys;
import com.jetbrains.cidr.cpp.valgrind.ValgrindUtil;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindError;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import com.jetbrains.cidr.cpp.valgrind.model.ValgrindTreeDataModel;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindErrorTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindTreeNode;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ValgrindSuppressAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ValgrindSuppressAction.class);

    public void update(AnActionEvent e) {
        ValgrindError errorToSuppress;
        super.update(e);
        DataContext context = e.getDataContext();
        ValgrindTreeDataModel treeDataModel = (ValgrindTreeDataModel)ValgrindDataKeys.TREE_MODEL.getData(context);
        ValgrindTreeNode selectedNode = (ValgrindTreeNode)ValgrindDataKeys.SELECTED_NODE.getData(context);
        ValgrindError valgrindError = errorToSuppress = selectedNode instanceof ValgrindErrorTreeNode ? ((ValgrindErrorTreeNode)selectedNode).getError() : null;
        if (treeDataModel == null || errorToSuppress == null) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        ValgrindError errorToSuppress;
        ValgrindTreeNode selectedNode = (ValgrindTreeNode)ValgrindDataKeys.SELECTED_NODE.getData(e.getDataContext());
        ValgrindTreeDataModel treeDataModel = (ValgrindTreeDataModel)ValgrindDataKeys.TREE_MODEL.getData(e.getDataContext());
        ValgrindError valgrindError = errorToSuppress = selectedNode instanceof ValgrindErrorTreeNode ? ((ValgrindErrorTreeNode)selectedNode).getError() : null;
        if (treeDataModel == null || errorToSuppress == null) {
            LOG.warn("Failed to apply ValgrindSuppressAction, because either ValgrindTreeDataModel or ValgrindError is null");
            return;
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"supp");
        descriptor2.setTitle("Choose Suppression File");
        descriptor2.setDescription("Choose file in which suppression will be added");
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, null, files -> {
            String suppressionFilePath = ((VirtualFile)files.get(0)).getPath();
            if (!FileUtil.exists((String)suppressionFilePath)) {
                LOG.warn("Failed to append suppression, because file does not exist");
                return;
            }
            try {
                FileUtil.appendToFile((File)new File(suppressionFilePath), (String)ValgrindSuppressAction.getSuppression(errorToSuppress));
                treeDataModel.remove(errorToSuppress);
                ValgrindUtil.removeNode(selectedNode, treeDataModel);
            }
            catch (IOException exc) {
                LOG.warn("Failed to append suppression: " + exc);
            }
        });
    }

    @NotNull
    private static String getSuppression(@NotNull ValgrindError error) {
        if (error == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(0);
        }
        String suppression = error.getRawSuppression();
        ValgrindFrame frame = error.getStack().getFrames().stream().filter(f -> StringUtil.isNotEmpty((String)f.getFunction()) || StringUtil.isNotEmpty((String)f.getObject())).findFirst().orElse(null);
        String suppressionName = frame == null ? "Suppression" : (StringUtil.isNotEmpty((String)frame.getFunction()) ? frame.getFunction() : frame.getObject());
        suppression = suppression.replace("<insert_a_suppression_name_here>", suppressionName);
        suppression = suppression.trim();
        String string = "\n" + suppression + "\n";
        if (string == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/actions/ValgrindSuppressAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/actions/ValgrindSuppressAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppression";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

