/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindUtil;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindAuxiliaryData;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindError;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindStack;
import com.jetbrains.cidr.cpp.valgrind.tree.ValgrindTreeGrouping;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindAuxiliaryMessageTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindDirectoryTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindErrorKindTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindErrorTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindFileTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindRootTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindStackFrameTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindTreeNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindTreeDataModel
extends DefaultTreeModel {
    public static final Comparator<ValgrindTreeNode> COMPARATOR = Comparator.comparing(ValgrindTreeNode::toString);
    @NotNull
    private final Set<ValgrindError> myErrors;
    @NotNull
    private ValgrindTreeGrouping myGrouping;
    @NotNull
    private final Project myProject;

    public ValgrindTreeDataModel(@NotNull Project project2) {
        if (project2 == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(0);
        }
        super(new ValgrindRootTreeNode(project2));
        this.myErrors = new LinkedHashSet<ValgrindError>();
        this.myGrouping = ValgrindTreeGrouping.GROUP_BY_KIND;
        this.myProject = project2;
    }

    @NotNull
    public List<ValgrindError> getErrors() {
        List<ValgrindError> list = Collections.unmodifiableList(ContainerUtil.newArrayList(this.myErrors));
        if (list == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean hasErrors() {
        return !this.myErrors.isEmpty();
    }

    public boolean retainAll(@NotNull Collection<ValgrindError> errors) {
        if (errors == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(2);
        }
        return this.myErrors.retainAll(errors);
    }

    public boolean remove(@NotNull ValgrindError error) {
        if (error == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(3);
        }
        return this.myErrors.remove(error);
    }

    public void addError(@NotNull ValgrindError error) {
        if (error == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(4);
        }
        this.myErrors.add(error);
        this.insertToTree(error);
        if (this.myErrors.size() == 1) {
            this.nodeStructureChanged((TreeNode)this.getRoot());
        }
    }

    @NotNull
    public ValgrindTreeGrouping getGrouping() {
        ValgrindTreeGrouping valgrindTreeGrouping = this.myGrouping;
        if (valgrindTreeGrouping == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(5);
        }
        return valgrindTreeGrouping;
    }

    public void groupBy(@NotNull ValgrindTreeGrouping grouping) {
        if (grouping == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(6);
        }
        if (this.myGrouping == grouping) {
            return;
        }
        this.myGrouping = grouping;
        ValgrindRootTreeNode rootNode = (ValgrindRootTreeNode)this.getRoot();
        rootNode.removeAllChildren();
        for (ValgrindError error : this.myErrors) {
            this.insertToTree(error);
        }
        this.nodeStructureChanged(rootNode);
    }

    private void insertToTree(@NotNull ValgrindError error) {
        String innermostDirectory;
        if (error == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(7);
        }
        ValgrindTreeNode parentNode = (ValgrindRootTreeNode)this.getRoot();
        ValgrindStack stack = error.getStack();
        ValgrindFrame innermostStackFrame = ValgrindUtil.getInnermostNavigatableStackFrame(stack);
        String innermostFile = innermostStackFrame != null ? innermostStackFrame.getFile() : null;
        String string = innermostDirectory = innermostStackFrame != null ? innermostStackFrame.getDirectory() : null;
        if (this.myGrouping == ValgrindTreeGrouping.GROUP_BY_DIRECTORY) {
            parentNode = this.tryAppendDirectory(parentNode, innermostDirectory);
            parentNode = this.tryAppendFileName(parentNode, innermostDirectory, innermostFile);
            parentNode = this.tryAppendErrorKind(parentNode, error.getKind());
        } else {
            parentNode = this.tryAppendErrorKind(parentNode, error.getKind());
            parentNode = this.tryAppendFileName(parentNode, innermostDirectory, innermostFile);
        }
        parentNode = this.appendErrorMessage(parentNode, error);
        this.appendStack(parentNode, stack);
        this.appendAuxiliaryData(parentNode, error.getAuxiliaryDataList());
    }

    private ValgrindTreeNode tryAppendDirectory(@NotNull ValgrindTreeNode parentNode, @Nullable String directory) {
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(8);
        }
        if (directory != null) {
            List directoryParts = FileUtil.splitPath((String)directory);
            for (String directoryPart : directoryParts) {
                if (!StringUtil.isNotEmpty((String)directoryPart)) continue;
                parentNode = this.tryInsertNode(new ValgrindDirectoryTreeNode(directoryPart), parentNode);
            }
        }
        return parentNode;
    }

    private ValgrindTreeNode tryAppendFileName(@NotNull ValgrindTreeNode parentNode, @Nullable String directory, @Nullable String fileName) {
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(9);
        }
        if (directory != null && fileName != null) {
            parentNode = this.tryInsertNode(new ValgrindFileTreeNode(directory, fileName, this.myProject), parentNode);
        }
        return parentNode;
    }

    private ValgrindTreeNode tryAppendErrorKind(@NotNull ValgrindTreeNode parentNode, @Nullable String errorKind) {
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(10);
        }
        if (StringUtil.isNotEmpty((String)errorKind)) {
            parentNode = this.tryInsertNode(new ValgrindErrorKindTreeNode(errorKind), parentNode);
        }
        return parentNode;
    }

    private ValgrindTreeNode appendErrorMessage(@NotNull ValgrindTreeNode parentNode, @NotNull ValgrindError error) {
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(11);
        }
        if (error == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(12);
        }
        ValgrindErrorTreeNode errorTreeNode = new ValgrindErrorTreeNode(error);
        TreeUtil.insertNode((MutableTreeNode)errorTreeNode, (MutableTreeNode)parentNode, (DefaultTreeModel)this, (boolean)true, COMPARATOR);
        return errorTreeNode;
    }

    private void appendStack(@NotNull ValgrindTreeNode parentNode, @NotNull ValgrindStack stack) {
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(13);
        }
        if (stack == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(14);
        }
        List stackFrameTreeNodes = stack.getFrames().stream().map(frame -> new ValgrindStackFrameTreeNode((ValgrindFrame)frame, this.myProject)).collect(Collectors.toList());
        TreeUtil.addChildrenTo((MutableTreeNode)parentNode, stackFrameTreeNodes);
    }

    private void appendAuxiliaryData(@NotNull ValgrindTreeNode parentNode, @NotNull List<ValgrindAuxiliaryData> auxiliaryDataList) {
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(15);
        }
        if (auxiliaryDataList == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(16);
        }
        for (ValgrindAuxiliaryData auxiliaryData : auxiliaryDataList) {
            if (auxiliaryData.isMessage()) {
                ValgrindAuxiliaryMessageTreeNode messageTreeNode = new ValgrindAuxiliaryMessageTreeNode(auxiliaryData.getMessage());
                parentNode.insert(messageTreeNode, parentNode.getChildCount());
                continue;
            }
            if (!auxiliaryData.isStack()) continue;
            this.appendStack(parentNode, auxiliaryData.getStack());
        }
    }

    private ValgrindTreeNode tryInsertNode(@NotNull ValgrindTreeNode nodeToInsert, @NotNull ValgrindTreeNode parentNode) {
        int index;
        if (nodeToInsert == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(17);
        }
        if (parentNode == null) {
            ValgrindTreeDataModel.$$$reportNull$$$0(18);
        }
        if ((index = TreeUtil.indexedBinarySearch((TreeNode)parentNode, (TreeNode)nodeToInsert, COMPARATOR)) >= 0) {
            return (ValgrindTreeNode)parentNode.getChildAt(index);
        }
        TreeUtil.insertNode((MutableTreeNode)nodeToInsert, (MutableTreeNode)parentNode, (DefaultTreeModel)this, COMPARATOR);
        return nodeToInsert;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/model/ValgrindTreeDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxiliaryDataList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeToInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/model/ValgrindTreeDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertToTree";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryAppendDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryAppendFileName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryAppendErrorKind";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendErrorMessage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendStack";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendAuxiliaryData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryInsertNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

