/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.cidr.cpp.valgrind.ValgrindNavigationData;
import com.jetbrains.cidr.cpp.valgrind.ValgrindUtil;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindNodeTextData;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindTreeNode;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindStackFrameTreeNode
extends ValgrindTreeNode {
    @NotNull
    private final ValgrindFrame myFrame;
    @NotNull
    private final Project myProject;

    public ValgrindStackFrameTreeNode(@NotNull ValgrindFrame frame, @NotNull Project project2) {
        if (frame == null) {
            ValgrindStackFrameTreeNode.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ValgrindStackFrameTreeNode.$$$reportNull$$$0(1);
        }
        super(frame);
        this.myFrame = frame;
        this.myProject = project2;
    }

    @NotNull
    public ValgrindFrame getFrame() {
        ValgrindFrame valgrindFrame = this.myFrame;
        if (valgrindFrame == null) {
            ValgrindStackFrameTreeNode.$$$reportNull$$$0(2);
        }
        return valgrindFrame;
    }

    @Override
    public boolean showTotalWarnings() {
        return false;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Debugger.StackFrame;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        ValgrindNavigationData navigationData = ValgrindUtil.getNavigationData(this.myFrame);
        if (navigationData == null) {
            return null;
        }
        return navigationData.isLineNumberValid() ? new OpenFileDescriptor(this.myProject, navigationData.getVirtualFile(), navigationData.getLineNumber(), 0) : new OpenFileDescriptor(this.myProject, navigationData.getVirtualFile());
    }

    @Override
    public boolean canBeExcluded() {
        return false;
    }

    @Override
    @Nullable
    public ValgrindNodeTextData getPrefixTextData() {
        return StringUtil.isNotEmpty((String)this.myFrame.getInstructionPointer()) ? new ValgrindNodeTextData(this.myFrame.getInstructionPointer(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES) : null;
    }

    @Override
    @Nullable
    public ValgrindNodeTextData getSuffixTextData() {
        if (StringUtil.isNotEmpty((String)this.myFrame.getFile())) {
            if (StringUtil.isNotEmpty((String)this.myFrame.getLine())) {
                return new ValgrindNodeTextData(this.myFrame.getFile() + ":" + this.myFrame.getLine(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
            return new ValgrindNodeTextData(this.myFrame.getFile(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        return null;
    }

    @Override
    @NotNull
    protected String getText() {
        if (StringUtil.isNotEmpty((String)this.myFrame.getFunction())) {
            String string = ValueRenderer.getShortenedType(this.myFrame.getFunction());
            if (string == null) {
                ValgrindStackFrameTreeNode.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getObject())) {
            String string = this.myFrame.getObject();
            if (string == null) {
                ValgrindStackFrameTreeNode.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("" == null) {
            ValgrindStackFrameTreeNode.$$$reportNull$$$0(5);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/tree/nodes/ValgrindStackFrameTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/tree/nodes/ValgrindStackFrameTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

