/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.ui;

import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.tree.IndexTreePathState;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindUtil;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindError;
import com.jetbrains.cidr.cpp.valgrind.model.ValgrindTreeDataModel;
import com.jetbrains.cidr.cpp.valgrind.tree.ValgrindTree;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindErrorTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindTreeNode;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ValgrindExclusionHandler
implements ExclusionHandler<ValgrindTreeNode> {
    private static final Logger LOG = Logger.getInstance(ValgrindExclusionHandler.class);
    private Set<ValgrindTreeNode> myNodesToExclude;
    @NotNull
    private final ValgrindTree myTree;
    @NotNull
    private final ValgrindTreeDataModel myDataModel;

    public ValgrindExclusionHandler(@NotNull ValgrindTree tree) {
        if (tree == null) {
            ValgrindExclusionHandler.$$$reportNull$$$0(0);
        }
        this.myNodesToExclude = new HashSet<ValgrindTreeNode>();
        this.myTree = tree;
        this.myDataModel = (ValgrindTreeDataModel)tree.getModel();
    }

    public boolean isNodeExclusionAvailable(@NotNull ValgrindTreeNode node) {
        if (node == null) {
            ValgrindExclusionHandler.$$$reportNull$$$0(1);
        }
        return node.canBeExcluded() && !this.myNodesToExclude.contains(node);
    }

    public boolean isNodeExcluded(@NotNull ValgrindTreeNode node) {
        if (node == null) {
            ValgrindExclusionHandler.$$$reportNull$$$0(2);
        }
        return this.myNodesToExclude.contains(node);
    }

    public void excludeNode(@NotNull ValgrindTreeNode node) {
        if (node == null) {
            ValgrindExclusionHandler.$$$reportNull$$$0(3);
        }
        this.myNodesToExclude.add(node);
    }

    public void includeNode(@NotNull ValgrindTreeNode node) {
        if (node == null) {
            ValgrindExclusionHandler.$$$reportNull$$$0(4);
        }
        LOG.warn("includeNode() is not supported by ValgrindExclusionHandler");
    }

    public boolean isActionEnabled(boolean isExcludeAction) {
        return isExcludeAction;
    }

    public void onDone(boolean isExcludeAction) {
        if (!isExcludeAction) {
            return;
        }
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                IndexTreePathState selectionState = new IndexTreePathState(selectionPath);
                ValgrindUtil.removeNode((ValgrindTreeNode)selectionPath.getLastPathComponent(), this.myDataModel);
                selectionState.restoreSelection((JTree)((Object)this.myTree));
            }
        }
        HashSet<ValgrindError> errorsToRetain = new HashSet<ValgrindError>();
        TreeUtil.traverse((TreeNode)((TreeNode)this.myDataModel.getRoot()), node -> {
            if (node instanceof ValgrindErrorTreeNode) {
                errorsToRetain.add(((ValgrindErrorTreeNode)node).getError());
            }
            return true;
        });
        this.myDataModel.retainAll(errorsToRetain);
        this.myNodesToExclude.clear();
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ui/ValgrindExclusionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeExclusionAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeExcluded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "includeNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

