/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindDataKeys;
import com.jetbrains.cidr.cpp.valgrind.actions.ValgrindGroupByDirectoryAction;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import com.jetbrains.cidr.cpp.valgrind.model.ValgrindTreeDataModel;
import com.jetbrains.cidr.cpp.valgrind.tree.ValgrindTree;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindStackFrameTreeNode;
import com.jetbrains.cidr.cpp.valgrind.tree.nodes.ValgrindTreeNode;
import com.jetbrains.cidr.cpp.valgrind.ui.ValgrindAutoScrollToSourceHandler;
import com.jetbrains.cidr.cpp.valgrind.ui.ValgrindExclusionHandler;
import com.jetbrains.cidr.cpp.valgrind.ui.ValgrindNoPreviewPanel;
import com.jetbrains.cidr.cpp.valgrind.ui.ValgrindOccurenceNavigator;
import com.jetbrains.cidr.cpp.valgrind.ui.ValgrindStackFramePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindOutputPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final ValgrindTreeDataModel myTreeDataModel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ValgrindTree myTree;
    @NotNull
    private final ValgrindNoPreviewPanel myNoPreviewPanel;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final ValgrindOccurenceNavigator myOccurenceNavigator;
    @NotNull
    private final ValgrindAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    @NotNull
    private final ValgrindExclusionHandler myExclusionHandler;

    public ValgrindOutputPanel(@NotNull ValgrindTreeDataModel treeDataModel, @NotNull Project project2) {
        if (treeDataModel == null) {
            ValgrindOutputPanel.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ValgrindOutputPanel.$$$reportNull$$$0(1);
        }
        this.myTreeDataModel = treeDataModel;
        this.myProject = project2;
        this.myTree = new ValgrindTree(treeDataModel);
        this.myNoPreviewPanel = new ValgrindNoPreviewPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.5f);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.setSecondComponent((JComponent)this.myNoPreviewPanel);
        this.myOccurenceNavigator = new ValgrindOccurenceNavigator(this.myTree);
        this.myAutoScrollToSourceHandler = new ValgrindAutoScrollToSourceHandler();
        this.myExclusionHandler = new ValgrindExclusionHandler(this.myTree);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySplitter, "Center");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.addActionToolbars();
            this.configureTreeListeners();
        }
        this.updatePreviewPanel();
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    private void configureTreeListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(event -> {
            this.updatePreviewPanel();
            if (this.myAutoScrollToSourceHandler.isAutoScrollMode()) {
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)this), (boolean)false);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)ValgrindOutputPanel.this), (boolean)false);
                }
            }
        });
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"ValgrindToolWindow.TreePopup", (String)"CodeInspection");
    }

    private void updatePreviewPanel() {
        this.disposePreviewPanel();
        ValgrindTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode instanceof ValgrindStackFrameTreeNode) {
            ValgrindFrame frameToPreview = ((ValgrindStackFrameTreeNode)selectedNode).getFrame();
            this.mySplitter.setSecondComponent((JComponent)new ValgrindStackFramePreviewPanel(frameToPreview, this.myProject));
        } else {
            this.mySplitter.setSecondComponent((JComponent)this.myNoPreviewPanel);
        }
    }

    private void addActionToolbars() {
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.add((Component)this.createLeftActionsToolbar(), "West");
        actionPanel.add((Component)this.createRightActionsToolbar(), "East");
        this.add((Component)actionPanel, "West");
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        actionGroup.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        actionGroup.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        actionGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        actionGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        return ValgrindOutputPanel.createToolbar(actionGroup);
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new ValgrindGroupByDirectoryAction(this.myTree, this.myTreeDataModel));
        actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        actionGroup.add(ActionManager.getInstance().getAction("Valgrind.EditSettings"));
        return ValgrindOutputPanel.createToolbar(actionGroup);
    }

    @Nullable
    public Object getData(String dataId) {
        if (ExclusionHandler.EXCLUSION_HANDLER.is(dataId)) {
            return this.myExclusionHandler;
        }
        if (ValgrindDataKeys.TREE.is(dataId)) {
            return this.myTree;
        }
        if (ValgrindDataKeys.TREE_MODEL.is(dataId)) {
            return this.myTreeDataModel;
        }
        ValgrindTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        if (ValgrindDataKeys.SELECTED_NODE.is(dataId)) {
            return selectedNode;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return selectedNode.getNavigatable();
        }
        return null;
    }

    public void dispose() {
        this.disposePreviewPanel();
    }

    private ValgrindTreeNode getSelectedNode() {
        int selectionCount = this.myTree.getSelectionModel().getSelectionCount();
        if (selectionCount != 1) {
            return null;
        }
        TreePath selectionPath = this.myTree.getSelectionModel().getSelectionPath();
        return selectionPath != null ? (ValgrindTreeNode)selectionPath.getLastPathComponent() : null;
    }

    private static JComponent createToolbar(DefaultActionGroup actionGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)actionGroup, false);
        return toolbar.getComponent();
    }

    @NotNull
    public ValgrindTree getTree() {
        ValgrindTree valgrindTree = this.myTree;
        if (valgrindTree == null) {
            ValgrindOutputPanel.$$$reportNull$$$0(2);
        }
        return valgrindTree;
    }

    @NotNull
    public ValgrindTreeDataModel getTreeDataModel() {
        ValgrindTreeDataModel valgrindTreeDataModel = this.myTreeDataModel;
        if (valgrindTreeDataModel == null) {
            ValgrindOutputPanel.$$$reportNull$$$0(3);
        }
        return valgrindTreeDataModel;
    }

    private void disposePreviewPanel() {
        JComponent component = this.mySplitter.getSecondComponent();
        if (component instanceof ValgrindStackFramePreviewPanel) {
            Disposer.dispose((Disposable)((Disposable)component));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeDataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ui/ValgrindOutputPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ui/ValgrindOutputPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

