/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.ui;

import com.intellij.codeInspection.ui.PreviewEditorFoldingRegion;
import com.intellij.codeInspection.ui.ProblemPreviewEditorPresentation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.valgrind.ValgrindNavigationData;
import com.jetbrains.cidr.cpp.valgrind.ValgrindUtil;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindStackFramePreviewPanel
extends JPanel
implements Disposable {
    @NotNull
    private final ValgrindFrame myFrame;
    @NotNull
    private final Project myProject;
    @Nullable
    private EditorEx myEditor;
    private volatile boolean myTaskCanceled;
    @NotNull
    private final JPanel myMainPanel;
    @NotNull
    private final LoadingDecorator myLoadingDecorator;

    public ValgrindStackFramePreviewPanel(@NotNull ValgrindFrame frame, @NotNull Project project2) {
        if (frame == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(1);
        }
        this.myFrame = frame;
        this.myProject = project2;
        this.myEditor = null;
        this.myTaskCanceled = false;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myMainPanel, (Disposable)this, 100);
        this.myLoadingDecorator.setLoadingText("Loading preview...");
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLoadingDecorator.getComponent(), "Center");
        this.updatePreviewPanelInBackground();
    }

    private void updatePreviewPanelInBackground() {
        this.myLoadingDecorator.startLoading(true);
        Application app = ApplicationManager.getApplication();
        app.executeOnPooledThread(() -> {
            ValgrindNavigationData navigationData = ValgrindUtil.getNavigationData(this.myFrame);
            app.invokeLater(() -> this.showPreviewInformation(navigationData), c -> this.myTaskCanceled);
        });
    }

    private void showPreviewInformation(@Nullable ValgrindNavigationData navigationData) {
        RunnerLayoutUi.Factory factory2 = RunnerLayoutUi.Factory.getInstance((Project)this.myProject);
        RunnerLayoutUi ui = factory2.create("ValgrindRunner", "ValgrindRunner", "ValgrindRunner", (Disposable)this);
        if (navigationData != null) {
            this.myEditor = this.createPreviewEditor(navigationData);
            Content previewContent = ui.createContent("ValgrindPreview", this.myEditor.getComponent(), "Preview Editor", AllIcons.Actions.PreviewDetails, null);
            previewContent.setCloseable(false);
            ui.addContent(previewContent);
        }
        Content frameContent = ui.createContent("ValgrindFrame", (JComponent)this.createFrameDescription(), "Frame Information", AllIcons.Debugger.StackFrame, null);
        frameContent.setCloseable(false);
        ui.addContent(frameContent);
        this.myMainPanel.add((Component)ui.getComponent(), "Center");
        this.myLoadingDecorator.stopLoading();
        this.myLoadingDecorator.getComponent().revalidate();
        this.myLoadingDecorator.getComponent().repaint();
    }

    public void dispose() {
        this.myTaskCanceled = true;
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            this.myEditor = null;
        }
    }

    @NotNull
    private JPanel createFrameDescription() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ArrayList<Pair> keyValuePairs = new ArrayList<Pair>();
        if (StringUtil.isNotEmpty((String)this.myFrame.getInstructionPointer())) {
            keyValuePairs.add(Pair.create((Object)"InstructionPointer: ", (Object)this.myFrame.getInstructionPointer()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getObject())) {
            keyValuePairs.add(Pair.create((Object)"Object: ", (Object)this.myFrame.getObject()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getFunction())) {
            keyValuePairs.add(Pair.create((Object)"Function: ", (Object)this.myFrame.getFunction()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getDirectory())) {
            keyValuePairs.add(Pair.create((Object)"Directory: ", (Object)this.myFrame.getDirectory()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getFile())) {
            keyValuePairs.add(Pair.create((Object)"File: ", (Object)this.myFrame.getFile()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getLine())) {
            keyValuePairs.add(Pair.create((Object)"Line: ", (Object)this.myFrame.getLine()));
        }
        for (int row = 0; row < keyValuePairs.size(); ++row) {
            Pair keyValuePair = (Pair)keyValuePairs.get(row);
            boolean isLastOne = row == keyValuePairs.size() - 1;
            ValgrindStackFramePreviewPanel.addDescription((String)keyValuePair.getFirst(), (String)keyValuePair.getSecond(), row, panel, isLastOne);
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private EditorEx createPreviewEditor(@NotNull ValgrindNavigationData navigationData) {
        if (navigationData == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(3);
        }
        Document document = navigationData.getDocument();
        VirtualFile virtualFile = navigationData.getVirtualFile();
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, virtualFile, true);
        DiffUtil.setFoldingModelSupport((EditorEx)editor);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(true);
        settings.setLineMarkerAreaShown(true);
        settings.setGutterIconsShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setLeadingWhitespaceShown(true);
        editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, editor.getColorsScheme().getDefaultBackground());
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.setBorder(IdeBorderFactory.createBorder((int)2));
        if (navigationData.isLineNumberValid()) {
            int lineNumber = navigationData.getLineNumber();
            ProblemPreviewEditorPresentation.setupFoldings((EditorEx)editor, ValgrindStackFramePreviewPanel.getFoldingRegions(document, lineNumber));
            ValgrindStackFramePreviewPanel.highlightLine((Editor)editor, lineNumber);
        }
        EditorEx editorEx = editor;
        if (editorEx == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(4);
        }
        return editorEx;
    }

    private static SortedSet<PreviewEditorFoldingRegion> getFoldingRegions(@NotNull Document document, int lineNumber) {
        if (document == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(5);
        }
        int additionalVisibleLines = 5;
        int visibleStartLine = Math.max(0, lineNumber - 5);
        int visibleEndLine = Math.min(lineNumber + 5 + 1, document.getLineCount());
        TreeSet<PreviewEditorFoldingRegion> foldingRegions = new TreeSet<PreviewEditorFoldingRegion>();
        if (visibleStartLine != 0) {
            foldingRegions.add(new PreviewEditorFoldingRegion(0, visibleStartLine));
        }
        if (visibleEndLine != document.getLineCount()) {
            foldingRegions.add(new PreviewEditorFoldingRegion(visibleEndLine, document.getLineCount()));
        }
        return foldingRegions;
    }

    private static void highlightLine(@NotNull Editor editor, int lineNumber) {
        if (editor == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(6);
        }
        TextAttributes attributes = editor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        MarkupModel model2 = editor.getMarkupModel();
        model2.addLineHighlighter(lineNumber, 6000, attributes);
    }

    private static void addDescription(@NotNull String title, @Nullable String value, int gridY, @NotNull JPanel container, boolean isLastOne) {
        if (title == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(7);
        }
        if (container == null) {
            ValgrindStackFramePreviewPanel.$$$reportNull$$$0(8);
        }
        JBLabel titleLabel = new JBLabel(title);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        JTextArea valueTextArea = ValgrindUtil.createTextArea(value != null ? value : "");
        double weightY = isLastOne ? 1.0 : 0.0;
        container.add((Component)titleLabel, new GridBagConstraints(0, gridY, 1, 1, 0.0, weightY, 18, 0, (Insets)JBUI.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        container.add((Component)valueTextArea, new GridBagConstraints(1, gridY, 1, 1, 1.0, weightY, 18, 2, (Insets)JBUI.insets((int)5, (int)0, (int)0, (int)10), 0, 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ui/ValgrindStackFramePreviewPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ui/ValgrindStackFramePreviewPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingRegions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

