/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxParamId;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import com.jetbrains.cidr.doxygen.psi.impl.DxPsiImplUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.psi.OCCallable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxReference
extends PsiReferenceBase<DxParamId>
implements PsiReference {
    public DxReference(@NotNull PsiElement element, @NotNull TextRange textRange) {
        if (element == null) {
            DxReference.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            DxReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)((DxParamId)element), textRange);
    }

    @Nullable
    public PsiElement resolve() {
        DxDocTag tag = (DxDocTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocTag.class);
        DxDocComment comment = (DxDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocComment.class);
        if (tag != null && comment != null) {
            Optional<Object> result = Optional.empty();
            if (tag.getName().equals(DoxygenCmd.PARAM.toString())) {
                result = this.resolveParam(comment);
            } else if (tag.getName().equals(DoxygenCmd.TPARAM.toString())) {
                result = this.resolveTemplateParam(comment);
            }
            if (result.isPresent()) {
                return (PsiElement)result.get();
            }
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return DxPsiImplUtil.setName((DxParamId)this.getElement(), newElementName);
    }

    public TextRange getRangeInElement() {
        return TextRange.create((int)0, (int)((DxParamId)this.myElement).getText().length());
    }

    private Optional<? extends PsiNamedElement> resolveParam(@NotNull DxDocComment comment) {
        PsiComment psiComment;
        OCCallable<?> func;
        if (comment == null) {
            DxReference.$$$reportNull$$$0(2);
        }
        if ((func = DoxygenUtil.findFunction(psiComment = DoxygenUtil.getHostComment(comment))) != null && func.getParameters() != null) {
            return func.getParameters().stream().filter(p -> ((DxParamId)this.myElement).getText().equals(p.getName())).findFirst();
        }
        return Optional.empty();
    }

    private Optional<? extends PsiNamedElement> resolveTemplateParam(@NotNull DxDocComment comment) {
        PsiComment psiComment;
        if (comment == null) {
            DxReference.$$$reportNull$$$0(3);
        }
        if ((psiComment = DoxygenUtil.getHostComment(comment)) instanceof PsiDocCommentBase) {
            PsiElement owner2 = ((PsiDocCommentBase)psiComment).getOwner();
            return Optional.ofNullable(DoxygenUtil.traverseTemplateParametersList(owner2, (element, name2) -> !((DxParamId)this.myElement).getText().equals(name2)));
        }
        return Optional.empty();
    }

    @NotNull
    public Object[] getVariants() {
        ASTNode node;
        PsiElement prev = ((DxParamId)this.myElement).getPrevSibling();
        if (prev != null && (node = prev.getNode()) != null && node.getElementType() == DxTypes.ELLIPSIS) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                DxReference.$$$reportNull$$$0(4);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        DxDocTag tag = (DxDocTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocTag.class);
        DxDocComment comment = (DxDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, DxDocComment.class);
        if (tag != null && comment != null) {
            PsiComment hostComment = DoxygenUtil.getHostComment(comment);
            if (tag.getName().equals(DoxygenCmd.PARAM.toString())) {
                Object[] objectArray = DxReference.getParamVariants(hostComment);
                if (objectArray == null) {
                    DxReference.$$$reportNull$$$0(5);
                }
                return objectArray;
            }
            if (tag.getName().equals(DoxygenCmd.TPARAM.toString())) {
                Object[] objectArray = DxReference.getTemplateParamVariants(hostComment);
                if (objectArray == null) {
                    DxReference.$$$reportNull$$$0(6);
                }
                return objectArray;
            }
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            DxReference.$$$reportNull$$$0(7);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static Object[] getParamVariants(@Nullable PsiComment psiComment) {
        List<PsiNamedElement> params;
        OCCallable<?> func = DoxygenUtil.findFunction(psiComment);
        if (func != null && (params = func.getParameters()) != null) {
            return params.stream().map(p -> "<unnamed>".equals(p.getName()) ? p.getText() : p.getName()).filter(name2 -> name2 != null && DxReference.isValidIdentifier(name2)).toArray();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static Object[] getTemplateParamVariants(@Nullable PsiComment psiComment) {
        if (psiComment instanceof PsiDocCommentBase) {
            PsiElement owner2 = ((PsiDocCommentBase)psiComment).getOwner();
            ArrayList params = new ArrayList();
            DoxygenUtil.traverseTemplateParametersList(owner2, name2 -> {
                if (DxReference.isValidIdentifier(name2)) {
                    params.add(name2);
                }
            });
            return params.toArray();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static boolean isValidIdentifier(@NotNull String name2) {
        if (name2 == null) {
            DxReference.$$$reportNull$$$0(8);
        }
        if (name2.isEmpty()) {
            return false;
        }
        return name2.startsWith("...") || Character.isJavaIdentifierPart(name2.charAt(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/DxReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/DxReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveParam";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveTemplateParam";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

