/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.doxygen.comment.ComplexItemBuilder;
import com.jetbrains.cidr.doxygen.comment.InfoItemImpl;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DoxygenCommentTagImpl
implements TagItem,
ComplexItemBuilder {
    private final String name;
    private final String options;
    private final List<String> params;
    private final List<InfoItem> items = new ArrayList<InfoItem>();

    public DoxygenCommentTagImpl(DxDocTag tag) {
        this.name = tag.getName();
        this.options = tag.getOptions().isEmpty() ? "" : "[" + StringUtil.join(tag.getOptions(), (String)", ") + "]";
        this.params = tag.getParamList().stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    public DoxygenCommentTagImpl(String tagName, String options, String paramName, String description) {
        this.name = tagName;
        this.options = options;
        this.params = Collections.singletonList(paramName);
        this.addText(description);
    }

    @Override
    public void addText(@NotNull String text) {
        if (text == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(0);
        }
        if (text.isEmpty()) {
            return;
        }
        this.items.add(new InfoItemImpl(text));
    }

    @Override
    public void addTag(@NotNull TagItem item) {
        if (item == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(1);
        }
        this.items.add(item);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getOptions() {
        String string = this.options;
        if (string == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        List<String> list = this.params;
        if (list == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = StringUtil.trimTrailing((String)StringUtil.join(this.items, InfoItem::getDescription, (String)" "));
        if (string == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public List<InfoItem> getContent() {
        ArrayList<InfoItem> arrayList = new ArrayList<InfoItem>(this.items);
        if (arrayList == null) {
            DoxygenCommentTagImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoxygenCommentTagImpl tag = (DoxygenCommentTagImpl)o;
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(tag.options) : tag.options != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(tag.params) : tag.params != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(tag.items) : tag.items != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentTagImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DoxygenCommentTagImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTag";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

