/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxCommentProcessorUtil {
    @NotNull
    public static List<PsiComment> getCommentScope(@NotNull PsiElement elt) {
        List<PsiComment> comments;
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(0);
        }
        List<PsiComment> list = comments = DxCommentProcessorUtil.findOCCommentForElementInternal(elt);
        if (list == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<PsiComment> findOCCommentFor(@Nullable PsiElement element) {
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentForElementInternal(element);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project2 = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project2);
            }
            if (symbol != null) {
                Object associatedElement = symbol.locateDefinition(project2);
                List<PsiComment> list = DxCommentProcessorUtil.findOCCommentForElementInternal(associatedElement);
                if (list == null) {
                    DxCommentProcessorUtil.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        List<PsiComment> list = comments;
        if (list == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<PsiComment> findOCCommentForElementInternal(@Nullable PsiElement elt) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                DxCommentProcessorUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                DxCommentProcessorUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        DxCommentProcessorUtil.findPrevComments(elt, comments);
        DxCommentProcessorUtil.findInnerComments(elt, comments);
        DxCommentProcessorUtil.findNextComments(elt, comments);
        LinkedList<PsiComment> linkedList = comments;
        if (linkedList == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    private static void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(7);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(8);
        }
        PsiElement initElement = elt.getFirstChild();
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            if (element instanceof PsiWhiteSpace || element instanceof OCMacroCall) continue;
            if (!(element instanceof PsiComment)) break;
            initElement = element;
        }
        if (initElement != null) {
            ArrayList<PsiComment> allComments = new ArrayList<PsiComment>();
            ArrayList<PsiComment> withArrow = new ArrayList<PsiComment>();
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, allComments, false);
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, withArrow, true);
            allComments.removeAll(withArrow);
            for (PsiComment comment : allComments) {
                if (!DoxygenUtil.isDoxygenComment(comment)) continue;
                comments.add(comment);
            }
        }
    }

    private static void findInnerComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(9);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(10);
        }
        if (elt instanceof OCClassDeclaration || elt instanceof OCMethod) {
            return;
        }
        ArrayList<PsiComment> firstComments = new ArrayList<PsiComment>();
        DxCommentProcessorUtil.findNextCommentsInternal(elt.getFirstChild(), firstComments, false);
        List innerComments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class);
        innerComments.removeAll(firstComments);
        for (PsiComment comment : innerComments) {
            if (!DoxygenUtil.isDoxygenComment(comment)) continue;
            comments.add(comment);
        }
    }

    private static void findNextComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(11);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(12);
        }
        if (elt instanceof OCParameterDeclaration || elt.getParent() instanceof OCEnum) {
            DxCommentProcessorUtil.findNextCommentsForCommaSeparatedSequence(elt, comments);
        } else {
            DxCommentProcessorUtil.findNextCommentsInternal(elt.getNextSibling(), comments, true);
        }
    }

    private static void findNextCommentsInternal(@Nullable PsiElement elt, List<PsiComment> comments, boolean onlyDoxygen) {
        if (elt == null) {
            return;
        }
        for (PsiElement next = elt; next != null; next = next.getNextSibling()) {
            if (next instanceof PsiWhiteSpace) continue;
            if (next instanceof PsiComment) {
                PsiComment comment = (PsiComment)next;
                if (!onlyDoxygen) {
                    comments.add(comment);
                    continue;
                }
                if (!DoxygenUtil.isDoxygenComment(comment) || !DoxygenUtil.hasArrow(comment)) break;
                if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                    EOLCommentPack pack = new EOLCommentPack(comment);
                    comments.addAll(pack.getComments());
                    next = pack.getLastComment();
                    continue;
                }
                comments.add(comment);
                continue;
            }
            if (!(next instanceof OCDeclaration) && !DxCommentProcessorUtil.isOCDeclaration(next)) break;
            DxCommentProcessorUtil.findNextCommentsInternal(next.getFirstChild(), comments, onlyDoxygen);
            break;
        }
    }

    private static void findNextCommentsForCommaSeparatedSequence(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(13);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(14);
        }
        boolean waitForArrow = false;
        for (PsiElement next = elt.getNextSibling(); next != null; next = next.getNextSibling()) {
            PsiComment comment;
            if (next instanceof PsiWhiteSpace) continue;
            if (next instanceof LeafElement && ((LeafElement)next).getElementType() == OCTokenTypes.COMMA) {
                waitForArrow = true;
                continue;
            }
            if (!(next instanceof PsiComment) || !DoxygenUtil.isDoxygenComment(comment = (PsiComment)next) || waitForArrow && !DoxygenUtil.hasArrow(comment)) break;
            if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                EOLCommentPack pack = new EOLCommentPack(comment);
                comments.addAll(pack.getComments());
                next = pack.getLastComment();
                continue;
            }
            comments.add(comment);
        }
    }

    private static boolean isOCDeclaration(@NotNull PsiElement elt) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(15);
        }
        return elt instanceof OCMethod || elt instanceof OCClassDeclaration || elt instanceof OCProperty || elt instanceof OCMethodSelectorPart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findOCCommentFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOCCommentForElementInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommentScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPrevComments";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInnerComments";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNextComments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findNextCommentsForCommaSeparatedSequence";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isOCDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EOLCommentPack {
        private final List<PsiComment> comments;

        public EOLCommentPack(@NotNull PsiComment EOLComment) {
            if (EOLComment == null) {
                EOLCommentPack.$$$reportNull$$$0(0);
            }
            this.comments = new ArrayList<PsiComment>();
            assert (DoxygenUtil.isDoxygenEOLComment(EOLComment.getText()));
            this.comments.add(EOLComment);
            EOLCommentPack.processEOLCommentPack(EOLComment, this.comments);
        }

        public List<PsiComment> getComments() {
            return this.comments;
        }

        @NotNull
        public PsiComment getLastComment() {
            assert (this.comments.size() > 0);
            PsiComment psiComment = this.comments.get(this.comments.size() - 1);
            if (psiComment == null) {
                EOLCommentPack.$$$reportNull$$$0(1);
            }
            return psiComment;
        }

        private static void processEOLCommentPack(@NotNull PsiComment EOLComment, @NotNull List<PsiComment> pack) {
            PsiDocumentManager manager;
            Document document;
            if (EOLComment == null) {
                EOLCommentPack.$$$reportNull$$$0(2);
            }
            if (pack == null) {
                EOLCommentPack.$$$reportNull$$$0(3);
            }
            if ((document = (manager = PsiDocumentManager.getInstance((Project)EOLComment.getProject())).getDocument(EOLComment.getContainingFile())) == null) {
                return;
            }
            int startOffset = EOLComment.getTextOffset();
            int lineStartOffset = startOffset - document.getLineStartOffset(document.getLineNumber(startOffset));
            for (PsiElement next = EOLComment.getNextSibling(); next != null; next = next.getNextSibling()) {
                if (next instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)next.getText()) == 1) continue;
                if (next instanceof PsiComment) {
                    if (!EOLCommentPack.processEOLComment((PsiComment)next, document, lineStartOffset, pack)) break;
                    continue;
                }
                if (!(next instanceof OCDeclaration) && !DxCommentProcessorUtil.isOCDeclaration(next)) break;
                for (PsiElement innerElement = next.getFirstChild(); innerElement != null && (innerElement instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)innerElement.getText()) == 1 || innerElement instanceof PsiComment && EOLCommentPack.processEOLComment((PsiComment)innerElement, document, lineStartOffset, pack)); innerElement = innerElement.getNextSibling()) {
                }
                break;
            }
        }

        private static boolean processEOLComment(@NotNull PsiComment comment, @NotNull Document document, int offset, @NotNull List<PsiComment> pack) {
            int startOffset;
            int lineStartOffset;
            if (comment == null) {
                EOLCommentPack.$$$reportNull$$$0(4);
            }
            if (document == null) {
                EOLCommentPack.$$$reportNull$$$0(5);
            }
            if (pack == null) {
                EOLCommentPack.$$$reportNull$$$0(6);
            }
            if (DoxygenUtil.isDoxygenEOLComment(comment.getText()) && offset == (lineStartOffset = (startOffset = comment.getTextOffset()) - document.getLineStartOffset(document.getLineNumber(startOffset)))) {
                pack.add(comment);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "EOLComment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil$EOLCommentPack";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pack";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil$EOLCommentPack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processEOLCommentPack";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processEOLComment";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

