/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxParam;
import com.jetbrains.cidr.doxygen.psi.DxParamId;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxPsiImplUtil {
    public static final String UNKNOWN = "<unknown>";

    @NotNull
    public static String getName(@NotNull DxDocTag docTag) {
        if (docTag == null) {
            DxPsiImplUtil.$$$reportNull$$$0(0);
        }
        String name2 = DxPsiImplUtil.getOriginalName(docTag);
        name2 = StringUtil.trimStart((String)name2, (String)"\\");
        int idx = (name2 = StringUtil.trimStart((String)name2, (String)"@")).indexOf(123);
        if (idx != -1) {
            name2 = name2.substring(0, idx);
        }
        String string = name2;
        if (string == null) {
            DxPsiImplUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getOriginalName(@NotNull DxDocTag docTag) {
        ASTNode tagName;
        if (docTag == null) {
            DxPsiImplUtil.$$$reportNull$$$0(2);
        }
        String string = (tagName = docTag.getNode().findChildByType(DxTypes.TAG_NAME)) != null ? tagName.getText() : UNKNOWN;
        if (string == null) {
            DxPsiImplUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getName(@NotNull DxParamId element) {
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(4);
        }
        String string = element.getText();
        if (string == null) {
            DxPsiImplUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static PsiElement setName(@NotNull DxParamId element, @NotNull String newName) {
        ASTNode node;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            DxPsiImplUtil.$$$reportNull$$$0(7);
        }
        if ((node = element.getNode().findChildByType(DxTypes.TAG_PARAM)) instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(newName);
            DxParamId dxParamId = element;
            if (dxParamId == null) {
                DxPsiImplUtil.$$$reportNull$$$0(8);
            }
            return dxParamId;
        }
        throw new IncorrectOperationException();
    }

    @Nullable
    public static PsiElement getNameIdentifier(@NotNull DxParamId element) {
        ASTNode node;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(9);
        }
        return (node = element.getNode().findChildByType(DxTypes.TAG_PARAM)) != null ? node.getPsi() : null;
    }

    @NotNull
    public static List<String> getOptions(@NotNull PsiElement element) {
        ASTNode tagName;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(10);
        }
        if ((tagName = element.getNode().findChildByType(DxTypes.TAG_OPTION)) != null) {
            List<String> list = DxPsiImplUtil.extractOptions(tagName);
            if (list == null) {
                DxPsiImplUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            DxPsiImplUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static List<String> extractOptions(@NotNull ASTNode tagName) {
        if (tagName == null) {
            DxPsiImplUtil.$$$reportNull$$$0(13);
        }
        String text = tagName.getText().trim();
        text = StringUtil.substringAfter((String)text, (String)"[");
        text = StringUtil.substringBefore((String)text, (String)"]");
        List<String> result = StringUtil.split((String)text, (String)",").stream().map(s -> {
            if ((s = s.trim()).startsWith("*")) {
                s = StringUtil.substringAfter((String)s, (String)"*");
            }
            if (s.endsWith("*")) {
                s = StringUtil.substringBefore((String)s, (String)"*");
            }
            return s.trim();
        }).collect(Collectors.toList());
        return result;
    }

    public static String getName(@NotNull DxParam element) {
        DxParamId id;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(14);
        }
        boolean hasEllipsis = element.getNode().findChildByType(DxTypes.ELLIPSIS) != null;
        String name2 = "";
        if (hasEllipsis) {
            name2 = "...";
        }
        if ((id = element.getParamId()) != null) {
            name2 = name2 + id.getName();
        }
        return name2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/psi/impl/DxPsiImplUtil";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/psi/impl/DxPsiImplUtil";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

