/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildTargetAndConfigurationData {
    @Nullable
    public final BuildTargetData target;
    @Nullable
    public final String configurationName;

    public BuildTargetAndConfigurationData(@Nullable BuildTargetData target, @Nullable String configurationName) {
        this.target = target;
        this.configurationName = configurationName;
    }

    public BuildTargetAndConfigurationData(@Nullable String projectName, @Nullable String targetName, @Nullable String configurationName) {
        this(projectName == null || targetName == null ? null : new BuildTargetData(projectName, targetName), configurationName);
    }

    public BuildTargetAndConfigurationData(@Nullable CidrBuildTarget target, @Nullable String configurationName) {
        this(target == null ? null : target.getProjectName(), target == null ? null : target.getName(), configurationName);
    }

    public BuildTargetAndConfigurationData(@Nullable CidrBuildTarget target, @Nullable CidrBuildConfiguration configuration) {
        this(target, configuration == null ? null : configuration.getName());
    }

    public BuildTargetAndConfigurationData() {
        this(null, null, null);
    }

    public String toString() {
        return this.getDisplayString();
    }

    @NotNull
    public String getDisplayString() {
        String string = BuildTargetAndConfigurationData.formatDisplayString(this.target == null ? null : this.target.projectName, this.target == null ? null : this.target.targetName, this.configurationName);
        if (string == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Contract(value="null, _ -> false")
    public static boolean checkData(@NotNull CidrBuildConfigurationHelper<?, ?> helper, @Nullable BuildTargetAndConfigurationData data, @Nullable BuildConfigurationProblems problems) {
        if (helper == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(1);
        }
        return BuildTargetAndConfigurationData.checkData(helper, data, problems, false, false);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean checkData(@NotNull CidrBuildConfigurationHelper<?, ?> helper, @Nullable BuildTargetAndConfigurationData data, @Nullable BuildConfigurationProblems problems, boolean allowEmptyTarget, boolean allowEmptyConfiguration) {
        String configurationName;
        if (helper == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(2);
        }
        BuildTargetData target = data != null ? data.target : null;
        String string = configurationName = data != null ? data.configurationName : null;
        if (problems != null) {
            problems.title = CidrBundle.message("build.configuration.invalid", new Object[0]);
        }
        if (target == null && !allowEmptyTarget || configurationName == null && !allowEmptyConfiguration) {
            if (problems != null) {
                if (target == null && !allowEmptyTarget) {
                    problems.problems.add(CidrBundle.message("build.configuration.parameterNotSelected", helper.getTargetTitle()));
                }
                if (configurationName == null && !allowEmptyConfiguration) {
                    problems.problems.add(CidrBundle.message("build.configuration.parameterNotSelected", helper.getConfigurationTitle()));
                }
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTargetAndConfigurationData that = (BuildTargetAndConfigurationData)o;
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return !(this.configurationName != null ? !this.configurationName.equals(that.configurationName) : that.configurationName != null);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.configurationName != null ? this.configurationName.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String formatDisplayString(@Nullable String projectName, @Nullable String targetName, @Nullable String configName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        String string = builder.append(BuildTargetAndConfigurationData.formatDisplayString(projectName, targetName)).append(" - ").append(configName).toString();
        String string2 = string;
        if (string2 == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(3);
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String formatDisplayString(@Nullable String projectName, @Nullable String targetName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        String string = builder.append(targetName).append(" (").append(projectName).append(")").toString();
        String string2 = string;
        if (string2 == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(4);
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDisplayString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

