/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrBuildConfigurationHelper<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>> {
    @NotNull
    public String getTargetTitle() {
        String string = CidrBundle.message("build.configuration.target", new Object[0]);
        if (string == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getConfigurationTitle() {
        String string = CidrBundle.message("build.configuration.configuration", new Object[0]);
        if (string == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean allowEditBuildConfiguration() {
        return true;
    }

    @NotNull
    public abstract List<TARGET> getTargets();

    @NotNull
    public List<BC> getConfigurations(@Nullable TARGET target) {
        List<Object> list = target == null ? Collections.emptyList() : target.getBuildConfigurations();
        if (list == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public abstract BC getDefaultConfiguration(@Nullable TARGET var1);

    @NotNull
    public abstract List<? extends TARGET> getRunTargets();

    @Nullable
    public abstract TARGET findRunTarget(@Nullable BuildTargetData var1);

    @Nullable
    public TARGET findTarget(@Nullable BuildTargetData targetData) {
        return this.findTarget(targetData, this.getTargets());
    }

    @Contract(value="null, _ -> null")
    public abstract <T extends TARGET> T findTarget(@Nullable BuildTargetData var1, @NotNull List<T> var2);

    @Nullable
    public abstract BC findConfiguration(@Nullable TARGET var1, @Nullable String var2);

    @Nullable
    public TARGET getDefaultTarget() {
        return (TARGET)((CidrBuildTarget)ContainerUtil.getFirstItem(this.getTargets()));
    }

    @Nullable
    public TARGET findFirstSuitableTarget(@Nullable String targetName) {
        return CidrBuildConfigurationHelper.findFirstSuitableTarget(this.getTargets(), targetName);
    }

    @Contract(value="_, null -> null")
    public static <T extends CidrBuildTarget> T findFirstSuitableTarget(@NotNull List<T> targets, @Nullable String targetName) {
        if (targets == null) {
            CidrBuildConfigurationHelper.$$$reportNull$$$0(3);
        }
        if (targetName == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.getName().equals(targetName)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public abstract BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable TARGET var1, @Nullable BC var2, @NotNull List<TARGET> var3);

    public static boolean isTargetDetectionEnabled() {
        return Registry.is((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable");
    }

    public static boolean setTargetDetection(boolean value) {
        boolean oldValue = CidrBuildConfigurationHelper.isTargetDetectionEnabled();
        Registry.get((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable").setValue(value);
        return oldValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSuitableTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

