/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends RunConfigurationProducer<CONFIGURATION> {
    private static final Pattern TEMPLATE_ARGS = Pattern.compile("<.*>");
    protected final CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> myBinder;
    protected final ConfigurationType myConfigurationType;

    protected CidrContextRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        if (configurationType == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (binder == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        super(configurationType);
        this.myBinder = binder;
        this.myConfigurationType = configurationType;
    }

    @NotNull
    protected List<TARGET> getTargetsForFile(@Nullable PsiFile containingFile, @NotNull Predicate<TARGET> condition) {
        if (condition == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                CidrContextRunConfigurationProducer.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<OCResolveConfiguration> orderedConfigurations = new ArrayList<OCResolveConfiguration>(OCWorkspace.getInstance(containingFile.getProject()).getConfigurations());
        orderedConfigurations.retainAll(OCInclusionContextUtil.getAllBuildConfigurationsForFile(containingFile, null));
        ArrayList<TARGET> targets = new ArrayList<TARGET>(orderedConfigurations.size());
        for (OCResolveConfiguration configuration : orderedConfigurations) {
            TARGET target = this.myBinder.getTargetFromResolveConfiguration(configuration);
            if (target == null || !condition.apply(target)) continue;
            targets.add(target);
        }
        List list = Collections.unmodifiableList(targets);
        if (list == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<TARGET> getExecutableTargetsForFile(@Nullable PsiFile containingFile) {
        List<TARGET> list = this.getTargetsForFile(containingFile, target -> target.isExecutable());
        if (list == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setupTarget(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        BuildTargetAndConfigurationData btc;
        if (newConfigurationWithTemplateDefaults == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (targetsWithContext == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((btc = this.findBuiltTargetAndConfiguration(newConfigurationWithTemplateDefaults, targetsWithContext)) == null) {
            return;
        }
        ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).setTargetAndConfigurationData(btc);
    }

    @Nullable
    protected BuildTargetAndConfigurationData findBuiltTargetAndConfiguration(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        Pair<TARGET, BC> selectedTargetAndConfig;
        if (newConfigurationWithTemplateDefaults == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (targetsWithContext == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (targetsWithContext.isEmpty()) {
            return null;
        }
        CidrBuildTarget target = null;
        CidrBuildConfigurationHelper<CidrBuildConfiguration, CidrBuildTarget> helper = ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).getHelper();
        Project project2 = newConfigurationWithTemplateDefaults.getProject();
        BuildTargetAndConfigurationData data = null;
        RunnerAndConfigurationSettings selectedSettings = RunManager.getInstance((Project)project2).getSelectedConfiguration();
        if (selectedSettings != null && this.myBinder.isSupportedRunConfiguration(selectedSettings.getConfiguration())) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration((CidrRunConfiguration)selectedSettings.getConfiguration());
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data == null) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration(newConfigurationWithTemplateDefaults);
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findTarget(data.target, targetsWithContext);
        }
        if (target == null) {
            data = null;
            target = (CidrBuildTarget)targetsWithContext.get(0);
        }
        assert (target != null);
        BuildTargetData buildTargetData = new BuildTargetData(target);
        if (newConfigurationWithTemplateDefaults instanceof CidrExecutableDataHolder) {
            ((CidrExecutableDataHolder)newConfigurationWithTemplateDefaults).setExecutableData(new ExecutableData(buildTargetData));
        }
        if (data == null) {
            Object buildConfiguration = ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).getHelper().getDefaultConfiguration(target);
            data = new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName());
        }
        return data;
    }

    @Nullable
    public static String getCanonicalNameFromSymbol(OCSymbolWithQualifiedName<?> namespaceSymbol, @NotNull OCResolveContext context) {
        OCQualifiedName namespaceQName;
        if (context == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return (namespaceQName = namespaceSymbol.getResolvedQualifiedName(context)) == null ? null : CidrContextRunConfigurationProducer.replaceTemplateParamTo(namespaceQName.getFullName(context), "");
    }

    public static String replaceTemplateParamTo(@NotNull String name2, @NotNull String replacement) {
        if (name2 == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (replacement == null) {
            CidrContextRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        return TEMPLATE_ARGS.matcher(name2).replaceAll(replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrContextRunConfigurationProducer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigurationWithTemplateDefaults";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetsWithContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrContextRunConfigurationProducer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableTargetsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetsForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupTarget";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltTargetAndConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNameFromSymbol";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceTemplateParamTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

