/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.ExecutionResult;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExecUtil {
    private static final int ERROR_MESSAGE_WRAP_LENGTH = 80;

    @NotNull
    public static Map<String, String> appendBuildPathVars(@NotNull Map<String, String> env, @Nullable String buildPath) {
        if (env == null) {
            CidrExecUtil.$$$reportNull$$$0(0);
        }
        CidrExecUtil.appendSearchPath(env, "DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "DYLD_FRAMEWORK_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_FRAMEWORK_PATH", buildPath);
        Map<String, String> map2 = env;
        if (map2 == null) {
            CidrExecUtil.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public static void setIfAbsent(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String value) {
        if (env == null) {
            CidrExecUtil.$$$reportNull$$$0(2);
        }
        if (paramName == null) {
            CidrExecUtil.$$$reportNull$$$0(3);
        }
        if (value != null && !env.containsKey(paramName)) {
            env.put(paramName, value);
        }
    }

    public static void appendSearchPath(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String appendPath) {
        if (env == null) {
            CidrExecUtil.$$$reportNull$$$0(4);
        }
        if (paramName == null) {
            CidrExecUtil.$$$reportNull$$$0(5);
        }
        if (appendPath == null) {
            return;
        }
        String result = env.get(paramName);
        result = result != null ? result + File.pathSeparator + appendPath : appendPath;
        env.put(paramName, result);
    }

    public static void checkErrorOnTermination(@NotNull StringBuilder errOut, @NotNull ExecutionResult<?> result) {
        if (errOut == null) {
            CidrExecUtil.$$$reportNull$$$0(6);
        }
        if (result == null) {
            CidrExecUtil.$$$reportNull$$$0(7);
        }
        if (result.isDone()) {
            return;
        }
        String error = errOut.toString();
        ExecutionException ex = null;
        if (!StringUtil.isEmptyOrSpaces((String)error)) {
            ex = new ExecutionException(error);
        }
        result.setException((Throwable)new ExecutionFinishedException((Throwable)ex));
    }

    public static String wrapErrorOutput(@NotNull String str) {
        if (str == null) {
            CidrExecUtil.$$$reportNull$$$0(8);
        }
        return CidrExecUtil.wrapErrorOutput(str, 80);
    }

    public static String wrapErrorOutput(@NotNull String str, int wrapLen) {
        if (str == null) {
            CidrExecUtil.$$$reportNull$$$0(9);
        }
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)str);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            StringTokenizer st = new StringTokenizer(lines[i], " \n\r");
            if (st.hasMoreTokens()) {
                String word = st.nextToken();
                result.append(word);
                int lineLen = word.length();
                while (st.hasMoreTokens()) {
                    word = st.nextToken();
                    int wordLen = word.length();
                    if (lineLen + wordLen > wrapLen) {
                        result.append('\n');
                        lineLen = wordLen;
                    } else {
                        result.append(' ');
                        lineLen += wordLen + 1;
                    }
                    result.append(word);
                }
            }
            if (i >= lines.length - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrExecUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errOut";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrExecUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "appendBuildPathVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendBuildPathVars";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIfAbsent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkErrorOnTermination";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapErrorOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

