/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.ui.ActionItemsComboBox;
import com.jetbrains.cidr.ui.BaseListRenderer;
import com.jetbrains.cidr.ui.BuildConfigurationPrinter;
import com.jetbrains.cidr.ui.BuildTargetPrinter;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.ItemState;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunConfigurationSettingsEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends SettingsEditor<CONFIGURATION>
implements PanelWithAnchor {
    protected final Project myProject;
    protected final BCH myConfigHelper;
    private JComponent myAnchor;
    private JBLabel myTargetLabel;
    protected JComboBox myTargetCombo;
    protected JComboBox myConfigurationCombo;
    private CommonProgramParametersPanel myCommonProgramParameters;

    public CidrRunConfigurationSettingsEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        if (project2 == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(0);
        }
        if (configHelper == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myConfigHelper = configHelper;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultFill(1).setDefaultAnchor(10).setDefaultWeightX(1, 1.0).setDefaultInsets(0, (Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)).setDefaultInsets(1, (Insets)JBUI.insetsBottom((int)4));
        this.createEditorInner(panel, g);
        this.setAnchor(this.myCommonProgramParameters.getAnchor());
        JPanel jPanel = panel;
        if (jPanel == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    protected void createEditorInner(JPanel panel, GridBag g) {
        this.myTargetLabel = new JBLabel(((CidrBuildConfigurationHelper)this.myConfigHelper).getTargetTitle() + ":");
        panel.add((Component)this.myTargetLabel, g.nextLine().next());
        this.myTargetCombo = CidrRunConfigurationSettingsEditor.createCombo();
        panel.add((Component)this.myTargetCombo, g.next().coverLine());
        this.myTargetLabel.setLabelFor((Component)this.myTargetCombo);
        this.myConfigurationCombo = CidrRunConfigurationSettingsEditor.createCombo();
        if (((CidrBuildConfigurationHelper)this.myConfigHelper).allowEditBuildConfiguration()) {
            JLabel label = new JLabel(((CidrBuildConfigurationHelper)this.myConfigHelper).getConfigurationTitle() + ":");
            panel.add((Component)label, g.nextLine().next());
            panel.add((Component)this.myConfigurationCombo, g.next().coverLine());
            label.setLabelFor(this.myConfigurationCombo);
        }
        this.createAdditionalControls(panel, g);
        this.myCommonProgramParameters = new CommonProgramParametersPanel();
        panel.add((Component)this.myCommonProgramParameters, g.nextLine().weighty(1.0).insets(8, -1, 8, -1).coverLine());
        this.myTargetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && CidrRunConfigurationSettingsEditor.this.myTargetCombo.getItemCount() > 0) {
                    return;
                }
                CidrBuildTarget target = e.getStateChange() == 1 ? (CidrBuildTarget)ComboBoxModelKt.getItemValue(e) : null;
                ReadAction.run(() -> {
                    CidrRunConfigurationSettingsEditor.this.myConfigurationCombo.setModel(new DefaultComboBoxModel<Object>(((CidrBuildConfigurationHelper)CidrRunConfigurationSettingsEditor.this.myConfigHelper).getConfigurations((CidrBuildTarget)target).toArray()));
                    CidrRunConfigurationSettingsEditor.this.myConfigurationCombo.setSelectedItem(null);
                    CidrRunConfigurationSettingsEditor.this.myConfigurationCombo.setSelectedItem(((CidrBuildConfigurationHelper)CidrRunConfigurationSettingsEditor.this.myConfigHelper).getDefaultConfiguration((CidrBuildTarget)target));
                });
                CidrRunConfigurationSettingsEditor.this.onTargetSelected(target);
            }
        });
        this.myTargetCombo.setModel(new DefaultComboBoxModel<Object>(this.getTargets().toArray()));
        this.myTargetCombo.setSelectedItem(null);
        this.myTargetCombo.setRenderer(this.getTargetsRenderer());
        this.myConfigurationCombo.setRenderer(this.getTargetsRenderer());
    }

    @NotNull
    protected List<TARGET> getTargets() {
        List list = ((CidrBuildConfigurationHelper)this.myConfigHelper).getTargets();
        if (list == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected boolean hasTargetsInSeveralProjects() {
        return false;
    }

    @NotNull
    protected MyRunConfigurationsRenderer getTargetsRenderer() {
        MyRunConfigurationsRenderer myRunConfigurationsRenderer = new MyRunConfigurationsRenderer(this.hasTargetsInSeveralProjects(), new ItemPrinter[0]);
        if (myRunConfigurationsRenderer == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(4);
        }
        return myRunConfigurationsRenderer;
    }

    protected void createAdditionalControls(JPanel panel, GridBag g) {
    }

    @NotNull
    protected static MyComboBox createCombo() {
        MyComboBox myComboBox = new MyComboBox();
        if (myComboBox == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(5);
        }
        return myComboBox;
    }

    protected void onTargetSelected(@Nullable TARGET target) {
    }

    protected void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(6);
        }
        this.resetBuildAndConfigurationFrom(runConfiguration);
        this.myCommonProgramParameters.reset(runConfiguration);
    }

    protected void resetBuildAndConfigurationFrom(@NotNull CONFIGURATION runConfiguration) {
        BuildTargetAndConfigurationData buildData;
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(7);
        }
        BuildTargetData buildTargetData = (buildData = ((CidrRunConfiguration)runConfiguration).getTargetAndConfigurationData()) == null ? null : buildData.target;
        ReadAction.run(() -> {
            Object buildTarget = ((CidrBuildConfigurationHelper)this.myConfigHelper).findTarget(buildTargetData);
            Object buildConfig = ((CidrBuildConfigurationHelper)this.myConfigHelper).findConfiguration(buildTarget, buildData == null ? null : buildData.configurationName);
            CidrRunConfigurationSettingsEditor.setSelectedItem(this.myTargetCombo, buildTarget, buildTargetData);
            CidrRunConfigurationSettingsEditor.setSelectedItem(this.myConfigurationCombo, buildConfig, buildData == null ? null : buildData.configurationName);
        });
    }

    protected void applyEditorTo(@NotNull CONFIGURATION runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(8);
        }
        this.applyBuildAndConfigurationTo(runConfiguration);
        this.myCommonProgramParameters.applyTo(runConfiguration);
    }

    protected void applyBuildAndConfigurationTo(@NotNull CONFIGURATION runConfiguration) {
        if (runConfiguration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(9);
        }
        CidrBuildTarget selectedBuildTarget = (CidrBuildTarget)ComboBoxModelKt.getSelectedItemValue(this.myTargetCombo);
        CidrBuildConfiguration selectedConfiguration = (CidrBuildConfiguration)ComboBoxModelKt.getSelectedItemValue(this.myConfigurationCombo);
        BuildTargetData selectedBuildTargetData = selectedBuildTarget != null ? new BuildTargetData(selectedBuildTarget) : (BuildTargetData)ComboBoxModelKt.getSelectedInvalidItemValue(this.myTargetCombo);
        String selectedConfigurationName = selectedConfiguration != null ? selectedConfiguration.getName() : (String)ComboBoxModelKt.getSelectedInvalidItemValue(this.myConfigurationCombo);
        ((CidrRunConfiguration)runConfiguration).setTargetAndConfigurationData(new BuildTargetAndConfigurationData(selectedBuildTargetData, selectedConfigurationName));
        this.syncBuildAndExecute(runConfiguration, selectedBuildTargetData);
    }

    protected void syncBuildAndExecute(@NotNull CONFIGURATION configuration, @Nullable BuildTargetData buildTargetData) {
        if (configuration == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(10);
        }
    }

    protected static void setSelectedItem(@NotNull JComboBox combo, @Nullable Object item, @Nullable Object invalidItemValue) {
        if (combo == null) {
            CidrRunConfigurationSettingsEditor.$$$reportNull$$$0(11);
        }
        item = ComboBoxModelKt.createMaybeInvalidItem(item, invalidItemValue);
        boolean exists = false;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!Comparing.equal((Object)item, combo.getItemAt(i))) continue;
            exists = true;
            break;
        }
        if (!exists) {
            combo.addItem(item);
        }
        combo.setSelectedItem(item);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myTargetLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunConfigurationSettingsEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetBuildAndConfigurationFrom";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyBuildAndConfigurationTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncBuildAndExecute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyRunConfigurationsRenderer
    extends BaseListRenderer {
        public MyRunConfigurationsRenderer(boolean hasTargetsInSeveralProjects, ItemPrinter ... itemPrinters) {
            if (itemPrinters == null) {
                MyRunConfigurationsRenderer.$$$reportNull$$$0(0);
            }
            super(MyRunConfigurationsRenderer.arrayOf(itemPrinters, new BuildTargetPrinter(hasTargetsInSeveralProjects), new BuildConfigurationPrinter()));
        }

        @Override
        public void appendError(@Nullable Object value, @NotNull ItemState state) {
            if (state == null) {
                MyRunConfigurationsRenderer.$$$reportNull$$$0(1);
            }
            super.appendError(value, state);
            String message = this.isChecking() ? CidrBundle.message("test.configuration.checking", new Object[0]) : CidrBundle.message("build.configuration.dialog.item.parameterNotFound", new Object[0]);
            this.appendGrayed(" (" + message + ")", state);
        }

        protected boolean isChecking() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemPrinters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationSettingsEditor$MyRunConfigurationsRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MyComboBox
    extends ActionItemsComboBox<String> {
        protected MyComboBox() {
        }

        public void fireSelectedItemChanged() {
            this.selectedItemChanged();
        }
    }
}

