/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTargetRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    private static CidrTargetRunConfigurationProducer INSTANCE = null;

    protected CidrTargetRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull CidrTargetRunConfigurationBinder<BC, TARGET, CONFIGURATION> binder) {
        if (configurationType == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (binder == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        super(configurationType, binder);
    }

    public static boolean isInEntryPoint(@NotNull PsiElement element) {
        if (element == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        return CidrTargetRunConfigurationProducer.isInEntryPoint(element, null);
    }

    private static boolean isInEntryPoint(@NotNull PsiElement element, @Nullable PsiElement topParent) {
        if (element == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        for (PsiElement current = element; current != null; current = current.getParent()) {
            if (current instanceof PsiFile || current == topParent) {
                return false;
            }
            if (current instanceof OCMacroCall && topParent == null) {
                Ref ref = new Ref();
                PsiElement macroAsParent = current;
                ((OCMacroCall)current).processExpansionLeaves((Processor<PsiElement>)((Processor)leaf -> {
                    boolean inEP = CidrTargetRunConfigurationProducer.isInEntryPoint(leaf, macroAsParent);
                    if (inEP) {
                        ref.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }));
                if (ref.get() != Boolean.TRUE) continue;
                return true;
            }
            if (!CidrTargetRunConfigurationProducer.isEntryPoint(current)) continue;
            return true;
        }
        return false;
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, Ref<PsiElement> sourceElement) {
        BuildTargetAndConfigurationData btc;
        Location location;
        if (configuration == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) != null && CidrTargetRunConfigurationProducer.isInEntryPoint(location.getPsiElement()) && (btc = this.findBuiltTargetAndConfiguration(configuration, this.getExecutableTargetsForFile(location.getPsiElement().getContainingFile()))) != null) {
            ((CidrRunConfiguration)configuration).setTargetAndConfigurationData(btc);
            if (btc.target != null) {
                configuration.setName(btc.target.targetName);
            }
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((location = context.getLocation()) != null && CidrTargetRunConfigurationProducer.isInEntryPoint(location.getPsiElement()) && this.myConfigurationType.equals(configuration.getType())) {
            BuildTargetAndConfigurationData fromContext = this.findBuiltTargetAndConfiguration(configuration, this.getExecutableTargetsForFile(location.getPsiElement().getContainingFile()));
            BuildTargetAndConfigurationData existence = ((CidrRunConfiguration)configuration).getTargetAndConfigurationData();
            return existence != null && fromContext != null && Objects.equals(existence.target, fromContext.target);
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isEntryPoint(@Nullable PsiElement e) {
        OCFunctionSymbol symbol;
        if (e instanceof OCFunctionDefinition && (symbol = ((OCFunctionDefinition)e).getSymbol()) != null && symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION) {
            return symbol.isMainFunction();
        }
        return false;
    }

    @Nullable
    public static synchronized CidrTargetRunConfigurationProducer getInstance(@NotNull Project project2) {
        if (project2 == null) {
            CidrTargetRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (INSTANCE != null) {
            return INSTANCE;
        }
        for (RunConfigurationProducer cp : RunConfigurationProducer.getProducers((Project)project2)) {
            if (!(cp instanceof CidrTargetRunConfigurationProducer)) continue;
            INSTANCE = (CidrTargetRunConfigurationProducer)cp;
            return INSTANCE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrTargetRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInEntryPoint";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

