/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GLogOutputReaders {
    public static final Logger LOG = Logger.getInstance(GLogOutputReaders.class);
    private volatile List<MyLogReader> myReaders = new LinkedList<MyLogReader>();
    private final File myLogDir;
    private final String myLogName;

    public GLogOutputReaders(File logDir, String logName) {
        this.myLogDir = logDir;
        this.myLogName = logName;
    }

    public void init() throws ExecutionException {
        this.myReaders.add(new MyLogReader(this.myLogDir, this.myLogName, LogType.INFO));
    }

    public File getLogDir() {
        return this.myLogDir;
    }

    public void close() {
        List<MyLogReader> readers = this.myReaders;
        this.myReaders = Collections.emptyList();
        for (MyLogReader each : readers) {
            each.stop();
        }
        for (MyLogReader each : readers) {
            try {
                each.waitFor();
            }
            catch (InterruptedException ignore) {
                Thread.interrupted();
                break;
            }
        }
        for (MyLogReader each : readers) {
            File file = each.getFile();
            if (!file.exists()) continue;
            FileUtil.delete((File)file);
        }
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull LogType var2);

    private class MyLogReader {
        @NotNull
        private final File myFile;
        @NotNull
        private final LogType myType;
        @Nullable
        private volatile BaseOutputReader myReader;
        private volatile boolean closed;

        private MyLogReader(@NotNull File dir, @NotNull String name2, LogType type) {
            if (dir == null) {
                MyLogReader.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                MyLogReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyLogReader.$$$reportNull$$$0(2);
            }
            this.myFile = new File(dir, name2 + "." + type.toString());
            this.myType = type;
            if (this.myFile.exists()) {
                FileUtil.delete((File)this.myFile);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                while (!this.closed && !this.myFile.exists()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                        break;
                    }
                }
                if (this.myFile.exists()) {
                    try {
                        this.start("log: " + this.myFile.getName());
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
            });
        }

        private void start(final @NotNull String presentableName) throws IOException {
            if (presentableName == null) {
                MyLogReader.$$$reportNull$$$0(3);
            }
            this.myReader = new BaseOutputReader(new FileInputStream(this.myFile), null){
                {
                    super(arg0, arg1);
                    this.start(presentableName);
                }

                protected void onTextAvailable(@NotNull String text) {
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GLogOutputReaders.this.onTextAvailable(text, MyLogReader.this.myType);
                }

                @NotNull
                protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                    if (runnable2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                    if (future == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return future;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "runnable";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "executeOnPooledThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "onTextAvailable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "executeOnPooledThread";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        private void stop() {
            BaseOutputReader reader = this.myReader;
            if (reader != null) {
                reader.stop();
            }
            this.closed = true;
        }

        private void waitFor() throws InterruptedException {
            BaseOutputReader reader = this.myReader;
            if (reader != null) {
                reader.waitFor();
            }
        }

        @NotNull
        private File getFile() {
            File file = this.myFile;
            if (file == null) {
                MyLogReader.$$$reportNull$$$0(4);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum LogType {
        INFO("INFO"),
        WARNING("WARNING"),
        ERROR("ERROR"),
        FATAL("FATAL");

        private final String myName;

        private LogType(String name2) {
            if (name2 == null) {
                LogType.$$$reportNull$$$0(0);
            }
            this.myName = name2;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/GLogOutputReaders$LogType", "<init>"));
        }
    }
}

