/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.toolchains.OSType;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessOutputReaders {
    private final AtomicReference<MyOutputReader[]> myReaders;
    private final String myPresentableName;
    private final Charset myCharset;

    public ProcessOutputReaders(@NotNull GeneralCommandLine commandLine, boolean usePtyOnUnix) throws ExecutionException {
        if (commandLine == null) {
            ProcessOutputReaders.$$$reportNull$$$0(0);
        }
        this(CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()), commandLine.getCharset(), usePtyOnUnix);
    }

    public ProcessOutputReaders(@NotNull OSType osType, @NotNull GeneralCommandLine commandLine, boolean usePtyOnUnix, boolean isRemoteEnv) throws ExecutionException {
        if (osType == null) {
            ProcessOutputReaders.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            ProcessOutputReaders.$$$reportNull$$$0(2);
        }
        this(osType, CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()), commandLine.getCharset(), usePtyOnUnix, isRemoteEnv);
    }

    public ProcessOutputReaders(@NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix) throws ExecutionException {
        if (presentableName == null) {
            ProcessOutputReaders.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            ProcessOutputReaders.$$$reportNull$$$0(4);
        }
        this(OSType.getCurrent(), presentableName, charset, usePtyOnUnix, false);
    }

    public ProcessOutputReaders(@NotNull OSType osType, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix, boolean isRemoteEnv) throws ExecutionException {
        if (osType == null) {
            ProcessOutputReaders.$$$reportNull$$$0(5);
        }
        if (presentableName == null) {
            ProcessOutputReaders.$$$reportNull$$$0(6);
        }
        if (charset == null) {
            ProcessOutputReaders.$$$reportNull$$$0(7);
        }
        this.myReaders = new AtomicReference<MyOutputReader[]>(new MyOutputReader[2]);
        this.myPresentableName = presentableName;
        this.myCharset = charset;
        try {
            MyOutputReader[] readers = this.getReaders();
            if (osType == OSType.LINUX && isRemoteEnv) {
                usePtyOnUnix = false;
            }
            if (osType == OSType.WIN) {
                readers[0] = new MyWinPipeOutputReader(this, ProcessOutputTypes.STDOUT);
                readers[1] = new MyWinPipeOutputReader(this, ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix) {
                readers[0] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDOUT);
                readers[1] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDERR);
            } else {
                readers[0] = new MyFileOutputReader(this, ProcessOutputTypes.STDOUT);
                readers[1] = new MyFileOutputReader(this, ProcessOutputTypes.STDERR);
            }
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create output file", (Throwable)e);
        }
    }

    public String getOutFileAbsolutePath() throws ExecutionException {
        return this.getReader(0).getFileAbsolutePath();
    }

    public String getErrFileAbsolutePath() throws ExecutionException {
        return this.getReader(1).getFileAbsolutePath();
    }

    protected MyOutputReader[] getReaders() {
        return this.myReaders.get();
    }

    protected MyOutputReader getReader(int num) throws ExecutionException {
        MyOutputReader[] readers = this.getReaders();
        if (ArrayUtil.isEmpty((Object[])readers)) {
            throw new ExecutionException("Reader is closed");
        }
        return readers[num];
    }

    protected boolean doWaitFor(MyOutputReader[] readers) {
        for (MyOutputReader each : readers) {
            try {
                each.waitFor();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
        }
        return true;
    }

    protected boolean doWaitFor(MyOutputReader[] readers, long timeout, TimeUnit unit) {
        for (MyOutputReader each : readers) {
            try {
                each.waitFor(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return true;
    }

    public boolean waitFor() {
        return this.doWaitFor(this.getReaders());
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return this.doWaitFor(this.getReaders(), timeout, unit);
    }

    public void close() {
        MyOutputReader[] readers;
        for (MyOutputReader each : readers = this.myReaders.getAndSet(new MyOutputReader[0])) {
            each.stop();
        }
        this.doWaitFor(readers);
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandLine";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "osType";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "presentableName";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "charset";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ReaderOptions
    extends BaseOutputReader.Options {
        private final BaseDataReader.SleepingPolicy myPolicy;

        public ReaderOptions(BaseDataReader.SleepingPolicy policy) {
            this.myPolicy = policy;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return this.myPolicy;
        }

        public boolean withSeparators() {
            return true;
        }

        public boolean splitToLines() {
            return false;
        }

        public boolean sendIncompleteLines() {
            return true;
        }
    }

    protected class MyWinPipeOutputReader
    extends MyOutputReader {
        @NotNull
        private final WinPipe myPipe;
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyWinPipeOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyWinPipeOutputReader.$$$reportNull$$$0(0);
            }
            this(this$0, WinPipe.createInboundPipe(type.toString()), type);
        }

        protected MyWinPipeOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull WinPipe pipe, Key type) {
            if (pipe == null) {
                MyWinPipeOutputReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyWinPipeOutputReader.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(type, pipe.getPipeName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.SIMPLE);
            this.myPipe = pipe;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.myPipe.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pipe";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyWinPipeOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyUnixPtyOutputReader
    extends MyOutputReader {
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyUnixPtyOutputReader.$$$reportNull$$$0(0);
            }
            this(this$0, new Pty(true), type);
        }

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull Pty pty, Key type) {
            if (pty == null) {
                MyUnixPtyOutputReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyUnixPtyOutputReader.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(type, pty.getSlaveName(), (InputStream)pty.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pty";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyUnixPtyOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyFileOutputReader
    extends MyOutputReader {
        @NotNull
        private final File myFileToDelete;
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyFileOutputReader.$$$reportNull$$$0(0);
            }
            this(this$0, FileUtil.createTempFile((String)this$0.getClass().getSimpleName(), (String)type.toString()), type);
        }

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull File file, Key type) throws IOException {
            if (file == null) {
                MyFileOutputReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyFileOutputReader.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(type, file.getAbsolutePath(), new FileInputStream(file), BaseDataReader.SleepingPolicy.SIMPLE);
            this.myFileToDelete = file;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FileUtil.delete((File)this.myFileToDelete);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyFileOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyOutputReader
    extends BaseOutputReader {
        @NotNull
        private final Key myType;
        @NotNull
        private final String myFileAbsolutePath;

        protected MyOutputReader(@NotNull Key type, @NotNull String fileAbsolutePath, InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
            if (type == null) {
                MyOutputReader.$$$reportNull$$$0(0);
            }
            if (fileAbsolutePath == null) {
                MyOutputReader.$$$reportNull$$$0(1);
            }
            if (stream == null) {
                MyOutputReader.$$$reportNull$$$0(2);
            }
            super(stream, ProcessOutputReaders.this.myCharset, (BaseOutputReader.Options)new ReaderOptions(sleepingPolicy));
            this.myType = type;
            this.myFileAbsolutePath = fileAbsolutePath;
            this.start(ProcessOutputReaders.this.myPresentableName);
        }

        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                MyOutputReader.$$$reportNull$$$0(3);
            }
            text = StringUtil.trimEnd((String)text, (String)"\r");
            text = StringUtil.convertLineSeparators((String)text);
            ProcessOutputReaders.this.onTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                MyOutputReader.$$$reportNull$$$0(4);
            }
            Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable2);
            if (future == null) {
                MyOutputReader.$$$reportNull$$$0(5);
            }
            return future;
        }

        public void stop() {
            super.stop();
            if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
                try {
                    this.waitFor(this.mySleepingPolicy.getTimeToSleep(false), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException ignored) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                    }
                }
            }
        }

        @NotNull
        public String getFileAbsolutePath() {
            String string = this.myFileAbsolutePath;
            if (string == null) {
                MyOutputReader.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAbsolutePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyOutputReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyOutputReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileAbsolutePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

