/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.pty4j.windows.CygwinPTYInputStream;
import com.pty4j.windows.CygwinPTYOutputStream;
import com.pty4j.windows.NamedPipe;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class WinPipe {
    private static final Kernel32 KERNEL32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
    private static final int PIPE_ACCESS_INBOUND = 1;
    private static final int PIPE_ACCESS_OUTBOUND = 2;
    private static final AtomicInteger ourProcessCounter = new AtomicInteger();
    private final NamedPipe myNamedPipe;
    private final WinNT.HANDLE myHandle;
    private final String myPipeName;

    private WinPipe(int pipeDirectionFlag, @NotNull String nameSuffix) throws IOException {
        if (nameSuffix == null) {
            WinPipe.$$$reportNull$$$0(0);
        }
        this.myPipeName = String.format("\\\\.\\pipe\\cidr-%d-%d-", KERNEL32.GetCurrentProcessId(), ourProcessCounter.getAndIncrement()) + nameSuffix;
        this.myHandle = KERNEL32.CreateNamedPipeA(this.myPipeName, pipeDirectionFlag | 0x40000000, 0, 1, 0, 0, 0, null);
        if (this.myHandle == WinBase.INVALID_HANDLE_VALUE) {
            KERNEL32.CloseHandle(this.myHandle);
            throw new IOException("Unable to create a named pipe");
        }
        this.myNamedPipe = new NamedPipe(this.myHandle, false);
    }

    @NotNull
    public static WinPipe createOutboundPipe(@NotNull String nameSuffix) throws IOException {
        if (nameSuffix == null) {
            WinPipe.$$$reportNull$$$0(1);
        }
        WinPipe winPipe = new WinPipe(2, nameSuffix);
        if (winPipe == null) {
            WinPipe.$$$reportNull$$$0(2);
        }
        return winPipe;
    }

    @NotNull
    public static WinPipe createInboundPipe(@NotNull String nameSuffix) throws IOException {
        if (nameSuffix == null) {
            WinPipe.$$$reportNull$$$0(3);
        }
        WinPipe winPipe = new WinPipe(1, nameSuffix);
        if (winPipe == null) {
            WinPipe.$$$reportNull$$$0(4);
        }
        return winPipe;
    }

    @NotNull
    public String getPipeName() {
        String string = this.myPipeName;
        if (string == null) {
            WinPipe.$$$reportNull$$$0(5);
        }
        return string;
    }

    public InputStream getInputStream() {
        return new CygwinPTYInputStream(this.myNamedPipe);
    }

    public OutputStream getOutputStream() {
        return new CygwinPTYOutputStream(this.myNamedPipe);
    }

    public void close() throws IOException {
        if (!KERNEL32.CloseHandle(this.myHandle)) {
            throw new IOException("Unable to close named pipe: " + this.getPipeName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSuffix";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/WinPipe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/WinPipe";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutboundPipe";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInboundPipe";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPipeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createOutboundPipe";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInboundPipe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Kernel32
    extends Library {
        public WinNT.HANDLE CreateNamedPipeA(String var1, int var2, int var3, int var4, int var5, int var6, int var7, WinBase.SECURITY_ATTRIBUTES var8);

        public boolean CloseHandle(WinNT.HANDLE var1);

        public int GetCurrentProcessId();
    }
}

