/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.BuildListener;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBuild {
    public static ExecutionResult<Boolean> execute(@NotNull Project project2, final @NotNull BuildContext context, @NotNull String taskName, @NotNull String progressTitle, @NotNull Runnable doExecute2) {
        if (project2 == null) {
            CidrBuild.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CidrBuild.$$$reportNull$$$0(1);
        }
        if (taskName == null) {
            CidrBuild.$$$reportNull$$$0(2);
        }
        if (progressTitle == null) {
            CidrBuild.$$$reportNull$$$0(3);
        }
        if (doExecute2 == null) {
            CidrBuild.$$$reportNull$$$0(4);
        }
        final Object processCreationLock = new Object();
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            context.indicator = new EmptyProgressIndicator();
        } else {
            final ExecutionResult indicatorResult = new ExecutionResult();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (project2 == null) {
                    CidrBuild.$$$reportNull$$$0(18);
                }
                if (taskName == null) {
                    CidrBuild.$$$reportNull$$$0(19);
                }
                if (context == null) {
                    CidrBuild.$$$reportNull$$$0(20);
                }
                new Task.Backgroundable(project2, taskName, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicatorResult.set(indicator);
                        boolean wasCanceled = false;
                        while (!context.myResult.isDone()) {
                            if (!wasCanceled && indicator.isCanceled()) {
                                wasCanceled = true;
                                Object object = processCreationLock;
                                synchronized (object) {
                                    ProcessHandler process2 = context.processHandler;
                                    if (process2 != null) {
                                        process2.destroyProcess();
                                    }
                                }
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                throw new ProcessCanceledException((Throwable)e);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/build/CidrBuild$1", "run"));
                    }
                }.queue();
            });
            try {
                context.indicator = (ProgressIndicator)indicatorResult.get();
                context.indicator.setText(progressTitle);
                context.indicator.setText2("");
            }
            catch (ExecutionException e) {
                context.myResult.setException(e);
                return context.myResult;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (context == null) {
                CidrBuild.$$$reportNull$$$0(12);
            }
            if (project2 == null) {
                CidrBuild.$$$reportNull$$$0(13);
            }
            if (doExecute2 == null) {
                CidrBuild.$$$reportNull$$$0(14);
            }
            if (!context.waitAndStart()) {
                return;
            }
            TransactionGuard.submitTransaction((Disposable)project2, () -> {
                if (context == null) {
                    CidrBuild.$$$reportNull$$$0(15);
                }
                if (project2 == null) {
                    CidrBuild.$$$reportNull$$$0(16);
                }
                if (doExecute2 == null) {
                    CidrBuild.$$$reportNull$$$0(17);
                }
                Object object = processCreationLock;
                synchronized (object) {
                    if (context.indicator.isCanceled()) {
                        context.finished(false);
                        return;
                    }
                    MessageView.SERVICE.getInstance((Project)project2);
                    FileDocumentManager.getInstance().saveAllDocuments();
                    doExecute2.run();
                }
            });
        });
        return context.myResult;
    }

    public static void startProcess(final Project project2, final @NotNull NotificationGroup logNotificationGroup, final String taskName, final BuildContext context, final @Nullable BuildListener buildListener, final List<File> toRefresh) {
        if (logNotificationGroup == null) {
            CidrBuild.$$$reportNull$$$0(5);
        }
        context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                context.indicator.setText(CidrBundle.message("build.refreshing", new Object[0]));
                context.indicator.setText2("");
                CidrBuild.refreshFiles(toRefresh, () -> {
                    MessageType messageType;
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (logNotificationGroup == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (project2.isDisposed()) {
                        return;
                    }
                    boolean buildSucceeded = event.getExitCode() == 0;
                    boolean canceled = context2.indicator.isCanceled();
                    context2.duration = System.currentTimeMillis() - context2.started;
                    context.finished(buildSucceeded);
                    if (canceled) {
                        messageType = MessageType.INFO;
                        context2.finishMessage = CidrBundle.message("build.canceled", taskName);
                    } else {
                        boolean hasWarningsOrErrors;
                        boolean bl = hasWarningsOrErrors = context2.errors > 0 || context2.warnings > 0;
                        messageType = !buildSucceeded ? MessageType.ERROR : (hasWarningsOrErrors ? MessageType.WARNING : MessageType.INFO);
                        context2.finishMessage = buildSucceeded ? CidrBundle.message("build.finished", taskName) : CidrBundle.message("build.failed", taskName);
                        context2.finishDetails = hasWarningsOrErrors ? CidrBundle.message("build.details", context2.errors, context2.warnings) : null;
                    }
                    String fullMessage = CidrBuild.showFinishMessage(project2, logNotificationGroup, messageType, context2.finishMessage, context2.finishDetails, context2.duration);
                    if (buildListener != null) {
                        buildListener.finished(buildSucceeded ? MessageType.INFO : MessageType.ERROR, fullMessage);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "logNotificationGroup";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$processTerminated$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        context.processHandler.startNotify();
    }

    public static void refreshFiles(@NotNull Iterable<File> files, @Nullable Runnable onFinish) {
        if (files == null) {
            CidrBuild.$$$reportNull$$$0(6);
        }
        ArrayList virtualFilesToRefresh = new ArrayList();
        for (File each : files) {
            VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(each);
            if (dir == null) continue;
            virtualFilesToRefresh.addAll(VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{dir}));
        }
        LocalFileSystem.getInstance().refreshFiles(virtualFilesToRefresh, true, true, onFinish);
    }

    static String showFinishMessage(Project project2, @NotNull NotificationGroup logNotificationGroup, @NotNull MessageType messageType, @NotNull String finishMessage, @Nullable String finishDetails, long time) {
        if (logNotificationGroup == null) {
            CidrBuild.$$$reportNull$$$0(7);
        }
        if (messageType == null) {
            CidrBuild.$$$reportNull$$$0(8);
        }
        if (finishMessage == null) {
            CidrBuild.$$$reportNull$$$0(9);
        }
        MessageView.SERVICE.getInstance((Project)project2);
        String notificationContent = finishMessage + (finishDetails == null ? "" : " with " + finishDetails);
        if (time > 0L) {
            notificationContent = notificationContent + " in " + StringUtil.formatDuration((long)time);
        }
        Notification notification = logNotificationGroup.createNotification(notificationContent, messageType);
        notification.notify(project2);
        if (messageType != MessageType.INFO) {
            ToolWindowManager.getInstance((Project)project2).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, notificationContent);
        }
        SystemNotifications.getInstance().notify(notification.getGroupId(), StringUtil.capitalizeWords((String)finishMessage, (boolean)true), StringUtil.notNullize((String)finishDetails));
        return notificationContent;
    }

    static Pair<AnAction, Disposable> initializeBuildLog(@NotNull BuildContext context, @NotNull String logName) {
        if (context == null) {
            CidrBuild.$$$reportNull$$$0(10);
        }
        if (logName == null) {
            CidrBuild.$$$reportNull$$$0(11);
        }
        File file = null;
        FileWriter writer = null;
        try {
            file = FileUtil.createTempFile((String)logName, (String)".log", (boolean)true);
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            OCLog.LOG.error("Cannot create build log file", (Throwable)e);
        }
        final File finalFile = file;
        final FileWriter finalWriter = writer;
        AnAction showBuildLogAction = new AnAction(CidrBundle.message("build.action.showLog", new Object[0]), null, AllIcons.Debugger.Console){

            public void actionPerformed(AnActionEvent event) {
                if (finalFile == null) {
                    return;
                }
                try {
                    Runtime.getRuntime().exec("open " + finalFile.getPath());
                }
                catch (IOException e) {
                    OCLog.LOG.error("Cannot open build log file: " + finalFile, (Throwable)e);
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(finalFile != null);
            }
        };
        if (finalWriter != null) {
            context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    try {
                        finalWriter.write(event.getText());
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (finalWriter != null) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }
                if (finalFile != null) {
                    FileUtil.delete((File)finalFile);
                }
            }
        };
        return Pair.create((Object)showBuildLogAction, (Object)disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 4: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doExecute";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logNotificationGroup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishMessage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/build/CidrBuild";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshFiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showFinishMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeBuildLog";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$2";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BuildContext {
        @NotNull
        protected final ExecutionResult<Boolean> myResult;
        private static final Key<Semaphore> BUILD_SEMAPHORE_KEY = Key.create((String)"BUILD_SEMAPHORE_KEY");
        private final Project myProject;
        private final Semaphore myBuildSemaphore;
        @NotNull
        public ProgressIndicator indicator;
        @NotNull
        public ProcessHandler processHandler;
        @Nullable
        public String finishMessage;
        @Nullable
        public String finishDetails;
        public final long started;
        public long duration;
        public int errors;
        public int warnings;

        public BuildContext(@NotNull Project project2) {
            if (project2 == null) {
                BuildContext.$$$reportNull$$$0(0);
            }
            this.myResult = new ExecutionResult();
            this.started = System.currentTimeMillis();
            this.myProject = project2;
            Semaphore semaphore = (Semaphore)this.myProject.getUserData(BUILD_SEMAPHORE_KEY);
            if (semaphore == null) {
                semaphore = (Semaphore)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(BUILD_SEMAPHORE_KEY, (Object)new Semaphore(1));
            }
            this.myBuildSemaphore = semaphore;
        }

        public boolean isRunning() {
            return !this.indicator.isCanceled() && !this.processHandler.isProcessTerminated() && !this.processHandler.isProcessTerminating();
        }

        public void stop() {
            this.indicator.cancel();
        }

        /*
         * Exception decompiling
         */
        public boolean waitAndStart() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void finished(boolean success) {
            this.myBuildSemaphore.release();
            this.myResult.set(success);
            if (!this.myProject.isDisposed()) {
                OCWorkspaceModificationTrackers.getInstance(this.myProject).getBuildsTracker().incModificationCount();
            }
        }

        public void error(Throwable e) {
            this.myBuildSemaphore.release();
            this.myResult.setException(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/build/CidrBuild$BuildContext", "<init>"));
        }
    }
}

