/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmView;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ExpiredException;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key THROW_ON_THREAD_COLLECTION = Key.create((String)"THROW_ON_THREAD_COLLECTION");
    public static final Key THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private final UserDataHolderBase myUserDataHolder;
    private final QueueProcessor<DebuggerCommand> myCommandQueue;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    private final String myDriverName;
    private final DebuggerDriverConfiguration myConfiguration;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore;
    protected final ConsoleView myConsole;
    private final List<Filter> myBackendConsoleFilters;
    private volatile LanguageConsoleView myBackendConsole;
    @NotNull
    private final CidrDisasmView myDisassemblyView;
    protected final RunParameters myRunParameters;
    private final ConcurrentMap<Language, CidrDebuggerTypesHelper> myTypesHelpers;
    private final List<Couple<File>> mySymbolFiles;
    final ExecutionResult<DebuggerDriver.Inferior> myInferiorResult;
    private volatile State myState;
    private volatile String myCurrentStateMessage;
    private final Map<Pair<String, Integer>, CachedValue<List<String>>> myCompletionCache;

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(1);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(2);
        }
        this(parameters, session, consoleBuilder, it -> Filter.EMPTY_ARRAY);
    }

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsoleFilterProvider backendConsoleFilterProvider) throws ExecutionException {
        if (parameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(3);
        }
        if (session == null) {
            CidrDebugProcess.$$$reportNull$$$0(4);
        }
        if (consoleBuilder == null) {
            CidrDebugProcess.$$$reportNull$$$0(5);
        }
        if (backendConsoleFilterProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(6);
        }
        super(session);
        this.myUserDataHolder = new UserDataHolderBase();
        this.myAttachedSemaphore = new Semaphore(0);
        this.myTypesHelpers = ContainerUtil.newConcurrentMap();
        this.mySymbolFiles = ContainerUtil.newArrayList();
        this.myInferiorResult = new ExecutionResult();
        this.myState = State.INITIALIZED;
        this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
        this.myCompletionCache = new HashMap<Pair<String, Integer>, CachedValue<List<String>>>();
        session.setPauseActionSupported(true);
        this.myCommandQueue = new QueueProcessor((Consumer)new MyCommandProcessor(), Conditions.alwaysFalse());
        this.myRunParameters = parameters;
        this.myConfiguration = parameters.getDebuggerDriverConfiguration();
        this.myDriverName = this.myConfiguration.getDriverName();
        this.myDriverDoNotUse = this.myConfiguration.createDriver(this);
        final ProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        this.myProcessHandler = new MyProcessHandler((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                driverProcessHandler.startNotify();
            }

            private boolean shouldDetach(boolean willBeDestroyed) {
                return !willBeDestroyed;
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                CidrDebugProcess.this.myAttachedSemaphore.release();
                Alarm forceTerminateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                CidrDebugProcess.this.postCommand(driver -> {
                    try {
                        if (this.shouldDetach(willBeDestroyed)) {
                            CidrDebugProcess.this.myInferiorResult.get().detach();
                        } else {
                            CidrDebugProcess.this.myInferiorResult.get().destroy();
                        }
                    }
                    finally {
                        if (forceTerminateAlarm.cancelAllRequests() > 0) {
                            driverProcessHandler.destroyProcess();
                        }
                    }
                    driver.checkErrors();
                });
                forceTerminateAlarm.addRequest(() -> {
                    CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
                    driverProcessHandler.destroyProcess();
                }, 3000L, ModalityState.any());
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
                CidrDebugProcess.this.myState = State.FINISHED;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEditorsProvider = CidrDebugProcess.createEditorsProvider(session.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = (XBreakpointHandler[])ContainerUtil.toArray((List)handlersList, (Object[])new XBreakpointHandler[handlersList.size()]);
        this.myConsole = consoleBuilder.getConsole();
        this.myBackendConsoleFilters = ContainerUtil.newSmartList((Object[])backendConsoleFilterProvider.getDefaultFilters(this.getProject()));
        this.myDisassemblyView = new CidrDisasmView(this);
    }

    @NotNull
    public String getCurrentStateMessage() {
        String string = this.myCurrentStateMessage;
        if (string == null) {
            CidrDebugProcess.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(8);
        }
        return consoleView;
    }

    @NotNull
    private static XDebuggerEditorsProvider createEditorsProvider(RunProfile profile2) throws ExecutionException {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = CidrDebuggerLanguageSupportManager.createEditor(profile2);
        if (xDebuggerEditorsProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(9);
        }
        return xDebuggerEditorsProvider;
    }

    public boolean isDetachDefault() {
        return false;
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        if (driver == null) {
            CidrDebugProcess.$$$reportNull$$$0(10);
        }
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(11);
        }
        EvaluationContext evaluationContext = this.myConfiguration.createEvaluationContext(driver, expirable, frame);
        if (evaluationContext == null) {
            CidrDebugProcess.$$$reportNull$$$0(12);
        }
        return evaluationContext;
    }

    public boolean driverSupportsArrayEvaluation() {
        return this.myConfiguration.supportsArrayEvaluation();
    }

    public boolean driverSupportsCodeFragmentEvaluation() {
        return this.myConfiguration.isCodeFragmentEvaluationSupported();
    }

    public boolean driverSupportsDisasm() {
        return this.myDriverDoNotUse.supportsDisasm();
    }

    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    public DebuggerDriver.Inferior getInferiorInTests() {
        try {
            return this.myInferiorResult.get();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.myDriverName, this.myDriverDoNotUse.getConsoleLanguage());
        this.myBackendConsoleFilters.forEach(arg_0 -> ((LanguageConsoleView)this.myBackendConsole).addMessageFilter(arg_0));
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, (Object)this);
        this.myBackendConsole.setEditable(false);
        this.postCommand(driver -> {
            DebuggerDriver.Inferior inferior;
            try {
                inferior = this.doLoadTarget(driver);
                List<Couple<File>> list = this.mySymbolFiles;
                synchronized (list) {
                    for (Couple<File> file : this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file.first, (File)file.second);
                    }
                    this.mySymbolFiles.clear();
                }
                this.myState = State.STARTED;
            }
            catch (ExecutionException e) {
                this.myInferiorResult.setException(e);
                throw e;
            }
            this.myInferiorResult.set(inferior);
        });
    }

    @NotNull
    protected abstract DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver var1) throws ExecutionException;

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    2.$$$reportNull$$$0(0);
                }
                Content content = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.myDriverName, AllIcons.Debugger.ToolConsole, null);
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myBackendConsole);
                content.setCloseable(false);
                ui.addContent(content, 0, PlaceInGrid.center, false);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)CidrDebugProcess.this.myBackendConsole, text -> CidrDebugProcess.this.executeConsoleCommand((String)text), (String)"AppCode.Debug.Console", null, null);
                CidrDebugProcess.this.getSession().addSessionListener(new XDebugSessionListener(){

                    public void sessionPaused() {
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.enableConsole(false);
                    }

                    private void enableConsole(boolean enabled) {
                        UIUtil.invokeAndWaitIfNeeded(() -> {
                            if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                                return;
                            }
                            CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                        });
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$2", "registerAdditionalContent"));
            }
        };
        if (xDebugTabLayouter == null) {
            CidrDebugProcess.$$$reportNull$$$0(13);
        }
        return xDebugTabLayouter;
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            CidrDebugProcess.$$$reportNull$$$0(14);
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        CidrBreakpointHandler cidrBreakpointHandler = new CidrBreakpointHandler(this);
        if (cidrBreakpointHandler == null) {
            CidrDebugProcess.$$$reportNull$$$0(15);
        }
        return cidrBreakpointHandler;
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        CidrExceptionBreakpointHandler cidrExceptionBreakpointHandler = new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
        if (cidrExceptionBreakpointHandler == null) {
            CidrDebugProcess.$$$reportNull$$$0(16);
        }
        return cidrExceptionBreakpointHandler;
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            CidrDebugProcess.$$$reportNull$$$0(17);
        }
        return this.myBreakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            CidrDebugProcess.$$$reportNull$$$0(18);
        }
        return consoleView;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.postCommand(driver -> {
            if (this.myState != State.STARTED) {
                return;
            }
            this.doStartTarget(this.myInferiorResult.get());
            this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
            this.getSession().rebuildViews();
        });
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws ExecutionException {
        if (inferior == null) {
            CidrDebugProcess.$$$reportNull$$$0(19);
        }
        return inferior.start();
    }

    public void stop() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            this.myWatchpointHandler.cleanup();
        }, (ModalityState)ModalityState.defaultModalityState());
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(DebuggerDriver::interrupt);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.postCommand(DebuggerDriver::resume);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(20);
        }
        this.postCommand(driver -> {
            if (position == null) {
                CidrDebugProcess.$$$reportNull$$$0(61);
            }
            driver.runTo(position.getFile().getPath(), position.getLine());
        });
    }

    private static boolean isDisassemblyContext(@Nullable XSuspendContext context) {
        if (context == null) {
            return false;
        }
        XExecutionStack stack = context.getActiveExecutionStack();
        if (stack == null) {
            return false;
        }
        XStackFrame frame = stack.getTopFrame();
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        return !((CidrStackFrame)frame).hasSourceFile();
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        this.postCommand(driver -> driver.stepOver(stepByInstruction));
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        this.postCommand(driver -> driver.stepInto(false, stepByInstruction));
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        this.postCommand(driver -> driver.stepInto(true, stepByInstruction));
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.postCommand(DebuggerDriver::stepOut);
    }

    @Nullable
    public XSourcePosition createDisasmPosition(@NotNull Address address) {
        if (address == null) {
            CidrDebugProcess.$$$reportNull$$$0(21);
        }
        if (!this.driverSupportsDisasm()) {
            return null;
        }
        return this.myDisassemblyView.disassemble(address);
    }

    protected void executeConsoleCommand(@NotNull String text) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(22);
        }
        long threadId = this.getCurrentThreadId();
        int frameIndex = this.getCurrentFrameIndex();
        this.postCommand(debuggerDriver -> {
            if (text == null) {
                CidrDebugProcess.$$$reportNull$$$0(60);
            }
            try {
                void driver;
                driver.executeConsoleCommand(threadId, frameIndex, text);
            }
            catch (DebuggerCommandException e) {
                this.printlnToConsole(e.getMessage());
            }
        });
    }

    public void postCommand(@NotNull DebuggerCommand command) {
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(23);
        }
        this.myCommandQueue.add((Object)command);
    }

    public void handleConsoleCompletion(CompletionParameters parameters, CompletionResultSet result) {
        int offset;
        String command = parameters.getOriginalFile().getText();
        Pair key = new Pair((Object)command, (Object)(offset = parameters.getOffset() > 0 ? parameters.getOffset() - 1 : 0));
        Object cachedValue = this.myCompletionCache.get(key);
        if (cachedValue == null) {
            cachedValue = new CachedValueImpl<List<String>>(() -> {
                ArrayList completions = new ArrayList();
                Semaphore completionSemaphore = new Semaphore(0);
                this.postCommand(driver -> driver.handleCompletion(command, offset, completions));
                try {
                    completionSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return new CachedValueProvider.Result(completions, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }){

                public boolean isFromMyProject(Project project2) {
                    return true;
                }
            };
        }
        this.myCompletionCache.put((Pair<String, Integer>)key, (CachedValue<List<String>>)cachedValue);
        List completions = (List)cachedValue.getValue();
        for (String str : completions) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)str));
        }
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        return position == null ? null : (PsiElement)ReadAction.compute(() -> this.getTypesHelper(position).getContextElement(position));
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(24);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(25);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(26);
        }
        if (value == null) {
            CidrDebugProcess.$$$reportNull$$$0(27);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrDebugProcess.$$$reportNull$$$0(28);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrDebugProcess.$$$reportNull$$$0(29);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrDebugProcess.$$$reportNull$$$0(30);
        }
        CidrDebuggerTypesHelper cidrDebuggerTypesHelper = this.getTypesHelper(CidrDebuggerLanguageSupportManager.getLanguage(frame));
        if (cidrDebuggerTypesHelper == null) {
            CidrDebugProcess.$$$reportNull$$$0(31);
        }
        return cidrDebuggerTypesHelper;
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper(@NotNull XSourcePosition position) {
        if (position == null) {
            CidrDebugProcess.$$$reportNull$$$0(32);
        }
        CidrDebuggerTypesHelper cidrDebuggerTypesHelper = this.getTypesHelper(CidrDebuggerLanguageSupportManager.getLanguage(position));
        if (cidrDebuggerTypesHelper == null) {
            CidrDebugProcess.$$$reportNull$$$0(33);
        }
        return cidrDebuggerTypesHelper;
    }

    private CidrDebuggerTypesHelper getTypesHelper(@Nullable Language language) {
        Language key = language == null ? Language.ANY : language;
        CidrDebuggerTypesHelper helper = (CidrDebuggerTypesHelper)this.myTypesHelpers.get(key);
        if (helper == null) {
            helper = CidrDebuggerLanguageSupportManager.createTypesHelper(language, this);
            this.myTypesHelpers.put(key, helper);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module2) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + (Object)((Object)this.myState)));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module2));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        RunParameters runParameters = this.myRunParameters;
        if (runParameters == null) {
            CidrDebugProcess.$$$reportNull$$$0(34);
        }
        return runParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand command, @NotNull ExecutionException exception) {
        DebuggerIllegalStateException illegalState;
        if (driver == null) {
            CidrDebugProcess.$$$reportNull$$$0(35);
        }
        if (command == null) {
            CidrDebugProcess.$$$reportNull$$$0(36);
        }
        if (exception == null) {
            CidrDebugProcess.$$$reportNull$$$0(37);
        }
        if ((illegalState = (DebuggerIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DebuggerIllegalStateException.class))) != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)illegalState));
            command.rejected(message);
            if (!(command instanceof DebuggerUIUpdateCommand)) {
                this.getSession().reportMessage(message, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            this.reportErrorInRedBalloon(exception);
            if (isFatalError) {
                driver.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (!(exception instanceof ThrowInTest.TestExecutionException)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CidrDebuggerLog.LOG.warn((Throwable)exception);
            } else {
                CidrDebuggerLog.LOG.error((Throwable)exception);
            }
        }
    }

    private void reportErrorInRedBalloon(ExecutionException e) {
        String message = e.getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
            message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e));
        }
        this.getSession().reportMessage(message, MessageType.ERROR, (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class));
    }

    public void printlnToConsole(@Nullable String message) {
        if (message != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message = StringUtil.stripHtml((String)message, (boolean)true)))) {
                message = message + "\n";
            }
            this.getProcessHandler().notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public long getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1L;
    }

    public int getCurrentFrameIndex() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameIndex() : -1;
    }

    @Override
    public void handleRunning() {
        this.getSession().sessionResumed();
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(38);
        }
        this.getSession().positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, null));
    }

    @Override
    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(39);
        }
        if (signal == null) {
            CidrDebugProcess.$$$reportNull$$$0(40);
        }
        if (meaning == null) {
            CidrDebugProcess.$$$reportNull$$$0(41);
        }
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause("Signal", signal + " (" + meaning + ")"));
    }

    @Override
    public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String description) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(42);
        }
        if (description == null) {
            CidrDebugProcess.$$$reportNull$$$0(43);
        }
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause("Exception", description));
    }

    private void doHandleSignalled(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(44);
        }
        if (cause == null) {
            CidrDebugProcess.$$$reportNull$$$0(45);
        }
        this.printlnToConsole(cause.getDisplayString());
        ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, cause), true);
    }

    @Override
    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        Object b;
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(46);
        }
        if ((b = this.myBreakpointHandler.getCodepoint(breakpointNumber)) == null) {
            b = this.myExceptionBreakpointHandler.getCodepoint(breakpointNumber);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getCodepoint(breakpointNumber);
        }
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(47);
        }
        Object b = this.myWatchpointHandler.getCodepoint(watchpointNumber);
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleConnected(@NotNull String connection) {
        if (connection == null) {
            CidrDebugProcess.$$$reportNull$$$0(48);
        }
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.connectedTo", connection));
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    @Override
    public void handleDisconnected() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.disconnected", new Object[0]));
        this.getSession().stop();
    }

    protected void handleCodepoint(@NotNull DebuggerDriver.StopPlace stopPlace, @Nullable XBreakpoint<?> b) {
        XBreakpointProperties props;
        if (stopPlace == null) {
            CidrDebugProcess.$$$reportNull$$$0(49);
        }
        CidrSuspensionCause cause = null;
        XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
        if (props instanceof CidrExceptionBreakpointType.Properties) {
            cause = new CidrSuspensionCause("Exception", "Exception breakpoint");
        }
        CidrSuspendContext suspendContext = new CidrSuspendContext(stopPlace, cause);
        if (b == null) {
            ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)suspendContext, true);
            return;
        }
        String expression = b.getLogExpression();
        if (expression == null) {
            boolean shouldSuspend = this.getSession().breakpointReached(b, null, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
            return;
        }
        this.postCommand(driver -> {
            boolean shouldSuspend;
            String evaluatedLogExpression;
            block7: {
                evaluatedLogExpression = null;
                XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
                XStackFrame frame = executionStack != null ? executionStack.getTopFrame() : null;
                XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
                CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
                try {
                    if (evaluator != null) {
                        try {
                            CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, (XExpression)XExpressionImpl.fromText((String)expression));
                            evaluatedLogExpression = expression + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.createEvaluationContext(driver, null));
                        }
                        catch (DebuggerCommandException e) {
                            evaluatedLogExpression = "error evaluating " + expression + ": " + e.getMessage();
                        }
                        break block7;
                    }
                    evaluatedLogExpression = "error evaluating " + expression;
                }
                catch (Throwable throwable) {
                    boolean shouldSuspend2 = this.getSession().breakpointReached(b, evaluatedLogExpression, (XSuspendContext)suspendContext);
                    if (!shouldSuspend2) {
                        driver.resume();
                    }
                    throw throwable;
                }
            }
            if (!(shouldSuspend = this.getSession().breakpointReached(b, evaluatedLogExpression, (XSuspendContext)suspendContext))) {
                driver.resume();
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(50);
        }
        if (type == null) {
            CidrDebugProcess.$$$reportNull$$$0(51);
        }
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    @Override
    public void handleGDBOutput(@NotNull String text) {
        if (text == null) {
            CidrDebugProcess.$$$reportNull$$$0(52);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (text == null) {
                CidrDebugProcess.$$$reportNull$$$0(59);
            }
            this.myBackendConsole.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
        }, (ModalityState)ModalityState.any());
    }

    @Override
    public void handlePrompt(@NotNull String prompt) {
        if (prompt == null) {
            CidrDebugProcess.$$$reportNull$$$0(53);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (prompt == null) {
                CidrDebugProcess.$$$reportNull$$$0(58);
            }
            LanguageConsoleView backendConsole = this.myBackendConsole;
            if (this.getProject().isDisposed() || backendConsole == null || Disposer.isDisposed((Disposable)backendConsole)) {
                return;
            }
            this.getDebuggerConsole().setPrompt(prompt);
        }, (ModalityState)ModalityState.any());
    }

    @Override
    public void handleTargetFinished(int code, @Nullable String description) {
        this.myProcessHandler.setExitCode(code);
        if (description != null) {
            this.myProcessHandler.notifyTextAvailable(description + "\n", ProcessOutputTypes.SYSTEM);
        }
        this.getSession().stop();
    }

    @Override
    public void handleTargetTerminated() {
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(int watchpointNumber) {
        GuiUtils.invokeLaterIfNeeded(() -> this.myWatchpointHandler.handleWatchpointScope(watchpointNumber), (ModalityState)ModalityState.any());
        this.postCommand(DebuggerDriver::resume);
    }

    @Override
    public void handleModulesLoaded(@NotNull List<String> modules) {
        if (modules == null) {
            CidrDebugProcess.$$$reportNull$$$0(54);
        }
    }

    @Override
    public void handleBreakpointChanged(LLBreakPointBroadcast broadcast_change) {
        XLineBreakpoint breakpoint = (XLineBreakpoint)this.myBreakpointHandler.getCodepoint(broadcast_change.getId());
        if (breakpoint == null) {
            return;
        }
        LLBreakpoint lb = new LLBreakpoint(broadcast_change.getId(), breakpoint.getFileUrl(), breakpoint.getLine(), broadcast_change.getNumLocations(), broadcast_change.getNumResolvedLocations(), false, broadcast_change.getIsValid(), "", "");
        if (lb.getBreakpointValidityState() == LLBreakpoint.ValidityState.RESOLVED) {
            this.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
        }
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause) {
        if (thread == null) {
            CidrDebugProcess.$$$reportNull$$$0(55);
        }
        CidrExecutionStack cidrExecutionStack = new CidrExecutionStack(thread, frame, current, cause);
        if (cidrExecutionStack == null) {
            CidrDebugProcess.$$$reportNull$$$0(56);
        }
        return cidrExecutionStack;
    }

    public static boolean viewsUpdatesDisabledInTests(@NotNull Object container) {
        if (container == null) {
            CidrDebugProcess.$$$reportNull$$$0(57);
        }
        return ApplicationManager.getApplication().isUnitTestMode() && !container.getClass().getSimpleName().contains("XTest");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendConsoleFilterProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess";
                break;
            }
            case 10: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferior";
                break;
            }
            case 20: 
            case 32: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 22: 
            case 50: 
            case 52: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signal";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStateMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorsProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluationContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabLayouter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createExceptionHandler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesHelper";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunParameters";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "newExecutionStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 56: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doStartTarget";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDisasmPosition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommand";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "postCommand";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypesHelper";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "handleCommandException";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doHandleSignalled";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpoint";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "handleWatchpoint";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "handleConnected";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "handleCodepoint";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetOutput";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "handleGDBOutput";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "handlePrompt";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesLoaded";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "newExecutionStack";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "viewsUpdatesDisabledInTests";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handlePrompt$14";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleGDBOutput$13";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeConsoleCommand$8";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runToPosition$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CidrExecutionStack
    extends XExecutionStack {
        @NotNull
        private final LLThread myThread;
        @Nullable
        private volatile CidrStackFrame myTopFrame;
        @Nullable
        private final CidrSuspensionCause mySuspensionCause;

        public CidrExecutionStack(@Nullable LLThread thread, LLFrame frame, @Nullable boolean current, CidrSuspensionCause suspensionCause) {
            if (thread == null) {
                CidrExecutionStack.$$$reportNull$$$0(0);
            }
            super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
            this.myThread = thread;
            this.mySuspensionCause = suspensionCause;
            this.myTopFrame = frame == null ? null : this.newFrame(frame);
        }

        public XStackFrame getTopFrame() {
            return this.myTopFrame;
        }

        public void computeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(driver -> {
                try {
                    boolean hasMore;
                    boolean repeat;
                    if (container.isObsolete()) {
                        return;
                    }
                    ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_FRAME_COLLECTION);
                    ArrayList<CidrStackFrame> result = new ArrayList<CidrStackFrame>();
                    CidrStackFrame toSelect = null;
                    int currentFrom = originalFrom;
                    int currentBatchSize = 100;
                    do {
                        if (container.isObsolete()) {
                            return;
                        }
                        repeat = false;
                        DebuggerDriver.ResultList<LLFrame> framesResult = driver.getFrames(this.myThread.getId(), currentFrom, currentBatchSize, currentFrom == 0);
                        CidrStackFrame top = this.myTopFrame;
                        result.ensureCapacity(result.size() + framesResult.list.size());
                        for (int i = 0; i < framesResult.list.size(); ++i) {
                            CidrStackFrame frame;
                            if (container.isObsolete()) {
                                return;
                            }
                            if (currentFrom == 0 && i == 0) {
                                if (top != null) {
                                    frame = top;
                                } else {
                                    top = this.myTopFrame = this.newFrame((LLFrame)framesResult.list.get(i));
                                    frame = this.myTopFrame;
                                }
                            } else {
                                frame = this.newFrame((LLFrame)framesResult.list.get(i));
                            }
                            result.add(frame);
                        }
                        hasMore = framesResult.hasMore;
                        if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame() || (toSelect = (CidrStackFrame)result.stream().filter(CidrStackFrame::hasSourceFile).findFirst().orElse(null)) != null || !hasMore || framesResult.list.size() >= currentBatchSize) continue;
                        currentFrom = framesResult.list.size();
                        currentBatchSize -= currentFrom;
                        repeat = true;
                    } while (repeat);
                    if (container instanceof XStackFrameContainerEx) {
                        ((XStackFrameContainerEx)container).addStackFrames(result, toSelect, !hasMore);
                    } else {
                        CidrDebuggerLog.LOG.error("Expected instanceof XStackFrameContainerEx, got" + container.getClass());
                        container.addStackFrames(result, !hasMore);
                    }
                    if (hasMore && !container.isObsolete()) {
                        this.computeStackFrames(currentFrom + result.size(), container);
                    }
                }
                catch (DebuggerCommandException e) {
                    container.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            });
        }

        private boolean shouldSelectDisasmFrame() {
            if (!CidrDebugProcess.this.driverSupportsDisasm()) {
                return false;
            }
            return this.mySuspensionCause == null;
        }

        @NotNull
        private CidrStackFrame newFrame(@NotNull LLFrame frame) {
            if (frame == null) {
                CidrExecutionStack.$$$reportNull$$$0(1);
            }
            CidrStackFrame cidrStackFrame = new CidrStackFrame(CidrDebugProcess.this, this.myThread, frame, this.mySuspensionCause);
            if (cidrStackFrame == null) {
                CidrExecutionStack.$$$reportNull$$$0(2);
            }
            return cidrStackFrame;
        }

        @Nullable
        public GutterIconRenderer getExecutionLineIconRenderer() {
            if (this.mySuspensionCause == null) {
                return super.getExecutionLineIconRenderer();
            }
            return new GutterIconRenderer(){

                @NotNull
                public Icon getIcon() {
                    Icon icon = ((CidrExecutionStack)CidrExecutionStack.this).mySuspensionCause.icon;
                    if (icon == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon;
                }

                @Nullable
                public String getTooltipText() {
                    return CidrExecutionStack.this.mySuspensionCause.getDisplayString();
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                        return false;
                    }
                    return Comparing.equal((Object)CidrExecutionStack.this.mySuspensionCause, (Object)((CidrExecutionStack)((Object)o)).mySuspensionCause);
                }

                public int hashCode() {
                    return CidrExecutionStack.this.mySuspensionCause.hashCode();
                }

                public boolean isDumbAware() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$CidrExecutionStack$1", "getIcon"));
                }
            };
        }

        public String toString() {
            return this.myThread.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$CidrExecutionStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$CidrExecutionStack";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newFrame";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "newFrame";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class CidrSuspendContext
    extends XSuspendContext {
        @NotNull
        private final XExecutionStack myActiveStack;
        private final long myActiveStackFrameId;

        public CidrSuspendContext(@Nullable DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cause) {
            if (stopPlace == null) {
                CidrSuspendContext.$$$reportNull$$$0(0);
            }
            this.myActiveStack = CidrDebugProcess.this.newExecutionStack(stopPlace.thread, stopPlace.frame, true, cause);
            this.myActiveStackFrameId = stopPlace.thread.getId();
        }

        @Nullable
        public XExecutionStack getActiveExecutionStack() {
            return this.myActiveStack;
        }

        public void computeExecutionStacks(XSuspendContext.XExecutionStackContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(driver -> {
                try {
                    ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_THREAD_COLLECTION);
                    List<LLThread> threads = driver.getThreads();
                    ArrayList<XExecutionStack> stacks = new ArrayList<XExecutionStack>(threads.size());
                    for (LLThread each : threads) {
                        stacks.add(each.getId() == this.myActiveStackFrameId ? this.myActiveStack : CidrDebugProcess.this.newExecutionStack(each, null, false, null));
                    }
                    container.addExecutionStack(stacks, true);
                }
                catch (DebuggerCommandException e) {
                    container.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopPlace", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$CidrSuspendContext", "<init>"));
        }
    }

    private class MyCommandProcessor
    implements Consumer<DebuggerCommand> {
        private MyCommandProcessor() {
        }

        public void consume(DebuggerCommand c) {
            ProcessHandler driverHandler = CidrDebugProcess.this.myDriverDoNotUse.getProcessHandler();
            if (driverHandler.isProcessTerminating() || driverHandler.isProcessTerminated()) {
                c.rejected("Process finished");
                return;
            }
            try {
                c.run(CidrDebugProcess.this.myDriverDoNotUse);
            }
            catch (ExpiredException expiredException) {
            }
            catch (ExecutionException e) {
                CidrDebugProcess.this.handleCommandException(CidrDebugProcess.this.myDriverDoNotUse, c, e);
            }
        }
    }

    private class MyProcessHandler
    extends ProcessHandler {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        public MyProcessHandler(ProcessListener processListener) {
            if (processListener != null) {
                this.addProcessListener(processListener);
            }
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        @NotNull
        public Integer getExitCode() {
            Integer exitCode = this.myExitCode.get();
            Integer n = exitCode == null ? 0 : exitCode;
            if (n == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            return n;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(boolean detach) {
            ProcessIOExecutorService.INSTANCE.submit(() -> {
                if (CidrDebugProcess.this.waitForTermination()) {
                    if (detach) {
                        this.notifyProcessDetached();
                    } else {
                        this.notifyProcessTerminated(this.getExitCode());
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (x$0, x$1) -> super.notifyTextAvailable(x$0, x$1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MyProcessHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExitCode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$MyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DebuggerUIUpdateCommand
    extends DebuggerCommand {
    }

    public static interface DebuggerStartupCommand
    extends DebuggerCommand {
    }

    public static interface DebuggerCommand {
        public void run(@NotNull DebuggerDriver var1) throws ExecutionException;

        default public void rejected(@NotNull String reason) {
            if (reason == null) {
                DebuggerCommand.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/jetbrains/cidr/execution/debugger/CidrDebugProcess$DebuggerCommand", "rejected"));
        }
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED;

    }
}

