/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtension;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtensionPoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    private static final CidrDebuggerEditorsExtension DEFAULT_EXTENSION = Arrays.stream(CidrDebuggerEditorsExtensionPoint.EP_NAME.getExtensions()).filter(it -> it.isDefault).findFirst().get().getInstance();
    @NotNull
    private static final FileType DEFAULT_FILE_TYPE = DEFAULT_EXTENSION.getSupportedLanguage().getAssociatedFileType();

    @NotNull
    public final FileType getFileType() {
        FileType fileType = DEFAULT_FILE_TYPE;
        if (fileType == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return fileType;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project2, @Nullable XSourcePosition sourcePosition) {
        if (project2 == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        Set<Language> set = Collections.singleton(CidrDebuggerEditorsProvider.getLanguage(null, sourcePosition));
        if (set == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Document createDocument(final @NotNull Project project2, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, final @NotNull EvaluationMode mode) {
        if (project2 == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(5);
        }
        final String text = expression.getExpression();
        if (sourcePosition != null) {
            Language language = CidrDebuggerEditorsProvider.getLanguage(expression, sourcePosition);
            final CidrDebuggerEditorsExtension extension = Arrays.stream(CidrDebuggerEditorsExtensionPoint.EP_NAME.getExtensions()).map(CidrDebuggerEditorsExtensionPoint::getInstance).filter(it -> language == it.getSupportedLanguage()).findFirst().orElse(DEFAULT_EXTENSION);
            final PsiElement context = extension.getContext(project2, sourcePosition);
            if (context != null) {
                Document document = (Document)new WriteAction<Document>(){

                    protected void run(@NotNull Result<Document> result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PsiFile fragment = extension.createExpressionCodeFragment(project2, text, context, mode);
                        result.setResult((Object)PsiDocumentManager.getInstance((Project)project2).getDocument(fragment));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/execution/debugger/CidrDebuggerEditorsProvider$1", "run"));
                    }
                }.execute().getResultObject();
                if (document == null) {
                    CidrDebuggerEditorsProvider.$$$reportNull$$$0(6);
                }
                return document;
            }
        }
        LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (CharSequence)text);
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
        if (document == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(7);
        }
        return document;
    }

    @NotNull
    private static Language getLanguage(@Nullable XExpression expression, @Nullable XSourcePosition position) {
        FileType type;
        if (expression != null && expression.getLanguage() != null) {
            Language language = expression.getLanguage();
            if (language == null) {
                CidrDebuggerEditorsProvider.$$$reportNull$$$0(8);
            }
            return language;
        }
        if (position != null && (type = position.getFile().getFileType()) instanceof LanguageFileType) {
            Language language = ((LanguageFileType)type).getLanguage();
            if (language == null) {
                CidrDebuggerEditorsProvider.$$$reportNull$$$0(9);
            }
            return language;
        }
        Language language = DEFAULT_EXTENSION.getSupportedLanguage();
        if (language == null) {
            CidrDebuggerEditorsProvider.$$$reportNull$$$0(10);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerEditorsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerEditorsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedLanguages";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

