/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(0);
        }
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            File file = new File(new File(CidrPathManager.getCidrSourcesRoot(), "cidr-debugger/bin/lldb/" + selector), relativePath);
            if (file == null) {
                CidrDebuggerPathManager.$$$reportNull$$$0(1);
            }
            return file;
        }
        File file = new File(PathManager.getBinPath(), "lldb/" + relativePath);
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        if (CidrDebuggerPathManager.isFromSources()) {
            File file = new File(CidrPathManager.getCidrSourcesRoot(), "cidr-debugger/bin/lldb/renderers");
            if (file == null) {
                CidrDebuggerPathManager.$$$reportNull$$$0(3);
            }
            return file;
        }
        File file = new File(PathManager.getBinPath(), "lldb/renderers");
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public static File getBundledGDBBinary() {
        File file = CidrDebuggerPathManager.getBundledGDBFile(SystemInfo.isWindows ? "bin/gdb.exe" : "bin/gdb");
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    public static File getBundledGDBFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(6);
        }
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            File file = new File(new File(CidrPathManager.getCidrSourcesRoot(), "cidr-debugger/bin/gdb/" + selector + "/"), relativePath);
            if (file == null) {
                CidrDebuggerPathManager.$$$reportNull$$$0(7);
            }
            return file;
        }
        File file = new File(PathManager.getBinPath(), "gdb/" + relativePath);
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public static File getWinbreakFile(@NotNull String name2) {
        if (name2 == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(9);
        }
        if (CidrDebuggerPathManager.isFromSources()) {
            File file = new File(new File(CidrPathManager.getCidrSourcesRoot(), "cidr-debugger/bin/gdb/"), name2);
            if (file == null) {
                CidrDebuggerPathManager.$$$reportNull$$$0(10);
            }
            return file;
        }
        File file = new File(PathManager.getBinPath(), "gdb/" + name2);
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public static File getBundledGDBSTLPrettyPrinters() {
        if (CidrDebuggerPathManager.isFromSources()) {
            File file = new File(CidrPathManager.getCidrSourcesRoot(), "cidr-debugger/bin/gdb/renderers");
            if (file == null) {
                CidrDebuggerPathManager.$$$reportNull$$$0(12);
            }
            return file;
        }
        File file = new File(PathManager.getBinPath(), "gdb/renderers");
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(13);
        }
        return file;
    }

    @Nullable
    public static File getOSXSystemPythonBinDir() {
        File pythonBinDir = new File("/System/Library/Frameworks/Python.framework/Versions/Current/bin");
        if (pythonBinDir.exists() && pythonBinDir.isDirectory()) {
            return pythonBinDir;
        }
        return null;
    }

    private static boolean isFromSources() {
        return PluginManagerCore.isRunningFromSources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBBinFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledLLDBSTLPrettyPrinters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledGDBBinary";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledGDBFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinbreakFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledGDBSTLPrettyPrinters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBundledGDBFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWinbreakFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

