/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettingsConfigurable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerSettings
extends XDebuggerSettings<CidrDebuggerSettings> {
    public boolean RENDERERS_ENABLED = true;
    public boolean VALUES_FILTER_ENABLED = true;
    public boolean COCOA_RENDERERS_ENABLED = true;
    public boolean CORE_DATA_RENDERERS_ENABLED = true;
    public boolean STL_RENDERERS_ENABLED = true;
    public boolean HEX_FORMATTING_ENABLED = false;
    public boolean HEX_AS_SECONDARY_FORMATTING_ENABLED = true;

    @NotNull
    public static CidrDebuggerSettings getInstance() {
        CidrDebuggerSettings cidrDebuggerSettings = (CidrDebuggerSettings)CidrDebuggerSettings.getInstance(CidrDebuggerSettings.class);
        if (cidrDebuggerSettings == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(0);
        }
        return cidrDebuggerSettings;
    }

    public CidrDebuggerSettings() {
        super("ObjectiveC");
    }

    public static void updateCurrentDebugSession(AnActionEvent e) {
        Project project2 = AnAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session == null) {
            return;
        }
        session.rebuildViews();
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(1);
        }
        if (PlatformUtils.isCidr()) {
            switch (category) {
                case DATA_VIEWS: {
                    List<CidrDebuggerSettingsConfigurable> list = Collections.singletonList(new CidrDebuggerSettingsConfigurable(this));
                    if (list == null) {
                        CidrDebuggerSettings.$$$reportNull$$$0(2);
                    }
                    return list;
                }
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(4);
        }
        return PlatformUtils.isCidr() && "Objective-C".equals(configurable.getDisplayName());
    }

    public CidrDebuggerSettings getState() {
        return this;
    }

    public void loadState(@NotNull CidrDebuggerSettings state) {
        if (state == null) {
            CidrDebuggerSettings.$$$reportNull$$$0(5);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

