/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder;
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    @NotNull
    private final LLFrame myFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    public static final Key THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");
    @NotNull
    private final NotNullLazyValue<Pair<XSourcePosition, Boolean>> mySourceOrDisasmLazyValue;

    public CidrStackFrame(@NotNull CidrDebugProcess process2, @NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause) {
        if (process2 == null) {
            CidrStackFrame.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            CidrStackFrame.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrStackFrame.$$$reportNull$$$0(2);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.mySourceOrDisasmLazyValue = NotNullLazyValue.createValue(this::doGetSourceOrDisasm);
        this.myProcess = process2;
        this.myThread = thread;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(3);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(4);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(5);
        }
        if (value == null) {
            CidrStackFrame.$$$reportNull$$$0(6);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrStackFrame.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(8);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            CidrStackFrame.$$$reportNull$$$0(9);
        }
        return cidrDebugProcess;
    }

    public long getThreadId() {
        return this.myThread.getId();
    }

    @NotNull
    public LLFrame getFrame() {
        LLFrame lLFrame = this.myFrame;
        if (lLFrame == null) {
            CidrStackFrame.$$$reportNull$$$0(10);
        }
        return lLFrame;
    }

    public int getFrameIndex() {
        return this.myFrame.getIndex();
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThread.getId(), (Object)this.myFrame.getIndex());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.getSourcePosition(true);
    }

    @Nullable
    public XSourcePosition getSourcePosition(boolean disassembleIfNeeded) {
        Pair sourceOrDisasm = (Pair)this.mySourceOrDisasmLazyValue.getValue();
        return disassembleIfNeeded || (Boolean)sourceOrDisasm.second != false ? (XSourcePosition)sourceOrDisasm.first : null;
    }

    public boolean hasSourceFile() {
        return this.getSourcePosition(false) != null;
    }

    @NotNull
    protected Pair<XSourcePosition, Boolean> doGetSourceOrDisasm() {
        XSourcePosition sourcePosition;
        VirtualFile resolvedFile = this.resolveFile();
        if (resolvedFile != null && (sourcePosition = XDebuggerUtil.getInstance().createPosition(resolvedFile, this.myFrame.getLine())) != null) {
            Pair pair2 = Pair.create((Object)sourcePosition, (Object)true);
            if (pair2 == null) {
                CidrStackFrame.$$$reportNull$$$0(11);
            }
            return pair2;
        }
        Pair pair3 = Pair.create((Object)this.myProcess.createDisasmPosition(this.myFrame.getProgramCounter()), (Object)false);
        if (pair3 == null) {
            CidrStackFrame.$$$reportNull$$$0(12);
        }
        return pair3;
    }

    @Nullable
    private VirtualFile resolveFile() {
        String file = this.myFrame.getFile();
        return file == null ? null : (VirtualFile)ReadAction.compute(() -> {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(file);
            if (vFile == null) {
                return null;
            }
            VirtualFile resolvedFile = ProjectRootUtil.findSymlinkedFileInContent((Project)this.myProcess.getProject(), (VirtualFile)vFile);
            if (CidrDebuggerLog.LOG.isTraceEnabled() && !vFile.equals(resolvedFile)) {
                CidrDebuggerLog.LOG.trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
            }
            return resolvedFile;
        });
    }

    @Nullable
    public PsiElement getContext() {
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> this.myProcess.getTypesHelper(this).getContextElement(this.getSourcePosition(false))));
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            CidrStackFrame.$$$reportNull$$$0(13);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
        XSourcePosition position = this.getSourcePosition(false);
        if (position != null) {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(" " + position.getFile().getName() + ":" + (position.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            component.append(" " + this.myFrame.getProgramCounter(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrStackFrame.$$$reportNull$$$0(14);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            if (node == null) {
                CidrStackFrame.$$$reportNull$$$0(20);
            }
            try {
                this.doComputeChildren(driver, node);
            }
            catch (DebuggerCommandException e) {
                node.setErrorMessage(e.getMessage());
            }
            catch (ExecutionException e) {
                node.setErrorMessage(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node) throws DebuggerCommandException, ExecutionException {
        if (driver == null) {
            CidrStackFrame.$$$reportNull$$$0(15);
        }
        if (node == null) {
            CidrStackFrame.$$$reportNull$$$0(16);
        }
        if (node.isObsolete()) {
            return;
        }
        if (this.mySuspensionCause != null) {
            XValueChildrenList list = new XValueChildrenList(1);
            list.add(new XNamedValue(this.mySuspensionCause.type){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    node.setPresentation(((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.icon, null, ((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.reason, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame$1";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            node.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        XSourcePosition framePosition = this.getSourcePosition(false);
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED);
        List<LLValue> vars = this.myFrame.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT ? ((LLDBDriver)driver).getVariables(this.myThread.getId(), this.myFrame.getIndex(), true, false) : driver.getVariables(this.myThread.getId(), this.myFrame.getIndex());
        vars = ContainerUtil.filter(vars, value -> {
            if (node == null) {
                CidrStackFrame.$$$reportNull$$$0(17);
            }
            if (framePosition == null) {
                value.setValid(false);
                return true;
            }
            boolean[] resolved = new boolean[1];
            boolean[] special = new boolean[]{false};
            Integer variableLine = (Integer)ReadAction.compute(() -> {
                DumbService dumbService;
                if (node == null) {
                    CidrStackFrame.$$$reportNull$$$0(18);
                }
                if ((dumbService = DumbService.getInstance((Project)this.myProcess.getProject())).isDumb()) {
                    special[0] = true;
                    dumbService.runWhenSmart(() -> {
                        if (node == null) {
                            CidrStackFrame.$$$reportNull$$$0(19);
                        }
                        if (!node.isObsolete()) {
                            this.myProcess.getSession().rebuildViews();
                        }
                    });
                    return null;
                }
                CidrDebuggerTypesHelper typesHelper = this.myProcess.getTypesHelper(this);
                PsiElement declarator = typesHelper.resolveToDeclaration(framePosition, (LLValue)((Object)value));
                boolean bl = resolved[0] = declarator != null;
                if (declarator == null) {
                    Boolean thisSelfSupper = typesHelper.isImplicitContextVariable(framePosition, (LLValue)((Object)value));
                    special[0] = thisSelfSupper != null ? thisSelfSupper : false;
                    return null;
                }
                PsiFile targetFile = declarator.getContainingFile();
                if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)framePosition.getFile())) {
                    return null;
                }
                int endOffset = declarator.getTextRange().getEndOffset();
                Document document = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
                if (document == null) {
                    return null;
                }
                return document.getLineNumber(endOffset);
            });
            value.setValid(special[0] || resolved[0] && variableLine != null && variableLine < framePosition.getLine());
            return !CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED || resolved[0] || special[0];
        });
        CidrValue.addLocalValues((Collection<LLValue>)vars, this.myProcess, framePosition, this, node);
    }

    public CidrEvaluator getEvaluator() {
        return CidrDebuggerLanguageSupportManager.createEvaluator(this);
    }

    public String toString() {
        return this.myFrame.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetSourceOrDisasm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doComputeChildren$5";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeChildren$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

