/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEvaluator
extends CidrEvaluator {
    public OCEvaluator(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            OCEvaluator.$$$reportNull$$$0(0);
        }
        super(frame);
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            OCEvaluator.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            OCEvaluator.$$$reportNull$$$0(2);
        }
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            OCEvaluator.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            OCEvaluator.$$$reportNull$$$0(4);
        }
        this.myFrame.getProcess().postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    1.$$$reportNull$$$0(0);
                }
                XSourcePosition valuePosition = expressionPosition == null ? OCEvaluator.this.myFrame.getSourcePosition() : expressionPosition;
                try {
                    CidrEvaluatedValue evaluatedValue = OCEvaluator.this.doEvaluate(driver, valuePosition, expression);
                    callback.evaluated((XValue)evaluatedValue);
                }
                catch (DebuggerCommandException e) {
                    callback.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            }

            @Override
            public void rejected(@NotNull String reason) {
                if (reason == null) {
                    1.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(reason);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "driver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reason";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/OCEvaluator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rejected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public TextRange getExpressionRangeAtOffset(Project project2, Document document, int offset, boolean sideEffectsAllowed) {
        return (TextRange)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            if (file == null) {
                return null;
            }
            PsiElement el = OCEvaluator.findSuitableExpression(file, offset, sideEffectsAllowed);
            return el == null ? null : el.getTextRange();
        }));
    }

    @Nullable
    private static PsiElement findSuitableExpression(PsiFile file, int offset, boolean sideEffectsAllowed) {
        OCSymbol s;
        PsiElement result = null;
        if (sideEffectsAllowed) {
            PsiElement macro;
            result = file.findElementAt(offset);
            if (result == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(result))) {
                if (offset > 0) {
                    result = file.findElementAt(offset - 1);
                }
                if (result == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(result))) {
                    return null;
                }
            }
            if ((macro = OCEvaluator.getIfMacroCall(result)) != null) {
                result = macro;
            } else {
                PsiElement call = OCEvaluator.getIfFunctionCall(result = PsiTreeUtil.getParentOfType((PsiElement)result, OCExpression.class, (boolean)false));
                if (call != null) {
                    result = call;
                }
            }
        } else {
            PsiReference ref = file.findReferenceAt(offset);
            if (ref instanceof OCReference) {
                OCSymbol symbol;
                result = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), OCReferenceExpression.class, (boolean)false);
                if (result != null && ((symbol = ((OCReferenceExpression)result).resolveToSymbol()) == null || symbol instanceof OCMacroSymbol)) {
                    return null;
                }
                if (OCEvaluator.getIfFunctionCall(result) != null) {
                    return null;
                }
            }
        }
        if (result instanceof OCReferenceExpression && (s = ((OCReferenceExpression)result).resolveToSymbol()) instanceof OCClassSymbol) {
            return null;
        }
        PsiElement slice = OCEvaluator.getIfArraySlice(result, sideEffectsAllowed);
        if (slice != null) {
            result = slice;
        }
        return result;
    }

    @Nullable
    private static PsiElement getIfFunctionCall(@Nullable PsiElement el) {
        PsiElement parent;
        if (el instanceof OCReferenceExpression && (parent = el.getParent()) instanceof OCCallExpression) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfMacroCall(@Nullable PsiElement el) {
        PsiElement parent;
        PsiElement psiElement = parent = el == null ? null : el.getParent();
        if (parent != null) {
            if (el.getNode().getElementType() instanceof OCPunctuatorElementType && parent instanceof OCMacroCall) {
                return parent;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof OCMacroCall) {
                return grandParent;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfArraySlice(@Nullable PsiElement el, boolean sideEffectsAllowed) {
        if (el == null) {
            return null;
        }
        PsiElement parent = el.getParent();
        OCArraySelectionExpression slice = null;
        if (el instanceof OCArraySelectionExpression) {
            slice = (OCArraySelectionExpression)el;
        } else if (parent instanceof OCArraySelectionExpression) {
            slice = (OCArraySelectionExpression)parent;
        }
        if (slice == null) {
            return null;
        }
        if (!sideEffectsAllowed) {
            OCExpression index = slice.getIndexExpression();
            PsiElementProcessor.FindFilteredElement processor2 = new PsiElementProcessor.FindFilteredElement(new PsiElementFilter(){

                public boolean isAccepted(PsiElement each) {
                    return each instanceof OCExpression && !(each instanceof OCLiteralExpression) && !(each instanceof OCReferenceExpression) && !(each instanceof OCCastExpression) && !(each instanceof OCParenthesizedExpression);
                }
            });
            PsiTreeUtil.processElements((PsiElement)index, (PsiElementProcessor)processor2);
            if (processor2.isFound()) {
                return null;
            }
        }
        return slice;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/OCEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

