/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriver {
    public static final Key<String> DEBUGSERVER_SOCKET = Key.create((String)"DEBUGSERVER_SOCKET");
    public static final Key<Integer> DEBUGSERVER_ID = Key.create((String)"DEBUGSERVER_ID");
    public static final int LOAD_TIMEOUT_MS = 90000;
    public static final int TIMEOUT_MS = 30000;
    public static final int EVALUATION_TIMEOUT_MS = 30000;
    public static final int CLOSE_TIMEOUT_MS = 300;
    public static final int DESTROY_TIMEOUT_MS = 1500;
    public static final int MAX_DESCRIPTION = 1000;
    public static final int MAX_CHILD_COUNT = Integer.MAX_VALUE;
    protected final Handler myHandler;
    private volatile TargetState myState;
    protected final QueueProcessor<Runnable> myHandlerProcessor;
    @Nullable
    private ProcessOutputReaders myReaders;
    protected volatile GeneralCommandLine myTargetCommandLine;
    protected boolean myToRedirect;

    public DebuggerDriver(@NotNull Handler handler) {
        if (handler == null) {
            DebuggerDriver.$$$reportNull$$$0(0);
        }
        this.myState = TargetState.NOT_READY;
        this.myHandlerProcessor = QueueProcessor.createRunnableQueueProcessor();
        this.myHandler = Handler.createQueuedHandler(handler, this.myHandlerProcessor);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    public abstract boolean supportsWatchpointLifetime();

    public boolean supportsDisasm() {
        return true;
    }

    @NotNull
    public abstract Language getConsoleLanguage();

    @NotNull
    public abstract ProcessHandler getProcessHandler();

    public abstract boolean isInPromptMode();

    public TargetState getState() {
        return this.myState;
    }

    public abstract void setValuesFilteringEnabled(boolean var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForLaunch(@NotNull Installer var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(int var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(@NotNull String var1, boolean var2) throws ExecutionException;

    public abstract boolean interrupt() throws ExecutionException;

    public abstract boolean resume() throws ExecutionException;

    public void stepOver() throws ExecutionException {
        this.stepOver(null);
    }

    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo) throws ExecutionException {
        this.stepInto(forceStepIntoFramesWithNoDebugInfo, null);
    }

    public abstract void stepOver(@Nullable Boolean var1) throws ExecutionException;

    public abstract void stepInto(boolean var1, @Nullable Boolean var2) throws ExecutionException;

    public abstract void stepOut() throws ExecutionException;

    public abstract void runTo(String var1, int var2) throws ExecutionException;

    protected abstract void doExit() throws ExecutionException;

    @NotNull
    public abstract LLWatchpoint addWatchpoint(long var1, int var3, LLValue var4, String var5, LLWatchpoint.Lifetime var6, LLWatchpoint.AccessType var7) throws ExecutionException, DebuggerCommandException;

    public abstract void removeWatchpoint(List<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line) throws ExecutionException, DebuggerCommandException {
        List<LLBreakpoint> list = this.addBreakpoint(path, line, null);
        if (list == null) {
            DebuggerDriver.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public abstract List<LLBreakpoint> addBreakpoint(String var1, int var2, @Nullable String var3) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern) throws ExecutionException, DebuggerCommandException {
        if (symbolPattern == null) {
            DebuggerDriver.$$$reportNull$$$0(2);
        }
        return this.addSymbolicBreakpoint(symbolPattern, null, null);
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern, @Nullable String module2, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (symbolPattern == null) {
            DebuggerDriver.$$$reportNull$$$0(3);
        }
        SymbolicBreakpoint symBreakpoint = new SymbolicBreakpoint();
        symBreakpoint.setPattern(symbolPattern);
        symBreakpoint.setModule(module2);
        symBreakpoint.setCondition(condition);
        return this.addSymbolicBreakpoint(symBreakpoint);
    }

    @Nullable
    public abstract LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull SymbolicBreakpoint var1) throws ExecutionException, DebuggerCommandException;

    public abstract void removeCodepoints(@NotNull Collection<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public ResultList<LLFrame> getFrames(long threadId, int from, int count) throws ExecutionException, DebuggerCommandException {
        ResultList<LLFrame> resultList = this.getFrames(threadId, from, count, false);
        if (resultList == null) {
            DebuggerDriver.$$$reportNull$$$0(4);
        }
        return resultList;
    }

    @NotNull
    public abstract ResultList<LLFrame> getFrames(long var1, int var3, int var4, boolean var5) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLValue> getVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            DebuggerDriver.$$$reportNull$$$0(5);
        }
        return this.getChildrenCount(var, Integer.MAX_VALUE);
    }

    @Nullable
    public abstract Integer getChildrenCount(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract LLValueData getData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract String getDescription(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<LLValue> getVariableChildren(LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LLValue evaluate(long threadId, int frameIndex, @NotNull String string) throws ExecutionException, DebuggerCommandException {
        void expression;
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(6);
        }
        LLValue lLValue = this.evaluate(threadId, frameIndex, (String)expression, null);
        if (lLValue == null) {
            DebuggerDriver.$$$reportNull$$$0(7);
        }
        return lLValue;
    }

    @NotNull
    public abstract LLValue evaluate(long var1, int var3, @NotNull String var4, @Nullable DebuggerLanguage var5) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLInstruction> disassemble(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLInstruction disassemble(@NotNull Address address) throws ExecutionException, DebuggerCommandException {
        List<LLInstruction> instructions;
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(8);
        }
        return (instructions = this.disassemble(address.rangeTo(address))).isEmpty() ? null : instructions.get(0);
    }

    @NotNull
    public abstract ShellCommandResult executeShellCommand(@NotNull String var1, @Nullable List<String> var2, @Nullable String var3, int var4) throws ExecutionException;

    public abstract void executeConsoleCommand(String var1) throws ExecutionException, DebuggerCommandException;

    public abstract void executeConsoleCommand(long var1, int var3, String var4) throws ExecutionException, DebuggerCommandException;

    public abstract void handleCompletion(String var1, int var2, List<String> var3) throws ExecutionException;

    public abstract void handleSignal(String var1, boolean var2, boolean var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    protected void setState(TargetState state) {
        this.myState = state;
        if (state == TargetState.FINISHED) {
            this.closeOutputReaders();
        }
    }

    protected void handleRunning() {
        this.setState(TargetState.RUNNING);
        this.myHandler.handleRunning();
    }

    protected void handleModulesLoaded(@NotNull List<String> modules) {
        if (modules == null) {
            DebuggerDriver.$$$reportNull$$$0(9);
        }
        this.myHandler.handleModulesLoaded(modules);
    }

    protected void handleBreakpointChanged(LLBreakPointBroadcast broadcast_change) {
        this.myHandlerProcessor.add(() -> this.myHandler.handleBreakpointChanged(broadcast_change));
    }

    protected void handleInterrupted(@NotNull StopPlace stopPlace) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(10);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleInterrupted(stopPlace);
    }

    protected void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(11);
        }
        if (signal == null) {
            DebuggerDriver.$$$reportNull$$$0(12);
        }
        if (meaning == null) {
            DebuggerDriver.$$$reportNull$$$0(13);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleSignal(stopPlace, signal, meaning);
    }

    protected void handleException(@NotNull StopPlace stopPlace, @NotNull String description) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(14);
        }
        if (description == null) {
            DebuggerDriver.$$$reportNull$$$0(15);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleException(stopPlace, description);
    }

    protected void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(16);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleBreakpoint(stopPlace, breakpointNumber);
    }

    protected void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(17);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpoint(stopPlace, watchpointNumber);
    }

    protected void handleWatchpointScope(int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpointScope(watchpointNumber);
    }

    protected void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        if (text == null) {
            DebuggerDriver.$$$reportNull$$$0(18);
        }
        if (type == null) {
            DebuggerDriver.$$$reportNull$$$0(19);
        }
        this.myHandler.handleTargetOutput(text, type);
    }

    protected void handleAttached(int pid) {
        this.myHandler.handleAttached(pid);
    }

    protected void handleConnected(@NotNull String connection) {
        if (connection == null) {
            DebuggerDriver.$$$reportNull$$$0(20);
        }
        this.myHandler.handleConnected(connection);
    }

    protected void handleDisconnected() {
        this.myHandler.handleDisconnected();
    }

    protected void handleGDBOutput(@NotNull String text) {
        if (text == null) {
            DebuggerDriver.$$$reportNull$$$0(21);
        }
        this.myHandler.handleGDBOutput(text);
    }

    protected void handlePrompt() {
        this.handlePrompt(false);
    }

    protected void handlePrompt(boolean inMultiLineCommand) {
        this.handlePrompt(inMultiLineCommand ? 1 : 0);
    }

    protected void handlePrompt(int promptLevel) {
        this.handlePrompt(promptLevel == 0 ? "(" + this.getPromptText() + ") " : StringUtil.repeat((String)"> ", (int)promptLevel));
    }

    protected abstract String getPromptText();

    protected void handlePrompt(@NotNull String prompt) {
        if (prompt == null) {
            DebuggerDriver.$$$reportNull$$$0(22);
        }
        this.myHandler.handlePrompt(prompt);
    }

    protected void handleTargetFinished(int code, @Nullable String description) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleTargetFinished(code, description);
    }

    protected void handleTargetTerminated() {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleTargetTerminated();
    }

    protected void handleDetached() {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleDetached();
    }

    protected void handleExited(int code) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleExited(code);
    }

    public void waitHandlerProcessed() {
        this.myHandlerProcessor.waitFor();
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public abstract void checkErrors() throws ExecutionException;

    protected void printTargetCommandLine(@Nullable GeneralCommandLine commandLine) {
        if (commandLine != null) {
            this.handleTargetOutput(commandLine.getCommandLineString() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    public void setRedirectOutputToFiles(boolean toRedirect) {
        this.myToRedirect = toRedirect;
    }

    @NotNull
    protected ProcessOutputReaders initReaders(@NotNull OSType osType, @NotNull GeneralCommandLine targetCommandLine, boolean usePty, boolean isRemote) throws ExecutionException {
        if (osType == null) {
            DebuggerDriver.$$$reportNull$$$0(23);
        }
        if (targetCommandLine == null) {
            DebuggerDriver.$$$reportNull$$$0(24);
        }
        if ((this.myReaders = new ProcessOutputReaders(osType, targetCommandLine, usePty, isRemote){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull Key type) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                DebuggerDriver.this.handleTargetOutput(text, type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }) == null) {
            DebuggerDriver.$$$reportNull$$$0(25);
        }
        return this.myReaders;
    }

    protected void closeOutputReaders() {
        ProcessOutputReaders readers = this.myReaders;
        if (readers != null) {
            try {
                if (!readers.waitFor(300L, TimeUnit.MILLISECONDS)) {
                    CidrDebuggerLog.LOG.warn("Closing inferior output readers took too long");
                }
            }
            finally {
                readers.close();
                this.myReaders = null;
            }
        }
    }

    protected static boolean isTargetTerminationSignal(int signal) {
        return 15 == signal || 9 == signal;
    }

    protected static boolean isTargetTerminationSignal(@Nullable String name2) {
        return "SIGTERM".equals(name2) || "SIGKILL".equals(name2);
    }

    public abstract void addSymbolsFile(File var1, File var2) throws ExecutionException;

    private static int escapedByte(String s, int idx, ByteArrayOutputStream bs) {
        if (idx + 4 > s.length() || s.charAt(idx) != '\\') {
            return -1;
        }
        try {
            int code = Integer.parseInt(s.substring(idx + 1, idx + 4), 8);
            bs.write(code);
            return idx + 4;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    protected static String stringify(@NotNull String s) {
        if (s == null) {
            DebuggerDriver.$$$reportNull$$$0(26);
        }
        StringBuilder buffer = new StringBuilder(s.length() + 2).append('\"');
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"\"", (StringBuilder)buffer);
        String string = buffer.append('\"').toString();
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String unescapeString(@NotNull String s) {
        if (s == null) {
            DebuggerDriver.$$$reportNull$$$0(28);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'e': {
                    buffer.append('\u001b');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                default: {
                    int i = idx - 1;
                    bs.reset();
                    while ((i = DebuggerDriver.escapedByte(s, i, bs)) != -1) {
                        idx = i;
                    }
                    if (bs.size() > 0) {
                        try {
                            buffer.append(new String(bs.toByteArray(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            CidrDebuggerLog.LOG.error((Throwable)e);
                        }
                        --idx;
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string = buffer.toString();
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Contract(value="_, !null -> !null")
    public static Address parseAddress(@NotNull String str, Address defaultValue) {
        if (str == null) {
            DebuggerDriver.$$$reportNull$$$0(30);
        }
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static Address parseAddress(@NotNull String str) throws ExecutionException {
        Address address;
        if (str == null) {
            DebuggerDriver.$$$reportNull$$$0(31);
        }
        try {
            address = Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(32);
        }
        return address;
    }

    @NotNull
    public static Address parseAddressSafe(@NotNull String str) throws DebuggerCommandException {
        Address address;
        if (str == null) {
            DebuggerDriver.$$$reportNull$$$0(33);
        }
        try {
            address = Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException(e);
        }
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(34);
        }
        return address;
    }

    protected static int getTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout", (int)30000);
    }

    protected static int getLoadTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.load", (int)90000);
    }

    protected static int getEvaluationTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.evaluate", (int)30000);
    }

    protected BaseProcessHandler createDebugProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull DebuggerDriverConfiguration config) throws ExecutionException {
        if (commandLine == null) {
            DebuggerDriver.$$$reportNull$$$0(35);
        }
        if (config == null) {
            DebuggerDriver.$$$reportNull$$$0(36);
        }
        BaseProcessHandler handler = config.createDebugProcessHandler(commandLine);
        final Process process2 = handler.getProcess();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (process2.isAlive() && willBeDestroyed) {
                    try {
                        DebuggerDriver.this.doExit();
                    }
                    catch (ExecutionException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                    }
                    try {
                        process2.waitFor(1500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (process2.isAlive() && OSProcessHandler.processCanBeKilledByOS((Process)process2)) {
                    OSProcessUtil.killProcess((Process)process2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return handler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signal";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "initReaders";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stringify";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeString";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAddress";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAddressSafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesLoaded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpoint";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleWatchpoint";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetOutput";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "handleConnected";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleGDBOutput";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handlePrompt";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initReaders";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "stringify";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unescapeString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseAddress";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseAddressSafe";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SymbolicBreakpoint {
        public static final int INVALID_THREAD_ID = 0;
        private String myPattern;
        private boolean myRegexpPattern = false;
        @Nullable
        private String myModule;
        @Nullable
        private String myCondition;
        private long myThreadId = 0L;

        public String getPattern() {
            return this.myPattern;
        }

        public void setPattern(String pattern) {
            this.myPattern = pattern;
        }

        public boolean isRegexpPattern() {
            return this.myRegexpPattern;
        }

        public void setRegexpPattern(boolean regexpPattern) {
            this.myRegexpPattern = regexpPattern;
        }

        @Nullable
        public String getModule() {
            return this.myModule;
        }

        public void setModule(@Nullable String module2) {
            this.myModule = module2;
        }

        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(@Nullable String condition) {
            this.myCondition = condition;
        }

        public long getThreadId() {
            return this.myThreadId;
        }

        public void setThreadId(long threadId) {
            this.myThreadId = threadId;
        }
    }

    public static enum StandardDebuggerLanguage implements DebuggerLanguage
    {
        C("C"),
        C_PLUS_PLUS("C++"),
        OBJC("Objective-C"),
        OBJC_PLUS_PLUS("Objective-C++"),
        SWIFT("Swift"),
        RUST("Rust"),
        FORTRAN("Fortran"),
        ADA("Ada"),
        COBOL("Cobol"),
        PASCAL("Pascal"),
        MODULA("Modula"),
        D("D"),
        OPENCL("OpenCL"),
        GO("Go"),
        HASKELL("Haskell"),
        OCAML("OCaml");

        private final String myName;

        private StandardDebuggerLanguage(String name2) {
            if (name2 == null) {
                StandardDebuggerLanguage.$$$reportNull$$$0(0);
            }
            this.myName = name2;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myName;
            if (string == null) {
                StandardDebuggerLanguage.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StandardDebuggerLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StandardDebuggerLanguage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DebuggerLanguage {
        public String toString();
    }

    public static class ResultList<T> {
        @NotNull
        public final List<T> list;
        public final boolean hasMore;

        public ResultList(@NotNull List<T> list, boolean hasMore) {
            if (list == null) {
                ResultList.$$$reportNull$$$0(0);
            }
            this.list = list;
            this.hasMore = hasMore;
        }

        @NotNull
        public static <T> ResultList<T> create(@NotNull List<T> list, boolean hasMore) {
            if (list == null) {
                ResultList.$$$reportNull$$$0(1);
            }
            ResultList<T> resultList = new ResultList<T>(list, hasMore);
            if (resultList == null) {
                ResultList.$$$reportNull$$$0(2);
            }
            return resultList;
        }

        @NotNull
        public static <T> ResultList<T> empty() {
            ResultList resultList = ResultList.create(Collections.emptyList(), false);
            if (resultList == null) {
                ResultList.$$$reportNull$$$0(3);
            }
            return resultList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class StopPlace {
        @NotNull
        public final LLThread thread;
        @NotNull
        public final LLFrame frame;

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame) {
            if (thread == null) {
                StopPlace.$$$reportNull$$$0(0);
            }
            if (frame == null) {
                StopPlace.$$$reportNull$$$0(1);
            }
            this.thread = thread;
            this.frame = frame;
        }

        public String toString() {
            return this.thread + ": " + this.frame;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frame";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PathMapping {
        @NotNull
        public final String from;
        @NotNull
        public final String to;

        public PathMapping(@NotNull String from, @NotNull String to) {
            if (from == null) {
                PathMapping.$$$reportNull$$$0(0);
            }
            if (to == null) {
                PathMapping.$$$reportNull$$$0(1);
            }
            this.from = from;
            this.to = to;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "to";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$PathMapping";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public abstract class Inferior {
        private final int myId;
        private final AtomicBoolean myIsRunning = new AtomicBoolean();

        public Inferior(int id) {
            this.myId = id;
        }

        public int getId() {
            return this.myId;
        }

        @NotNull
        public DebuggerDriver getDriver() {
            DebuggerDriver debuggerDriver = DebuggerDriver.this;
            if (debuggerDriver == null) {
                Inferior.$$$reportNull$$$0(0);
            }
            return debuggerDriver;
        }

        public long start() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(false, true)) {
                throw new ExecutionException("started already");
            }
            return this.startImpl();
        }

        public void detach() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return;
            }
            this.detachImpl();
        }

        public boolean destroy() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return false;
            }
            return this.destroyImpl();
        }

        protected abstract long startImpl() throws ExecutionException;

        protected abstract void detachImpl() throws ExecutionException;

        protected abstract boolean destroyImpl() throws ExecutionException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Inferior", "getDriver"));
        }
    }

    public static interface Handler
    extends EventListener {
        default public void handleRunning() {
        }

        default public void handleModulesLoaded(@NotNull List<String> modules) {
            if (modules == null) {
                Handler.$$$reportNull$$$0(0);
            }
        }

        default public void handleBreakpointChanged(LLBreakPointBroadcast bc) {
        }

        default public void handleInterrupted(@NotNull StopPlace stopPlace) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(1);
            }
        }

        default public void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (signal == null) {
                Handler.$$$reportNull$$$0(3);
            }
            if (meaning == null) {
                Handler.$$$reportNull$$$0(4);
            }
        }

        default public void handleException(@NotNull StopPlace stopPlace, @NotNull String description) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(5);
            }
            if (description == null) {
                Handler.$$$reportNull$$$0(6);
            }
        }

        default public void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(7);
            }
        }

        default public void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(8);
            }
        }

        default public void handleWatchpointScope(int watchpointNumber) {
        }

        default public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
            if (text == null) {
                Handler.$$$reportNull$$$0(9);
            }
            if (type == null) {
                Handler.$$$reportNull$$$0(10);
            }
        }

        default public void handleGDBOutput(@NotNull String text) {
            if (text == null) {
                Handler.$$$reportNull$$$0(11);
            }
        }

        default public void handlePrompt(@NotNull String prompt) {
            if (prompt == null) {
                Handler.$$$reportNull$$$0(12);
            }
        }

        default public void handleTargetFinished(int code, @Nullable String description) {
        }

        default public void handleTargetTerminated() {
        }

        default public void handleExited(int code) {
        }

        default public void handleAttached(int pid) {
        }

        default public void handleDetached() {
        }

        default public void handleConnected(@NotNull String connection) {
            if (connection == null) {
                Handler.$$$reportNull$$$0(13);
            }
        }

        default public void handleDisconnected() {
        }

        @NotNull
        public static Handler createQueuedHandler(@NotNull Handler handler, @NotNull QueueProcessor<Runnable> queueProcessor) {
            if (handler == null) {
                Handler.$$$reportNull$$$0(14);
            }
            if (queueProcessor == null) {
                Handler.$$$reportNull$$$0(15);
            }
            Handler handler2 = (Handler)Proxy.newProxyInstance(Handler.class.getClassLoader(), new Class[]{Handler.class}, (proxy, method, args) -> {
                if (handler == null) {
                    Handler.$$$reportNull$$$0(17);
                }
                if (queueProcessor == null) {
                    Handler.$$$reportNull$$$0(18);
                }
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)handler, args);
                }
                queueProcessor.add(() -> {
                    if (handler == null) {
                        Handler.$$$reportNull$$$0(19);
                    }
                    try {
                        method.invoke((Object)handler, args);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                    }
                });
                return null;
            });
            if (handler2 == null) {
                Handler.$$$reportNull$$$0(16);
            }
            return handler2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopPlace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signal";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meaning";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prompt";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 14: 
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queueProcessor";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQueuedHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleModulesLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInterrupted";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleSignal";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleException";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpoint";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleWatchpoint";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTargetOutput";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "handleGDBOutput";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "handlePrompt";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "handleConnected";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueuedHandler";
                    break;
                }
                case 16: {
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createQueuedHandler$1";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum TargetState {
        NOT_READY,
        RUNNING,
        SUSPENDED,
        FINISHED;

    }

    public static class ShellCommandResult {
        private final String myOutput;
        private final int myStatus;
        private final int mySignal;

        public ShellCommandResult(@NotNull String output, int status, int signal) {
            if (output == null) {
                ShellCommandResult.$$$reportNull$$$0(0);
            }
            this.myOutput = output;
            this.myStatus = status;
            this.mySignal = signal;
        }

        @NotNull
        public String getOutput() {
            String string = this.myOutput;
            if (string == null) {
                ShellCommandResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getStatus() {
            return this.myStatus;
        }

        public int getSignal() {
            return this.mySignal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ShellCommandResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ShellCommandResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

