/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.toolchains.OSType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriverConfiguration
extends UserDataHolderBase {
    @NotNull
    public abstract String getDriverName();

    public boolean isAttachSupported() {
        return true;
    }

    @NotNull
    public abstract DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler var1) throws ExecutionException;

    @NotNull
    public abstract GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver var1) throws ExecutionException;

    protected static void setupCommonParameters(@NotNull GeneralCommandLine result) {
        if (result == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(0);
        }
        result.setCharset(CharsetToolkit.UTF8_CHARSET);
    }

    @Contract(value="null -> null")
    public String convertToLocalPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    @Contract(value="null -> null")
    public String convertToEnvPath(@Nullable String localPath) {
        return localPath;
    }

    @NotNull
    public BaseProcessHandler createDebugProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(1);
        }
        OSProcessHandler handler = new OSProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration$1", "readerOptions"));
            }
        };
        handler.setShouldDestroyProcessRecursively(false);
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(2);
        }
        return oSProcessHandler;
    }

    public boolean isRemoteEnv() {
        return false;
    }

    @NotNull
    public OSType getEnvOSType() {
        OSType oSType = OSType.getCurrent();
        if (oSType == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(3);
        }
        return oSType;
    }

    public void sendSignalToRemoteProcess(int pid, int signal) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public abstract EvaluationContext createEvaluationContext(@NotNull DebuggerDriver var1, @Nullable Expirable var2, @NotNull CidrStackFrame var3);

    @Deprecated
    public boolean supportsArrayEvaluation() {
        return false;
    }

    @Deprecated
    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvOSType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupCommonParameters";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

