/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    private boolean myBundledLLDB;

    @Override
    @NotNull
    public String getDriverName() {
        if ("LLDB" == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        return "LLDB";
    }

    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion;
        try {
            GeneralCommandLine commandLine = this.createLLDBFrontendCommandLine();
            commandLine.addParameter("--version");
            displayVersion = CidrToolsUtil.readOneLineWithProgress(commandLine, 10000);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.info("Cannot read LLDB version", (Throwable)e);
            return null;
        }
        if (displayVersion == null) {
            return null;
        }
        return LLDBDriverConfiguration.parseVersion(displayVersion);
    }

    public void setBundledLLDB(boolean bundledLLDB) {
        this.myBundledLLDB = bundledLLDB;
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        if (displayVersion == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        ToolVersion toolVersion = ToolVersion.parse(displayVersion, VERSION_PATTERN);
        if (toolVersion == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        return toolVersion;
    }

    @Override
    public boolean isAttachSupported() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler) throws ExecutionException {
        if (handler == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        LLDBDriver lLDBDriver = new LLDBDriver(handler, this);
        if (lLDBDriver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        return lLDBDriver;
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        File file = this.getLLDBBinFile(SystemInfo.isWindows ? "liblldb.dll" : (SystemInfo.isLinux ? "lib/liblldb.so" : "LLDB.framework"));
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        File file = CidrDebuggerPathManager.getLLDBBinFile(relativePath);
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        return file;
    }

    public boolean isBundledLLDB() {
        String lldbFramework = this.getLLDBFrameworkFile().getAbsolutePath();
        String bundleDirectory = CidrDebuggerPathManager.getLLDBBinFile("").getAbsolutePath() + File.separator;
        return lldbFramework.startsWith(bundleDirectory);
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(8);
        }
        GeneralCommandLine result = this.createLLDBFrontendCommandLine();
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine() throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : (SystemInfo.isMac ? "LLDBFrontend" : "bin/LLDBFrontend"));
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_PRELOAD", lldbFrameworkFile.getAbsolutePath());
        } else if (SystemInfo.isWindows) {
            env.put("PATH", lldbFrameworkFile.getParent() + ";" + frontendExecutable.getParent());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File debugserver = new File(lldbFrameworkFile, "Resources/debugserver");
            if (debugserver.exists()) {
                env.put("LLDB_DEBUGSERVER_PATH", debugserver.getAbsolutePath());
                env.put("LLDB_DEBUGSERVER_EXTRA_ARG_1", "--reverse-connect");
            }
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
            result.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        LLDBDriverConfiguration.setupCommonParameters(result);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
        if (result == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(11);
        }
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(12);
        }
        if (frame == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(13);
        }
        LLDBEvaluationContext lLDBEvaluationContext = new LLDBEvaluationContext(driver, expirable, frame);
        if (lLDBEvaluationContext == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(14);
        }
        return lLDBEvaluationContext;
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return false;
    }

    public boolean disableASLR() {
        return false;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBFrameworkFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBBinFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLDBFrontendCommandLine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluationContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureDriverCommandLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

