/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLFrame {
    public static final String UNKNOWN_FUNCTION = CidrDebuggerBundle.message("debug.frames.unknownFunction", new Object[0]);
    private final int myIndex;
    @Nullable
    private final String myFunction;
    @Nullable
    private final String myFile;
    private final int myLine;
    @NotNull
    private final Address myProgramCounter;
    @Nullable
    private final DebuggerDriver.DebuggerLanguage myLanguage;
    private final boolean myOptimized;

    public LLFrame(int index, @Nullable String function, @Nullable String file, int line, long pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized) {
        this(index, function, file, line, Address.fromUnsignedLong(pc), language, optimized);
    }

    public LLFrame(int index, @Nullable String function, @Nullable String file, int line, @NotNull Address pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized) {
        if (pc == null) {
            LLFrame.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.myFunction = function;
        this.myFile = file == null ? null : FileUtil.toSystemIndependentName((String)file);
        this.myLine = line;
        this.myProgramCounter = pc;
        this.myLanguage = language;
        this.myOptimized = optimized;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public String getFunction() {
        String string = StringUtil.defaultIfEmpty((String)this.myFunction, (String)UNKNOWN_FUNCTION);
        if (string == null) {
            LLFrame.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    @NotNull
    public Address getProgramCounter() {
        Address address = this.myProgramCounter;
        if (address == null) {
            LLFrame.$$$reportNull$$$0(2);
        }
        return address;
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.myLanguage;
    }

    public boolean getOptimized() {
        return this.myOptimized;
    }

    public boolean hasDebugInfo() {
        return this.myFile != null;
    }

    public boolean hasSymbolInfo() {
        return this.myFunction != null;
    }

    public String toString() {
        return String.format("%d: %s %s@%s:%d (%s)%s", this.myIndex, this.myProgramCounter, this.myFunction, this.myFile, this.myLine, this.myLanguage, this.myOptimized ? " [opt]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLFrame gdbFrame = (LLFrame)o;
        if (this.myLine != gdbFrame.myLine) {
            return false;
        }
        if (this.myIndex != gdbFrame.myIndex) {
            return false;
        }
        if (this.myFunction != null ? !this.myFunction.equals(gdbFrame.myFunction) : gdbFrame.myFunction != null) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(gdbFrame.myFile) : gdbFrame.myFile != null) {
            return false;
        }
        if (!this.myProgramCounter.equals(gdbFrame.myProgramCounter)) {
            return false;
        }
        if (this.myLanguage != null ? !this.myLanguage.equals(gdbFrame.myLanguage) : gdbFrame.myLanguage != null) {
            return false;
        }
        return this.myOptimized == gdbFrame.myOptimized;
    }

    public int hashCode() {
        int result = this.myIndex;
        result = 31 * result + (this.myFunction != null ? this.myFunction.hashCode() : 0);
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 31 * result + this.myLine;
        result = 31 * result + this.myProgramCounter.hashCode();
        result = 31 * result + (this.myLanguage != null ? this.myLanguage.hashCode() : 0);
        result = 31 * result + (this.myOptimized ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pc";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgramCounter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

