/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.VersionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionQueueProcessor;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBVarsCache;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSDebugSymbols;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSSierraDuringStartupProgramTerminatedException;
import com.jetbrains.cidr.execution.debugger.backend.gdb.lang.GDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.toolchains.OSType;
import com.pty4j.unix.Pty;
import gnu.trove.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.PrintFormat;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBDriver
extends DebuggerDriver {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^GNU gdb (?:\\(GDB(?:;[^)]*+)?\\) )?(?:[\\w ]*\\()?([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    public static final Key<String> PRETTY_PRINTERS_PATH = Key.create((String)"GDBDriver.PRETTY_PRINTERS_PATH");
    public static final Key<Boolean> ENABLE_STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.ENABLE_STL_PRETTY_PRINTERS");
    private static final Key<LLValueLoader> LLVALUE_DATA_LOADER = Key.create((String)"GDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueLoadedData> LLVALUE_DATA = Key.create((String)"GDBDriver.LLVALUE_DATA");
    private static final Key<GDBTuple> LLVALUE_CLASS_CHILDREN_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN");
    private static final Key<Integer> LLVALUE_CLASS_CHILDREN_COUNT_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN_COUNT_CACHE");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"GDBDriver.LLVALUE_MAP_ELEMENT");
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final Pattern CANNOT_ACCESS_MEMORY_AT_ADDRESS = Pattern.compile("Cannot access memory at address 0x([0-9a-f]+)(?: .*)?");
    private static final Pattern BAD_INSTRUCTION_WITH_PREFIX_SUFFIX = Pattern.compile("^[^#]*(\\(bad\\)).*$");
    private static final Pattern INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME = Pattern.compile("^([^#]*(?:0|0x[0-9a-f]+))\\s*(<.*>)\\s*$", 2);
    private static final Pattern WHATIS_TYPE_OUTPUT = Pattern.compile("^type = (?:(?:/\\* real type = (.*) \\*/\\n.*)|(.*))\\n");
    private static final Pattern PROMPT = Pattern.compile("[ ]*>");
    private static final int IGNORE_RESPONSE_COMMAND_TOKEN = 0;
    @Nullable
    private static Boolean ourShellAvailable;
    @Nullable
    private volatile Consumer<String> myFrameVarDisposeListener;
    @Nullable
    private volatile MIResponseFilter myMIResponseFilter;
    @NotNull
    private final DebuggerDriverConfiguration myStarter;
    @Nullable
    private Version myGdbVersion;
    @Nullable
    private String myWinBreakPath;
    @NotNull
    private final GeneralCommandLine myGdbCommandLine;
    @NotNull
    private final BaseProcessHandler myProcessHandler;
    private final boolean myEmulateStepMode;
    private volatile boolean myMIAsyncMode;
    private volatile boolean myStepMode;
    private volatile int myPromptLevel;
    @NotNull
    private final Writer mySink;
    @Nullable
    private volatile OutputStream myProcessInput;
    private final OutputStream myProcessInputProxy;
    private final Semaphore myCommandSemaphore;
    private final ExecutionQueueProcessor myCommandProcessor;
    private final BlockingQueue<Response> myResultQueue;
    private final Semaphore myInterrupted;
    private final Semaphore myPendingForAttachNotification;
    @Nullable
    private volatile Integer myTargetPID;
    @Nullable
    private volatile TLongHashSet myIndirectSymbols;
    @Nullable
    private volatile DebuggerDriver.StopPlace myStopPlace;
    @NotNull
    private volatile Communication myCommunication;
    @Nullable
    private volatile String myLastCommand;
    private boolean myIsConsoleCommand;
    private final List<GDBResponse.Record> myVarsDropPool;
    private final GDBVarsCache myVarsCache;
    private final HashMap<String, LLValue> myFrameVarCache;
    private final BidirectionalMap<String, String> myFrameVarIDCache;
    private final HashMap<String, LLValueLoadedData> myFrameVarDataCache;
    private static final Pattern VALUE_DESCRIPTION_PATTERN;

    public void setMIOutputFilterInTests(@NotNull @RegExp String regexp, @NotNull String replacement) {
        if (regexp == null) {
            GDBDriver.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            GDBDriver.$$$reportNull$$$0(1);
        }
        this.setMIOutputFilterInTests((NotNullFunction<String, String>)((NotNullFunction)s -> {
            if (regexp == null) {
                GDBDriver.$$$reportNull$$$0(168);
            }
            if (replacement == null) {
                GDBDriver.$$$reportNull$$$0(169);
            }
            return s.replaceAll(regexp, replacement);
        }));
    }

    public void setMIOutputFilterInTests(@Nullable NotNullFunction<String, String> miOutputFilter) {
        this.setMIResponseFilterInTests(miOutputFilter == null ? null : (request, s) -> (String)miOutputFilter.fun((Object)s));
    }

    public void setMIResponseFilterInTests(@Nullable MIResponseFilter miResponseFilter) {
        this.myMIResponseFilter = miResponseFilter;
    }

    public void setFrameVarDisposeListenerInTests(@Nullable Consumer<String> listener2) {
        this.myFrameVarDisposeListener = listener2;
    }

    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull DebuggerDriverConfiguration starter) throws ExecutionException {
        if (handler == null) {
            GDBDriver.$$$reportNull$$$0(2);
        }
        if (starter == null) {
            GDBDriver.$$$reportNull$$$0(3);
        }
        super(handler);
        this.myMIAsyncMode = false;
        this.myStepMode = false;
        this.myProcessInputProxy = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(i);
                }
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(bytes, i, i1);
                }
            }

            @Override
            public void close() throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.close();
                }
            }

            @Override
            public void flush() throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.flush();
                }
            }
        };
        this.myCommandSemaphore = new Semaphore();
        this.myResultQueue = new LinkedBlockingQueue<Response>();
        this.myInterrupted = new Semaphore();
        this.myPendingForAttachNotification = new Semaphore();
        this.myTargetPID = null;
        this.myStopPlace = null;
        this.myCommunication = new Communication(this, "");
        this.myLastCommand = null;
        this.myVarsDropPool = new ArrayList<GDBResponse.Record>();
        this.myVarsCache = new GDBVarsCache(this.myVarsDropPool::add);
        this.myFrameVarCache = new HashMap();
        this.myFrameVarIDCache = new BidirectionalMap();
        this.myFrameVarDataCache = new HashMap();
        this.myStarter = starter;
        this.myEmulateStepMode = this.isMac();
        this.myCommandProcessor = new ExecutionQueueProcessor();
        this.myGdbCommandLine = this.myStarter.createDriverCommandLine(this);
        this.myProcessHandler = this.createDebugProcessHandler(this.myGdbCommandLine, this.myStarter);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            @NotNull
            private StringBuilder myBuffer = new StringBuilder();

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                String text = event.getText();
                if (outputType == ProcessOutputTypes.STDOUT) {
                    int end;
                    this.myBuffer.append(text);
                    String content = this.myBuffer.toString();
                    boolean changed = false;
                    while ((end = content.indexOf("\n")) != -1) {
                        String response = content.substring(0, end).trim();
                        content = content.substring(end + 1);
                        changed = true;
                        MIResponseFilter filter = GDBDriver.this.myMIResponseFilter;
                        if (filter != null) {
                            for (String line : StringUtil.splitByLines((String)filter.apply(((GDBDriver)GDBDriver.this).myCommunication.command, response))) {
                                GDBDriver.this.processResponse(line);
                            }
                            continue;
                        }
                        GDBDriver.this.processResponse(response);
                    }
                    if (changed) {
                        this.myBuffer = new StringBuilder(content);
                    }
                } else {
                    if (text != null && CidrDebuggerLog.LOG.isDebugEnabled()) {
                        CidrDebuggerLog.LOG.debug("<" + text);
                    }
                    if (outputType == ProcessOutputTypes.STDERR) {
                        GDBDriver.this.handleTargetOutput(text, outputType);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                CidrDebuggerLog.LOG.info("Debugger exited with code " + event.getExitCode());
                CidrDebuggerLog.LOG.debug("<[terminated]");
                GDBDriver.this.cleanupOnTermination();
                GDBDriver.this.handleExited(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        OutputStream input = this.myProcessHandler.getProcessInput();
        Charset charset = this.myProcessHandler.getCharset();
        assert (input != null);
        assert (charset != null);
        this.mySink = new OutputStreamWriter(input, charset);
        this.myCommandSemaphore.down();
        this.executeCommandNoUserException(() -> {
            this.handlePrompt();
            CidrDebuggerLog.LOG.info("Debugger started");
        });
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        GDBLanguage gDBLanguage = GDBLanguage.INSTANCE;
        if (gDBLanguage == null) {
            GDBDriver.$$$reportNull$$$0(4);
        }
        return gDBLanguage;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        BaseProcessHandler baseProcessHandler = this.myProcessHandler;
        if (baseProcessHandler == null) {
            GDBDriver.$$$reportNull$$$0(5);
        }
        return baseProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException, DebuggerCommandException {
        this.removeCodepoints(ids);
    }

    @Override
    public void addSymbolsFile(File file, File module2) {
    }

    @Override
    public boolean isInPromptMode() {
        return this.myPromptLevel > 0;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(DebuggerDriver.TargetState state) {
        super.setState(state);
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new VoidCommand(){

                @Override
                public void run() throws ExecutionException {
                    for (GDBResponse.Record record : GDBDriver.this.myVarsDropPool) {
                        GDBDriver.this.doDeleteVar(record);
                    }
                    GDBDriver.this.myVarsDropPool.clear();
                }
            });
        }
    }

    private void doDeleteVar(GDBResponse.Record var) {
        try {
            String name2 = var.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(name2));
        }
        catch (ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug(e);
        }
    }

    @NotNull
    protected String shellQuote(@NotNull String s) {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(6);
        }
        if (this.isWindows()) {
            String string = CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false);
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = String.format("'%s'", s.replace("'", "'\\''"));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void warnUser(@NotNull String message) {
        if (message == null) {
            GDBDriver.$$$reportNull$$$0(9);
        }
        this.warnUser(message, null);
    }

    private void warnUser(@NotNull String message, @Nullable Throwable e) {
        if (message == null) {
            GDBDriver.$$$reportNull$$$0(10);
        }
        message = message.trim();
        this.handleTargetOutput(message + "\n\n", ProcessOutputTypes.SYSTEM);
        CidrDebuggerLog.LOG.warn(message, e);
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
    }

    private void doSetUpGDB(boolean isRemoteTarget) throws ExecutionException {
        try {
            this.doSetMaxDescription(true);
            this.gdbSet("print repeats", 0);
            this.gdbSet("print object", true);
            this.gdbSet("print asm-demangle", true);
            this.gdbSet("python print-stack", "full");
            if (this.myEmulateStepMode) {
                this.gdbSet("step-mode", true);
            }
            this.gdbSet("backtrace past-main", true);
            if (this.isMac()) {
                this.gdbSet("backtrace past-entry", true);
            }
            this.doSetMIAsync(isRemoteTarget);
        }
        catch (DebuggerCommandException e) {
            this.warnUser("Cannot configure GDB defaults: " + e.getMessage(), e);
        }
        try {
            String script = "import sys; sys.dont_write_bytecode = True; ";
            String printersPath = (String)this.myGdbCommandLine.getUserData(PRETTY_PRINTERS_PATH);
            if (printersPath != null) {
                Response response;
                boolean hasSTLprinters;
                script = script + "sys.path.insert(0, " + GDBDriver.stringify(this.toEnvPath(printersPath)) + "); ";
                script = script + "from default.printers import register_default_printers; register_default_printers(None); ";
                if (this.myGdbCommandLine.getUserData(ENABLE_STL_PRETTY_PRINTERS) == Boolean.TRUE && !(hasSTLprinters = (response = this.sendSilentRequestAndWaitForDone("info pretty-printer", new Object[0])).getOutput().contains("libstdc++-v6"))) {
                    script = script + "from libstdcxx.v6.printers import register_libstdcxx_printers; register_libstdcxx_printers(None); ";
                }
                this.sendSilentRequestAndWaitForDone("python %s", script);
                this.sendRequestAndWaitForDone("-enable-pretty-printing", new Object[0]);
            }
        }
        catch (GDBCommandException e) {
            this.warnUser("Error during pretty printers setup: " + e.getMessage() + "\n\nSome features and performance optimizations will not be available.\n\n" + e.getResponse().getOutput(), e);
        }
    }

    private void doSetStepMode(boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (this.myStepMode == enabled) {
            return;
        }
        if (!this.myEmulateStepMode) {
            this.gdbSet("step-mode", enabled);
        }
        this.myStepMode = enabled;
    }

    private void doSetMIAsync(boolean enabled) throws ExecutionException, DebuggerCommandException {
        try {
            this.gdbSet("mi-async", enabled);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Can't enable 'mi-async' mode (too old GDB?); falling back to 'target-async'");
            this.gdbSet("target-async", enabled);
        }
        this.myMIAsyncMode = enabled;
    }

    private void doSetMaxDescription(boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet("print elements", enabled ? 1000 : 0);
    }

    protected void gdbSet(@NotNull String setting, boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(11);
        }
        this.gdbSet(setting, enabled ? "on" : "off");
    }

    protected void gdbSet(@NotNull String setting, int value) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(12);
        }
        this.gdbSet(setting, String.valueOf(value));
    }

    protected void gdbSet(@NotNull String setting, @Nullable String value) throws ExecutionException, DebuggerCommandException {
        String command;
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(13);
        }
        String string = command = value != null ? String.format("-gdb-set %s %s", setting, value) : String.format("unset %s", setting);
        if (StringUtil.containsLineBreak((CharSequence)command)) {
            command = GDBDriver.createMI2Command(command, -1L, -1);
        }
        this.sendRequestAndWaitForDone("%s", command);
    }

    @NotNull
    protected GDBTuple gdbShow(@NotNull String setting) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(14);
        }
        GDBTuple gDBTuple = this.sendRequestAndWaitForDone("-gdb-show %s", setting).getResultList();
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(15);
        }
        return gDBTuple;
    }

    private int doAllocateInferior() throws ExecutionException, GDBCommandException {
        GDBTuple threadGroup;
        GDBTuple threadGroupsResult = this.sendRequestAndWaitForDone("-list-thread-groups", new Object[0]).getResultList();
        GDBTuple groups = threadGroupsResult.getTupleOrEmpty("groups");
        if (groups.size() == 1 && (threadGroup = (GDBTuple)groups.get(0)).getRequiredString("type").equals("process") && threadGroup.getString("executable") == null) {
            return this.doSelectInferior(threadGroup.getRequiredString("id"), threadGroup);
        }
        GDBTuple addInferiorResult = this.sendRequestAndWaitForDone("-add-inferior", new Object[0]).getResultList();
        return this.doSelectInferior(addInferiorResult.getRequiredString("inferior"), addInferiorResult);
    }

    private int doSelectInferior(@NotNull String iIdString, @NotNull GDBTuple tuple) throws ExecutionException, GDBCommandException {
        int id;
        if (iIdString == null) {
            GDBDriver.$$$reportNull$$$0(16);
        }
        if (tuple == null) {
            GDBDriver.$$$reportNull$$$0(17);
        }
        try {
            id = Integer.parseUnsignedInt(iIdString.substring(1));
        }
        catch (NumberFormatException e) {
            throw new ExecutionException("Malformed inferior id '" + iIdString + "' in tuple: " + tuple.get(0));
        }
        this.sendSilentRequestAndWaitForDone("inferior %d", id);
        return id;
    }

    @NotNull
    private Command<Integer> loadInferiorCommand(final @NotNull LoadingCommand loadingCommand) {
        if (loadingCommand == null) {
            GDBDriver.$$$reportNull$$$0(18);
        }
        Command<Integer> command = new Command<Integer>(){

            @Override
            @NotNull
            public Integer call() throws ExecutionException, DebuggerCommandException {
                int inferiorId = GDBDriver.this.doAllocateInferior();
                loadingCommand.call();
                Integer n = inferiorId;
                if (n == null) {
                    4.$$$reportNull$$$0(0);
                }
                return n;
            }

            @Override
            public long getTimeout() {
                return loadingCommand.getTimeout();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$4", "call"));
            }
        };
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(19);
        }
        return command;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        if (installer == null) {
            GDBDriver.$$$reportNull$$$0(20);
        }
        final GeneralCommandLine targetCommandLine = installer.install();
        if (this.isMac()) {
            this.tryLoadIndirectSymbols(targetCommandLine);
        }
        int inferiorId = this.executeCommandNoUserException(this.loadInferiorCommand(() -> {
            if (installer == null) {
                GDBDriver.$$$reportNull$$$0(167);
            }
            this.doSetUpGDB(false);
            this.doLoadExecutable(installer.getExecutableFile());
        }));
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(inferiorId){

            @Override
            protected long startImpl() throws ExecutionException {
                return GDBDriver.this.launch(targetCommandLine);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(21);
        }
        return inferior;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(@NotNull String name2, boolean wait) throws ExecutionException {
        if (name2 == null) {
            GDBDriver.$$$reportNull$$$0(22);
        }
        throw new ExecutionException("Attaching by name is not implemented for GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        if (this.isMac()) {
            throw new ExecutionException("Attaching is unsupported for GDB on OS X");
        }
        int inferiorId = this.executeCommandNoUserException(this.loadInferiorCommand(() -> this.doSetUpGDB(false)));
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(inferiorId){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.attachTo(pid);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(23);
        }
        return inferior;
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(24);
        }
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(25);
        }
        int inferiorId = this.executeCommandNoUserException(this.loadInferiorCommand(() -> {
            if (pathMappings == null) {
                GDBDriver.$$$reportNull$$$0(166);
            }
            this.doSetUpGDB(true);
            if (symbolFile != null) {
                try {
                    this.doLoadExecutable(symbolFile);
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot load symbol file: " + e.getMessage(), e);
                }
            }
            if (sysroot != null) {
                try {
                    this.gdbSet("sysroot", sysroot.getPath());
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set sysroot: " + e.getMessage(), e);
                }
            }
            for (DebuggerDriver.PathMapping each : pathMappings) {
                String from = FileUtil.toSystemIndependentName((String)each.from);
                String to = FileUtil.toSystemIndependentName((String)each.to);
                try {
                    this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(from), GDBDriver.stringify(to));
                    String envFrom = this.toEnvPath(from);
                    if (from.equals(envFrom)) continue;
                    this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(envFrom), GDBDriver.stringify(to));
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set path mapping: " + e.getMessage(), e);
                }
            }
        }));
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(inferiorId){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.connectTo(connectionString);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(true);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(26);
        }
        return inferior;
    }

    private void tryLoadIndirectSymbols(@NotNull GeneralCommandLine line) {
        if (line == null) {
            GDBDriver.$$$reportNull$$$0(27);
        }
        try {
            this.myIndirectSymbols = MacOSDebugSymbols.load(line);
        }
        catch (IOException e) {
            this.warnUser("Cannot create and read debug symbols: " + ExceptionUtil.getMessage((Throwable)e), e);
        }
    }

    private void doLoadExecutable(@NotNull File file) throws ExecutionException, DebuggerCommandException {
        if (file == null) {
            GDBDriver.$$$reportNull$$$0(28);
        }
        String path = this.toEnvPath(file.getPath());
        this.sendRequestAndWaitForDone("-file-exec-and-symbols %s", GDBDriver.stringify(FileUtil.toSystemIndependentName((String)path)));
        this.handleModulesLoaded(Collections.singletonList(path));
    }

    private int launch(@NotNull GeneralCommandLine targetCommandLine) throws ExecutionException {
        if (targetCommandLine == null) {
            GDBDriver.$$$reportNull$$$0(29);
        }
        return this.executeCommandNoUserException(() -> {
            if (targetCommandLine == null) {
                GDBDriver.$$$reportNull$$$0(165);
            }
            this.printTargetCommandLine(targetCommandLine);
            String workDirectory = this.toEnvPath(targetCommandLine.getWorkDirectory().getAbsolutePath());
            this.sendRequestAndWaitForDone("-environment-cd %s", GDBDriver.stringify(workDirectory));
            Map gdbEnv = this.myGdbCommandLine.getEffectiveEnvironment();
            this.doPrepareInferiorEnv(targetCommandLine, gdbEnv);
            String params = this.getInferiorArgs(targetCommandLine.getParametersList());
            boolean gdbSupportsIORedirectionOnWindows = this.myGdbVersion != null && this.myGdbVersion.major >= 8;
            try {
                Object pipe;
                if (!this.isWindows() && !this.isRemoteEnv()) {
                    Pty pty = new Pty(true);
                    this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(pty.getSlaveName()));
                    this.myProcessInput = pty.getOutputStream();
                } else if (this.isRemoteEnv()) {
                    pipe = this.myStarter.openNamedPipe();
                    params = params + String.format(" < %s ", this.shellQuote(pipe.getName()));
                    this.myProcessInput = pipe.getOutputStream();
                } else if (this.isWindows() && gdbSupportsIORedirectionOnWindows) {
                    pipe = WinPipe.createOutboundPipe("stdin");
                    params = params + String.format(" < %s ", this.shellQuote(((WinPipe)pipe).getPipeName()));
                    this.myProcessInput = ((WinPipe)pipe).getOutputStream();
                }
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.error((Throwable)e);
            }
            if (this.myToRedirect) {
                if (this.isWindows() && !gdbSupportsIORedirectionOnWindows) {
                    this.sendRequestAndWaitForDone("-gdb-set new-console on", new Object[0]);
                } else {
                    boolean isCsh;
                    ProcessOutputReaders readers = this.initReaders(this.myStarter.getEnvOSType(), targetCommandLine, !this.isWindows(), this.isRemoteEnv());
                    String redirectParams = String.format(" 1> %s 2> %s", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())), this.shellQuote(this.toEnvPath(readers.getErrFileAbsolutePath())));
                    String gdbShell = gdbEnv.getOrDefault("SHELL", "/bin/sh");
                    boolean bl = isCsh = SystemInfo.isUnix && gdbShell.endsWith("csh");
                    if (!isCsh) {
                        params = params + redirectParams;
                    } else if (GDBDriver.isBourneShellAvailable()) {
                        this.doWrapExec(this.getShellCommandLineString("exec \"$@\" " + redirectParams));
                    } else {
                        params = params + String.format(" >&! %s", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())));
                        this.warnUser(gdbShell + " doesn't support separate IO redirection.\nThe output will appear without stderr coloring");
                    }
                }
            }
            this.doSelectWinbreakBinary();
            this.gdbSet("args", params);
            try {
                this.sendRequestAndWaitForRunning("-exec-run", new Object[0]);
            }
            catch (GDBCommandException e) {
                if (SystemInfo.isMacOSSierra && e.getMessage().startsWith("During startup program terminated with")) {
                    throw new MacOSSierraDuringStartupProgramTerminatedException(e);
                }
                throw e;
            }
            Integer pid = this.myTargetPID;
            CidrDebuggerLog.LOG.assertTrue(pid != null);
            return pid;
        });
    }

    protected void doWrapExec(String wrapper) throws ExecutionException, DebuggerCommandException {
        String oldWrapper = this.gdbShow("exec-wrapper").getString("value");
        if (oldWrapper != null) {
            wrapper = wrapper + " " + oldWrapper;
        }
        this.gdbSet("exec-wrapper", wrapper);
    }

    protected static boolean isBourneShellAvailable() throws ExecutionException {
        if (ourShellAvailable == null) {
            ourShellAvailable = ExecUtil.execAndGetOutput((GeneralCommandLine)GDBDriver.getShellWrapper("exit \"$@\" 1> /dev/null 2> /dev/null", "0")).checkSuccess(CidrDebuggerLog.LOG);
        }
        return ourShellAvailable;
    }

    @NotNull
    protected static GeneralCommandLine getShellWrapper(@NotNull String command, String ... parameters) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(30);
        }
        if (parameters == null) {
            GDBDriver.$$$reportNull$$$0(31);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"/bin/sh", "-c", command, "--"}).withParameters(parameters);
        if (generalCommandLine == null) {
            GDBDriver.$$$reportNull$$$0(32);
        }
        return generalCommandLine;
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull String command) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(33);
        }
        String string = this.getShellCommandLineString(GDBDriver.getShellWrapper(command, new String[0]));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            GDBDriver.$$$reportNull$$$0(35);
        }
        String string = commandLine.getCommandLineList(null).stream().map(s -> this.shellQuote((String)s)).collect(Collectors.joining(" "));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    protected String getInferiorArgs(@NotNull ParametersList parametersList) {
        if (parametersList == null) {
            GDBDriver.$$$reportNull$$$0(37);
        }
        Function<String, String> quoteFunction = !this.isWindows() ? s -> this.shellQuote((String)s) : parameter -> CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
        String string = parametersList.getList().stream().map(quoteFunction).collect(Collectors.joining(" "));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(38);
        }
        return string;
    }

    protected void doPrepareInferiorEnv(GeneralCommandLine targetCommandLine, Map<String, String> gdbEnv) throws ExecutionException, DebuggerCommandException {
        boolean unbufferedIO;
        if (!targetCommandLine.isPassParentEnvironment()) {
            this.sendSilentRequestAndWaitForDone("unset env", new Object[0]);
            gdbEnv = Collections.emptyMap();
        }
        Map targetEnv = targetCommandLine.getEffectiveEnvironment();
        for (Map.Entry entry : ContainerUtil.diff((Map)targetEnv, gdbEnv).entrySet()) {
            String key = StringUtil.escapeLineBreak((String)((String)entry.getKey()));
            String value = (String)((Couple)entry.getValue()).first;
            this.gdbSet("env " + key, value);
        }
        if (this.isMac() && !(unbufferedIO = "YES".equalsIgnoreCase((String)targetEnv.get("NSUnbufferedIO")))) {
            this.warnUser("NSUnbufferedIO is not set, output may be delayed");
        }
    }

    protected void doSelectWinbreakBinary() throws ExecutionException, DebuggerCommandException {
        if (!this.isWindows() || this.myMIAsyncMode) {
            return;
        }
        String winBreakName = null;
        Pattern pattern = Pattern.compile(".+, file type (.+)\\.");
        Response response = this.sendSilentRequestAndWaitForDone("info target", new Object[0]);
        String consoleOutput = response.getOutput();
        for (String eachLine : StringUtil.splitByLines((String)consoleOutput)) {
            Matcher matcher = pattern.matcher(eachLine);
            if (!matcher.matches()) continue;
            String type = matcher.group(1);
            if (type.matches(".*\\bi\\d86\\b.*")) {
                winBreakName = "winbreak32.exe";
            } else if (type.contains("86_64") || type.contains("86-64")) {
                winBreakName = "winbreak64.exe";
            } else {
                throw new ExecutionException("Cannot determine architecture of the target: " + type);
            }
            CidrDebuggerLog.LOG.debug("Winbreak selected: " + winBreakName + " for: " + type);
            break;
        }
        if (winBreakName == null) {
            throw new ExecutionException("Cannot determine architecture of the target:\n" + consoleOutput);
        }
        File winBreakFile = CidrDebuggerPathManager.getWinbreakFile(winBreakName);
        if (!winBreakFile.exists()) {
            throw new ExecutionException("Cannot find " + winBreakFile.getPath());
        }
        this.myWinBreakPath = winBreakFile.getPath();
    }

    private void attachTo(final int pid) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.buildRequest("-target-attach %d", pid).suppressRunningEvent(GDBDriver.this.isWindows()).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                return pid;
            }

            @Override
            protected void whenAttached() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.handleAttached(pid);
            }
        });
    }

    private void detach(boolean isRemoteTarget) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doInterruptAndWait();
            Response response = this.buildRequest("-target-detach", new Object[0]).suppressTargetFinishedEvent().send().waitFor(new GDBResponse.ResultRecord.Type[0]);
            String message = response.getGDBErrorMessage();
            if (message != null) {
                if (message.equals("Remote connection closed") || message.startsWith("Remote communication error.  Target disconnected.")) {
                    this.warnUser(message);
                } else if (!message.equals("The program is not being run.")) {
                    throw new GDBCommandException(response, message);
                }
            }
            if (isRemoteTarget) {
                this.handleDisconnected();
            } else {
                this.handleDetached();
            }
        });
    }

    private void connectTo(final @NotNull String connectionString) throws ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(39);
        }
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.sendRequest("-target-select remote %s", connectionString).waitFor(GDBResponse.ResultRecord.Type.connected);
                return -1;
            }

            @Override
            protected void whenAttached() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.handleConnected(connectionString);
            }
        });
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        return this.executeCommandNoUserException(this::doInterrupt);
    }

    private boolean doInterrupt() throws ExecutionException {
        return this.doInterrupt(false);
    }

    private boolean doInterrupt(boolean tearDownRequest) throws ExecutionException {
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        Integer pid = this.myTargetPID;
        if (pid == null || this.getState() != DebuggerDriver.TargetState.RUNNING) {
            return false;
        }
        if (this.myMIAsyncMode) {
            this.doInterruptAsync(tearDownRequest);
        } else {
            this.doInterruptWithSignal(pid, tearDownRequest);
        }
        return true;
    }

    protected void doInterruptAsync(boolean tearDownRequest) throws ExecutionException {
        try {
            this.buildRequest("-exec-interrupt", new Object[0]).tearDownRequest(tearDownRequest).send().waitFor(GDBResponse.ResultRecord.Type.done);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.error((Throwable)e);
        }
    }

    protected void doInterruptWithSignal(int pid, boolean tearDownRequest) throws ExecutionException {
        this.sendRequestOrSpecialCommunication("interrupt", tearDownRequest, (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
            if (this.isWindows()) {
                this.doInterruptWinBreak(pid);
            } else {
                this.doInterruptSigInt(pid);
            }
        }));
    }

    private void doInterruptWinBreak(int pid) throws ExecutionException {
        CidrDebuggerLog.LOG.debug(">Sending interrupt signal using 'winbreak'");
        if (this.myWinBreakPath == null) {
            throw new ExecutionException("winbreak was not selected");
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{this.myWinBreakPath, Integer.toString(pid)}));
        String stderr = output.getStderr();
        CidrDebuggerLog.LOG.debug(stderr);
        int exitCode = output.getExitCode();
        if (exitCode != 0) {
            StringBuilder errorMessage;
            CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
            try (Scanner scanner = new Scanner(new ByteArrayInputStream(stderr.getBytes(Charset.forName("UTF-8"))));){
                errorMessage = new StringBuilder();
                while (scanner.hasNext()) {
                    if (scanner.findInLine("ERROR: (.*)") != null) {
                        MatchResult result = scanner.match();
                        if (errorMessage.length() > 0) {
                            errorMessage.append('\n');
                        }
                        errorMessage.append(result.group(1));
                    }
                    scanner.nextLine();
                }
            }
            throw new ExecutionException(errorMessage.toString());
        }
    }

    private void doInterruptSigInt(int pid) throws ExecutionException {
        int signal = 2;
        String signalDisplayName = "'SIGINT' (" + signal + ")";
        String signalCommand = "Sending " + signalDisplayName + " to " + pid;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        try {
            if (this.isRemoteEnv()) {
                this.myStarter.sendSignalToRemoteProcess(pid, signal);
            } else {
                UnixProcessManager.sendSignal((int)pid, (int)signal);
            }
        }
        catch (Throwable e) {
            throw new ExecutionException("Cannot send " + signalDisplayName + " to " + pid, e);
        }
    }

    private boolean doInterruptAndWait() throws ExecutionException {
        return this.doInterruptAndWait(false);
    }

    private boolean doInterruptAndWait(boolean tearDownRequest) throws ExecutionException {
        this.myInterrupted.down();
        try {
            if (this.doInterrupt(tearDownRequest)) {
                if (tearDownRequest && !GDBDriver.waitForSemaphore(this.myInterrupted, 1500L)) {
                    throw new ExecutionException("Couldn't interrupt GDB to request exit");
                }
                GDBDriver.waitForSemaphore(this.myInterrupted);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myInterrupted.up();
        }
    }

    @Override
    public boolean resume() throws ExecutionException {
        return this.executeCommandNoUserException(this::doResume);
    }

    private boolean doResume() throws ExecutionException, DebuggerCommandException {
        return this.doResume(false);
    }

    private boolean doResume(boolean suppressRunningEvent) throws ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
            return false;
        }
        try {
            this.buildRequest("-exec-continue %s", this.onStoppedThreadAndFrame()).suppressRunningEvent(suppressRunningEvent).send().waitFor(GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    private boolean getInstructionMode(@Nullable Boolean stepByInstruction) {
        boolean frameHasNoDebugInfo;
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        boolean bl = frameHasNoDebugInfo = stopPlace != null && !stopPlace.frame.hasDebugInfo();
        if (stepByInstruction != Boolean.TRUE) {
            if (frameHasNoDebugInfo && stepByInstruction == Boolean.FALSE) {
                CidrDebuggerLog.LOG.error("Attempt to line-step through function with no source line information; forcing instruction stepping mode");
            }
            stepByInstruction = frameHasNoDebugInfo;
        }
        return stepByInstruction;
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(stepByInstruction);
            if (!instructionMode) {
                this.doSetStepMode(forceStepIntoFramesWithNoDebugInfo);
            }
            this.buildRequest("-exec-step%s %s", GDBDriver.withInstructionMode(instructionMode), this.onStoppedThreadAndFrame()).onSteppingFinished((ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException>)((ThrowableConvertor)stopPlace -> {
                if (instructionMode || forceStepIntoFramesWithNoDebugInfo || stopPlace.frame.hasDebugInfo()) {
                    return true;
                }
                if (this.isMac() && this.isIndirectSymbolFrame(stopPlace.frame)) {
                    this.executeAsyncCommand(() -> this.sendSilentRequest("-exec-step %s", this.onStoppedThreadAndFrame()));
                    return false;
                }
                return this.asyncStepOutUntilFrameWithDebugInfo((DebuggerDriver.StopPlace)stopPlace);
            })).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(stepByInstruction);
            if (!instructionMode) {
                this.doSetStepMode(false);
            }
            this.buildRequest("-exec-next%s %s", GDBDriver.withInstructionMode(instructionMode), this.onStoppedThreadAndFrame()).onSteppingFinished((ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException>)(instructionMode ? null : this::asyncStepOutUntilFrameWithDebugInfo)).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOut() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(null);
            this.doSetStepMode(false);
            this.buildRequest("-exec-finish %s", this.onStoppedThreadAndFrame()).onSteppingFinished((ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException>)(instructionMode ? null : this::asyncStepOutUntilFrameWithDebugInfo)).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    private boolean asyncStepOutUntilFrameWithDebugInfo(@NotNull DebuggerDriver.StopPlace stopPlace) {
        boolean shouldStop;
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(40);
        }
        if (!(shouldStop = stopPlace.frame.hasDebugInfo())) {
            this.executeAsyncCommand(() -> this.buildRequest("-exec-next %s", this.onStoppedThreadAndFrame()).suppressAll().onSteppingFinished((ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException>)((ThrowableConvertor)this::asyncStepOutUntilFrameWithDebugInfo)).send());
        }
        return shouldStop;
    }

    @Override
    public void runTo(String path, int line) throws ExecutionException {
        this.executeCommandNoUserException(() -> this.sendRequestAndWaitForRunning("-exec-until %s %s", this.onStoppedThreadAndFrame(), GDBDriver.atSourceLine(path, line)));
    }

    private boolean abort() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
                return false;
            }
            this.doInterruptAndWait();
            try {
                this.sendSilentRequest("kill", new Object[0]).waitFor(GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                if ("The program is not being run.".equals(e.getMessage())) {
                    return false;
                }
                throw e;
            }
            return true;
        });
    }

    @Override
    protected void doExit() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            try {
                this.doInterruptAndWait(true);
            }
            catch (ExecutionFinishedException executionFinishedException) {
                // empty catch block
            }
            this.buildRequest("-gdb-exit", new Object[0]).tearDownRequest(true).send();
        });
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        LLWatchpoint lLWatchpoint = this.executeCommand(() -> {
            if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
                throw new ExecutionException("Cannot set watchpoint while program is running");
            }
            String watchpointExpression = this.doGetWatchpointExpression(threadId, frameIndex, lifetime, expr);
            Response response = this.sendRequestAndWaitForDone("-break-watch %s %s", accessType.getParamString(), GDBDriver.stringify(watchpointExpression));
            return GDBDriver.readWatchpoint(response.getResultList(), accessType);
        });
        if (lLWatchpoint == null) {
            GDBDriver.$$$reportNull$$$0(41);
        }
        return lLWatchpoint;
    }

    @NotNull
    private String doGetWatchpointExpression(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expression) throws ExecutionException, DebuggerCommandException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated = this.doEvaluate(threadId, frameIndex, "&(" + expression + ")", null);
            String value = GDBDriver.doLoadVariable((LLValue)evaluated).data.getValue();
            if (value.isEmpty()) {
                throw new DebuggerCommandException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression = "*" + value;
        }
        String string = expression;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws ExecutionException {
        GDBTuple tuple = resultList.getRequiredTuple(accessType.getTupleKey());
        return new LLWatchpoint(tuple.getRequiredInt("number"), tuple.getRequiredString("exp"));
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        List list = this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                String envPath = this.toEnvPath(path);
                Response response = this.sendRequestAndWaitForDone("-break-insert -f %s %s", GDBDriver.withCondition(condition), GDBDriver.atSourceLine(envPath, line));
                List<LLBreakpoint> list = Collections.singletonList(GDBDriver.readBreakpoint(response.getResultList(), condition, null));
                return list;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(43);
        }
        return list;
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        if (symBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(44);
        }
        LLSymbolicBreakpoint lLSymbolicBreakpoint = this.executeCommand(() -> {
            if (symBreakpoint == null) {
                GDBDriver.$$$reportNull$$$0(164);
            }
            StringBuilder commandSb = new StringBuilder();
            commandSb.append("-break-insert -f ").append(symBreakpoint.getPattern());
            if (symBreakpoint.getThreadId() != 0L) {
                commandSb.append(" -p ").append(symBreakpoint.getThreadId());
            }
            Response response = this.sendRequestAndWaitForDone("%s", commandSb.toString());
            GDBTuple pairs = response.getResultList();
            for (Pair each : pairs) {
                GDBTuple bkpt = (GDBTuple)each.second;
                if (bkpt == null) continue;
                int number = bkpt.getRequiredInt("number");
                return new LLSymbolicBreakpoint(number);
            }
            throw new DebuggerCommandException("No code at this line");
        });
        if (lLSymbolicBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(45);
        }
        return lLSymbolicBreakpoint;
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException, DebuggerCommandException {
        if (ids == null) {
            GDBDriver.$$$reportNull$$$0(46);
        }
        this.executeCommand(() -> {
            if (ids == null) {
                GDBDriver.$$$reportNull$$$0(163);
            }
            boolean interrupted = this.doInterruptAndWait();
            try {
                for (Integer each : ids) {
                    this.sendRequestAndWaitForDone("-break-delete %d", each);
                }
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @NotNull
    private static LLBreakpoint readBreakpoint(@NotNull GDBTuple info, String condition, String error) throws ExecutionException, DebuggerCommandException {
        if (info == null) {
            GDBDriver.$$$reportNull$$$0(47);
        }
        Pair<GDBTuple, List<GDBTuple>> breakpointWithLocations = info.getWithSuccessors("bkpt", GDBTuple.class);
        GDBTuple breakpointTuple = (GDBTuple)breakpointWithLocations.first;
        List multipleLocationTuples = (List)breakpointWithLocations.second;
        if (breakpointTuple == null) {
            throw new DebuggerCommandException("No code at this line");
        }
        int number = breakpointTuple.getRequiredInt("number");
        String addr = breakpointTuple.getString("addr");
        boolean multipleLocations = "<MULTIPLE>".equals(addr) && !multipleLocationTuples.isEmpty();
        boolean pending = "<PENDING>".equals(addr);
        GDBTuple.Location location = (multipleLocations ? (GDBTuple)multipleLocationTuples.get(0) : breakpointTuple).getLocation("fullname", "line");
        if (location == null && pending) {
            location = breakpointTuple.getLocation("pending");
        }
        if (location == null) {
            location = breakpointTuple.getRequiredLocationOrThrow("original-location", msg -> {
                CidrDebuggerLog.LOG.warn(msg);
                return new DebuggerCommandException("GDB does not allow to set breakpoint here");
            });
        }
        LLBreakpoint lLBreakpoint = new LLBreakpoint(number, location.path, location.line, "<PENDING>".equals(addr), condition, error);
        if (lLBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(48);
        }
        return lLBreakpoint;
    }

    @NotNull
    private DebuggerDriver.StopPlace doReadStopPlace(@NotNull GDBTuple stopTuple) throws ExecutionException {
        if (stopTuple == null) {
            GDBDriver.$$$reportNull$$$0(49);
        }
        long threadId = stopTuple.getRequiredInt("thread-id");
        LLThread thread = new LLThread(threadId, "STOPPED", null);
        GDBTuple frameTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> {
            if (stopTuple == null) {
                GDBDriver.$$$reportNull$$$0(162);
            }
            return new ExecutionException("Cannot read stop place: " + stopTuple);
        });
        LLFrame frame = this.doReadFrame(0, frameTuple);
        DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(50);
        }
        return stopPlace;
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        List list = (List)this.executeCommand(this::doGetThreads);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    private List<LLThread> doGetThreads() throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        GDBTuple threads = response.getResultList().getRequiredTuple("threads");
        ArrayList<LLThread> result = new ArrayList<LLThread>(threads.size());
        for (GDBTuple each : threads) {
            int id = each.getRequiredInt("id");
            String name2 = each.getString("name");
            String state = each.getRequiredString("state");
            result.add(new LLThread(id, state.toUpperCase(), null, name2));
        }
        Collections.sort(result, Comparator.comparingLong(LLThread::getId));
        ArrayList<LLThread> arrayList = result;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        DebuggerDriver.ResultList resultList = this.executeCommand(() -> this.doGetFrames(threadId, from, count, untilFirstLineWithCode));
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(53);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequest("-stack-list-frames --thread %d %d %d", threadId, from, from + count).waitFor(new GDBResponse.ResultRecord.Type[0]);
        GDBTuple stack = response.getResultList().getTuple("stack");
        List<GDBTuple> frames = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = response.getGDBErrorMessage();
        if (frames == null) {
            if (msg != null && msg.contains(" Not enough frames in stack")) {
                DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.empty();
                if (resultList == null) {
                    GDBDriver.$$$reportNull$$$0(54);
                }
                return resultList;
            }
            throw new DebuggerCommandException(msg != null ? msg : "Cannot collect frames");
        }
        if (msg != null) {
            this.warnUser(msg);
        }
        ArrayList<LLFrame> result = new ArrayList<LLFrame>(frames.size());
        for (int i = 0; i < Math.min(frames.size(), count); ++i) {
            GDBTuple each = frames.get(i);
            LLFrame frame = this.doReadFrame(each.getRequiredInt("level"), each);
            result.add(frame);
            if (untilFirstLineWithCode && frame.getLine() != -1) break;
        }
        boolean hasMore = result.size() < frames.size();
        DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(55);
        }
        return resultList;
    }

    @NotNull
    private LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
        if (frameTuple == null) {
            GDBDriver.$$$reportNull$$$0(56);
        }
        String func = frameTuple.getString("func");
        String addrStr = frameTuple.getString("addr");
        String fullname = frameTuple.getString("fullname");
        String file = this.myStarter.convertToLocalPath(fullname != null ? fullname : frameTuple.getString("file"));
        int line = -1;
        if (file != null) {
            line = frameTuple.getInt("line", 0) - 1;
        }
        Address addr = Address.NULL;
        if (addrStr != null) {
            try {
                addr = GDBDriver.parseAddress(addrStr);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        LLFrame lLFrame = new LLFrame(level, "??".equals(func) ? null : func, file, line, addr, null, false);
        if (lLFrame == null) {
            GDBDriver.$$$reportNull$$$0(57);
        }
        return lLFrame;
    }

    private boolean isIndirectSymbolFrame(@NotNull LLFrame frame) throws ExecutionException {
        TLongHashSet indirectSymbols;
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(58);
        }
        if ((indirectSymbols = this.myIndirectSymbols) == null) {
            return false;
        }
        return !frame.hasDebugInfo() && !frame.hasSymbolInfo() && indirectSymbols.contains(frame.getProgramCounter().unsignedLongValue());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        List list = (List)this.executeCommand(() -> this.doGetFrameVariables(threadId, frameIndex));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(59);
        }
        return list;
    }

    @NotNull
    private String doGetFrameAddr(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-data-evaluate-expression %s $fp", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        String string = response.getResultList().getRequiredStringOrThrow("value", () -> new ExecutionException("Cannot evaluate frame address for thread: " + threadId + " frame: " + frameIndex));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    private List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        SmartList result = new SmartList();
        String currentFrameAddr = this.doGetFrameAddr(threadId, frameIndex);
        for (Object o : this.doUpdateAndListFrameVariables(threadId, frameIndex, currentFrameAddr)) {
            result.add(this.doReadVariable((GDBTuple)o, "", currentFrameAddr, null, threadId, frameIndex));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GDBDriver.$$$reportNull$$$0(61);
        }
        return smartList;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(62);
        }
        LLValueData lLValueData = (LLValueData)this.executeCommand(() -> {
            if (value == null) {
                GDBDriver.$$$reportNull$$$0(161);
            }
            return GDBDriver.doLoadVariable((LLValue)value).data;
        });
        if (lLValueData == null) {
            GDBDriver.$$$reportNull$$$0(63);
        }
        return lLValueData;
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(64);
        }
        return (String)this.executeCommand(() -> {
            Response response;
            boolean lengthChanged;
            if (value == null) {
                GDBDriver.$$$reportNull$$$0(160);
            }
            String id = GDBDriver.doLoadVariable((LLValue)value).id;
            boolean bl = lengthChanged = maxLength != 1000;
            if (lengthChanged) {
                this.doSetMaxDescription(false);
            }
            try {
                if (lengthChanged) {
                    this.sendRequestAndWaitForDone("-var-update --no-values %s", GDBDriver.stringify(id));
                }
                response = this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            }
            finally {
                if (lengthChanged) {
                    this.doSetMaxDescription(true);
                }
            }
            return (String)GDBDriver.getDescriptionFromValue((String)response.getResultList().getRequiredString((String)"value")).second;
        });
    }

    @NotNull
    public String getVariableID(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(65);
        }
        String string = (String)this.executeCommand(() -> {
            if (value == null) {
                GDBDriver.$$$reportNull$$$0(159);
            }
            return GDBDriver.doLoadVariable((LLValue)value).id;
        });
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(66);
        }
        return string;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        DebuggerDriver.ResultList resultList = (DebuggerDriver.ResultList)this.executeCommand(() -> this.doGetVariableChildren(value, from, count));
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(67);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetVariableChildren(final @NotNull LLValue var, final int offset, final int count) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(68);
        }
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            int endOffset = offset + count;
            List<LLValue> all = Arrays.asList(mapElement.getKey(), mapElement.getValue());
            List<LLValue> list = all.subList(Math.min(offset, 2), Math.min(endOffset, 2));
            boolean hasMore = endOffset < 2;
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(list, hasMore);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(69);
            }
            return resultList;
        }
        if (data.isMap) {
            DebuggerDriver.ResultList<LLValue> resultList = this.doGetMapChildren(var, offset, count);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(70);
            }
            return resultList;
        }
        final ArrayList result = new ArrayList();
        boolean readAsStruct = this.doVisitCppClassChildren(var, new StructChildrenVisitor(){
            int currentOffset;
            int restCount;
            {
                this.currentOffset = offset;
                this.restCount = count;
            }

            @Override
            public boolean visitRealChild(@NotNull GDBTuple child) throws ExecutionException {
                if (child == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (this.currentOffset >= 1) {
                    --this.currentOffset;
                    return true;
                }
                result.add(GDBDriver.this.doReadVariable(child, var.getReferenceExpression(), null));
                --this.restCount;
                this.currentOffset = Math.max(0, this.currentOffset - 1);
                return this.restCount != 0;
            }

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
                if (fakeChild == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (this.currentOffset >= childrenCount) {
                    this.currentOffset -= childrenCount;
                    return true;
                }
                int innerEndPos = Math.min(this.currentOffset + this.restCount, childrenCount);
                result.addAll(((GDBDriver)GDBDriver.this).doGetPlainVariableChildren((LLValue)fakeChild, (int)this.currentOffset, (int)innerEndPos).list);
                this.restCount -= innerEndPos - this.currentOffset;
                this.currentOffset = 0;
                return this.restCount != 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "child";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fakeChild";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRealChild";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFakeChild";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (readAsStruct) {
            int childrenCount = this.doGetChildrenCount(var);
            boolean hasMore = offset + result.size() < childrenCount;
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(71);
            }
            return resultList;
        }
        DebuggerDriver.ResultList<LLValue> resultList = this.doGetPlainVariableChildren(var, offset, offset + count);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(72);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetPlainVariableChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(73);
        }
        if (offset > endPos) {
            throw new ExecutionException("Internal error, incorrect children range. from = " + offset + " to = " + endPos);
        }
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset, endPos);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        for (Object o : (GDBTuple)childList.first) {
            GDBTuple each = GDBDriver.getChildTuple((GDBTuple)childList.first, o);
            if (each == null) {
                hasMore = false;
                break;
            }
            result.add(this.doReadVariable(each, var.getReferenceExpression(), null));
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(74);
        }
        return resultList;
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData loaded;
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(75);
        }
        if (!(loaded = GDBDriver.doLoadVariable(var)).mayHaveChildren()) {
            Pair pair2 = Pair.create((Object)new GDBTuple(), (Object)false);
            if (pair2 == null) {
                GDBDriver.$$$reportNull$$$0(76);
            }
            return pair2;
        }
        String id = loaded.id;
        Response response = this.sendRequestAndWaitForDone("-var-list-children --all-values %s %d %d", GDBDriver.stringify(id), offset, endPos);
        GDBTuple resultList = response.getResultList();
        GDBTuple children = resultList.getTupleOrEmpty("children");
        boolean hasMore = resultList.getBoolean("has_more");
        if (hasMore) {
            this.sendRequestAndWaitForDone("-var-set-update-range %s 0 %d", GDBDriver.stringify(id), endPos);
        }
        Pair pair3 = Pair.create((Object)children, (Object)hasMore);
        if (pair3 == null) {
            GDBDriver.$$$reportNull$$$0(77);
        }
        return pair3;
    }

    private boolean doVisitCppClassChildren(@NotNull LLValue var, @NotNull StructChildrenVisitor visitor) throws ExecutionException, DebuggerCommandException {
        Object o;
        GDBTuple each;
        Integer childrenCount;
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(78);
        }
        if (visitor == null) {
            GDBDriver.$$$reportNull$$$0(79);
        }
        if ((childrenCount = GDBDriver.doLoadVariable((LLValue)var).childrenCount) == null) {
            return false;
        }
        if (childrenCount == 0) {
            return true;
        }
        if (childrenCount > 10) {
            return false;
        }
        GDBTuple children = (GDBTuple)var.getUserData(LLVALUE_CLASS_CHILDREN_CACHE);
        if (children == null) {
            children = (GDBTuple)this.doListChildren((LLValue)var, (int)-1, (int)-1).first;
            var.putUserData(LLVALUE_CLASS_CHILDREN_CACHE, children);
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext() && (each = GDBDriver.getChildTuple(children, o = iterator.next())) != null) {
            if (each.getString("type") != null) {
                if (visitor.visitRealChild(each)) continue;
                break;
            }
            String name2 = each.getRequiredStringOrThrow("name", msg -> new ExecutionException("Internal error: Unexpected gdb fake variable: " + msg));
            LLValue fakeValue = new LLValue("", "", null, name2);
            int numchild = each.getInt("numchild", 0);
            GDBDriver.doUpdateLoadedData(fakeValue, new LLValueLoadedData(name2, null, numchild, false, false, false, ""));
            if (visitor.visitFakeChild(fakeValue, numchild)) continue;
            break;
        }
        return true;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetMapChildren(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset * 2, (offset + count) * 2);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        int size = ((GDBTuple)childList.first).size();
        for (int i = 0; i < size - 1; i += 2) {
            GDBTuple keyTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i));
            GDBTuple valueTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i + 1));
            if (keyTuple == null || valueTuple == null) {
                hasMore = false;
                break;
            }
            LLValue key = this.doReadVariable(keyTuple, var.getReferenceExpression(), null, "first");
            LLValue value = this.doReadVariable(valueTuple, var.getReferenceExpression(), null, "second");
            LLValue element = new LLValue("[" + (offset + i / 2) + "]", "std::pair<" + key.getType() + ", " + value.getType() + ">", null, value.getReferenceExpression());
            element.putUserData(LLVALUE_DATA, new LLValueLoadedData("<map element>", null, 2, false, false, false, ""));
            element.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key, value));
            result.add(element);
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(80);
        }
        return resultList;
    }

    @Nullable
    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws ExecutionException {
        if (!(o instanceof Pair)) {
            throw new ExecutionException("Invalid object in the list: " + varObjList);
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new ExecutionException("pair.first required to be \"child\": " + p.toString());
        }
        GDBTuple result = (GDBTuple)p.second;
        String name2 = result.getString("name");
        return name2 != null && name2.matches(".*\\.<error at.*") ? null : result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private GDBResponse.Record doCreateVar(@NotNull String expression, long threadId, int n) throws ExecutionException, DebuggerCommandException {
        void frameIndex;
        if (expression == null) {
            GDBDriver.$$$reportNull$$$0(81);
        }
        String command = GDBDriver.createMI2Command(String.format("-var-create - * %s", GDBDriver.stringify(expression)), threadId, (int)frameIndex);
        Response response = this.sendRequestAndWaitForDone("%s", command);
        if (response.getReceivedSignalCount() != 0) {
            String id = response.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-set-frozen %s 1", GDBDriver.stringify(id));
        }
        GDBResponse.Record record = response.getRecord();
        if (record == null) {
            GDBDriver.$$$reportNull$$$0(82);
        }
        return record;
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String currentFrameAddr) throws ExecutionException {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(83);
        }
        if (parentRef == null) {
            GDBDriver.$$$reportNull$$$0(84);
        }
        LLValue lLValue = this.doReadVariable(varTuple, parentRef, currentFrameAddr, null);
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(85);
        }
        return lLValue;
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String frameAddress, @Nullable String displayName) throws ExecutionException {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(86);
        }
        if (parentRef == null) {
            GDBDriver.$$$reportNull$$$0(87);
        }
        LLValue lLValue = this.doReadVariable(varTuple, parentRef, frameAddress, displayName, -1L, -1);
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(88);
        }
        return lLValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String frameAddress, @Nullable String displayName, long threadId, int n) throws ExecutionException {
        void frameIndex;
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(89);
        }
        if (parentRef == null) {
            GDBDriver.$$$reportNull$$$0(90);
        }
        boolean isFrameVariable = frameAddress != null;
        LLValue result = null;
        String name2 = varTuple.getString("name");
        String type = varTuple.getString("type");
        String fvKey = null;
        if (name2 != null && isFrameVariable) {
            fvKey = GDBDriver.makeFVKey(frameAddress, name2);
            result = this.myFrameVarCache.get(fvKey);
            if (type == null) {
                if (result != null) {
                    type = result.getType();
                } else {
                    try {
                        type = this.doGetExpressionType(name2, threadId, (int)frameIndex);
                    }
                    catch (GDBCommandException e) {
                        String error = e.getMessage();
                        type = "value has been optimized out".equals(error) ? "<optimized out>" : "error: " + error;
                    }
                }
            }
        }
        boolean invalid = name2 == null || type == null;
        name2 = StringUtil.notNullize((String)name2, (String)"<unknown>");
        type = StringUtil.notNullize((String)type, (String)"<unknown>");
        String id = name2;
        String value = varTuple.getString("value");
        if (result == null) {
            String exp = varTuple.getString("exp");
            if (exp != null) {
                name2 = exp;
            }
            result = new LLValue(displayName != null ? displayName : name2, GDBDriver.fixType(type), null, parentRef.isEmpty() ? name2 : parentRef + "." + name2);
        } else {
            result = new LLValue(result.getName(), result.getType(), result.getTypeClass(), result.getReferenceExpression());
        }
        if (fvKey != null) {
            this.myFrameVarCache.put(fvKey, result);
        }
        if (invalid) {
            GDBDriver.doUpdateLoadedData(result, new LLValueLoadedData("", null, 0, false, false, false, StringUtil.notNullize((String)value)));
        } else {
            LLValueLoader loader = null;
            if (isFrameVariable) {
                loader = new FrameValueLoader(fvKey, threadId, (int)frameIndex, value);
            } else {
                LLValueLoadedData data = GDBDriver.doReadLoadedData(varTuple, id, null, StringUtil.notNullize((String)value));
                if (value == null) {
                    loader = new CreatedValueLoader(data);
                } else {
                    GDBDriver.doUpdateLoadedData(result, data);
                }
            }
            result.putUserData(LLVALUE_DATA_LOADER, loader);
        }
        LLValue lLValue = result;
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(91);
        }
        return lLValue;
    }

    @NotNull
    private static LLValueLoadedData doLoadVariable(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data;
        LLValueLoader loader;
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(92);
        }
        if ((loader = (LLValueLoader)value.getUserData(LLVALUE_DATA_LOADER)) != null) {
            loader.loadValue(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
        }
        if ((data = (LLValueLoadedData)value.getUserData(LLVALUE_DATA)) == null) {
            throw new ExecutionException("Internal error, variable is not initialized: " + (Object)((Object)value));
        }
        LLValueLoadedData lLValueLoadedData = data;
        if (lLValueLoadedData == null) {
            GDBDriver.$$$reportNull$$$0(93);
        }
        return lLValueLoadedData;
    }

    @NotNull
    private static LLValueLoadedData doReadLoadedData(@NotNull GDBTuple varTuple, @NotNull String id, @Nullable String fvKey, @NotNull String value) throws ExecutionException {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(94);
        }
        if (id == null) {
            GDBDriver.$$$reportNull$$$0(95);
        }
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(96);
        }
        Integer childrenCount = null;
        boolean isDynamic = varTuple.getBoolean("dynamic");
        boolean hasDynamicChildren = false;
        if (isDynamic) {
            hasDynamicChildren = varTuple.getBoolean("has_more", true);
        } else {
            childrenCount = varTuple.getInt("numchild", 0);
        }
        boolean isMap = "map".equals(varTuple.getString("displayhint"));
        LLValueLoadedData lLValueLoadedData = new LLValueLoadedData(id, fvKey, childrenCount, isDynamic, hasDynamicChildren, isMap, value);
        if (lLValueLoadedData == null) {
            GDBDriver.$$$reportNull$$$0(97);
        }
        return lLValueLoadedData;
    }

    @NotNull
    private static LLValueLoadedData doUpdateLoadedData(@NotNull LLValue var, @NotNull LLValueLoadedData data) {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(98);
        }
        if (data == null) {
            GDBDriver.$$$reportNull$$$0(99);
        }
        var.putUserData(LLVALUE_DATA, data);
        LLValueLoadedData lLValueLoadedData = data;
        if (lLValueLoadedData == null) {
            GDBDriver.$$$reportNull$$$0(100);
        }
        return lLValueLoadedData;
    }

    @Override
    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var, int max) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(101);
        }
        return (Integer)this.executeCommand(() -> {
            if (var == null) {
                GDBDriver.$$$reportNull$$$0(158);
            }
            return Math.min(this.doGetChildrenCount(var), max);
        });
    }

    @Nullable
    private Integer doGetChildrenCount(LLValue var) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        Integer nullableChildrenCount = data.childrenCount;
        if (data.isDynamic && nullableChildrenCount == null) {
            int size = ((GDBTuple)this.doListChildren((LLValue)var, (int)0, (int)(data.isMap ? 100 : 50)).first).size();
            return data.isMap ? size / 2 : size;
        }
        if (nullableChildrenCount == null) {
            return null;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            return nullableChildrenCount;
        }
        Integer classChildrenCountCache = (Integer)var.getUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE);
        if (classChildrenCountCache != null) {
            return classChildrenCountCache;
        }
        final int[] childrenCount = new int[]{nullableChildrenCount};
        if (this.doVisitCppClassChildren(var, new StructChildrenVisitor(){

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int fakeChildrenCount) {
                if (fakeChild == null) {
                    11.$$$reportNull$$$0(0);
                }
                childrenCount[0] = childrenCount[0] - 1;
                childrenCount[0] = childrenCount[0] + fakeChildrenCount;
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeChild", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$11", "visitFakeChild"));
            }
        })) {
            var.putUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE, childrenCount[0]);
        }
        return childrenCount[0];
    }

    private static String fixType(@Nullable String type) {
        return type == null ? null : type.replace("'", "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLValue evaluate(final long threadId, final int frameIndex, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage debuggerLanguage) throws ExecutionException, DebuggerCommandException {
        void language;
        if (expression == null) {
            GDBDriver.$$$reportNull$$$0(102);
        }
        final String debuggerLanguage2 = GDBDriver.convertLanguage((DebuggerDriver.DebuggerLanguage)language);
        LLValue lLValue = this.executeCommand(new EvaluationCommand<LLValue>(expression){

            @Override
            public LLValue call() throws ExecutionException, DebuggerCommandException {
                return GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage2);
            }
        });
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(103);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(104);
        }
        List list = this.executeCommand(() -> {
            Response response;
            if (range == null) {
                GDBDriver.$$$reportNull$$$0(157);
            }
            if ((response = this.doDataDisassemble(range, true)).getRecord().getType() == GDBResponse.ResultRecord.Type.error) {
                Matcher matcher = CANNOT_ACCESS_MEMORY_AT_ADDRESS.matcher(response.getResultList().getString("msg", ""));
                if (!matcher.matches()) {
                    throw response.createGDBError();
                }
                Address badAddress = Address.parseHexString(matcher.group(1));
                AddressRange smallerRange = range.getStart().rangeTo(badAddress.minus(1));
                if (smallerRange.isEmpty() || !range.covers(smallerRange)) {
                    throw response.createGDBError();
                }
                response = this.doDataDisassemble(smallerRange, false);
            }
            GDBTuple asmInsns = response.getResultList().getRequiredTuple("asm_insns");
            ArrayList<LLInstruction> result = new ArrayList<LLInstruction>(asmInsns.size());
            for (GDBTuple asmInsn : asmInsns) {
                String disassembly = asmInsn.getRequiredString("inst").trim();
                if (BAD_INSTRUCTION_WITH_PREFIX_SUFFIX.matcher(disassembly).matches()) {
                    disassembly = String.format("/* BAD: %s */", asmInsn.getRequiredString("opcodes"));
                }
                disassembly = INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME.matcher(disassembly).replaceAll("$1  # $2");
                result.add(new LLInstruction(asmInsn.getRequiredAddress("address"), disassembly));
            }
            return result;
        });
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(105);
        }
        return list;
    }

    @NotNull
    private Response doDataDisassemble(@NotNull AddressRange range, boolean allowError) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(106);
        }
        Response response = this.sendRequest("-data-disassemble -s %s -e %s -- 2", range.getStart(), range.getEndCoerced()).waitFor(GDBResponse.ResultRecord.Type.done, allowError ? GDBResponse.ResultRecord.Type.error : GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(107);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable String language) throws ExecutionException, DebuggerCommandException {
        GDBResponse.Record response = this.myVarsCache.getFromCache(expression);
        if (response != null) {
            String name2 = response.getResultList().getRequiredString("name");
            this.sendRequestAndWaitForDone("-var-update %s", GDBDriver.stringify(name2));
        } else {
            if (language != null) {
                this.sendRequestAndWaitForDone("-gdb-set language %s", language);
            }
            try {
                response = this.doCreateVar(expression, threadId, frameIndex);
            }
            finally {
                if (language != null) {
                    this.sendRequestAndWaitForDone("-gdb-set language auto", new Object[0]);
                }
            }
            this.myVarsCache.putIntoCache(expression, response);
        }
        return this.doReadVariable(response.getResultList(), "", null, null);
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return "c";
                }
                case C_PLUS_PLUS: {
                    return "c++";
                }
                case OBJC: {
                    return "objective-c";
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        if (executable == null) {
            GDBDriver.$$$reportNull$$$0(108);
        }
        throw new ExecutionException("Not implemented yet");
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException, DebuggerCommandException {
        this.executeConsoleCommand(-1L, -1, command);
    }

    @Override
    public void executeConsoleCommand(final long threadId, final int frameIndex, final String command) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(new ConsoleCommand<Object>(command){

            @Override
            public Object call() throws ExecutionException, DebuggerCommandException {
                String commandToSend;
                if (GDBDriver.this.isInPromptMode()) {
                    commandToSend = command;
                } else {
                    String trimmed;
                    long actualThreadId = threadId;
                    int actualFrameIndex = frameIndex;
                    DebuggerDriver.StopPlace currentPlace = GDBDriver.this.myStopPlace;
                    if (actualThreadId < 0L && currentPlace != null) {
                        actualThreadId = currentPlace.thread.getId();
                        actualFrameIndex = currentPlace.frame.getIndex();
                    }
                    if ("run".equals(trimmed = command.trim())) {
                        GDBDriver.this.handleGDBOutput("Command '" + trimmed + "' is not supported.\n");
                        return null;
                    }
                    commandToSend = GDBDriver.createConsoleCommand(trimmed, actualThreadId, actualFrameIndex);
                }
                GDBDriver.this.sendRequest("%s", commandToSend).waitFor(new GDBResponse.ResultRecord.Type[0]);
                return null;
            }
        });
    }

    @Override
    public void handleCompletion(String command, int pos, List<String> completions) throws ExecutionException {
    }

    @Override
    public void handleSignal(String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            ArrayList<String> options = new ArrayList<String>(3);
            options.add(GDBDriver.handleSignalOption(stop, "stop"));
            options.add(GDBDriver.handleSignalOption(pass, "pass"));
            options.add(GDBDriver.handleSignalOption(notify, "print"));
            String command = String.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        });
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = "";
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(109);
        }
        String string = GDBDriver.createConsoleCommand(request, -1L, -1);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(110);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected static String createConsoleCommand(@NotNull String request, long threadId, int n) {
        void frameIndex;
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(111);
        }
        String string = String.format("-interpreter-exec %s console %s", GDBDriver.onThreadAndFrame(threadId, (int)frameIndex), GDBDriver.stringify(request));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(112);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected static String createMI2Command(@NotNull String request, long threadId, int n) {
        void frameIndex;
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(113);
        }
        String string = String.format("%d-interpreter-exec %s %s %s", 0, GDBDriver.onThreadAndFrame(threadId, (int)frameIndex), "mi2", GDBDriver.stringify(request));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(114);
        }
        return string;
    }

    private String onStoppedThreadAndFrame() {
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        return stopPlace == null ? "" : GDBDriver.onThreadAndFrame(stopPlace.thread.getId(), stopPlace.frame.getIndex());
    }

    private static String onThreadAndFrame(long threadId, int frameIndex) {
        return threadId >= 0L ? String.format("--thread %d --frame %d", threadId, frameIndex) : "";
    }

    private static String atSourceLine(@NotNull String source, int line) {
        if (source == null) {
            GDBDriver.$$$reportNull$$$0(115);
        }
        return GDBDriver.stringify(String.format("%s:%d", source, line + 1));
    }

    private static String withCondition(@Nullable String condition) {
        return condition != null ? String.format("-c %s", GDBDriver.stringify(condition)) : "";
    }

    private static String withInstructionMode(boolean stepByInstruction) {
        return stepByInstruction ? "-instruction" : "";
    }

    @NotNull
    @Contract(pure=true)
    protected Request buildRequest(@NotNull @PrintFormat String command, Object ... args) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(116);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(117);
        }
        Request request = new Request(String.format(command, args));
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(118);
        }
        return request;
    }

    @NotNull
    protected Communication sendRequest(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(119);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(120);
        }
        Communication communication = this.buildRequest(command, args).send();
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(121);
        }
        return communication;
    }

    @NotNull
    protected Response sendRequestAndWaitForDone(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(122);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(123);
        }
        Response response = this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(124);
        }
        return response;
    }

    @NotNull
    protected Response sendRequestAndWaitForRunning(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(125);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(126);
        }
        Response response = this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(127);
        }
        return response;
    }

    @NotNull
    private Communication sendSilentRequest(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(128);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(129);
        }
        Communication communication = this.buildRequest(command, args).suppressAll().send();
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(130);
        }
        return communication;
    }

    @NotNull
    protected Response sendSilentRequestAndWaitForDone(@NotNull @PrintFormat String command, Object ... args) throws ExecutionException, GDBCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(131);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(132);
        }
        Response response = this.sendSilentRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(133);
        }
        return response;
    }

    protected void sendRequestOrSpecialCommunication(@NotNull String commandDisplayString, boolean tearDownRequest, @NotNull ThrowableRunnable<ExecutionException> r) throws ExecutionException {
        if (commandDisplayString == null) {
            GDBDriver.$$$reportNull$$$0(134);
        }
        if (r == null) {
            GDBDriver.$$$reportNull$$$0(135);
        }
        GDBDriver.waitForSemaphore(this.myCommandSemaphore);
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        this.myCommandSemaphore.down();
        this.myLastCommand = commandDisplayString;
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(">" + commandDisplayString);
        }
        r.run();
    }

    private void throwIfTerminatedOrHasPendingErrors(boolean tearDownRequest) throws ExecutionException {
        if (!tearDownRequest && this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated()) {
            throw new ExecutionFinishedException();
        }
        this.checkErrors();
    }

    @Override
    public void checkErrors() throws ExecutionException {
        Response response;
        while ((response = (Response)this.myResultQueue.poll()) != null) {
            try {
                response.checkError();
            }
            catch (ExecutionFinishedException executionFinishedException) {}
        }
    }

    @Override
    protected void handleGDBOutput(@NotNull String text) {
        if (text == null) {
            GDBDriver.$$$reportNull$$$0(136);
        }
        if (!this.myCommunication.suppressOutputEvent) {
            super.handleGDBOutput(text);
        }
    }

    @Override
    protected void handleRunning() {
        if (!this.myCommunication.suppressRunningEvent) {
            super.handleRunning();
        }
    }

    @Override
    protected void handleTargetFinished(int code, @Nullable String description) {
        if (this.myCommunication.suppressTargetFinishedEvent) {
            return;
        }
        this.myInterrupted.up();
        super.handleTargetFinished(code, description);
    }

    @Override
    protected void handleTargetTerminated() {
        this.myInterrupted.up();
        super.handleTargetTerminated();
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    private static ExecutionException unexpectedResponse(Object response) throws ExecutionException {
        return new ExecutionException("Unexpected response: " + response);
    }

    private static boolean messageContains(@NotNull Exception e, @NotNull String string) {
        String message;
        if (e == null) {
            GDBDriver.$$$reportNull$$$0(137);
        }
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(138);
        }
        return (message = e.getMessage()) != null && message.contains(string);
    }

    private static void waitForSemaphore(@NotNull Semaphore s) throws ExecutionException {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(139);
        }
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private static boolean waitForSemaphore(@NotNull Semaphore s, long msTimeout) throws ExecutionException {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(140);
        }
        try {
            return s.waitForUnsafe(msTimeout);
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Execution interrupted", (Throwable)e);
        }
    }

    private void setPromptMode(int promptLevel) {
        this.myPromptLevel = promptLevel;
        this.handlePrompt(promptLevel);
    }

    private boolean enterPromptMode(String prompt) {
        if (!PROMPT.matcher(prompt).matches()) {
            return false;
        }
        CidrDebuggerLog.LOG.assertTrue(this.myIsConsoleCommand, (Object)"Prompt mode is only expected as a result of a console command");
        GDBResponse.AsyncRecord record = new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, "read-one-line", new GDBTuple());
        this.setPromptMode(prompt.length());
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
        this.myCommandSemaphore.up();
        return true;
    }

    private void processResponse(@NotNull String output) {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(141);
        }
        try {
            this.doProcessResponse(output);
        }
        catch (Throwable e) {
            this.myResultQueue.offer(new ErrorResponse("Failed to process MI record:\n>" + this.myCommunication.command + "\n<" + output, e));
        }
    }

    private void doProcessResponse(@NotNull String output) throws GDBResponse.ResponseParseException, ExecutionException {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(142);
        }
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug("<" + output);
        }
        if ("(gdb)".equals(output)) {
            CidrDebuggerLog.LOG.assertTrue(!this.isInPromptMode(), (Object)"Prompt mode should have been reset on ^result record");
            this.myCommandSemaphore.up();
            return;
        }
        if (output.startsWith("0^")) {
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            this.doProcessStreamRecord((GDBResponse.StreamRecord)response);
        } else if (response instanceof GDBResponse.ResultRecord) {
            this.doProcessResultRecord((GDBResponse.ResultRecord)response);
        } else if (response instanceof GDBResponse.AsyncRecord) {
            this.doProcessAsyncRecord((GDBResponse.AsyncRecord)response);
        } else {
            throw GDBDriver.unexpectedResponse(output);
        }
    }

    private void doProcessStreamRecord(GDBResponse.StreamRecord record) {
        String text = record.getText();
        switch (record.getCategory()) {
            case target: {
                this.handleTargetOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case console: {
                if (this.myIsConsoleCommand && this.enterPromptMode(text)) break;
                if (this.myGdbVersion == null) {
                    this.myGdbVersion = VersionUtil.parseVersion((String)text, (Pattern[])new Pattern[]{VERSION_PATTERN});
                }
                this.myCommunication.consoleOutput.append(text);
            }
            case log: {
                this.handleGDBOutput(text);
            }
        }
    }

    private void doProcessResultRecord(GDBResponse.ResultRecord record) throws ExecutionException {
        this.setPromptMode(0);
        switch ((GDBResponse.ResultRecord.Type)record.getType()) {
            case continuing: 
            case stepping: {
                return;
            }
            case running: {
                this.myStopPlace = null;
                this.handleRunning();
                if (!this.myCommunication.suppressRunningResult) break;
                return;
            }
            case error: {
                DebuggerDriver.StopPlace stopPlace;
                GDBTuple tuple = record.getResultList();
                String reason = tuple.getString("reason");
                if (!"breakpoint-hit".equals(reason)) break;
                this.myStopPlace = stopPlace = this.doReadStopPlace(tuple);
                this.processBreakpointHit(stopPlace, tuple);
                break;
            }
        }
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
    }

    private void doProcessAsyncRecord(GDBResponse.AsyncRecord record) throws ExecutionException {
        String type = ((GDBResponse.AsyncRecord.Type)record.getType()).getValue();
        GDBTuple resultTuple = record.getResultList();
        switch ((GDBResponse.AsyncRecord.Category)record.getCategory()) {
            case notify: {
                switch (type) {
                    case "library-loaded": {
                        String moduleName = resultTuple.getString("id");
                        if (moduleName != null) {
                            this.handleModulesLoaded(Collections.singletonList(moduleName));
                        }
                        return;
                    }
                    case "thread-group-exited": {
                        if (this.getState() == DebuggerDriver.TargetState.NOT_READY && SystemInfo.isUnix) {
                            UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcessHandler.getProcess());
                            return;
                        }
                        int code = resultTuple.getInt("exit-code", 1);
                        this.handleTargetFinished(code, null);
                        return;
                    }
                    case "thread-group-started": {
                        this.myTargetPID = resultTuple.getRequiredInt("pid");
                        return;
                    }
                }
                return;
            }
            case exec: {
                DebuggerDriver.StopPlace stopPlace;
                if (!type.equals("stopped")) {
                    return;
                }
                if (resultTuple.getAll("reason", String.class).stream().anyMatch(o -> o.startsWith("exited"))) {
                    DebuggerDriver.TargetState state = this.getState();
                    CidrDebuggerLog.LOG.assertTrue(state == DebuggerDriver.TargetState.FINISHED, (Object)("Finished state should have been reported already: " + (Object)((Object)state)));
                    return;
                }
                if (this.myPendingForAttachNotification.tryUp()) {
                    return;
                }
                this.myStopPlace = stopPlace = this.doReadStopPlace(resultTuple);
                switch (resultTuple.getString("reason", "")) {
                    case "signal-received": {
                        ++this.myCommunication.receivedSignalCount;
                        if (this.myInterrupted.tryUp()) {
                            return;
                        }
                        String name2 = resultTuple.getString("signal-name");
                        String meaning = resultTuple.getString("signal-meaning");
                        if (GDBDriver.isTargetTerminationSignal(name2)) {
                            this.handleTargetTerminated();
                            return;
                        }
                        if (name2 == null || meaning == null) break;
                        this.handleSignal(stopPlace, name2, meaning);
                        return;
                    }
                    case "breakpoint-hit": {
                        this.processBreakpointHit(stopPlace, resultTuple);
                        return;
                    }
                    case "location-reached": {
                        break;
                    }
                    case "function-finished": 
                    case "end-stepping-range": {
                        Boolean shouldStop = (Boolean)this.myCommunication.onSteppingFinished.convert((Object)stopPlace);
                        if (shouldStop.booleanValue()) break;
                        return;
                    }
                    case "watchpoint-trigger": 
                    case "read-watchpoint-trigger": 
                    case "access-watchpoint-trigger": {
                        String tupleKey;
                        String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                        GDBTuple wpt = null;
                        String[] stringArray = tupleKeys;
                        int n = stringArray.length;
                        for (int i = 0; i < n && (wpt = resultTuple.getTuple(tupleKey = stringArray[i])) == null; ++i) {
                        }
                        if (wpt == null) break;
                        int number = wpt.getRequiredInt("number");
                        this.handleWatchpoint(stopPlace, number);
                        return;
                    }
                    case "watchpoint-scope": {
                        int wpnum = resultTuple.getRequiredInt("wpnum");
                        this.handleWatchpointScope(wpnum);
                        return;
                    }
                }
                this.handleInterrupted(stopPlace);
                return;
            }
        }
    }

    private void processBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple) throws ExecutionException {
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(143);
        }
        if (resultTuple == null) {
            GDBDriver.$$$reportNull$$$0(144);
        }
        int num = resultTuple.getRequiredInt("bkptno");
        this.handleBreakpoint(stopPlace, num);
    }

    private void cleanupOnTermination() {
        OutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        this.myResultQueue.offer(new ErrorResponse((NotNullProducer<ExecutionException>)((NotNullProducer)ExecutionFinishedException::new)));
        this.myCommandSemaphore.up();
        this.myInterrupted.up();
        this.myPendingForAttachNotification.up();
    }

    protected <T> T executeCommandNoUserException(Command<T> c) throws ExecutionException {
        long timeout = c.getTimeout();
        try {
            ExecutionResult<T> executionResult = this.doExecuteCommand(c, false);
            return timeout < 0L ? executionResult.get() : executionResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            CidrDebuggerLog.LOG.warn("Command timed out (" + timeout + "): " + this.myLastCommand);
            if (c instanceof EvaluationCommand) {
                throw new DebuggerEvaluationTimedOutException(((EvaluationCommand)c).getExpression());
            }
            throw new DebuggerCommandTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    protected <T> T executeCommand(Command<T> c) throws ExecutionException, DebuggerCommandException {
        try {
            return this.executeCommandNoUserException(c);
        }
        catch (ExecutionException e) {
            DebuggerCommandException cause = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
            if (cause != null) {
                throw new DebuggerCommandException(cause.getMessage(), cause);
            }
            throw e;
        }
    }

    private void executeAsyncCommand(Command<?> c) {
        this.doExecuteCommand(c, true);
    }

    private <T> ExecutionResult<T> doExecuteCommand(Command<T> c, boolean async) {
        return this.myCommandProcessor.submit(() -> {
            try {
                if (c instanceof SuspendedCommand && this.getState() == DebuggerDriver.TargetState.RUNNING) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                }
                this.myIsConsoleCommand = c instanceof ConsoleCommand;
                if (!this.myIsConsoleCommand && this.isInPromptMode()) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                }
                return c.call();
            }
            catch (Throwable e) {
                if (async) {
                    this.myResultQueue.offer(new ErrorResponse(e));
                }
                throw e;
            }
        });
    }

    @NotNull
    public static Pair<String, String> getDescriptionFromValue(@NotNull String value) {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(145);
        }
        String description = null;
        Matcher matcher = VALUE_DESCRIPTION_PATTERN.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(1);
            description = matcher.group(2);
        }
        if (description == null) {
            description = value;
        }
        Pair pair2 = Pair.create((Object)value, (Object)description);
        if (pair2 == null) {
            GDBDriver.$$$reportNull$$$0(146);
        }
        return pair2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private GDBTuple doUpdateAndListFrameVariables(long threadId, int frameIndex, @NotNull String string) throws ExecutionException, DebuggerCommandException {
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(147);
        }
        Consumer<String> frameVarDisposeListener = this.myFrameVarDisposeListener;
        Response updateResponse = this.sendRequestAndWaitForDone("-var-update --all-values *", new Object[0]);
        GDBTuple changeList = updateResponse.getResultList().getRequiredTuple("changelist");
        for (Object each : changeList) {
            if (!(each instanceof GDBTuple)) continue;
            GDBTuple change = (GDBTuple)each;
            String fVar = change.getString("name", "");
            boolean inScope = change.getBoolean("in_scope", false);
            boolean typeChanged = change.getBoolean("type_changed");
            if (!inScope || typeChanged) {
                this.myFrameVarIDCache.removeValue((Object)fVar);
                LLValueLoadedData data = this.myFrameVarDataCache.remove(fVar);
                if (data != null && data.fvKey != null) {
                    this.myFrameVarCache.remove(data.fvKey);
                }
                this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(fVar));
                if (frameVarDisposeListener == null) continue;
                frameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            String changedValue = change.getString("value");
            if (changedValue == null) continue;
            this.updateFrameVarDataCache(fVar, changedValue);
        }
        Response response = this.sendRequestAndWaitForDone("-stack-list-variables %s --no-values", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        HashSet<String> uniqueSet = new HashSet<String>();
        GDBTuple result = new GDBTuple();
        GDBTuple variables = response.getResultList().getRequiredTuple("variables");
        for (Object each : variables) {
            void currentFrameAddr;
            GDBTuple gdbTuple = (GDBTuple)each;
            String name2 = gdbTuple.getString("name", "");
            String fvKey = GDBDriver.makeFVKey((String)currentFrameAddr, name2);
            if (uniqueSet.contains(name2)) {
                this.myFrameVarCache.remove(fvKey);
                String fVar = (String)this.myFrameVarIDCache.remove((Object)fvKey);
                if (fVar == null) continue;
                this.myFrameVarDataCache.remove(fVar);
                this.sendRequestAndWaitForDone("-var-delete %s", GDBDriver.stringify(fVar));
                if (frameVarDisposeListener == null) continue;
                frameVarDisposeListener.consume((Object)fVar);
                continue;
            }
            uniqueSet.add(name2);
            result.add(each);
        }
        GDBTuple gDBTuple = result;
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(148);
        }
        return gDBTuple;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String doGetExpressionType(@NotNull String expr, long threadId, int n) throws ExecutionException, GDBCommandException {
        void frameIndex;
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(149);
        }
        if (StringUtil.isEmptyOrSpaces((String)expr)) {
            return null;
        }
        String command = GDBDriver.createConsoleCommand(String.format("whatis/mt %s", expr), threadId, (int)frameIndex);
        String output = this.sendSilentRequestAndWaitForDone("%s", command).getOutput();
        Matcher m = WHATIS_TYPE_OUTPUT.matcher(output);
        if (m.matches()) {
            String substring = m.group(1) != null ? m.group(1) : m.group(2);
            return StringUtil.convertLineSeparators((String)substring, (String)" ").trim();
        }
        return null;
    }

    private void updateFrameVarDataCache(@NotNull String id, @NotNull String newValue) {
        LLValueLoadedData data;
        if (id == null) {
            GDBDriver.$$$reportNull$$$0(150);
        }
        if (newValue == null) {
            GDBDriver.$$$reportNull$$$0(151);
        }
        if ((data = this.myFrameVarDataCache.get(id)) != null) {
            data = new LLValueLoadedData(data.id, data.fvKey, data.childrenCount, data.isDynamic, data.hasDynamicChildren, data.isMap, newValue);
            this.myFrameVarDataCache.put(id, data);
        }
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name2) {
        if (frameAddr == null) {
            GDBDriver.$$$reportNull$$$0(152);
        }
        if (name2 == null) {
            GDBDriver.$$$reportNull$$$0(153);
        }
        String string = frameAddr + "-" + name2;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(154);
        }
        return string;
    }

    @NotNull
    private String toEnvPath(@NotNull String path) {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(155);
        }
        String string = this.myStarter.convertToEnvPath(path);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(156);
        }
        return string;
    }

    private boolean isWindows() {
        return this.myStarter.getEnvOSType() == OSType.WIN;
    }

    private boolean isMac() {
        return this.myStarter.getEnvOSType() == OSType.MAC;
    }

    private boolean isLinux() {
        return this.myStarter.getEnvOSType() == OSType.LINUX;
    }

    private boolean isRemoteEnv() {
        return this.myStarter.isRemoteEnv();
    }

    static {
        VALUE_DESCRIPTION_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)(?: <.+?>)?(?: (\\w?\".*\"(?:\\.\\.\\.)?))?$");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 97: 
            case 100: 
            case 103: 
            case 105: 
            case 107: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 130: 
            case 133: 
            case 146: 
            case 148: 
            case 154: 
            case 156: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 97: 
            case 100: 
            case 103: 
            case 105: 
            case 107: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 130: 
            case 133: 
            case 146: 
            case 148: 
            case 154: 
            case 156: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 1: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 97: 
            case 100: 
            case 103: 
            case 105: 
            case 107: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 130: 
            case 133: 
            case 146: 
            case 148: 
            case 154: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver";
                break;
            }
            case 6: 
            case 139: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iIdString";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tuple";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingCommand";
                break;
            }
            case 20: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installer";
                break;
            }
            case 22: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 25: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 30: 
            case 33: 
            case 116: 
            case 119: 
            case 122: 
            case 125: 
            case 128: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 40: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 44: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symBreakpoint";
                break;
            }
            case 46: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 49: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopTuple";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameTuple";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 62: 
            case 64: 
            case 65: 
            case 92: 
            case 96: 
            case 145: 
            case 159: 
            case 160: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 68: 
            case 73: 
            case 75: 
            case 78: 
            case 98: 
            case 101: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 81: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 83: 
            case 86: 
            case 89: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varTuple";
                break;
            }
            case 84: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRef";
                break;
            }
            case 95: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 104: 
            case 106: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 109: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 117: 
            case 120: 
            case 123: 
            case 126: 
            case 129: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDisplayString";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 141: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTuple";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFrameAddr";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAddr";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "shellQuote";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "gdbShow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInferiorCommand";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForLaunch";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForAttach";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForRemote";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellWrapper";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellCommandLineString";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferiorArgs";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addWatchpoint";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetWatchpointExpression";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "addSymbolicBreakpoint";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "readBreakpoint";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadStopPlace";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetThreads";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrames";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadFrame";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrameAddr";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrameVariables";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableID";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetVariableChildren";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetPlainVariableChildren";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "doListChildren";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetMapChildren";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateVar";
                break;
            }
            case 85: 
            case 88: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadVariable";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadVariable";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadLoadedData";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdateLoadedData";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "disassemble";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "doDataDisassemble";
                break;
            }
            case 110: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleCommand";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "createMI2Command";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRequest";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequest";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestAndWaitForDone";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestAndWaitForRunning";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "sendSilentRequest";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "sendSilentRequestAndWaitForDone";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFromValue";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdateAndListFrameVariables";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFVKey";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMIOutputFilterInTests";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 97: 
            case 100: 
            case 103: 
            case 105: 
            case 107: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 130: 
            case 133: 
            case 146: 
            case 148: 
            case 154: 
            case 156: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shellQuote";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "warnUser";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "gdbSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "gdbShow";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doSelectInferior";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadInferiorCommand";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadForLaunch";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttach";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemote";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIndirectSymbols";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doLoadExecutable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "launch";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getShellWrapper";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getShellCommandLineString";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getInferiorArgs";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "connectTo";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "asyncStepOutUntilFrameWithDebugInfo";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeCodepoints";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "readBreakpoint";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "doReadStopPlace";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "doReadFrame";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isIndirectSymbolFrame";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getVariableID";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "doGetVariableChildren";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "doGetPlainVariableChildren";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "doListChildren";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "doVisitCppClassChildren";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "doCreateVar";
                break;
            }
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "doReadVariable";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "doLoadVariable";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "doReadLoadedData";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateLoadedData";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "doDataDisassemble";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "executeShellCommand";
                break;
            }
            case 109: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleCommand";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "createMI2Command";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "atSourceLine";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "buildRequest";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "sendRequest";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestAndWaitForDone";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestAndWaitForRunning";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "sendSilentRequest";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "sendSilentRequestAndWaitForDone";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestOrSpecialCommunication";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "handleGDBOutput";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "messageContains";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "waitForSemaphore";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "doProcessResponse";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "processBreakpointHit";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionFromValue";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateAndListFrameVariables";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "doGetExpressionType";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameVarDataCache";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "makeFVKey";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disassemble$36";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildrenCount$35";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVariableID$32";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDescription$31";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getData$30";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doReadStopPlace$26";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeCodepoints$24";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSymbolicBreakpoint$23";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "lambda$launch$6";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadForRemote$5";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadForLaunch$3";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setMIOutputFilterInTests$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 97: 
            case 100: 
            case 103: 
            case 105: 
            case 107: 
            case 110: 
            case 112: 
            case 114: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 130: 
            case 133: 
            case 146: 
            case 148: 
            case 154: 
            case 156: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GDBCommandException
    extends DebuggerCommandException {
        @NotNull
        private final Response myResponse;

        public GDBCommandException(@NotNull Response response, @NotNull String message) {
            if (response == null) {
                GDBCommandException.$$$reportNull$$$0(0);
            }
            if (message == null) {
                GDBCommandException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myResponse = response;
        }

        @NotNull
        public Response getResponse() {
            Response response = this.myResponse;
            if (response == null) {
                GDBCommandException.$$$reportNull$$$0(2);
            }
            return response;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBCommandException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBCommandException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class FrameValueLoader
    implements LLValueLoader {
        @NotNull
        private final String myFvKey;
        private final long myThreadId;
        private final int myFrameIndex;
        @Nullable
        private final String myAvailableValue;

        /*
         * WARNING - void declaration
         */
        public FrameValueLoader(String fvKey, long threadId, @Nullable int frameIndex, String string) {
            void availableValue;
            if (fvKey == null) {
                FrameValueLoader.$$$reportNull$$$0(0);
            }
            this.myFvKey = fvKey;
            this.myThreadId = threadId;
            this.myFrameIndex = frameIndex;
            this.myAvailableValue = availableValue;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            LLValueLoadedData data;
            if (value == null) {
                FrameValueLoader.$$$reportNull$$$0(1);
            }
            String name2 = value.getName();
            String id = (String)GDBDriver.this.myFrameVarIDCache.get((Object)this.myFvKey);
            if (id == null) {
                GDBResponse.Record varObj = GDBDriver.this.doCreateVar(name2, this.myThreadId, this.myFrameIndex);
                id = varObj.getResultList().getRequiredString("name");
                String v = varObj.getResultList().getString("value", "");
                data = GDBDriver.doReadLoadedData(varObj.getResultList(), id, this.myFvKey, v);
                GDBDriver.this.myFrameVarIDCache.put((Object)this.myFvKey, (Object)id);
                GDBDriver.this.myFrameVarDataCache.put(id, data);
            } else {
                if (this.myAvailableValue != null) {
                    GDBDriver.this.updateFrameVarDataCache(id, this.myAvailableValue);
                }
                data = (LLValueLoadedData)GDBDriver.this.myFrameVarDataCache.get(id);
            }
            GDBDriver.doUpdateLoadedData(value, data);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fvKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$FrameValueLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CreatedValueLoader
    implements LLValueLoader {
        @NotNull
        private final LLValueLoadedData partialLoadedData;

        public CreatedValueLoader(LLValueLoadedData partialLoadedData) {
            if (partialLoadedData == null) {
                CreatedValueLoader.$$$reportNull$$$0(0);
            }
            this.partialLoadedData = partialLoadedData;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            if (value == null) {
                CreatedValueLoader.$$$reportNull$$$0(1);
            }
            String id = this.partialLoadedData.id;
            Response varObj = GDBDriver.this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            String val = varObj.getResultList().getRequiredString("value");
            GDBDriver.doUpdateLoadedData(value, new LLValueLoadedData(id, this.partialLoadedData.fvKey, this.partialLoadedData.childrenCount, this.partialLoadedData.isDynamic, this.partialLoadedData.hasDynamicChildren, this.partialLoadedData.isMap, val));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "partialLoadedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$CreatedValueLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface LLValueLoader {
        public void loadValue(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;
    }

    private static class LLValueLoadedData {
        @NotNull
        public final String id;
        @Nullable
        public final String fvKey;
        @Nullable
        public final Integer childrenCount;
        public final boolean isDynamic;
        public final boolean hasDynamicChildren;
        public final boolean isMap;
        @NotNull
        public final LLValueData data;

        public LLValueLoadedData(@NotNull String id, @Nullable String fvKey, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, boolean isMap, @NotNull String value) {
            if (id == null) {
                LLValueLoadedData.$$$reportNull$$$0(0);
            }
            if (value == null) {
                LLValueLoadedData.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.fvKey = fvKey;
            this.childrenCount = childrenCount;
            this.isDynamic = isDynamic;
            this.hasDynamicChildren = hasDynamicChildren;
            this.isMap = isMap;
            Pair<String, String> valueAndDescription = GDBDriver.getDescriptionFromValue(value);
            value = (String)valueAndDescription.first;
            String description = (String)valueAndDescription.second;
            boolean hasLongerDescription = description != null && description.length() >= 1000;
            boolean mayHaveChildren = childrenCount != null && childrenCount > 0 || hasDynamicChildren || isDynamic;
            this.data = new LLValueData(value, description, hasLongerDescription, mayHaveChildren, isDynamic);
        }

        public boolean mayHaveChildren() {
            return this.data.mayHaveChildren();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$LLValueLoadedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        public MapElement(@NotNull LLValue key, @NotNull LLValue value) {
            if (key == null) {
                MapElement.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MapElement.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        public LLValue getKey() {
            LLValue lLValue = this.myKey;
            if (lLValue == null) {
                MapElement.$$$reportNull$$$0(2);
            }
            return lLValue;
        }

        @NotNull
        public LLValue getValue() {
            LLValue lLValue = this.myValue;
            if (lLValue == null) {
                MapElement.$$$reportNull$$$0(3);
            }
            return lLValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ErrorResponse
    implements Response {
        @NotNull
        private final NotNullProducer<ExecutionException> myErrorSupplier;

        public ErrorResponse(@Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(throwable)));
        }

        public ErrorResponse(@Nullable String message, @Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(message, throwable)));
        }

        public ErrorResponse(@NotNull NotNullProducer<ExecutionException> errorSupplier) {
            if (errorSupplier == null) {
                ErrorResponse.$$$reportNull$$$0(0);
            }
            this.myErrorSupplier = errorSupplier;
        }

        @NotNull
        public ExecutionException getError() {
            ExecutionException executionException = (ExecutionException)((Object)this.myErrorSupplier.produce());
            if (executionException == null) {
                ErrorResponse.$$$reportNull$$$0(1);
            }
            return executionException;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException {
            throw this.getError();
        }

        @Override
        @NotNull
        public String getOutput() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public void checkError() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public int getReceivedSignalCount() throws ExecutionException {
            throw this.getError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ErrorResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ErrorResponse";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResultResponse
    implements Response {
        @NotNull
        private final GDBResponse.Record myRecord;
        @NotNull
        private final String myOutput;
        private final int myReceivedSignalCount;

        public ResultResponse(@NotNull GDBResponse.Record record, @NotNull String output, int receivedSignalCount) {
            if (record == null) {
                ResultResponse.$$$reportNull$$$0(0);
            }
            if (output == null) {
                ResultResponse.$$$reportNull$$$0(1);
            }
            this.myRecord = record;
            this.myOutput = output;
            this.myReceivedSignalCount = receivedSignalCount;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() {
            GDBResponse.Record record = this.myRecord;
            if (record == null) {
                ResultResponse.$$$reportNull$$$0(2);
            }
            return record;
        }

        @Override
        @NotNull
        public String getOutput() {
            String string = this.myOutput;
            if (string == null) {
                ResultResponse.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public int getReceivedSignalCount() {
            return this.myReceivedSignalCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ResultResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ResultResponse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecord";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface Response {
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException;

        @NotNull
        default public GDBTuple getResultList() throws ExecutionException {
            GDBTuple gDBTuple = this.getRecord().getResultList();
            if (gDBTuple == null) {
                Response.$$$reportNull$$$0(0);
            }
            return gDBTuple;
        }

        @NotNull
        public String getOutput() throws ExecutionException;

        default public void checkError() throws ExecutionException {
        }

        @NotNull
        default public GDBCommandException createGDBError() throws ExecutionException {
            String errorMessage = this.getGDBErrorMessage();
            if (errorMessage == null) {
                errorMessage = "Unknown GDB error";
            }
            GDBCommandException gDBCommandException = new GDBCommandException(this, errorMessage);
            if (gDBCommandException == null) {
                Response.$$$reportNull$$$0(1);
            }
            return gDBCommandException;
        }

        @Nullable
        default public String getGDBErrorMessage() throws ExecutionException {
            return this.getRecord().getResultList().getString("msg");
        }

        public int getReceivedSignalCount() throws ExecutionException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Response";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGDBError";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected class Request {
        @NotNull
        private final String myCommand;
        private boolean mySuppressOutputEvent;
        private boolean mySuppressRunningEvent;
        private boolean mySuppressTargetFinishedEvent;
        private boolean mySuppressRunningResult;
        @Nullable
        private ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException> myOnSteppingFinished;
        private boolean myTearDownRequest;

        public Request(String command) {
            if (command == null) {
                Request.$$$reportNull$$$0(0);
            }
            this.myCommand = command;
        }

        @NotNull
        public Communication send() throws ExecutionException {
            Communication communication = new Communication(GDBDriver.this, this.myCommand, this.mySuppressOutputEvent, this.mySuppressRunningEvent, this.mySuppressTargetFinishedEvent, this.mySuppressRunningResult, this.myTearDownRequest, this.myOnSteppingFinished);
            GDBDriver.this.myCommunication = communication;
            communication.initiate();
            Communication communication2 = communication;
            if (communication2 == null) {
                Request.$$$reportNull$$$0(1);
            }
            return communication2;
        }

        @NotNull
        public String getCommand() {
            String string = this.myCommand;
            if (string == null) {
                Request.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Request suppressAll() {
            return this.suppressOutputEvent().suppressRunningEvent().suppressRunningResult();
        }

        public Request suppressOutputEvent() {
            return this.suppressOutputEvent(true);
        }

        public Request suppressOutputEvent(boolean suppressOutputEvent) {
            this.mySuppressOutputEvent = suppressOutputEvent;
            return this;
        }

        public Request suppressRunningEvent() {
            return this.suppressRunningEvent(true);
        }

        public Request suppressRunningEvent(boolean suppressRunningEvent) {
            this.mySuppressRunningEvent = suppressRunningEvent;
            return this;
        }

        public Request suppressTargetFinishedEvent() {
            return this.suppressTargetFinishedEvent(true);
        }

        public Request suppressTargetFinishedEvent(boolean suppressTargetFinishedEvent) {
            this.mySuppressTargetFinishedEvent = suppressTargetFinishedEvent;
            return this;
        }

        public Request suppressRunningResult() {
            return this.suppressRunningResult(true);
        }

        public Request suppressRunningResult(boolean suppressRunningResult) {
            this.mySuppressRunningResult = suppressRunningResult;
            return this;
        }

        public Request tearDownRequest() {
            return this.tearDownRequest(true);
        }

        private Request tearDownRequest(boolean tearDownRequest) {
            this.myTearDownRequest = tearDownRequest;
            return this;
        }

        public Request onSteppingFinished(@Nullable ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException> onSteppingFinished) {
            this.myOnSteppingFinished = onSteppingFinished;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "send";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ConsoleCommand<T>
    extends EvaluationCommand<T> {
        public ConsoleCommand(@NotNull String expression) {
            if (expression == null) {
                ConsoleCommand.$$$reportNull$$$0(0);
            }
            super(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ConsoleCommand", "<init>"));
        }
    }

    protected static abstract class EvaluationCommand<T>
    implements SuspendedCommand<T> {
        @NotNull
        private final String myExpression;

        public EvaluationCommand(@NotNull String expression) {
            if (expression == null) {
                EvaluationCommand.$$$reportNull$$$0(0);
            }
            this.myExpression = expression;
        }

        @NotNull
        public String getExpression() {
            String string = this.myExpression;
            if (string == null) {
                EvaluationCommand.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public long getTimeout() {
            return GDBDriver.getEvaluationTimeoutMs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$EvaluationCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$EvaluationCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface SuspendedCommand<T>
    extends Command<T> {
    }

    protected static interface DestroyCommand
    extends VoidCommand {
        @Override
        default public long getTimeout() {
            return 1500L;
        }
    }

    protected abstract class AttachConnectCommand
    implements LaunchCommand {
        protected AttachConnectCommand() {
        }

        @Override
        @NotNull
        public Integer call() throws ExecutionException, DebuggerCommandException {
            int pid;
            GDBDriver.this.myPendingForAttachNotification.down();
            try {
                pid = this.attach();
                GDBDriver.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
            }
            finally {
                GDBDriver.this.myPendingForAttachNotification.up();
            }
            GDBDriver.this.doSelectWinbreakBinary();
            this.whenAttached();
            GDBDriver.this.sendRequestAndWaitForRunning("-exec-continue", new Object[0]);
            Integer n = pid;
            if (n == null) {
                AttachConnectCommand.$$$reportNull$$$0(0);
            }
            return n;
        }

        protected abstract int attach() throws ExecutionException, DebuggerCommandException;

        protected abstract void whenAttached() throws ExecutionException, DebuggerCommandException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$AttachConnectCommand", "call"));
        }
    }

    protected static interface LaunchCommand
    extends StartCommand<Integer> {
    }

    protected static interface LoadingCommand
    extends StartCommand<Void>,
    VoidCommand {
    }

    protected static interface StartCommand<T>
    extends Command<T> {
        @Override
        default public long getTimeout() {
            return GDBDriver.getLoadTimeoutMs();
        }
    }

    protected static interface VoidCommand
    extends Command<Void> {
        @Override
        @Nullable
        default public Void call() throws ExecutionException, DebuggerCommandException {
            this.run();
            return null;
        }

        public void run() throws ExecutionException, DebuggerCommandException;
    }

    protected static interface Command<T> {
        @Nullable
        public T call() throws ExecutionException, DebuggerCommandException;

        default public long getTimeout() {
            return GDBDriver.getTimeoutMs();
        }
    }

    protected class Communication {
        @NotNull
        public final String command;
        public final boolean suppressOutputEvent;
        public final boolean suppressRunningEvent;
        public final boolean suppressTargetFinishedEvent;
        public final boolean suppressRunningResult;
        public final boolean tearDownRequest;
        @NotNull
        public final ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException> onSteppingFinished;
        @NotNull
        public final StringBuffer consoleOutput;
        public int receivedSignalCount;
        final /* synthetic */ GDBDriver this$0;

        public Communication(@NotNull GDBDriver this$0, String command) {
            if (command == null) {
                Communication.$$$reportNull$$$0(0);
            }
            this(this$0, command, false, false, false, false, false, null);
        }

        public Communication(@NotNull GDBDriver this$0, String command, boolean suppressOutputEvent, boolean suppressRunningEvent, boolean suppressTargetFinishedEvent, boolean suppressRunningResult, @Nullable boolean tearDownRequest, ThrowableConvertor<DebuggerDriver.StopPlace, Boolean, ExecutionException> onSteppingFinished) {
            if (command == null) {
                Communication.$$$reportNull$$$0(1);
            }
            this.this$0 = this$0;
            this.consoleOutput = new StringBuffer();
            this.command = command;
            CidrDebuggerLog.LOG.assertTrue(!StringUtil.containsLineBreak((CharSequence)command) || this.isMultilineCommand(), (Object)("MI command must not contain unescaped newlines: " + command));
            this.suppressOutputEvent = suppressOutputEvent;
            this.suppressRunningEvent = suppressRunningEvent;
            this.suppressTargetFinishedEvent = suppressTargetFinishedEvent;
            this.suppressRunningResult = suppressRunningResult;
            this.tearDownRequest = tearDownRequest;
            this.onSteppingFinished = (ThrowableConvertor)ObjectUtils.notNull(onSteppingFinished, stopPlace -> true);
        }

        protected boolean isMultilineCommand() {
            return this.this$0.isInPromptMode() ? this.command.equals("end") : this.command.endsWith("\nend");
        }

        protected boolean useExtraLineFeedWorkaround() {
            if (this.this$0.isLinux() && this.command.startsWith("-target-attach")) {
                return true;
            }
            return this.this$0.isWindows() && this.isMultilineCommand();
        }

        protected void consumeResponseToExtraLineFeed() {
            try {
                this.this$0.myResultQueue.poll(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                CidrDebuggerLog.LOG.debug((Throwable)e);
            }
        }

        public void initiate() throws ExecutionException {
            this.this$0.sendRequestOrSpecialCommunication(this.command, this.tearDownRequest, (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                try {
                    this.this$0.mySink.write(this.command + "\n");
                    this.this$0.mySink.flush();
                }
                catch (IOException e) {
                    if (this.this$0.isTerminated()) {
                        throw new ExecutionFinishedException((Throwable)e);
                    }
                    throw new ExecutionException("Cannot send request", (Throwable)e);
                }
            }));
        }

        public Response createResponse(@NotNull GDBResponse.Record record) {
            if (record == null) {
                Communication.$$$reportNull$$$0(2);
            }
            return new ResultResponse(record, this.consoleOutput.toString(), this.receivedSignalCount);
        }

        public Response waitFor(GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
            if (expectedTypes == null) {
                Communication.$$$reportNull$$$0(3);
            }
            boolean extraLineFeed = this.useExtraLineFeedWorkaround();
            try {
                if (extraLineFeed) {
                    this.this$0.mySink.write("\n");
                    this.this$0.mySink.flush();
                }
                Response response = this.waitForResponse(expectedTypes);
                return response;
            }
            catch (IOException e) {
                if (this.this$0.isTerminated()) {
                    throw new ExecutionFinishedException((Throwable)e);
                }
                throw new ExecutionException("Cannot send request", (Throwable)e);
            }
            finally {
                if (extraLineFeed) {
                    this.consumeResponseToExtraLineFeed();
                }
            }
        }

        @NotNull
        private Response waitForResponse(GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
            if (expectedTypes == null) {
                Communication.$$$reportNull$$$0(4);
            }
            Response response = this.doWaitForResponse();
            GDBResponse.Record result = response.getRecord();
            Object resultType = result.getType();
            if (expectedTypes.length == 0 || ArrayUtil.contains(resultType, (Object[])expectedTypes)) {
                Response response2 = response;
                if (response2 == null) {
                    Communication.$$$reportNull$$$0(5);
                }
                return response2;
            }
            if (!"-exec-interrupt".equals(this.command) || !GDBDriver.INFERIOR_NOT_EXECUTING.equals(response.getGDBErrorMessage())) {
                CidrDebuggerLog.LOG.warn(">" + this.command);
                CidrDebuggerLog.LOG.warn("<" + result);
            }
            if (resultType == GDBResponse.ResultRecord.Type.error) {
                throw response.createGDBError();
            }
            throw GDBDriver.unexpectedResponse(result);
        }

        @NotNull
        private Response doWaitForResponse() throws ExecutionException {
            Response response;
            try {
                String errorMessage;
                Response response2 = (Response)this.this$0.myResultQueue.take();
                if (this.this$0.getState() != DebuggerDriver.TargetState.NOT_READY && "ptrace: No such process.".equals(errorMessage = response2.getGDBErrorMessage())) {
                    this.this$0.handleTargetTerminated();
                    throw new ExecutionFinishedException();
                }
                response = response2;
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Execution interrupted", (Throwable)e);
            }
            if (response == null) {
                Communication.$$$reportNull$$$0(6);
            }
            return response;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedTypes";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Communication";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Communication";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "waitForResponse";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doWaitForResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createResponse";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "waitFor";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForResponse";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StructChildrenVisitor {
        private StructChildrenVisitor() {
        }

        boolean visitRealChild(@NotNull GDBTuple child) throws ExecutionException {
            if (child == null) {
                StructChildrenVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
            if (fakeChild == null) {
                StructChildrenVisitor.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeChild";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$StructChildrenVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRealChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFakeChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface MIResponseFilter
    extends BiFunction<String, String, String> {
        @Override
        public String apply(@NotNull String var1, @NotNull String var2);
    }
}

