/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBTuple
extends ArrayList<Object> {
    private static final List<String> TRUE_STRINGS = Arrays.asList("true", "yes", "on");
    private static final List<String> FALSE_STRINGS = Arrays.asList("false", "no", "off");

    public static GDBTuple of(Object ... elements) {
        GDBTuple tuple = new GDBTuple();
        tuple.addAll(Arrays.asList(elements));
        return tuple;
    }

    @Contract(value="_, _, !null -> !null")
    protected <T> T get(String key, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        if (clazz == null) {
            GDBTuple.$$$reportNull$$$0(0);
        }
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (!clazz.isInstance(o)) continue;
            return clazz.cast(o);
        }
        return defaultValue;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Contract(value="_, !null -> !null")
    public String getString(String key, @Nullable String defaultValue) {
        return this.get(key, String.class, defaultValue);
    }

    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(1);
        }
        String string = this.getRequiredStringOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        if (string == null) {
            GDBTuple.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (exceptionSupplier == null) {
            GDBTuple.$$$reportNull$$$0(3);
        }
        String string = GDBTuple.checkNotNullOrThrow(this.getString(key), exceptionSupplier);
        if (string == null) {
            GDBTuple.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getRequiredString(String key) throws ExecutionException {
        String string = this.getRequiredStringOrThrow(key, ExecutionException::new);
        if (string == null) {
            GDBTuple.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public GDBTuple getTuple(String key) {
        return this.get(key, GDBTuple.class, null);
    }

    @NotNull
    public GDBTuple getTupleOrEmpty(String key) {
        GDBTuple value = this.getTuple(key);
        if (value == null) {
            value = new GDBTuple();
        }
        GDBTuple gDBTuple = value;
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(6);
        }
        return gDBTuple;
    }

    @NotNull
    public GDBTuple getRequiredTuple(String key) throws ExecutionException {
        GDBTuple gDBTuple = this.getRequiredTupleOrThrow(key, ExecutionException::new);
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(7);
        }
        return gDBTuple;
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(8);
        }
        GDBTuple gDBTuple = this.getRequiredTupleOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(9);
        }
        return gDBTuple;
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (exceptionSupplier == null) {
            GDBTuple.$$$reportNull$$$0(10);
        }
        GDBTuple gDBTuple = GDBTuple.checkNotNullOrThrow(this.getTuple(key), exceptionSupplier);
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(11);
        }
        return gDBTuple;
    }

    @Nullable
    public Address getAddress(String key) {
        return this.getAddress(key, null);
    }

    @Contract(value="_, !null -> !null")
    public Address getAddress(String key, @Nullable Address defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return GDBTuple.parseAddress(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Address getRequiredAddress(String key) throws ExecutionException {
        Address address = this.getRequiredAddressOrThrow(key, ExecutionException::new);
        if (address == null) {
            GDBTuple.$$$reportNull$$$0(12);
        }
        return address;
    }

    @NotNull
    public <X extends Throwable> Address getRequiredAddressOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(13);
        }
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        Address address = GDBTuple.checkNotNullOrThrow(GDBTuple.parseAddress(s, null), GDBTuple.withMessage(exceptionConstructor, () -> "Malformed number value '" + s + "' for key '" + key + "' in tuple: " + this));
        if (address == null) {
            GDBTuple.$$$reportNull$$$0(14);
        }
        return address;
    }

    @Contract(value="_, !null -> !null")
    private static Address parseAddress(@NotNull String s, @Nullable Address defaultValue) {
        if (s == null) {
            GDBTuple.$$$reportNull$$$0(15);
        }
        try {
            return Address.parseHexString(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Contract(value="_, !null -> !null")
    public Integer getInteger(String key, @Nullable Integer defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return GDBTuple.parseInteger(s, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInteger(key, defaultValue);
    }

    public int getRequiredInt(String key) throws ExecutionException {
        return this.getRequiredIntOrThrow(key, ExecutionException::new);
    }

    public <X extends Throwable> int getRequiredIntOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(16);
        }
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseInteger(s, null), GDBTuple.withMessage(exceptionConstructor, () -> "Malformed number value '" + s + "' for key '" + key + "' in tuple: " + this));
    }

    @Contract(value="_, !null -> !null")
    private static Integer parseInteger(@NotNull String s, @Nullable Integer defaultValue) {
        if (s == null) {
            GDBTuple.$$$reportNull$$$0(17);
        }
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            String lowerCase = s.toLowerCase();
            if (TRUE_STRINGS.contains(lowerCase)) {
                return true;
            }
            if (FALSE_STRINGS.contains(lowerCase)) {
                return false;
            }
            Integer integer = GDBTuple.parseInteger(s, null);
            if (integer != null) {
                return integer != 0;
            }
        }
        return defaultValue;
    }

    @Nullable
    public Location getLocation(String key) {
        return this.getLocation(key, (Location)null);
    }

    @Contract(value="_, !null -> !null")
    public Location getLocation(String key, @Nullable Location defaultValue) {
        String s = this.getString(key);
        if (s != null) {
            return Location.tryParse(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Location getRequiredLocation(String key) throws ExecutionException {
        Location location = this.getRequiredLocationOrThrow(key, ExecutionException::new);
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(18);
        }
        return location;
    }

    @NotNull
    public <X extends Throwable> Location getRequiredLocationOrThrow(String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(19);
        }
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        Location location = GDBTuple.checkNotNullOrThrow(Location.tryParse(s), GDBTuple.withMessage(exceptionConstructor, () -> "Malformed location string '" + s + "' for key '" + key + "' in tuple: " + this));
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(20);
        }
        return location;
    }

    @Nullable
    public Location getLocation(String pathKey, String lineKey) {
        return this.getLocation(pathKey, lineKey, null);
    }

    @Contract(value="_, _, !null -> !null")
    public Location getLocation(String pathKey, String lineKey, @Nullable Location defaultValue) {
        String path = this.getString(pathKey);
        Integer lineNumber = this.getInteger(lineKey, null);
        if (path != null && lineNumber != null) {
            return Location.fromFileLineNumber(path, lineNumber);
        }
        return defaultValue;
    }

    @NotNull
    public Location getRequiredLocation(String pathKey, String lineKey) throws ExecutionException {
        Location location = this.getRequiredLocationOrThrow(pathKey, lineKey, ExecutionException::new);
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(21);
        }
        return location;
    }

    @NotNull
    public <X extends Throwable> Location getRequiredLocationOrThrow(String pathKey, String lineKey, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(22);
        }
        String path = GDBTuple.checkNotNullOrThrow(this.getString(pathKey), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(pathKey)));
        int lineNumber = this.getRequiredIntOrThrow(lineKey, exceptionConstructor);
        Location location = Location.fromFileLineNumber(path, lineNumber);
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(23);
        }
        return location;
    }

    @NotNull
    public <T> List<T> getAll(String key, Class<T> clazz) {
        SmartList result = new SmartList();
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (o == null) continue;
            result.add(clazz.cast(o));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GDBTuple.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(String key, Class<T> clazz) {
        Pair<Object, List<Object>> pair2 = this.getWithSuccessors(key, clazz, null);
        if (pair2 == null) {
            GDBTuple.$$$reportNull$$$0(25);
        }
        return pair2;
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(String key, Class<T> clazz, @Nullable T defaultValue) {
        SmartList successors = new SmartList();
        Object found = null;
        for (Object each : this) {
            if (found == null) {
                found = GDBTuple.getIfEquals(each, key);
                continue;
            }
            if (each instanceof Pair) break;
            successors.add(clazz.cast(each));
        }
        if (found == null) {
            found = defaultValue;
        }
        Pair pair2 = Pair.create(found, (Object)successors);
        if (pair2 == null) {
            GDBTuple.$$$reportNull$$$0(26);
        }
        return pair2;
    }

    @NotNull
    private Supplier<String> missingKeyError(String key) {
        Supplier<String> supplier = () -> "Missing required key '" + key + "' in tuple: " + this;
        if (supplier == null) {
            GDBTuple.$$$reportNull$$$0(27);
        }
        return supplier;
    }

    @NotNull
    private static <X extends Throwable> Supplier<X> withMessage(@NotNull Function<String, ? extends X> exceptionConstructor, @NotNull Supplier<String> messageSupplier) {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(28);
        }
        if (messageSupplier == null) {
            GDBTuple.$$$reportNull$$$0(29);
        }
        Supplier<Throwable> supplier = () -> {
            if (exceptionConstructor == null) {
                GDBTuple.$$$reportNull$$$0(34);
            }
            if (messageSupplier == null) {
                GDBTuple.$$$reportNull$$$0(35);
            }
            return (Throwable)exceptionConstructor.apply((String)messageSupplier.get());
        };
        if (supplier == null) {
            GDBTuple.$$$reportNull$$$0(30);
        }
        return supplier;
    }

    @NotNull
    private static <T, X extends Throwable> T checkNotNullOrThrow(@Nullable T value, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (exceptionSupplier == null) {
            GDBTuple.$$$reportNull$$$0(31);
        }
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        T t = value;
        if (t == null) {
            GDBTuple.$$$reportNull$$$0(32);
        }
        return t;
    }

    @Nullable
    private static <T> T getIfEquals(@NotNull Object val, String key) {
        if (val == null) {
            GDBTuple.$$$reportNull$$$0(33);
        }
        if (val.equals(key)) {
            return (T)val;
        }
        if (val instanceof Pair && ((Pair)val).first.equals(key)) {
            return (T)((Pair)val).second;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionConstructor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple";
                break;
            }
            case 3: 
            case 10: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionSupplier";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageSupplier";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredStringOrThrow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleOrEmpty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredTuple";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredTupleOrThrow";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredAddress";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredAddressOrThrow";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLocation";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLocationOrThrow";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithSuccessors";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "missingKeyError";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "withMessage";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNotNullOrThrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredStringOrThrow";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredTupleOrThrow";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredAddressOrThrow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseAddress";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredIntOrThrow";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseInteger";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLocationOrThrow";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "withMessage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullOrThrow";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getIfEquals";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$withMessage$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Location {
        private static final Pattern LOCATION_PATTERN = Pattern.compile("^(.*):(\\d+)$");
        @NotNull
        public final String path;
        public final int line;

        public Location(@NotNull String path, int line) {
            if (path == null) {
                Location.$$$reportNull$$$0(0);
            }
            this.path = path;
            this.line = line;
        }

        @NotNull
        public static Location fromFileLineNumber(@NotNull String path, int lineNumber) {
            if (path == null) {
                Location.$$$reportNull$$$0(1);
            }
            Location location = new Location(path, lineNumber - 1);
            if (location == null) {
                Location.$$$reportNull$$$0(2);
            }
            return location;
        }

        @Nullable
        public static Location tryParse(@NotNull String locationString) {
            if (locationString == null) {
                Location.$$$reportNull$$$0(3);
            }
            return Location.tryParse(locationString, null);
        }

        @Contract(value="_, !null -> !null")
        public static Location tryParse(@NotNull String locationString, @Nullable Location defaultValue) {
            Matcher matcher;
            if (locationString == null) {
                Location.$$$reportNull$$$0(4);
            }
            if (!(matcher = LOCATION_PATTERN.matcher(locationString)).matches()) {
                return defaultValue;
            }
            String path = matcher.group(1);
            int lineNumber = Integer.parseInt(matcher.group(2));
            return Location.fromFileLineNumber(path, lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple$Location";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locationString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple$Location";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFileLineNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFileLineNumber";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "tryParse";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

