/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import gnu.trove.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;

public class MacOSDebugSymbols {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TLongHashSet load(@NotNull GeneralCommandLine cl) throws IOException {
        if (cl == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(0);
        }
        try {
            File executable = new File(cl.getExePath());
            File dsymBundle = new File(executable.getParentFile(), executable.getName() + ".dSYM");
            if (!dsymBundle.exists() || executable.lastModified() > dsymBundle.lastModified()) {
                File tmpDir = FileUtil.createTempDirectory((String)executable.getName(), null);
                try {
                    File newDSYMBundle = new File(tmpDir, dsymBundle.getName());
                    GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/dsymutil"});
                    commandLine.addParameter(cl.getExePath());
                    commandLine.addParameter("-o");
                    commandLine.addParameter(newDSYMBundle.getAbsolutePath());
                    String output = StringUtil.notNullize((String)ExecUtil.readFirstLine((InputStream)commandLine.createProcess().getInputStream(), null));
                    if (output.matches("^error.*")) {
                        throw new IOException("Cannot create dsym bundle for " + cl.getExePath());
                    }
                    if (dsymBundle.exists()) {
                        FileUtil.delete((File)dsymBundle);
                    }
                    FileUtil.rename((File)newDSYMBundle, (File)dsymBundle);
                }
                finally {
                    FileUtil.delete((File)tmpDir);
                }
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/otool"});
            commandLine.addParameter("-I");
            commandLine.addParameter(cl.getExePath());
            return MacOSDebugSymbols.parseIndirectSymTable(commandLine.createProcess().getInputStream());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static TLongHashSet parseIndirectSymTable(InputStream input) throws ExecutionException {
        Scanner scanner = new Scanner(input);
        TLongHashSet symbols = new TLongHashSet();
        try {
            block2: while (scanner.hasNext()) {
                if (scanner.findInLine("Indirect symbols for \\(__TEXT,__stubs\\)") != null) {
                    int snum = scanner.nextInt();
                    scanner.nextLine();
                    MacOSDebugSymbols.nextTitle(scanner, "address");
                    MacOSDebugSymbols.nextTitle(scanner, "index");
                    scanner.nextLine();
                    int i = 0;
                    while (true) {
                        if (i >= snum) continue block2;
                        symbols.add(DebuggerDriver.parseAddress(scanner.next()).unsignedLongValue());
                        scanner.nextInt();
                        scanner.nextLine();
                        ++i;
                    }
                }
                scanner.nextLine();
            }
            return symbols;
        }
        catch (NoSuchElementException e) {
            throw new ExecutionException("Cannot parse indirect symbol table: " + e);
        }
    }

    private static void nextTitle(@NotNull Scanner scanner, @NotNull String expected) throws ExecutionException {
        String str;
        if (scanner == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(1);
        }
        if (expected == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(2);
        }
        if (!expected.equals(str = scanner.next())) {
            throw new ExecutionException("Invalid section title:" + str);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/MacOSDebugSymbols";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nextTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

