/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<GeneratedMessage> {
    public static final Logger LOG = CidrDebuggerLog.LOG;
    public static final Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    private static final Key<Integer> LLVALUE_ID = Key.create((String)"LLDBDriver.LLVALUE_ID");
    private static final Key<LLValueDataLoader> LLVALUE_DATA_LOADER = Key.create((String)"LLDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueData> LLVALUE_DATA = Key.create((String)"LLDBDriver.LLVALUE_DATA");
    private static final Key<Integer> CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.CHILDREN_COUNT_CACHE");
    private static final Key<Integer> MAX_REQUESTED_CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.MAX_REQUESTED_CHILDREN_COUNT_CACHE");
    public static final String NO_RESULT = "<no result>";
    private GeneralCommandLine myLLDBCommandLine;
    private BaseProcessHandler myLLDBFrontendHandler;
    private final ExecutionResult<ProtobufServer<Protocol.CompositeResponse>> myConnectedClient = new ExecutionResult();
    private final Set<Integer> myTemporaryBreakpoints = new HashSet<Integer>();
    private final ProcessInputWriter myProcessInputHandler = new ProcessInputWriter();
    private volatile Integer myAsyncAttachingTo;
    private final LLDBDriverConfiguration myStarter;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<Protocol.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DebuggerFatalException> myAsyncFatalException = new AtomicReference();
    private volatile long myStoppedThreadID;

    private void dispatchInput(String input, Model.DispatchTarget target) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage(request, Protocol.DispatchInput_Res.class, dispatchInput_res -> {}, null);
    }

    protected ProtobufServer<Protocol.CompositeResponse> getProtobufClient() throws ExecutionException {
        this.checkErrors();
        return this.myConnectedClient.get();
    }

    private void storeAsyncFatalException(DebuggerFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    @Override
    public void checkErrors() throws ExecutionException {
        DebuggerFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DebuggerFatalException((Throwable)((Object)exception));
        }
    }

    public LLDBDriver(DebuggerDriver.Handler handler, LLDBDriverConfiguration starter) throws ExecutionException {
        super(handler);
        this.myStarter = starter;
        this.myGLogOutputReaders = new GLogOutputReaders(LLDBDriver.getLogDir(), "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(text.trim());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.startDriver();
    }

    @NotNull
    private static File getLogDir() {
        File file = new File(ApplicationManager.getApplication().isUnitTestMode() ? PathManager.getSystemPath() + "/testlog" : PathManager.getLogPath());
        if (file == null) {
            LLDBDriver.$$$reportNull$$$0(0);
        }
        return file;
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    public boolean supportsDisasm() {
        return false;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        LLDBLanguage lLDBLanguage = LLDBLanguage.INSTANCE;
        if (lLDBLanguage == null) {
            LLDBDriver.$$$reportNull$$$0(1);
        }
        return lLDBLanguage;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        BaseProcessHandler baseProcessHandler = this.myLLDBFrontendHandler;
        if (baseProcessHandler == null) {
            LLDBDriver.$$$reportNull$$$0(2);
        }
        return baseProcessHandler;
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    private void startDriver() throws ExecutionException {
        try {
            this.myProtobufServer = new ProtobufServer<Protocol.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<Protocol.CompositeResponse>(){

                @Override
                public Protocol.CompositeResponse parse(byte[] buffer) throws IOException {
                    return Protocol.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(GeneratedMessage response) {
                    return response instanceof Protocol.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                @Override
                protected void handleIOException(IOException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                    if (!LLDBDriver.this.myConnectedClient.isDone()) {
                        LLDBDriver.this.myConnectedClient.setException(e);
                    } else {
                        LLDBDriver.this.storeAsyncFatalException(new DebuggerFatalException(e));
                    }
                }
            };
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", this.myGLogOutputReaders.getLogDir().getPath());
        if (LOG.isTraceEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        this.myLLDBFrontendHandler = this.createDebugProcessHandler(this.myLLDBCommandLine, this.myStarter);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!LLDBDriver.this.myConnectedClient.isDone()) {
                    LLDBDriver.this.myConnectedClient.setException(new ExecutionFinishedException());
                }
                LLDBDriver.this.myProcessInputHandler.close();
                LLDBDriver.this.myGLogOutputReaders.close();
                LLDBDriver.this.handleExited(event.getExitCode());
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ((text = event.getText()) != null && CidrDebuggerLog.LOG.isDebugEnabled()) {
                    CidrDebuggerLog.LOG.debug(PathUtil.getFileName((String)LLDBDriver.this.myLLDBCommandLine.getExePath()) + ": " + text);
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    LLDBDriver.this.handleTargetOutput(event.getText(), outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        LLDBDriver.doSetValuesFilteringEnabled(enabled, this.getProtobufClient());
    }

    private static void doSetValuesFilteringEnabled(boolean enabled, ProtobufServer<Protocol.CompositeResponse> client) throws ExecutionException {
        client.sendMessageAndWaitForReply(ProtobufMessageFactory.setValuesFilteringEnabled(enabled), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architectureId) throws ExecutionException {
        if (installer == null) {
            LLDBDriver.$$$reportNull$$$0(3);
        }
        this.myTargetCommandLine = installer.install();
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(installer.getExecutableFile().getPath(), StringUtil.notNullize((String)architectureId)));
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch((ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)() -> {
                    File tmpDir;
                    String stdoutPath = null;
                    String stderrPath = null;
                    if (LLDBDriver.this.myToRedirect) {
                        ProcessOutputReaders readers = LLDBDriver.this.initReaders(OSType.getCurrent(), LLDBDriver.this.myTargetCommandLine, !SystemInfo.isWindows, false);
                        stdoutPath = readers.getOutFileAbsolutePath();
                        stderrPath = readers.getErrFileAbsolutePath();
                    }
                    try {
                        tmpDir = FileUtil.createTempDirectory((String)"process_pipe_dir", null);
                    }
                    catch (IOException e) {
                        throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.cannotCreatePipe", new Object[0]));
                    }
                    LLDBDriver.this.myProcessInputHandler.initPipeInput(tmpDir, "process_pipe");
                    return ProtobufMessageFactory.launch(LLDBDriver.this.myTargetCommandLine, new File(tmpDir, "process_pipe").getAbsolutePath(), stdoutPath, stderrPath);
                }, false);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
        if (inferior == null) {
            LLDBDriver.$$$reportNull$$$0(4);
        }
        return inferior;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
                LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attach(pid), Protocol.Attach_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
                LLDBDriver.this.handlePrompt();
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
        if (inferior == null) {
            LLDBDriver.$$$reportNull$$$0(5);
        }
        return inferior;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final @NotNull String name2, final boolean wait) throws ExecutionException {
        if (name2 == null) {
            LLDBDriver.$$$reportNull$$$0(6);
        }
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
                LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name2, wait), Protocol.AttachByName_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
                LLDBDriver.this.handlePrompt();
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
        if (inferior == null) {
            LLDBDriver.$$$reportNull$$$0(7);
        }
        return inferior;
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteLaunch(final @NotNull Installer installer, @Nullable String architectureId, @NotNull File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        if (installer == null) {
            LLDBDriver.$$$reportNull$$$0(8);
        }
        if (sysroot == null) {
            LLDBDriver.$$$reportNull$$$0(9);
        }
        if (pathMappings == null) {
            LLDBDriver.$$$reportNull$$$0(10);
        }
        this.myTargetCommandLine = installer.install();
        String exePath = installer.getExecutableFile().getPath();
        String remoteExePath = this.myTargetCommandLine.getExePath();
        CidrDebuggerLog.LOG.debug("creating remote target: exepath: " + exePath + " remotePath: " + remoteExePath + " arch: " + StringUtil.notNullize((String)architectureId));
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, StringUtil.notNullize((String)architectureId), "remote-ios", sysroot.getAbsolutePath(), remoteExePath));
        this.addPathMapping(pathMappings);
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch((ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)() -> {
                    String debugserverSocket;
                    if (installer == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    CidrDebuggerLog.LOG.assertTrue((debugserverSocket = (String)LLDBDriver.this.myTargetCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET)) != null);
                    LLDBDriver.this.myProcessInputHandler.initDispatchInput();
                    return ProtobufMessageFactory.remoteLaunch(installer.getExecutableFile().getAbsolutePath(), LLDBDriver.this.myTargetCommandLine, debugserverSocket);
                }, true);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installer", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$8", "lambda$startImpl$0"));
            }
        };
        if (inferior == null) {
            LLDBDriver.$$$reportNull$$$0(11);
        }
        return inferior;
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings) throws ExecutionException {
        if (mappings == null) {
            LLDBDriver.$$$reportNull$$$0(12);
        }
        StringBuilder builder = new StringBuilder();
        for (DebuggerDriver.PathMapping each : mappings) {
            builder.append("\"").append(each.from).append("\" ");
            builder.append("\"").append(each.to).append("\" ");
        }
        this.myProtobufServer.sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target modules search-paths add " + builder.toString()), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        if (createTargetRequest == null) {
            LLDBDriver.$$$reportNull$$$0(13);
        }
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't create target");
        this.getProtobufClient().sendMessageAndWaitForReply(createTargetRequest, Protocol.CreateTarget_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    private long doLaunch(@NotNull ThrowableComputable<Protocol.CompositeRequest, ExecutionException> launchRequestSupplier, boolean isRemoteTarget) throws ExecutionException {
        if (launchRequestSupplier == null) {
            LLDBDriver.$$$reportNull$$$0(14);
        }
        final Ref launchedPid = new Ref();
        ThrowIfNotValid<Protocol.Launch_Res> responseHandler = new ThrowIfNotValid<Protocol.Launch_Res>("Couldn't launch process"){

            @Override
            public void consume(Protocol.Launch_Res message) {
                super.consume(message);
                if (this.isValid()) {
                    launchedPid.set((Object)message.getPid());
                }
            }
        };
        assert (this.myTargetCommandLine != null) : "Not Installed";
        Protocol.CompositeRequest launchReq = (Protocol.CompositeRequest)launchRequestSupplier.compute();
        this.printTargetCommandLine(this.myTargetCommandLine);
        this.getProtobufClient().sendMessageAndWaitForReply(launchReq, Protocol.Launch_Res.class, (Consumer<Protocol.CompositeResponse>)responseHandler);
        if (isRemoteTarget && !responseHandler.isValid() && CidrDebuggerBundle.message("debug.lldb.lockedDeviceResponse", new Object[0]).equals(responseHandler.getMessage())) {
            throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        this.handlePrompt();
        return (Long)launchedPid.get();
    }

    private void detach() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't detach process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.detach(), Protocol.Detach_Res.class, responseHandler);
        if (!responseHandler.isValid() && !"Sending disconnect packet failed.".equals(responseHandler.getMessage())) {
            responseHandler.throwIfNeeded();
        }
        this.handleDetached();
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        Ref result = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.Suspend_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)suspend_res -> result.set((Object)suspend_res.getCommonResponse().getIsValid())));
        return result.isNull() ? false : (Boolean)result.get();
    }

    @Override
    public boolean resume() throws ExecutionException {
        boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        this.getProtobufClient().sendMessageAndWaitForReply(resume, Protocol.Continue_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)continue_res -> {
            res[0] = continue_res.getCommonResponse().getIsValid();
        }));
        return res[0];
    }

    @Override
    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping over");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(this.myStoppedThreadID);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOver_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping into");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(this.myStoppedThreadID);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepInto_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepOut() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping out");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(this.myStoppedThreadID);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOut_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(String path, int line) throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            try {
                List<LLBreakpoint> breakpoints = this.addBreakpoint(path, line);
                for (LLBreakpoint breakpoint : breakpoints) {
                    this.myTemporaryBreakpoints.add(breakpoint.getId());
                }
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
            if (!this.resume()) {
                throw new ExecutionException("Couldn't resume program");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryBreakpoints() throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            for (int num : this.myTemporaryBreakpoints) {
                Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
                this.getProtobufClient().sendMessage(request, Protocol.RemoveBreakpoint_Res.class, res -> {
                    if (!res.getCommonResponse().getIsValid()) {
                        CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                    }
                }, null);
            }
            this.myTemporaryBreakpoints.clear();
        }
    }

    private boolean abort() throws ExecutionException {
        Ref toThrow = Ref.create();
        Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), Protocol.Kill_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (commonResponse.getIsValid()) {
                abort.set((Object)true);
            } else {
                String errorMessage = commonResponse.getErrorMessage();
                if ("process not exist".equals(errorMessage)) {
                    abort.set((Object)false);
                } else {
                    if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                        errorMessage = "Failed to abort process";
                    }
                    toThrow.set((Object)new LLDBDriverException(errorMessage));
                }
            }
        }));
        return (Boolean)abort.get();
    }

    @Override
    protected void doExit() throws ExecutionException {
        try {
            if (this.myConnectedClient.isDone()) {
                this.myConnectedClient.get().sendMessage(ProtobufMessageFactory.exit(), null, null);
            }
        }
        finally {
            this.myProtobufServer.tearDown();
        }
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        String expression = value.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value), null, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.READ, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.WRITE, true);
        Ref result = Ref.create(null);
        Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.AddWatchpoint_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                toThrow.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else {
                result.set((Object)new LLWatchpoint(res.getWatchpointId(), expression));
            }
        }));
        if (result.isNull()) {
            throw (DebuggerCommandException)toThrow.get();
        }
        LLWatchpoint lLWatchpoint = (LLWatchpoint)result.get();
        if (lLWatchpoint == null) {
            LLDBDriver.$$$reportNull$$$0(15);
        }
        return lLWatchpoint;
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException {
        String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(convertedPath, line + 1, condition);
        Ref result = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> result.set((Object)new LLBreakpoint(res.getId(), convertedPath, line, res.hasNumLocations() ? res.getNumLocations() : 1L, res.hasNumResolvedLocations() ? res.getNumResolvedLocations() : 1L, false, res.getCommonResponse().getIsValid(), condition, null))));
        List<Object> list = result.isNull() ? Collections.emptyList() : Collections.singletonList(result.get());
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        if (symBreakpoint == null) {
            LLDBDriver.$$$reportNull$$$0(17);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        Ref result = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> result.set((Object)new LLSymbolicBreakpoint(res.getId()))));
        return (LLSymbolicBreakpoint)result.get();
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException {
        if (ids == null) {
            LLDBDriver.$$$reportNull$$$0(18);
        }
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove breakpoint");
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveBreakpoint_Res.class, responseHandler);
            responseHandler.throwIfNeeded();
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    private LLThread newLLThread(@NotNull Model.LLDBThread lldbThread) {
        Model.ThreadStopReasonInfo stopReasonInfo;
        if (lldbThread == null) {
            LLDBDriver.$$$reportNull$$$0(19);
        }
        boolean isStopped = (stopReasonInfo = lldbThread.getStopReasonInfo()) != null && stopReasonInfo.getStopReason() != Model.ThreadStopReason.ThreadStopReasonInvalid;
        LLThread lLThread = new LLThread(lldbThread.getId(), isStopped ? "STOPPED" : null, lldbThread.getQueue(), lldbThread.getName());
        if (lLThread == null) {
            LLDBDriver.$$$reportNull$$$0(20);
        }
        return lLThread;
    }

    @NotNull
    private LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        if (frame == null) {
            LLDBDriver.$$$reportNull$$$0(21);
        }
        LLFrame lLFrame = new LLFrame(frame.getNumber(), frame.hasFunction() ? frame.getFunction() : null, frame.hasFile() ? this.myStarter.convertToLocalPath(frame.getFile()) : null, frame.hasLine() ? frame.getLine() - 1 : -1, frame.hasPc() ? frame.getPc() : 0L, frame.hasLanguage() ? LLDBDriver.convertLanguage(frame.getLanguage()) : null, frame.hasOptimized() && frame.getOptimized());
        if (lLFrame == null) {
            LLDBDriver.$$$reportNull$$$0(22);
        }
        return lLFrame;
    }

    @Nullable
    private static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
                case LanguageRust: {
                    return DebuggerDriver.StandardDebuggerLanguage.RUST;
                }
                case LanguageFortran77: 
                case LanguageFortran90: 
                case LanguageFortran95: 
                case LanguageFortran03: 
                case LanguageFortran08: {
                    return DebuggerDriver.StandardDebuggerLanguage.FORTRAN;
                }
                case LanguageAda83: 
                case LanguageAda95: {
                    return DebuggerDriver.StandardDebuggerLanguage.ADA;
                }
                case LanguageCobol74: 
                case LanguageCobol85: {
                    return DebuggerDriver.StandardDebuggerLanguage.COBOL;
                }
                case LanguagePascal83: {
                    return DebuggerDriver.StandardDebuggerLanguage.PASCAL;
                }
                case LanguageModula2: 
                case LanguageModula3: {
                    return DebuggerDriver.StandardDebuggerLanguage.MODULA;
                }
                case LanguageD: {
                    return DebuggerDriver.StandardDebuggerLanguage.D;
                }
                case LanguageOpenCL: {
                    return DebuggerDriver.StandardDebuggerLanguage.OPENCL;
                }
                case LanguageGo: {
                    return DebuggerDriver.StandardDebuggerLanguage.GO;
                }
                case LanguageHaskell: {
                    return DebuggerDriver.StandardDebuggerLanguage.HASKELL;
                }
                case LanguageOCaml: {
                    return DebuggerDriver.StandardDebuggerLanguage.OCAML;
                }
                case UnsupportedLanguage: {
                    CidrDebuggerLog.LOG.warn("Unknown language reported by LLDB. Protocol needs to be updated");
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return Model.Language.LanguageC;
                }
                case C_PLUS_PLUS: {
                    return Model.Language.LanguageC_plus_plus;
                }
                case OBJC: {
                    return Model.Language.LanguageObjC;
                }
                case OBJC_PLUS_PLUS: {
                    return Model.Language.LanguageObjC_plus_plus;
                }
                case SWIFT: {
                    return Model.Language.LanguageSwift;
                }
                case FORTRAN: {
                    return Model.Language.LanguageFortran08;
                }
                case RUST: {
                    return Model.Language.LanguageRust;
                }
                case ADA: {
                    return Model.Language.LanguageAda95;
                }
                case COBOL: {
                    return Model.Language.LanguageCobol85;
                }
                case PASCAL: {
                    return Model.Language.LanguagePascal83;
                }
                case MODULA: {
                    return Model.Language.LanguageModula3;
                }
                case D: {
                    return Model.Language.LanguageD;
                }
                case OPENCL: {
                    return Model.Language.LanguageOpenCL;
                }
                case GO: {
                    return Model.Language.LanguageGo;
                }
                case HASKELL: {
                    return Model.Language.LanguageHaskell;
                }
                case OCAML: {
                    return Model.Language.LanguageOCaml;
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        ArrayList<LLThread> result = new ArrayList<LLThread>();
        Protocol.CompositeRequest request = ProtobufMessageFactory.getThreads();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetThreads_Res.class, res -> {
            for (Model.LLDBThread each : res.getThreadList()) {
                result.add(this.newLLThread(each));
            }
        }, Integer.MAX_VALUE);
        ArrayList<LLThread> arrayList = result;
        if (arrayList == null) {
            LLDBDriver.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Ref result = new Ref();
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(threadId, from, count, untilFirstLineWithCode);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetFrames_Res.class, res -> {
            List<Model.LLDBFrame> lldbFrames = res.getFrameList();
            ArrayList<LLFrame> frames = new ArrayList<LLFrame>(lldbFrames.size());
            for (Model.LLDBFrame frame : lldbFrames) {
                frames.add(this.newLLFrame(frame));
            }
            result.set(DebuggerDriver.ResultList.create(frames, res.getHasMore()));
        }, Integer.MAX_VALUE);
        DebuggerDriver.ResultList resultList = (DebuggerDriver.ResultList)result.get();
        if (resultList == null) {
            LLDBDriver.$$$reportNull$$$0(24);
        }
        return resultList;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException {
        boolean staticsAndGlobals = this.myStarter.isStaticVarsLoadingEnabled();
        List<LLValue> list = this.getVariables(threadId, frameIndex, staticsAndGlobals, staticsAndGlobals);
        if (list == null) {
            LLDBDriver.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex, boolean statics, boolean globals) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getVars(threadId, frameIndex, statics, globals);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetVars_Res.class, res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message = commonResponse.getErrorMessage();
                if (message != null) {
                    errorMessage.set((Object)message);
                }
            } else {
                for (Model.LLDBValue lldbValue : res.getValueList()) {
                    result.add(this.createLLValue(lldbValue, null));
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new ExecutionException((String)errorMessage.get());
        }
        ArrayList<LLValue> arrayList = result;
        if (arrayList == null) {
            LLDBDriver.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(27);
        }
        LLValueData lLValueData = LLDBDriver.getLLValueData(value);
        if (lLValueData == null) {
            LLDBDriver.$$$reportNull$$$0(28);
        }
        return lLValueData;
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(29);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.getValueDescription(LLDBDriver.valId(value), maxLength);
        Ref description = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.GetValueDescription_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                return;
            }
            if (res.hasDescription()) {
                description.set((Object)res.getDescription());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        return (String)description.get();
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Integer childrenCount = this.getChildrenCount(value, from + count + 1);
        if (childrenCount == 0) {
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.empty();
            if (resultList == null) {
                LLDBDriver.$$$reportNull$$$0(30);
            }
            return resultList;
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(value), from, count);
        Ref errorMessage = new Ref();
        ArrayList result = new ArrayList();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueChildren_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                this.convertList(res.getValueList(), result);
            }
        }, 0L);
        String message = (String)errorMessage.get();
        if (message != null) {
            throw new DebuggerCommandException(message);
        }
        boolean hasMore = from + count < childrenCount;
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            LLDBDriver.$$$reportNull$$$0(31);
        }
        return resultList;
    }

    @Override
    public void addSymbolsFile(File dSYM, File module2) throws ExecutionException {
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target module add \"" + module2.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add module: " + module2.getAbsolutePath()));
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target symbols add \"" + dSYM.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add dSYM: " + dSYM.getAbsolutePath()));
    }

    private void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value = this.createLLValue(val, null);
            result.add(value);
        }
    }

    private static int valId(@NotNull LLValue var) throws ExecutionException {
        if (var == null) {
            LLDBDriver.$$$reportNull$$$0(32);
        }
        return (Integer)var.getUserData(LLVALUE_ID);
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Ref errorMessage = Ref.create((Object)"unknown error");
        ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), Protocol.GetArraySlice_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                String message = res.getCommonResponse().getErrorMessage();
                if (message != null) {
                    errorMessage.set((Object)message);
                }
                return;
            }
            errorMessage.set(null);
            this.convertList(res.getValueList(), vals);
        }));
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return vals;
    }

    @NotNull
    private LLValue createLLValue(@NotNull Model.LLDBValue lldbValue, @Nullable String expression) {
        LLValue.TypeClass typeClass;
        if (lldbValue == null) {
            LLDBDriver.$$$reportNull$$$0(33);
        }
        switch (lldbValue.getTypeClass()) {
            case TypeClassFunction: {
                typeClass = LLValue.TypeClass.FUNCTION;
                break;
            }
            case TypeClassBuiltin: {
                typeClass = LLValue.TypeClass.BUILTIN;
                break;
            }
            case TypeClassClass: 
            case TypeClassStruct: {
                typeClass = LLValue.TypeClass.CLASS_STRUCT;
                break;
            }
            case TypeClassObjCObjectPointer: {
                typeClass = LLValue.TypeClass.OBJC_POINTER;
                break;
            }
            default: {
                typeClass = null;
            }
        }
        String referenceExpression = lldbValue.getName();
        LLValue result = new LLValue(expression == null ? lldbValue.getName() : expression, lldbValue.getType(), typeClass, referenceExpression);
        result.putUserData(LLVALUE_ID, lldbValue.getId());
        result.putUserData(LLVALUE_DATA_LOADER, new LLValueDataLoader());
        LLValue lLValue = result;
        if (lLValue == null) {
            LLDBDriver.$$$reportNull$$$0(34);
        }
        return lLValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static LLValueData getLLValueData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBDriver.$$$reportNull$$$0(35);
        }
        LLValue lLValue = value;
        // MONITORENTER : lLValue
        LLValueDataLoader loader = (LLValueDataLoader)value.getUserData(LLVALUE_DATA_LOADER);
        if (loader != null) {
            LLValueData data = loader.loadData(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
            value.putUserData(LLVALUE_DATA, data);
            LLValueData lLValueData = data;
            // MONITOREXIT : lLValue
            if (lLValueData != null) return lLValueData;
            LLDBDriver.$$$reportNull$$$0(36);
            return lLValueData;
        }
        LLValueData data = (LLValueData)value.getUserData(LLVALUE_DATA);
        if (data == null) {
            throw new ExecutionException("Internal error, variable _p not initialized: " + (Object)((Object)value));
        }
        LLValueData lLValueData = data;
        // MONITOREXIT : lLValue
        if (lLValueData != null) return lLValueData;
        LLDBDriver.$$$reportNull$$$0(37);
        return lLValueData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLValue evaluate(long threadId, int frameIndex, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage debuggerLanguage) throws ExecutionException, DebuggerCommandException {
        void language;
        if (expression == null) {
            LLDBDriver.$$$reportNull$$$0(38);
        }
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(threadId, frameIndex, expression, LLDBDriver.convertLanguage((DebuggerDriver.DebuggerLanguage)language));
        Ref result = new Ref();
        Ref errorMessage = new Ref();
        try {
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.EvaluateExpression_Res.class, res -> {
                if (expression == null) {
                    LLDBDriver.$$$reportNull$$$0(54);
                }
                if (res.getCommonResponse().getIsValid()) {
                    if (res.hasResult()) {
                        Model.LLDBValue lldbValue = res.getResult();
                        LLValue value = this.createLLValue(lldbValue, expression);
                        result.set((Object)value);
                    } else {
                        errorMessage.set((Object)NO_RESULT);
                    }
                } else {
                    String error = res.getCommonResponse().getErrorMessage();
                    errorMessage.set((Object)(error != null ? error : "Unknown evaluation error"));
                }
            }, 0L);
        }
        catch (ProtobufTimedOutException e) {
            throw new DebuggerEvaluationTimedOutException(expression);
        }
        if (!errorMessage.isNull()) {
            String message = (String)errorMessage.get();
            if (NO_RESULT.equals(message)) {
                LLValue resultValue = new LLValue("result", "void", null, "");
                resultValue.putUserData(LLVALUE_ID, 0);
                resultValue.putUserData(LLVALUE_DATA, new LLValueData("", null, false, false, false));
                resultValue.putUserData(CHILDREN_COUNT_CACHE, 0);
                LLValue lLValue = resultValue;
                if (lLValue == null) {
                    LLDBDriver.$$$reportNull$$$0(39);
                }
                return lLValue;
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message);
            if (matcher.find()) {
                message = matcher.group(1);
            }
            throw new DebuggerCommandException(message);
        }
        if (result.isNull()) {
            throw new ExecutionException("Unknown evaluation error");
        }
        LLValue lLValue = (LLValue)((Object)result.get());
        if (lLValue == null) {
            LLDBDriver.$$$reportNull$$$0(40);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            LLDBDriver.$$$reportNull$$$0(41);
        }
        throw new ExecutionException("Disassembling not implemented in " + this.getClass().getSimpleName());
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        if (executable == null) {
            LLDBDriver.$$$reportNull$$$0(42);
        }
        Ref result = new Ref();
        Ref errorMessage = new Ref();
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        if (params != null) {
            args.addAll(params);
        }
        String command = StringUtil.join(args, s -> StringUtil.escapeCharCharacters((String)s), (String)" ");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), Protocol.ExecuteShellCommand_Res.class, res -> {
            Protocol.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message = commonResponse.getErrorMessage();
                errorMessage.set((Object)(message != null && !StringUtil.isEmpty((String)message) ? message : "Invalid shell command response"));
            } else {
                result.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
            }
        }, (timeoutSecs + 10) * 1000);
        if (!errorMessage.isNull()) {
            throw new ExecutionException((String)errorMessage.get());
        }
        DebuggerDriver.ShellCommandResult shellCommandResult = (DebuggerDriver.ShellCommandResult)result.get();
        if (shellCommandResult == null) {
            LLDBDriver.$$$reportNull$$$0(43);
        }
        return shellCommandResult;
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException {
        this.executeConsoleCommand(-1L, -1, command);
    }

    @Override
    public void executeConsoleCommand(long threadId, int frameIndex, String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameIndex, command);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
            if (res.hasOut()) {
                this.handleGDBOutput(res.getOut());
            }
            if (res.hasErr()) {
                this.handleGDBOutput(res.getErr());
            }
        }));
    }

    @Override
    public void handleCompletion(String command, int pos, List<String> completions) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleCompletion_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> completions.addAll(res.getCompletionList())));
    }

    @Override
    public void handleSignal(String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't handle signal");
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop, pass, notify);
        this.getProtobufClient().sendMessageAndWaitForReply(handleSignalReq, Protocol.HandleSignal_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputHandler;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException {
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove watchpoint");
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveWatchpoint_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    @NotNull
    public Integer getChildrenCount(@NotNull LLValue var, int max) throws ExecutionException, DebuggerCommandException {
        Integer cached;
        if (var == null) {
            LLDBDriver.$$$reportNull$$$0(44);
        }
        if ((cached = (Integer)var.getUserData(CHILDREN_COUNT_CACHE)) != null) {
            Integer max_cache = (Integer)var.getUserData(MAX_REQUESTED_CHILDREN_COUNT_CACHE);
            assert (max_cache != null);
            if (cached < max_cache) {
                Integer n = cached;
                if (n == null) {
                    LLDBDriver.$$$reportNull$$$0(45);
                }
                return n;
            }
            if (max < max_cache) {
                Integer n = max;
                if (n == null) {
                    LLDBDriver.$$$reportNull$$$0(46);
                }
                return n;
            }
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var), max);
        Ref errorMessage = new Ref();
        Ref result = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetChildrenCount_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result.set((Object)res.getCount());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        var.putUserData(MAX_REQUESTED_CHILDREN_COUNT_CACHE, max);
        var.putUserData(CHILDREN_COUNT_CACHE, result.get());
        Integer n = (Integer)result.get();
        if (n == null) {
            LLDBDriver.$$$reportNull$$$0(47);
        }
        return n;
    }

    public long getValueAddress(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            LLDBDriver.$$$reportNull$$$0(48);
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueAddress(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueAddress_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result.set((Object)res.getAddress());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return (Long)result.get();
    }

    protected void lldbSet(@NotNull String setting, boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            LLDBDriver.$$$reportNull$$$0(49);
        }
        this.lldbSet(setting, enabled ? "true" : "false");
    }

    protected void lldbSet(@NotNull String setting, @Nullable String value) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            LLDBDriver.$$$reportNull$$$0(50);
        }
        String settingCommand = value != null ? "set " + setting + " " + value : "remove " + setting;
        this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "settings " + settingCommand), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't set " + setting + " = " + value));
    }

    @NotNull
    @Contract(pure=true)
    protected String createTypeSummaryConsoleCommand(@NotNull String summaryString, @Nullable String category, String ... typeNames) {
        if (summaryString == null) {
            LLDBDriver.$$$reportNull$$$0(51);
        }
        if (typeNames == null) {
            LLDBDriver.$$$reportNull$$$0(52);
        }
        String string = String.format("type summary add --skip-pointers --summary-string %s --category %s %s", LLDBDriver.stringify(summaryString), category != null ? category : "default", Arrays.stream(typeNames).map(DebuggerDriver::stringify).collect(Collectors.joining(" ")));
        if (string == null) {
            LLDBDriver.$$$reportNull$$$0(53);
        }
        return string;
    }

    private void haveConnection() {
        try {
            this.lldbSet("target.process.thread.step-in-avoid-nodebug", true);
            this.lldbSet("target.process.thread.step-out-avoid-nodebug", true);
            String typeSummaryConsoleCommand = this.createTypeSummaryConsoleCommand("${var%d} ${var}", "cplusplus", "char", "signed char", "unsigned char");
            this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, typeSummaryConsoleCommand), Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {}));
            this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "type category enable objc"), Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {}));
            this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
            if (this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "script import lldb_formatters.jetbrains_stl_formatters"), Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
                    if (res.hasOut() || res.hasErr()) {
                        String message1 = "Error during data formatters setup:";
                        if (res.hasOut()) {
                            message1 = message1 + "\n" + res.getOut();
                        }
                        if (res.hasErr()) {
                            message1 = message1 + "\n" + res.getErr();
                        }
                        this.handleTargetOutput(message1, ProcessOutputTypes.SYSTEM);
                    }
                }));
            }
            if (CidrDebuggerLog.LOG.isTraceEnabled()) {
                String logPath = LLDBDriver.getLogDir() + "/lldb.log";
                this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "log enable -f " + logPath + " lldb default"), Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {}));
            }
            this.myConnectedClient.set(this.myProtobufServer);
        }
        catch (Exception e) {
            this.myConnectedClient.setException(e);
        }
    }

    public void consume(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Model.Initialized_Message) {
            this.haveConnection();
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            this.handleTargetFinished(exitCode, exit.hasExitDescription() ? exit.getExitDescription() : null);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            Model.ThreadStopReason stopReason;
            try {
                this.removeTemporaryBreakpoints();
            }
            catch (ExecutionException attachedTo) {
                // empty catch block
            }
            Broadcasts.ProcessInterrupted_Broadcast interrupted_broadcast = (Broadcasts.ProcessInterrupted_Broadcast)generatedMessage;
            Model.LLDBThread lldbThread = interrupted_broadcast.getThread();
            LLThread thread = this.newLLThread(lldbThread);
            LLFrame frame = this.newLLFrame(interrupted_broadcast.getFrame());
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.myStoppedThreadID = stopPlace.thread.getId();
            Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.getStopReasonInfo();
            Model.ThreadStopReason threadStopReason = stopReason = stopReasonInfo == null ? null : stopReasonInfo.getStopReason();
            if (stopReason == Model.ThreadStopReason.ThreadStopReasonBreakpoint && stopReasonInfo.hasCodepointId()) {
                this.handleBreakpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonWatchpoint && stopReasonInfo.hasCodepointId()) {
                this.handleWatchpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonSignal) {
                int signal = stopReasonInfo.getSignal();
                String signalName = stopReasonInfo.getSignalName();
                if (LLDBDriver.isTargetTerminationSignal(signal)) {
                    this.handleTargetTerminated();
                } else {
                    this.handleSignal(stopPlace, !signalName.isEmpty() ? signalName : String.valueOf(signal), stopReasonInfo.getStopDescription());
                }
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonException) {
                this.handleException(stopPlace, stopReasonInfo.getStopDescription());
            } else {
                this.handleInterrupted(stopPlace);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handlePrompt(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() == 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleGDBOutput(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage());
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(outputBroadcast.getText(), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            this.handleModulesLoaded(((Broadcasts.ModulesLoaded_Broadcast)generatedMessage).getModulesList());
        } else if (generatedMessage instanceof Broadcasts.BreakpointChanged_Broadcast) {
            Broadcasts.BreakpointChanged_Broadcast breakpoint_change = (Broadcasts.BreakpointChanged_Broadcast)generatedMessage;
            this.handleBreakpointChanged(new LLBreakPointBroadcast(breakpoint_change.getBreakpointId(), breakpoint_change.getIsValid(), breakpoint_change.getNumLocations(), breakpoint_change.getNumResolvedLocations()));
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sysroot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createTargetRequest";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchRequestSupplier";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symBreakpoint";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lldbThread";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 27: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 32: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lldbValue";
                break;
            }
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summaryString";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForLaunch";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForAttach";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForRemoteLaunch";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addWatchpoint";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newLLThread";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "newLLFrame";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLValue";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLValueData";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "executeShellCommand";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenCount";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeSummaryConsoleCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadForLaunch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttach";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemoteLaunch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sendCreateTargetRequest";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doLaunch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeCodepoints";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newLLThread";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newLLFrame";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "valId";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createLLValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLLValueData";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "executeShellCommand";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getValueAddress";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lldbSet";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createTypeSummaryConsoleCommand";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluate$14";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ProcessInputWriter
    extends OutputStream {
        private final Object myCloseOpLock = new Object();
        private File myInputFileDir;
        private volatile boolean closed;
        private volatile boolean pipeInput;
        private volatile OutputStream myOutputStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPipeInput(@NotNull File inputFileDir, @NotNull String inputFileName) {
            if (inputFileDir == null) {
                ProcessInputWriter.$$$reportNull$$$0(0);
            }
            if (inputFileName == null) {
                ProcessInputWriter.$$$reportNull$$$0(1);
            }
            this.pipeInput = true;
            this.closed = false;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                this.myInputFileDir = inputFileDir;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (inputFileDir == null) {
                    ProcessInputWriter.$$$reportNull$$$0(3);
                }
                if (inputFileName == null) {
                    ProcessInputWriter.$$$reportNull$$$0(4);
                }
                File inputFile = new File(inputFileDir, inputFileName);
                while (!this.closed && !inputFile.exists()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                        break;
                    }
                }
                if (this.closed) {
                    return;
                }
                Object object = this.myCloseOpLock;
                synchronized (object) {
                    if (inputFile.exists()) {
                        try {
                            this.myOutputStream = new FileOutputStream(inputFile);
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                        }
                    }
                }
            });
        }

        public void initDispatchInput() {
            this.pipeInput = false;
        }

        @Override
        public void write(int i) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(@NotNull byte[] bytes, int i, int i1) throws IOException {
            if (bytes == null) {
                ProcessInputWriter.$$$reportNull$$$0(2);
            }
            if (this.pipeInput) {
                if (!this.closed && this.myOutputStream != null) {
                    this.myOutputStream.write(bytes, i, i1);
                }
            } else {
                try {
                    String input = new String(bytes, i, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                    LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File getInputFileDir() {
            Object object = this.myCloseOpLock;
            synchronized (object) {
                return this.myInputFileDir;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.pipeInput) {
                return;
            }
            this.closed = true;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                    if (this.myInputFileDir.exists()) {
                        FileUtil.delete((File)this.myInputFileDir);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputFileDir";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputFileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$ProcessInputWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initPipeInput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$initPipeInput$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LLValueDataLoader {
        private LLValueDataLoader() {
        }

        @NotNull
        public LLValueData loadData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            if (value == null) {
                LLValueDataLoader.$$$reportNull$$$0(0);
            }
            Protocol.CompositeRequest req = ProtobufMessageFactory.getValueData(LLDBDriver.valId(value), 1000);
            Ref lldbDataRef = Ref.create();
            Ref exception = Ref.create();
            LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.GetValueData_Res.class, (Consumer<Protocol.CompositeResponse>)((Consumer)res -> {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                    return;
                }
                lldbDataRef.set((Object)res.getValue());
            }));
            if (!exception.isNull()) {
                throw (DebuggerCommandException)exception.get();
            }
            Model.LLDBValueData lldbData = (Model.LLDBValueData)lldbDataRef.get();
            LLValueData lLValueData = new LLValueData(lldbData.getValue(), lldbData.hasDescription() ? lldbData.getDescription() : null, lldbData.getHasLongerDescription(), lldbData.getMayHaveChildren(), lldbData.getIsSynthetic());
            if (lLValueData == null) {
                LLValueDataLoader.$$$reportNull$$$0(1);
            }
            return lLValueData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$LLValueDataLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver$LLValueDataLoader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "loadData";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ThrowIfNotValid<T extends GeneratedMessage>
    implements Consumer<T> {
        private String myMessage;
        private boolean myIsValid = false;

        public ThrowIfNotValid(String mes) {
            this.myMessage = mes;
        }

        public void consume(T message) {
            Map allFields = message.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof Protocol.CommonResponse)) continue;
                Protocol.CommonResponse commonResponse = (Protocol.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws LLDBDriverException {
            if (!this.myIsValid) {
                throw new LLDBDriverException(this.myMessage);
            }
        }

        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }
    }
}

