/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;

public class LLDBEvaluationContext
extends EvaluationContext {
    private final DebuggerDriver myDriver;

    public LLDBEvaluationContext(DebuggerDriver driver, Expirable expirable, CidrStackFrame frame) {
        super(driver, expirable, frame);
        this.myDriver = driver;
    }

    @Override
    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(0);
        }
        if (type == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(1);
        }
        String string = LLDBEvaluationContext.cast(expr, "long");
        if (string == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String convertToRValue(@NotNull LLValueData lValueData, @NotNull Pair<LLValue, String> rValuePair) throws DebuggerCommandException, ExecutionException {
        LLValueData rValueData;
        if (lValueData == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(3);
        }
        if (rValuePair == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(4);
        }
        if ((rValueData = this.getData((LLValue)((Object)rValuePair.first))).isNullPointer()) {
            if ("((id)0)" == null) {
                LLDBEvaluationContext.$$$reportNull$$$0(5);
            }
            return "((id)0)";
        }
        String string = lValueData.isPointer() && ((LLValue)((Object)rValuePair.first)).getType().equals("int") && rValueData.intValue() == 0L ? "0" : (String)rValuePair.getSecond();
        if (string == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    public long getValueAddress(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            LLDBEvaluationContext.$$$reportNull$$$0(7);
        }
        return ((LLDBDriver)this.myDriver).getValueAddress(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValueData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rValuePair";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "castIDToNumber";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "castIDToNumber";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToRValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueAddress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

