/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<XBreakpointProperties>> {
    private CidrDebugProcess myProcess;

    public CidrBreakpointHandler(CidrDebugProcess process2) {
        this(process2, (Class<? extends XLineBreakpointType<XBreakpointProperties>>)CidrLineBreakpointType.class);
    }

    public CidrBreakpointHandler(CidrDebugProcess process2, @NotNull Class<? extends XLineBreakpointType<XBreakpointProperties>> type) {
        if (type == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(process2, type);
        this.myProcess = process2;
    }

    @Override
    protected Collection<LLCodepoint> doAddCodepoints(DebuggerDriver driver, XLineBreakpoint<XBreakpointProperties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        List<LLCodepoint> result;
        String condition = this.convertCondition((XBreakpoint<? extends XBreakpointProperties>)breakpoint);
        try {
            result = driver.addBreakpoint(VfsUtil.urlToPath((String)breakpoint.getFileUrl()), breakpoint.getLine(), condition);
        }
        catch (DebuggerCommandException e) {
            this.myProcess.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, e.getMessage());
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        LLBreakpoint.ValidityState breakpointValidity = LLBreakpoint.ValidityState.INVALID;
        for (LLBreakpoint lLBreakpoint : result) {
            breakpointValidity = lLBreakpoint.getBreakpointValidityState();
            String error = lLBreakpoint.getConditionError();
            if (error == null) continue;
            errors.add(error);
        }
        if (errors.isEmpty() && breakpointValidity != LLBreakpoint.ValidityState.INVALID) {
            if (breakpointValidity == LLBreakpoint.ValidityState.RESOLVED) {
                this.myProcess.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
            } else if (breakpointValidity == LLBreakpoint.ValidityState.PENDING) {
                this.myProcess.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_set_breakpoint, null);
            }
        } else {
            this.myProcess.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, StringUtil.join(errors, (String)"\n"));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrBreakpointHandler", "<init>"));
    }
}

