/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<T, List<LLCodepoint>> myBreakpoints;
    private final Map<Integer, T> myIdToBreakpoint;

    public CidrCodePointHandlerBase(CidrDebugProcess process2, @NotNull Class<? extends XBreakpointType<T, ?>> type) {
        if (type == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(0);
        }
        super(type);
        this.myBreakpoints = FactoryMap.create(key -> new ArrayList());
        this.myIdToBreakpoint = new THashMap();
        this.myProcess = process2;
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(1);
        }
        long threadId = this.myProcess.getCurrentThreadId();
        int frameIndex = this.myProcess.getCurrentFrameIndex();
        this.myProcess.postCommand(debuggerDriver -> {
            void driver;
            if (breakpoint == null) {
                CidrCodePointHandlerBase.$$$reportNull$$$0(5);
            }
            this.doRegisterBreakpoint((DebuggerDriver)driver, breakpoint, threadId, frameIndex);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegisterBreakpoint(DebuggerDriver driver, T breakpoint, long threadId, int frameIndex) throws ExecutionException {
        Collection<LLCodepoint> added = this.doAddCodepoints(driver, breakpoint, threadId, frameIndex);
        if (added.isEmpty()) {
            return;
        }
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            this.myBreakpoints.get(breakpoint).addAll(added);
            for (LLCodepoint each : added) {
                int id = each.getId();
                this.myIdToBreakpoint.put(id, breakpoint);
            }
        }
    }

    protected abstract Collection<LLCodepoint> doAddCodepoints(DebuggerDriver var1, T var2, long var3, int var5) throws ExecutionException;

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(2);
        }
        this.myProcess.postCommand(driver -> {
            if (breakpoint == null) {
                CidrCodePointHandlerBase.$$$reportNull$$$0(4);
            }
            try {
                this.doUnregisterBreakpoint(driver, breakpoint);
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException((Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> doUnregisterBreakpoint(T breakpoint) {
        List idsToRemove;
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            List<LLCodepoint> removed = this.myBreakpoints.remove(breakpoint);
            if (removed == null) {
                return Collections.emptyList();
            }
            idsToRemove = ContainerUtil.map(removed, LLCodepoint::getId);
            for (Integer each : idsToRemove) {
                this.myIdToBreakpoint.remove(each);
            }
        }
        return Collections.unmodifiableList(idsToRemove);
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, T breakpoint) throws ExecutionException, DebuggerCommandException {
        List<Integer> idsToRemove;
        if (driver == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(3);
        }
        if (!(idsToRemove = this.doUnregisterBreakpoint(breakpoint)).isEmpty()) {
            this.removeBreakpointInBackend(driver, idsToRemove, breakpoint);
        }
    }

    protected void removeBreakpointInBackend(DebuggerDriver driver, List<Integer> ids, T breakpoint) throws ExecutionException, DebuggerCommandException {
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getCodepoint(int id) {
        Map<T, List<LLCodepoint>> map2 = this.myBreakpoints;
        synchronized (map2) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    @Nullable
    protected String convertCondition(final XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        RunResult result;
        String conversion;
        if (breakpoint.getCondition() != null && (conversion = (String)(result = new WriteAction<String>(){

            protected void run(@NotNull Result<String> stringResult) throws Throwable {
                block3: {
                    if (stringResult == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        stringResult.setResult((Object)CidrEvaluatorHelper.getInstance().convertExpression(CidrCodePointHandlerBase.this.myProcess, breakpoint.getCondition(), breakpoint.getSourcePosition()));
                    }
                    catch (CidrEvaluatorHelper.ConversionException e) {
                        if (!(breakpoint instanceof XLineBreakpoint)) break block3;
                        CidrCodePointHandlerBase.this.myProcess.getSession().updateBreakpointPresentation((XLineBreakpoint)breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, e.getMessage());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringResult", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase$1", "run"));
            }
        }.execute()).getResultObject()) != null) {
            return conversion;
        }
        return breakpoint.getCondition();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doUnregisterBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$unregisterBreakpoint$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$registerBreakpoint$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

