/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExceptionBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrExceptionBreakpointType() {
        this("Exception Breakpoints");
    }

    protected CidrExceptionBreakpointType(String title) {
        super("CidrExceptionBreakpoint", title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return "Invalid Exception Breakpoint";
        }
        Properties.Type thrown = properties.getWhenThrown();
        Properties.Type caught = properties.getWhenCaught();
        if (thrown == null && caught == null) {
            return "Exception Breakpoint";
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("When ");
            if (thrown != null) {
                builder.append(CidrExceptionBreakpointType.formatType(thrown)).append(" is thrown");
            }
            if (caught != null) {
                if (thrown != null) {
                    builder.append("; ");
                }
                builder.append(CidrExceptionBreakpointType.formatType(caught)).append(" is caught");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private static String formatType(@NotNull Properties.Type thrown) {
        if (thrown == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(0);
        }
        String displayString = thrown.getDisplayString();
        return thrown == Properties.Type.ANY_EXCEPTION ? displayString.toLowerCase() : displayString;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_exception_breakpoint;
        if (icon == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    public Properties createProperties() {
        return new Properties();
    }

    public XBreakpoint<Properties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<Properties> creator) {
        if (creator == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(4);
        }
        XBreakpoint breakpoint = creator.createBreakpoint((XBreakpointProperties)this.createProperties());
        breakpoint.setEnabled(false);
        return breakpoint;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomPropertiesPanel() {
        return new CidrExceptionBreakpointPropertiesPanel();
    }

    public XBreakpoint<Properties> addBreakpoint(Project project2, JComponent parentComponent) {
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new Properties()));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrown";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Attribute(value="thrown")
        @Nullable
        private Type myWhenThrown;
        @Attribute(value="caught")
        @Nullable
        private Type myWhenCaught;

        public Properties() {
            this(Type.ANY_EXCEPTION, null);
        }

        public Properties(@Nullable Type whenThrown, @Nullable Type whenCaught) {
            this.myWhenThrown = whenThrown;
            this.myWhenCaught = whenCaught;
        }

        @Nullable
        public Type getWhenThrown() {
            return this.myWhenThrown;
        }

        public void setWhenThrown(@Nullable Type whenThrown) {
            this.myWhenThrown = whenThrown;
        }

        @Nullable
        public Type getWhenCaught() {
            return this.myWhenCaught;
        }

        public void setWhenCaught(@Nullable Type stopOnCaught) {
            this.myWhenCaught = stopOnCaught;
        }

        @NotNull
        public Properties getState() {
            Properties properties = this;
            if (properties == null) {
                Properties.$$$reportNull$$$0(0);
            }
            return properties;
        }

        public void loadState(@NotNull Properties state) {
            if (state == null) {
                Properties.$$$reportNull$$$0(1);
            }
            this.myWhenThrown = state.myWhenThrown;
            this.myWhenCaught = state.myWhenCaught;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Type {
            ANY_EXCEPTION("Any"),
            OBJC_EXCEPTION("Objective-C"){

                @Override
                public boolean isAvailable() {
                    return SystemInfo.isMac;
                }
            };

            private final String myDisplayString;

            private Type(String s) {
                this.myDisplayString = s;
            }

            @NotNull
            public String getDisplayString() {
                String string = this.myDisplayString;
                if (string == null) {
                    Type.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties$Type", "getDisplayString"));
            }
        }
    }
}

