/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.disasm;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0014J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020%J!\u0010$\u001a\u0002H&\"\f\b\u0000\u0010&*\u00060'j\u0002`(2\u0006\u0010)\u001a\u0002H&\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u00020\u001d\"\b\b\u0000\u0010,*\u00020\u00002\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0\u0007H\u0007J\b\u0010.\u001a\u00020%H\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/execution/debugger/disasm/CidrDisasmRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "isAllocated", "", "instructions", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;ZLjava/util/List;)V", "lines", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;)V", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Z)V", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "()Z", "myInstructionMap", "Ljava/util/NavigableMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "myMarkerInDocument", "Lcom/intellij/openapi/editor/RangeMarker;", "getMyMarkerInDocument", "()Lcom/intellij/openapi/editor/RangeMarker;", "myRangeMarker", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "addToDocument", "", "offset", "getInstructionIndex", "address", "getLineNumberInDocument", "getOffsetInDocument", "removeFromDocument", "render", "", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "buffer", "(Ljava/lang/Appendable;)Ljava/lang/Appendable;", "replaceWith", "T", "newRegions", "toString", "intellij.cidr.debugger"})
public final class CidrDisasmRegion
implements AddressSpace.Region {
    @NotNull
    private final AddressRange range;
    private final boolean isAllocated;
    private final NavigableMap<Address, LLInstruction> myInstructionMap;
    private RangeMarker myRangeMarker;

    @Override
    @NotNull
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    public boolean isAllocated() {
        return this.isAllocated;
    }

    private final RangeMarker getMyMarkerInDocument() {
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker == null) {
            throw (Throwable)new IllegalStateException("Region has not been added to a document");
        }
        return rangeMarker;
    }

    @Nullable
    public final Document getDocument() {
        RangeMarker rangeMarker = this.myRangeMarker;
        return rangeMarker != null ? rangeMarker.getDocument() : null;
    }

    @NotNull
    public final <A extends Appendable> A render(@NotNull A buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, (String)"buffer");
        buffer.append("\n! [" + this.getRange() + "]:\n");
        if (this.myInstructionMap != null) {
            Collection collection = this.myInstructionMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"myInstructionMap.values");
            CollectionsKt.joinTo$default((Iterable)collection, buffer, (CharSequence)"", null, null, (int)0, null, (Function1)render.1.INSTANCE, (int)60, null);
        } else {
            buffer.append("!\t");
            buffer.append(this.isAllocated() ? "disassembling..." : "not disassembled yet");
            buffer.append("\n");
        }
        return buffer;
    }

    @NotNull
    public final String render() {
        String string = ((StringBuilder)this.render((Appendable)new StringBuilder())).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"render(StringBuilder()).toString()");
        return string;
    }

    public final int addToDocument(@NotNull Document document, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker != null) {
            RangeMarker rangeMarker2;
            RangeMarker it = rangeMarker2 = rangeMarker;
            throw (Throwable)new IllegalStateException("Attempting to add an already added region at " + it);
        }
        String text = this.render();
        document.insertString(offset, (CharSequence)text);
        this.myRangeMarker = document.createRangeMarker(offset, offset + text.length());
        return text.length();
    }

    public final int removeFromDocument() {
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker == null) {
            throw (Throwable)new IllegalStateException("Attempting to remove a not yet added region");
        }
        RangeMarker marker = rangeMarker;
        int startOffset = marker.getStartOffset();
        marker.getDocument().deleteString(startOffset, marker.getEndOffset());
        marker.dispose();
        this.myRangeMarker = null;
        return startOffset;
    }

    public final <T extends CidrDisasmRegion> int replaceWith(@NotNull List<? extends T> newRegions) {
        CidrDisasmRegion region;
        int i;
        Intrinsics.checkParameterIsNotNull(newRegions, (String)"newRegions");
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker == null) {
            throw (Throwable)new IllegalStateException("Attempting to replace a not yet added region");
        }
        RangeMarker marker = rangeMarker;
        Document document = marker.getDocument();
        int startOffset = marker.getStartOffset();
        StringBuilder sb = new StringBuilder();
        TextRange[] ranges = new TextRange[newRegions.size()];
        Iterable $receiver$iv = newRegions;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n = index$iv++;
            CidrDisasmRegion cidrDisasmRegion = (CidrDisasmRegion)item$iv;
            i = n;
            RangeMarker rangeMarker2 = region.myRangeMarker;
            if (rangeMarker2 != null) {
                RangeMarker rangeMarker3;
                RangeMarker it = rangeMarker3 = rangeMarker2;
                throw (Throwable)new IllegalStateException("Attempting to add an already added region at " + region);
            }
            ranges[i] = new TextRange(startOffset + sb.length(), startOffset + ((StringBuilder)region.render((Appendable)sb)).length());
        }
        document.replaceString(startOffset, marker.getEndOffset(), (CharSequence)sb);
        $receiver$iv = newRegions;
        index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n = index$iv++;
            region = (CidrDisasmRegion)item$iv;
            i = n;
            TextRange textRange = ranges[i];
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            region.myRangeMarker = document.createRangeMarker(textRange);
        }
        marker.dispose();
        this.myRangeMarker = null;
        return startOffset + sb.length();
    }

    public final int getInstructionIndex(@NotNull Address address) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        CidrDisasmRegion cidrDisasmRegion = this;
        int n2 = 1;
        CidrDisasmRegion $receiver = cidrDisasmRegion;
        if (!$receiver.getRange().contains((Comparable)address)) {
            if (address.compareTo($receiver.getRange().getStart()) < 0) {
                n = -1;
            } else {
                NavigableMap<Address, LLInstruction> navigableMap = $receiver.myInstructionMap;
                n = navigableMap != null ? navigableMap.size() : 1;
            }
        } else {
            NavigableMap<Address, LLInstruction> navigableMap = $receiver.myInstructionMap;
            n = navigableMap != null && (navigableMap = navigableMap.subMap(Address.MIN_VALUE, true, address, true)) != null ? navigableMap.size() : 1;
        }
        int n3 = n;
        return n2 + n3;
    }

    public final int getLineNumberInDocument(@NotNull Address address) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        RangeMarker marker = this.getMyMarkerInDocument();
        int regionLineNumber = marker.getDocument().getLineNumber(marker.getStartOffset());
        int instructionIndex = this.getInstructionIndex(address);
        Document document = marker.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"marker.document");
        int it = n = RangesKt.coerceIn((int)(regionLineNumber + instructionIndex), (int)0, (int)(document.getLineCount() - 1));
        if (regionLineNumber + instructionIndex != it) {
            CidrDebuggerLog.LOG.warn("Computed line number " + regionLineNumber + '+' + instructionIndex + " is outside the document boundary " + it);
        }
        return n;
    }

    public final int getOffsetInDocument(@NotNull Address address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        RangeMarker marker = this.getMyMarkerInDocument();
        int lineNumber = this.getLineNumberInDocument(address);
        int n = marker.getDocument().getLineStartOffset(lineNumber);
        Document document = marker.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"marker.document");
        return RangesKt.coerceIn((int)n, (int)0, (int)(document.getTextLength() - 1));
    }

    @NotNull
    public String toString() {
        return "CidrDisasmRegion(range=" + this.getRange() + ", isAllocated=" + this.isAllocated() + ", myRangeMarker=" + this.myRangeMarker + ')';
    }

    /*
     * WARNING - void declaration
     */
    private CidrDisasmRegion(AddressRange range, boolean isAllocated, List<LLInstruction> instructions) {
        TreeMap treeMap;
        boolean bl;
        boolean bl2 = bl = !range.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Range must not be empty";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = isAllocated || instructions == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "An unallocated region must not have content";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.range = range;
        this.isAllocated = isAllocated;
        CidrDisasmRegion cidrDisasmRegion = this;
        List<LLInstruction> list = instructions;
        if (list != null) {
            Collection<Pair> collection;
            void $receiver$iv$iv;
            Collection $receiver$iv;
            TreeMap treeMap2;
            List<LLInstruction> list2 = list;
            CidrDisasmRegion cidrDisasmRegion2 = cidrDisasmRegion;
            List<LLInstruction> it = list2;
            Iterable iterable = instructions;
            TreeMap treeMap3 = treeMap2;
            TreeMap treeMap4 = treeMap2;
            void var9_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                LLInstruction lLInstruction = (LLInstruction)item$iv$iv;
                collection = destination$iv$iv;
                Pair pair2 = TuplesKt.to((Object)it2.getAddress(), (Object)it2);
                collection.add(pair2);
            }
            collection = (List)destination$iv$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)collection;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            if (pairArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            collection = pairArray;
            Pair[] pairArray2 = (Pair[])collection;
            treeMap3(MapsKt.mapOf((Pair[])Arrays.copyOf(pairArray2, pairArray2.length)));
            TreeMap treeMap5 = treeMap4;
            cidrDisasmRegion = cidrDisasmRegion2;
            treeMap = treeMap5;
        } else {
            treeMap = null;
        }
        cidrDisasmRegion.myInstructionMap = treeMap;
    }

    public CidrDisasmRegion(@NotNull AddressRange range, @NotNull List<LLInstruction> lines) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        this(range, true, lines);
    }

    public CidrDisasmRegion(@NotNull AddressRange range, boolean isAllocated) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        this(range, isAllocated, null);
    }
}

