/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.disasm;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.disasm.DisasmFileType;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrDisasmView
implements AddressSpace.Listener<CidrDisasmRegion> {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LightVirtualFile myVirtualFile;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final AddressSpace<CidrDisasmRegion> myAddressSpace;

    public CidrDisasmView(@NotNull CidrDebugProcess process2) {
        if (process2 == null) {
            CidrDisasmView.$$$reportNull$$$0(0);
        }
        this.myProcess = process2;
        this.myVirtualFile = new LightVirtualFile(CidrDebuggerBundle.message("debug.disasm.view.name", this.myProcess.getSession().getSessionName()), (FileType)DisasmFileType.INSTANCE, (CharSequence)"");
        this.myVirtualFile.setWritable(false);
        this.myVirtualFile.putUserData(Iconable.ICON_FLAG_IGNORE_MASK, (Object)2);
        this.myDocument = (Document)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.myVirtualFile);
            CidrDebuggerLog.LOG.assertTrue(document != null, (Object)"null Document returned for newly created LightVirtualFile");
            return document;
        });
        this.myProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                GuiUtils.invokeLaterIfNeeded(() -> {
                    Project project2 = CidrDisasmView.this.myProcess.getProject();
                    if (!project2.isDisposed()) {
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                        fileEditorManager.closeFile((VirtualFile)CidrDisasmView.this.myVirtualFile);
                    }
                }, (ModalityState)ModalityState.defaultModalityState());
            }
        });
        this.myAddressSpace = new AddressSpace<CidrDisasmRegion>(CidrDisasmRegion::new);
        this.myAddressSpace.addListener(this);
        this.postWriteAction(() -> this.myAddressSpace.get(Address.NULL).addToDocument(this.myDocument, 0));
    }

    private void requestDisassemblingForMissingRanges(@NotNull Address address) {
        if (address == null) {
            CidrDisasmView.$$$reportNull$$$0(1);
        }
        this.postWriteAction(() -> {
            if (address == null) {
                CidrDisasmView.$$$reportNull$$$0(10);
            }
            List<AddressRange> ranges = this.myAddressSpace.preallocate(address);
            for (final AddressRange range : ranges) {
                this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand(){

                    @Override
                    public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                        if (driver == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        try {
                            List<LLInstruction> result = driver.disassemble(range);
                            CidrDisasmRegion region = new CidrDisasmRegion(range, result);
                            CidrDisasmView.this.postWriteAction(() -> CidrDisasmView.this.myAddressSpace.save(region));
                        }
                        catch (DebuggerCommandException e) {
                            CidrDebuggerLog.LOG.warn((Throwable)e);
                            CidrDisasmView.this.postWriteAction(() -> CidrDisasmView.this.myAddressSpace.unallocate(range));
                        }
                    }

                    @Override
                    public void rejected(@NotNull String reason) {
                        if (reason == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        CidrDebuggerLog.LOG.warn(reason);
                        CidrDisasmView.this.postWriteAction(() -> CidrDisasmView.this.myAddressSpace.unallocate(range));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "driver";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "reason";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/disasm/CidrDisasmView$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "rejected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        });
    }

    public XSourcePosition disassemble(final @NotNull Address address) {
        if (address == null) {
            CidrDisasmView.$$$reportNull$$$0(2);
        }
        return new XSourcePosition(){
            private boolean myRequested;

            private void requestDisassemblingIfNeeded() {
                if (!this.myRequested) {
                    CidrDisasmView.this.requestDisassemblingForMissingRanges(address);
                    this.myRequested = true;
                }
            }

            public int getLine() {
                this.requestDisassemblingIfNeeded();
                return (Integer)ReadAction.compute(() -> {
                    if (address == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return ((CidrDisasmRegion)CidrDisasmView.this.myAddressSpace.get(address)).getLineNumberInDocument(address);
                });
            }

            public int getOffset() {
                this.requestDisassemblingIfNeeded();
                return (Integer)ReadAction.compute(() -> {
                    if (address == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return ((CidrDisasmRegion)CidrDisasmView.this.myAddressSpace.get(address)).getOffsetInDocument(address);
                });
            }

            @NotNull
            public VirtualFile getFile() {
                LightVirtualFile lightVirtualFile = CidrDisasmView.this.myVirtualFile;
                if (lightVirtualFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                return lightVirtualFile;
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project2, (XSourcePosition)this);
                if (openFileDescriptor == null) {
                    3.$$$reportNull$$$0(2);
                }
                return openFileDescriptor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/disasm/CidrDisasmView$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "address";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/disasm/CidrDisasmView$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNavigatable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createNavigatable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getOffset$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getLine$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public void regionSplit(@NotNull CidrDisasmRegion oldRegion, @NotNull List<? extends CidrDisasmRegion> newRegions) {
        if (oldRegion == null) {
            CidrDisasmView.$$$reportNull$$$0(3);
        }
        if (newRegions == null) {
            CidrDisasmView.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        oldRegion.replaceWith(newRegions);
    }

    @NotNull
    private Runnable withDocumentWritable(@NotNull Runnable action) {
        if (action == null) {
            CidrDisasmView.$$$reportNull$$$0(5);
        }
        Runnable runnable2 = () -> {
            if (action == null) {
                CidrDisasmView.$$$reportNull$$$0(9);
            }
            boolean wasWritable = this.myDocument.isWritable();
            this.myDocument.setReadOnly(false);
            try {
                action.run();
                this.myDocument.setReadOnly(!wasWritable);
            }
            catch (Throwable throwable) {
                this.myDocument.setReadOnly(!wasWritable);
                throw throwable;
            }
        };
        if (runnable2 == null) {
            CidrDisasmView.$$$reportNull$$$0(6);
        }
        return runnable2;
    }

    private void postWriteAction(@NotNull Runnable action) {
        if (action == null) {
            CidrDisasmView.$$$reportNull$$$0(7);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (action == null) {
                CidrDisasmView.$$$reportNull$$$0(8);
            }
            DocumentUtil.writeInRunUndoTransparentAction((Runnable)this.withDocumentWritable(action));
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRegion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRegions";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/disasm/CidrDisasmView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/disasm/CidrDisasmView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withDocumentWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestDisassemblingForMissingRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "regionSplit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentWritable";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "postWriteAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postWriteAction$4";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$withDocumentWritable$3";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestDisassemblingForMissingRanges$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

