/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggerTypesHelper {
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("Swift\\.(ImplicitlyUnwrapped)?Optional<(.*?)>");
    protected CidrDebugProcess myProcess;

    public CidrDebuggerTypesHelper(CidrDebugProcess process2) {
        this.myProcess = process2;
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project2) {
        if (project2 == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(0);
        }
        if (sourcePosition == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        return CidrDebuggerTypesHelper.findContextElement(sourcePosition, document, psiFile);
    }

    @Nullable
    private static PsiElement findContextElement(XSourcePosition sourcePosition, Document document, PsiFile psiFile) {
        PsiElement element;
        int positionOffset = sourcePosition.getOffset();
        if (!DocumentUtil.isValidOffset((int)positionOffset, (Document)document)) {
            return null;
        }
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(positionOffset));
        int offset = positionOffset;
        while ((element = psiFile.findElementAt(offset)) != null) {
            if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                return element;
            }
            offset = element.getTextRange().getEndOffset() + 1;
            if (offset < lineEndOffset) continue;
        }
        return psiFile.findElementAt(positionOffset);
    }

    @Nullable
    public XSourcePosition computeSourcePosition(XSourcePosition position, LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(resolved.getContainingFile().getVirtualFile(), resolved.getTextOffset());
    }

    @Nullable
    public Integer getSizeOf(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public abstract XSourcePosition computeSourcePosition(@NotNull CidrMemberValue var1);

    public PsiElement getContextElement(XSourcePosition position) {
        return CidrDebuggerTypesHelper.getContextElement(position, this.myProcess.getProject());
    }

    @Nullable
    public abstract XSourcePosition resolveProperty(@NotNull CidrMemberValue var1, @Nullable String var2);

    public PsiElement resolveToDeclaration(XSourcePosition position, LLValue var) {
        PsiElement context = this.getContextElement(position);
        if (context == null) {
            return null;
        }
        PsiReference ref = this.createReferenceFromText(var, context);
        if (ref == null) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (resolved == null) {
            return null;
        }
        if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
            return null;
        }
        return resolved;
    }

    @Nullable
    protected abstract PsiReference createReferenceFromText(@NotNull LLValue var1, @NotNull PsiElement var2);

    @Nullable
    public abstract Boolean isImplicitContextVariable(@NotNull XSourcePosition var1, @NotNull LLValue var2);

    @Nullable
    public static String unwrapSwiftOptionalType(@NotNull String typeName) {
        Matcher m;
        if (typeName == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(2);
        }
        return (m = OPTIONAL_PATTERN.matcher(typeName)).matches() ? m.group(2) : null;
    }

    @NotNull
    public static String unwrapSwiftOptionalTypeIfNecessary(@NotNull String typeName) {
        if (typeName == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(3);
        }
        String string = StringUtil.notNullize((String)CidrDebuggerTypesHelper.unwrapSwiftOptionalType(typeName), (String)typeName);
        if (string == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSwiftOptionalTypeIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSizeOf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSwiftOptionalType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSwiftOptionalTypeIfNecessary";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

