/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValuePresentationKt;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    public static final Key THROW_ON_TYPE = Key.create((String)"THROW_ON_TYPE");
    public static final Key THROW_ON_ICON = Key.create((String)"THROW_ON_ICON");
    public static final Key THROW_ON_VALUE = Key.create((String)"THROW_ON_VALUE");
    public static final Key THROW_ON_HAS_CHILDREN = Key.create((String)"THROW_ON_CHILDREN_COUNT");
    public static final Key THROW_ON_CHILDREN = Key.create((String)"THROW_ON_CHILDREN");
    @NotNull
    private final LLValue myVar;
    @Nullable
    private volatile LLValue myPresentationVar;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myVarDataResult;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myPresentationVarDataResult;
    @NotNull
    private final CachedDebuggerResult<ValueRenderer> myRendererResult;

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        if (var == null) {
            CidrPhysicalValue.$$$reportNull$$$0(0);
        }
        if (process2 == null) {
            CidrPhysicalValue.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrPhysicalValue.$$$reportNull$$$0(2);
        }
        this(var, var.getName(), process2, position, frame);
    }

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull String displayName, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        if (var == null) {
            CidrPhysicalValue.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            CidrPhysicalValue.$$$reportNull$$$0(4);
        }
        if (process2 == null) {
            CidrPhysicalValue.$$$reportNull$$$0(5);
        }
        if (frame == null) {
            CidrPhysicalValue.$$$reportNull$$$0(6);
        }
        super(displayName, process2, position, frame);
        this.myVarDataResult = new CachedDebuggerResult();
        this.myPresentationVarDataResult = new CachedDebuggerResult();
        this.myRendererResult = new CachedDebuggerResult();
        this.myVar = var;
    }

    @NotNull
    public ValueRenderer getPreparedRenderer() {
        ValueRenderer result = this.myRendererResult.getResultIfAvailable();
        if (result == null) {
            CidrDebuggerLog.LOG.error("getPreparedRenderer() called before getRenderer()");
            ValueRenderer valueRenderer = new ValueRenderer(this);
            if (valueRenderer == null) {
                CidrPhysicalValue.$$$reportNull$$$0(7);
            }
            return valueRenderer;
        }
        ValueRenderer valueRenderer = result;
        if (valueRenderer == null) {
            CidrPhysicalValue.$$$reportNull$$$0(8);
        }
        return valueRenderer;
    }

    @NotNull
    public ValueRenderer getRenderer(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(9);
        }
        ValueRenderer valueRenderer = this.myRendererResult.getResult(new CachedDebuggerResult.NotNullCalculator<ValueRenderer>(){

            @Override
            @NotNull
            public ValueRenderer calculate() throws ExecutionException, DebuggerCommandException {
                ValueRenderer valueRenderer = CidrPhysicalValue.this.doCreateRenderer(context);
                if (valueRenderer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return valueRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$1", "calculate"));
            }
        });
        if (valueRenderer == null) {
            CidrPhysicalValue.$$$reportNull$$$0(10);
        }
        return valueRenderer;
    }

    @NotNull
    protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(11);
        }
        ValueRenderer valueRenderer = ValueRendererFactory.createRenderer(context, this);
        if (valueRenderer == null) {
            CidrPhysicalValue.$$$reportNull$$$0(12);
        }
        return valueRenderer;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.myVar.getReferenceExpression();
        if (string == null) {
            CidrPhysicalValue.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public LLValue getVar() {
        LLValue lLValue = this.myVar;
        if (lLValue == null) {
            CidrPhysicalValue.$$$reportNull$$$0(14);
        }
        return lLValue;
    }

    @NotNull
    public LLValue getPresentationVar() {
        LLValue presentationVar = this.myPresentationVar;
        LLValue lLValue = presentationVar != null ? presentationVar : this.myVar;
        if (lLValue == null) {
            CidrPhysicalValue.$$$reportNull$$$0(15);
        }
        return lLValue;
    }

    public void setPresentationVar(@Nullable LLValue presentationVar) {
        this.myPresentationVar = presentationVar;
    }

    public String getType() {
        return this.myVar.getType();
    }

    public boolean isValueDataAvailable() {
        return this.myVarDataResult.getResultIfAvailable() != null;
    }

    @NotNull
    public LLValueData getPreparedVarData() {
        LLValueData result = this.myVarDataResult.getResultIfAvailable();
        if (result == null) {
            CidrDebuggerLog.LOG.error("getPreparedVarData() called before getVarData()");
            LLValueData lLValueData = new LLValueData("", null, false, false, false);
            if (lLValueData == null) {
                CidrPhysicalValue.$$$reportNull$$$0(16);
            }
            return lLValueData;
        }
        LLValueData lLValueData = result;
        if (lLValueData == null) {
            CidrPhysicalValue.$$$reportNull$$$0(17);
        }
        return lLValueData;
    }

    @NotNull
    public LLValueData getVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(18);
        }
        LLValueData lLValueData = this.myVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData lLValueData = context.getData(CidrPhysicalValue.this.myVar);
                if (lLValueData == null) {
                    2.$$$reportNull$$$0(0);
                }
                return lLValueData;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$2", "calculate"));
            }
        });
        if (lLValueData == null) {
            CidrPhysicalValue.$$$reportNull$$$0(19);
        }
        return lLValueData;
    }

    @NotNull
    public LLValueData getPresentationVarData(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        LLValue presentationVar;
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(20);
        }
        if ((presentationVar = this.myPresentationVar) == null) {
            LLValueData lLValueData = this.getVarData(context);
            if (lLValueData == null) {
                CidrPhysicalValue.$$$reportNull$$$0(21);
            }
            return lLValueData;
        }
        LLValueData lLValueData = this.myPresentationVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData lLValueData = context.getData(presentationVar);
                if (lLValueData == null) {
                    3.$$$reportNull$$$0(0);
                }
                return lLValueData;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$3", "calculate"));
            }
        });
        if (lLValueData == null) {
            CidrPhysicalValue.$$$reportNull$$$0(22);
        }
        return lLValueData;
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        LLValueData data;
        String pointer;
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(23);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_TYPE);
        String type = this.getRenderer(context).getDisplayType();
        if (this.getProcess().getProject().getUserData(DO_NOT_SHOW_ADDRESSES) != Boolean.TRUE && (pointer = (data = this.getVarData(context)).getPresentablePointer()) != null) {
            type = type + " | " + pointer;
        }
        return type;
    }

    @Nullable
    public String getShownAddress() {
        if (!this.isValueDataAvailable()) {
            return null;
        }
        return this.getPreparedVarData().getPresentablePointer();
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(24);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VALUE);
        Pair<String, XFullValueEvaluator> pair2 = this.getRenderer(context).computeValueAndEvaluator(context);
        if (pair2 == null) {
            CidrPhysicalValue.$$$reportNull$$$0(25);
        }
        return pair2;
    }

    @Override
    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        boolean isNumberFormattingEnabled;
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(26);
        }
        if (value == null) {
            CidrPhysicalValue.$$$reportNull$$$0(27);
        }
        XValuePresentation valuePresentation = null;
        boolean bl = isNumberFormattingEnabled = Registry.is((String)"cidr.debugger.value.numberFormatting.hex", (boolean)false) || ApplicationManager.getApplication().isUnitTestMode();
        if (isNumberFormattingEnabled) {
            valuePresentation = this.createNumberValuePresentation(context, value, type);
        }
        if (valuePresentation == null) {
            valuePresentation = super.createValuePresentation(context, value, type);
        }
        XValuePresentation xValuePresentation = valuePresentation;
        if (xValuePresentation == null) {
            CidrPhysicalValue.$$$reportNull$$$0(28);
        }
        return xValuePresentation;
    }

    @Nullable
    protected XValuePresentation createNumberValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        long number;
        LLValueData valueData;
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(29);
        }
        if (value == null) {
            CidrPhysicalValue.$$$reportNull$$$0(30);
        }
        if ((valueData = this.getPresentationVarData(context)).isPointer()) {
            return null;
        }
        Pair<String, String> numberAndData = valueData.splitNumberAndData();
        String numberText = (String)numberAndData.first;
        if (numberText == null) {
            return null;
        }
        if (!value.startsWith(numberText)) {
            return null;
        }
        String text = value.substring(numberText.length());
        try {
            number = Long.decode(numberText);
        }
        catch (NumberFormatException ignored) {
            number = 0L;
        }
        boolean isHex = CidrDebuggerSettings.getInstance().HEX_FORMATTING_ENABLED;
        if (!isHex) {
            return new CidrNumberValuePresentation(value, type, numberText, text);
        }
        Integer sizeof = this.getTypesHelper().getSizeOf(this);
        int sizeBits = sizeof != null ? sizeof * 8 : 64;
        boolean isHexAsSecondary = CidrDebuggerSettings.getInstance().HEX_AS_SECONDARY_FORMATTING_ENABLED;
        return ValuePresentationKt.createHexValuePresentation(value, type, numberText, text, number, sizeBits, isHexAsSecondary);
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(31);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_HAS_CHILDREN);
        return this.getRenderer(context).computeMayHaveChildren(context);
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(32);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_ICON);
        return this.getRenderer(context).getIcon(hasChildren);
    }

    @Override
    public final void computeValueChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrPhysicalValue.$$$reportNull$$$0(33);
        }
        this.getProcess().postCommand(driver -> {
            if (node == null) {
                CidrPhysicalValue.$$$reportNull$$$0(37);
            }
            if (node.isObsolete()) {
                return;
            }
            try {
                ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_CHILDREN);
                EvaluationContext context = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
                this.getRenderer(context).computeChildren(context, node);
            }
            catch (DebuggerCommandException e) {
                node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
            }
            catch (ExecutionException e) {
                node.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)))), true);
                throw e;
            }
        });
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrPhysicalValue.$$$reportNull$$$0(34);
        }
        String string = this.getRenderer(context).getConsoleDescription(context).toString();
        if (string == null) {
            CidrPhysicalValue.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        CidrDebuggerTypesHelper cidrDebuggerTypesHelper = this.getProcess().getTypesHelper(this.getFrame());
        if (cidrDebuggerTypesHelper == null) {
            CidrPhysicalValue.$$$reportNull$$$0(36);
        }
        return cidrDebuggerTypesHelper;
    }

    public String toString() {
        return this.getVar().toString();
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.getFrame().getFrame().getLanguage();
    }

    public boolean isObjectiveCContext() {
        DebuggerDriver.DebuggerLanguage l = this.getLanguage();
        return l == DebuggerDriver.StandardDebuggerLanguage.OBJC || l == DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
    }

    public boolean isSwiftContext() {
        return this.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
    }

    public boolean isSwiftOptional() {
        return this.isSwiftContext() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(this.getType()) != null;
    }

    public boolean isSwiftVoid() {
        return this.isSwiftContext() && "()".equals(this.getType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue";
                break;
            }
            case 9: 
            case 11: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRenderer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationVar";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedVarData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationVarData";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createValuePresentation";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleDescription";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 36: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRenderer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getVarData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationVarData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doComputeType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createValuePresentation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createNumberValuePresentation";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doComputeMayHaveChildren";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIcon";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeValueChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDescription";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeValueChildren$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

