/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.ExpiredException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationContext {
    private static final Key<Map<String, UserDataHolder>> TYPES_CACHE_KEY = Key.create((String)"TYPES_CACHE_KEY");
    @NotNull
    private final CidrStackFrame myFrame;
    protected final long myThreadId;
    protected final int myFrameIndex;
    @NotNull
    private final DebuggerDriver myDriver;
    @Nullable
    private final Expirable myExpirable;

    public EvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        if (driver == null) {
            EvaluationContext.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            EvaluationContext.$$$reportNull$$$0(1);
        }
        this.myThreadId = frame.getThreadId();
        this.myFrameIndex = frame.getFrameIndex();
        this.myFrame = frame;
        this.myDriver = driver;
        this.myExpirable = expirable;
    }

    public void checkExpiration() {
        if (this.myExpirable != null && this.myExpirable.isExpired()) {
            throw new ExpiredException(this, this.myExpirable);
        }
    }

    @NotNull
    public LLValue evaluate(@NotNull String expression) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(2);
        }
        LLValue lLValue = this.evaluate(expression, null);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(3);
        }
        return lLValue;
    }

    @NotNull
    public LLValueData evaluateData(@NotNull String expression) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(4);
        }
        LLValueData lLValueData = this.getData(this.evaluate(expression, null));
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(5);
        }
        return lLValueData;
    }

    @NotNull
    public LLValue evaluate(@NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(6);
        }
        this.checkExpiration();
        LLValue lLValue = this.myDriver.evaluate(this.myThreadId, this.myFrameIndex, expression, language);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(7);
        }
        return lLValue;
    }

    @NotNull
    public LLValueData evaluateData(@NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(8);
        }
        LLValueData lLValueData = this.getData(this.evaluate(expression, language));
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(9);
        }
        return lLValueData;
    }

    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            EvaluationContext.$$$reportNull$$$0(10);
        }
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(11);
        }
        String string = EvaluationContext.cast(expr, type);
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public abstract String convertToRValue(@NotNull LLValueData var1, @NotNull Pair<LLValue, String> var2) throws DebuggerCommandException, ExecutionException;

    public static String cast(String expr, String type) {
        return "((" + type + ")(" + expr + "))";
    }

    @NotNull
    public LLValue messageSend(LLValueData self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.evaluate(EvaluationContext.messageSendExpr(self.getPointer(), selectorAndArgs, returnType), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(13);
        }
        return lLValue;
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.messageSend(this.getData(self), selectorAndArgs, returnType);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(14);
        }
        return lLValue;
    }

    protected static String messageSendExpr(String expr, String selectorAndArgs, String returnType) {
        return EvaluationContext.cast("[" + EvaluationContext.cast(expr, "id") + " " + selectorAndArgs + "]", returnType);
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.messageSend(self, selectorAndArgs, "id");
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(15);
        }
        return lLValue;
    }

    @NotNull
    public LLValueData messageSendData(LLValue self, String selectorAndArgs) throws ExecutionException, DebuggerCommandException {
        LLValueData lLValueData = this.getData(this.messageSend(self, selectorAndArgs));
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(16);
        }
        return lLValueData;
    }

    public boolean isKindOfClass(String className, LLValue value) throws ExecutionException, DebuggerCommandException {
        return this.evaluateData("(unsigned char)((Class)objc_getClass(\"" + className + "\")?" + EvaluationContext.cast("[" + EvaluationContext.cast(this.getData(value).getPointer(), "id") + " isKindOfClass:(Class)objc_lookUpClass(\"" + className + "\")]", "unsigned char") + ":0)", DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).isTrue();
    }

    @NotNull
    public String stringFromNSString(LLValue nsstring) throws ExecutionException, DebuggerCommandException {
        String string = this.stringFromNSString(this.getData(nsstring).getPointer());
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String stringFromNSString(String expr) throws ExecutionException, DebuggerCommandException {
        String string = StringUtil.unquoteString((String)this.evaluateData(EvaluationContext.stringFromNSStringExpr(expr), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).getPresentableValue());
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static String stringFromNSStringExpr(String expr) {
        String lengthExpr = EvaluationContext.messageSendExpr(expr, "length", "int");
        String substringExpr = EvaluationContext.messageSendExpr(expr, "substringToIndex:" + String.format("(((%s) > %d) ? %d : %s)", lengthExpr, 1000, 1000, lengthExpr), "id");
        return EvaluationContext.messageSendExpr(substringExpr, "UTF8String", "char *");
    }

    @NotNull
    public LLValueData getData(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            EvaluationContext.$$$reportNull$$$0(19);
        }
        this.checkExpiration();
        LLValueData lLValueData = this.myDriver.getData(var);
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(20);
        }
        return lLValueData;
    }

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var, int max) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            EvaluationContext.$$$reportNull$$$0(21);
        }
        this.checkExpiration();
        return this.myDriver.getChildrenCount(var, max);
    }

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            EvaluationContext.$$$reportNull$$$0(22);
        }
        this.checkExpiration();
        return this.myDriver.getChildrenCount(var);
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue var, int offset, int size) throws ExecutionException, DebuggerCommandException {
        this.checkExpiration();
        DebuggerDriver.ResultList<LLValue> resultList = this.myDriver.getVariableChildren(var, offset, size);
        if (resultList == null) {
            EvaluationContext.$$$reportNull$$$0(23);
        }
        return resultList;
    }

    @Nullable
    public <T> T getCachedTypeInfo(@NotNull String type, @NotNull Key<T> key) {
        UserDataHolder holder;
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(24);
        }
        if (key == null) {
            EvaluationContext.$$$reportNull$$$0(25);
        }
        return (T)((holder = this.getTypeInfoHolder(type)) == null ? null : holder.getUserData(key));
    }

    public <T> void putCachedTypeInfo(@NotNull String type, @NotNull Key<T> key, @Nullable T value) {
        UserDataHolder holder;
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(26);
        }
        if (key == null) {
            EvaluationContext.$$$reportNull$$$0(27);
        }
        if ((holder = this.getTypeInfoHolder(type)) != null) {
            holder.putUserData(key, value);
        }
    }

    @Nullable
    private UserDataHolder getTypeInfoHolder(@NotNull String type) {
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(28);
        }
        if (type.equals("id")) {
            return null;
        }
        Map map2 = this.myFrame.getUserData(TYPES_CACHE_KEY);
        if (map2 == null) {
            map2 = this.myFrame.putUserDataIfAbsent(TYPES_CACHE_KEY, FactoryMap.create(key -> new UserDataHolderBase()));
        }
        return map2.get(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 11: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/EvaluationContext";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "castIDToNumber";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "messageSend";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "messageSendData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stringFromNSString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "castIDToNumber";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCachedTypeInfo";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putCachedTypeInfo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

