/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.jetbrains.cidr.execution.debugger.evaluation.CidrFormattedNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberWithAdditionalFormatValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.TextWithPattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001aD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0001\u001a\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"unsignedHexNumberPattern", "Lkotlin/text/Regex;", "getUnsignedHexNumberPattern", "()Lkotlin/text/Regex;", "createHexValuePresentation", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrNumberValuePresentation;", "value", "", "type", "numberText", "stringText", "number", "", "sizeBits", "", "asSecondaryFormat", "", "formatHexValue", "intellij.cidr.debugger"})
public final class ValuePresentationKt {
    @NotNull
    private static final Regex unsignedHexNumberPattern = new Regex("^0x(\\p{XDigit}+)$");

    @NotNull
    public static final Regex getUnsignedHexNumberPattern() {
        return unsignedHexNumberPattern;
    }

    @JvmOverloads
    @NotNull
    public static final CidrNumberValuePresentation createHexValuePresentation(@NotNull String value, @Nullable String type, @NotNull String numberText, @NotNull String stringText, long number, int sizeBits, boolean asSecondaryFormat) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)numberText, (String)"numberText");
        Intrinsics.checkParameterIsNotNull((Object)stringText, (String)"stringText");
        TextWithPattern hexFormattedNumber = new TextWithPattern(ValuePresentationKt.formatHexValue(number, sizeBits), unsignedHexNumberPattern);
        return asSecondaryFormat ? (CidrNumberValuePresentation)new CidrNumberWithAdditionalFormatValuePresentation(value, type, numberText, stringText, hexFormattedNumber) : (CidrNumberValuePresentation)new CidrFormattedNumberValuePresentation(value, type, hexFormattedNumber, stringText);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ CidrNumberValuePresentation createHexValuePresentation$default(String string, String string2, String string3, String string4, long l, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        return ValuePresentationKt.createHexValuePresentation(string, string2, string3, string4, l, n, bl);
    }

    @JvmOverloads
    @NotNull
    public static final CidrNumberValuePresentation createHexValuePresentation(@NotNull String value, @Nullable String type, @NotNull String numberText, @NotNull String stringText, long number, int sizeBits) {
        return ValuePresentationKt.createHexValuePresentation$default(value, type, numberText, stringText, number, sizeBits, false, 64, null);
    }

    @NotNull
    public static final String formatHexValue(long number, int sizeBits) {
        long mask = sizeBits < 64 ? (1L << sizeBits) - 1L : 0L ^ 0xFFFFFFFFFFFFFFFFL;
        return "0x" + Long.toUnsignedString(number & mask, 16);
    }
}

