/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    private static final Pattern SWIFT_DESCRIPTION_PATTERN = Pattern.compile("( *((\u25bf .*)|(- .*? : .*?))(\n|$))*");
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final CachedDebuggerResult<Pair<String, XFullValueEvaluator>> myValueCache;
    @NotNull
    private final CachedDebuggerResult<Boolean> myMayHaveChildrenCache;
    protected int myCurrentIndex;

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(0);
        }
        this.myValueCache = new CachedDebuggerResult();
        this.myMayHaveChildrenCache = new CachedDebuggerResult();
        this.myCurrentIndex = 0;
        this.myValue = value;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        CidrPhysicalValue cidrPhysicalValue = this.myValue;
        if (cidrPhysicalValue == null) {
            ValueRenderer.$$$reportNull$$$0(1);
        }
        return cidrPhysicalValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            ValueRenderer.$$$reportNull$$$0(2);
        }
        boolean isPointer = this.myValue.getPreparedVarData().isPointer();
        boolean isSwift = this.myValue.isSwiftContext();
        if (child.getName().matches("\\[\\w+\\]")) {
            String string = this.getChildEvaluationExpression(child, "", this.myValue);
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (!isSwift && isPointer) {
            String string = this.getChildEvaluationExpression(child, "->", this.myValue);
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (!isSwift && this.myValue instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)this.myValue;
            if (value.getIndex() == 0) {
                String string = this.getChildEvaluationExpression(child, "->", value.getContainer());
                if (string == null) {
                    ValueRenderer.$$$reportNull$$$0(5);
                }
                return string;
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                String string = parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
                if (string == null) {
                    ValueRenderer.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        String string = this.getChildEvaluationExpression(child, ".", this.myValue);
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(7);
        }
        return string;
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValueData messageSendToSelfData(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.getData(this.messageSendToSelf(selectorAndArgs, returnType, context));
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(8);
        }
        StringBuilder builder = new StringBuilder();
        try {
            boolean hasChildren;
            String value = (String)this.computeValueAndEvaluator((EvaluationContext)context).first;
            builder.append("(").append(this.myValue.getType()).append((") " + value).trim());
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeMayHaveChildren(context))) {
                builder.append("\n");
                this.printChildrenConsoleDescription(context, builder);
            }
        }
        catch (DebuggerCommandException e) {
            ValueRenderer.appendConsoleError(builder, this.toString());
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            ValueRenderer.$$$reportNull$$$0(9);
        }
        return stringBuilder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    private void printChildrenConsoleDescription(EvaluationContext context, StringBuilder builder) throws ExecutionException, DebuggerCommandException {
        builder.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder, context);
        try {
            this.computeChildren(context, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder, @NotNull String errorMessage) {
        if (errorMessage == null) {
            ValueRenderer.$$$reportNull$$$0(10);
        }
        builder.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        String string = ValueRenderer.getShortenedType(this.myValue.getVar().getType());
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getShortenedType(@NotNull String type) {
        if (type == null) {
            ValueRenderer.$$$reportNull$$$0(12);
        }
        int TEMPLATE_TYPE_REDUCE_LEVEL = 1;
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '<') {
                ++count;
            }
            if (count <= TEMPLATE_TYPE_REDUCE_LEVEL) {
                int length = result.length();
                if (c == '>' && length > 2 && result.charAt(length - 1) == ' ' && result.charAt(length - 2) != '>') {
                    result.setLength(length - 1);
                }
                result.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        String string = count == 0 ? result.toString() : type;
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String separator, CidrPhysicalValue parent) {
        boolean cast;
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, separator, parent);
        }
        String parentRefExpression = parent.getEvaluationExpression();
        boolean bl = cast = parent.getVar().getTypeClass() == LLValue.TypeClass.OBJC_POINTER;
        if (cast) {
            parentRefExpression = "((" + parent.getType() + ")(" + parentRefExpression + "))";
        }
        return parentRefExpression + separator + child.getVar().getName();
    }

    @NotNull
    public Pair<String, XFullValueEvaluator> computeValueAndEvaluator(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(14);
        }
        Pair<String, XFullValueEvaluator> pair2 = this.myValueCache.getResult(new CachedDebuggerResult.NotNullCalculator<Pair<String, XFullValueEvaluator>>(){

            @Override
            @NotNull
            public Pair<String, XFullValueEvaluator> calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                if (data.isNullPointer()) {
                    LLValue var = ValueRenderer.this.getValue().getVar();
                    boolean objc = var.getTypeClass() == LLValue.TypeClass.OBJC_POINTER || "id".equals(var.getType()) && ValueRenderer.this.getValue().isObjectiveCContext();
                    Pair pair2 = Pair.create((Object)(objc ? "nil" : "NULL"), null);
                    if (pair2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return pair2;
                }
                if (ValueRenderer.this.myValue.isSwiftVoid()) {
                    Pair pair3 = Pair.create((Object)"", null);
                    if (pair3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return pair3;
                }
                Pair result = ValueRenderer.this.doComputeValueAndEvaluator(context);
                Pair pair4 = ((String)result.first).equals("{...}") ? Pair.create((Object)"", null) : result;
                if (pair4 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return pair4;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$1", "calculate"));
            }
        });
        if (pair2 == null) {
            ValueRenderer.$$$reportNull$$$0(15);
        }
        return pair2;
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(16);
        }
        Pair<String, XFullValueEvaluator> pair2 = this.doComputeValueAndEvaluator(context, this.myValue.getPresentationVar(), this.myValue.getPresentationVarData(context));
        if (pair2 == null) {
            ValueRenderer.$$$reportNull$$$0(17);
        }
        return pair2;
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context, LLValue var, LLValueData data) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(18);
        }
        String description = data.getDescription();
        Pair result = null;
        if (description != null) {
            if (this.myValue.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT) {
                description = StringUtil.unescapeStringCharacters((String)description);
            }
            if (!this.ignoreDescription(description = description.trim())) {
                result = Pair.create((Object)StringUtil.first((String)description, (int)1000, (boolean)false), data.hasLongerDescription() ? this.createFullDescriptionEvaluator(var) : null);
            }
        }
        if (result == null) {
            description = this.doComputeFallbackValue(context, var, data);
            ImmediateFullValueEvaluator evaluator = null;
            if (description.length() > 1000) {
                evaluator = new ImmediateFullValueEvaluator(description);
            }
            result = Pair.create((Object)StringUtil.first((String)description, (int)1000, (boolean)false), (Object)evaluator);
        }
        Pair pair2 = result;
        if (pair2 == null) {
            ValueRenderer.$$$reportNull$$$0(19);
        }
        return pair2;
    }

    protected boolean ignoreDescription(@NotNull String description) {
        DebuggerDriver.DebuggerLanguage language;
        if (description == null) {
            ValueRenderer.$$$reportNull$$$0(20);
        }
        return (language = this.myValue.getLanguage()) == DebuggerDriver.StandardDebuggerLanguage.OBJC && StringUtil.containsLineBreak((CharSequence)description) || language == DebuggerDriver.StandardDebuggerLanguage.SWIFT && SWIFT_DESCRIPTION_PATTERN.matcher(description).matches();
    }

    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(21);
        }
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(22);
        }
        if (data == null) {
            ValueRenderer.$$$reportNull$$$0(23);
        }
        String string = data.getValue();
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    private XFullValueEvaluator createFullDescriptionEvaluator(final @NotNull LLValue value) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(25);
        }
        return new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    2.$$$reportNull$$$0(0);
                }
                ValueRenderer.this.getValue().getProcess().postCommand(driver -> {
                    if (callback == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (value == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (callback.isObsolete()) {
                        return;
                    }
                    try {
                        int _10mb = 0xA00000;
                        String description = driver.getDescription(value, _10mb);
                        callback.evaluated(StringUtil.notNullize((String)description));
                    }
                    catch (DebuggerCommandException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callback";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startEvaluation";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$startEvaluation$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean computeMayHaveChildren(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        Integer result;
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(26);
        }
        if (this.mayHaveChildrenViaChildrenCount() && (result = this.computeChildrenCount(context, 1)) != null) {
            return result > 0;
        }
        return this.myMayHaveChildrenCache.getResult(new CachedDebuggerResult.NotNullCalculator<Boolean>(){

            @Override
            @NotNull
            public Boolean calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                Boolean bl = data.isNullPointer() || ValueRenderer.this.myValue.isSwiftVoid() ? false : data.mayHaveChildren();
                if (bl == null) {
                    3.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$3", "calculate"));
            }
        });
    }

    protected boolean mayHaveChildrenViaChildrenCount() {
        return false;
    }

    @Nullable
    protected Integer computeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(27);
        }
        return this.computeChildrenCount(context, Integer.MAX_VALUE);
    }

    @Nullable
    private Integer computeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DebuggerCommandException {
        LLValueData data;
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(28);
        }
        return (data = this.myValue.getVarData(context)).isNullPointer() || this.myValue.isSwiftVoid() ? new Integer(0) : this.doComputeChildrenCount(context, max);
    }

    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(29);
        }
        return context.getChildrenCount(this.myValue.getPresentationVar(), max);
    }

    public void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(30);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(31);
        }
        if (!this.computeMayHaveChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container);
    }

    protected int getBatchSize() {
        return ValueRenderer.getPositiveNumberFromRegistry("cidr.debugger.value.maxChildren", 50);
    }

    private static int getPositiveNumberFromRegistry(@NotNull String key, int defaultValue) {
        int value;
        if (key == null) {
            ValueRenderer.$$$reportNull$$$0(32);
        }
        if ((value = Registry.intValue((String)key, (int)defaultValue)) <= 0) {
            CidrDebuggerLog.LOG.warn(key + " must be a positive number, falling back to default value: " + defaultValue);
            value = defaultValue;
        }
        return value;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(33);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(34);
        }
        LLValue var = this.myValue.getPresentationVar();
        DebuggerDriver.ResultList<LLValue> result = context.getVariableChildren(var, this.getCurrentIndex(), this.getBatchSize());
        this.addChildrenTo(result.list, context, container, this.areChildrenModifiable(var, this.myValue.getPresentationVarData(context)));
        if (result.hasMore) {
            container.tooManyChildren(-1);
        }
    }

    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        if (children == null) {
            ValueRenderer.$$$reportNull$$$0(35);
        }
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(36);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(37);
        }
        SmartList values = new SmartList();
        for (LLValue each : children) {
            if (container.isObsolete()) {
                return;
            }
            values.add(new CidrMemberValue(each, this.myValue, modifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, container);
        this.myCurrentIndex += children.size();
    }

    protected int getCurrentIndex() {
        return this.myCurrentIndex;
    }

    protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(38);
        }
        if (data == null) {
            ValueRenderer.$$$reportNull$$$0(39);
        }
        return !data.isSynthetic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 23: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEvaluationExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortenedType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeValueAndEvaluator";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeFallbackValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildEvaluationExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendConsoleError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShortenedType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeValueAndEvaluator";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDescription";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doComputeFallbackValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFullDescriptionEvaluator";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeMayHaveChildren";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "computeChildrenCount";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildrenCount";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPositiveNumberFromRegistry";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenModifiable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        public ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context) {
            this.myBuilder = builder;
            this.myContext = context;
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            if (children == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(0);
            }
            for (int i = 0; i < children.size(); ++i) {
                String name2 = children.getName(i);
                this.myBuilder.append("\t").append(name2).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children.getValue(i)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DebuggerCommandException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(1);
            }
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(2);
            }
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(4);
            }
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setErrorMessage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

