/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.ipcUtils;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.ipcUtils.POSIX;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;

public class POSIXLibHandle {
    public static final int RTLD_LAZY = 1;
    public static final int RTLD_LOCAL = SystemInfo.isMac ? 4 : 0;
    public static final int RTLD_GLOBAL = SystemInfo.isMac ? 8 : 256;
    private Pointer handle = Pointer.NULL;
    private final File myLib;

    public POSIXLibHandle(File lib) {
        this.myLib = lib;
    }

    public boolean load() {
        if (this.handle == Pointer.NULL) {
            try {
                String canonicalPath = this.myLib.getCanonicalPath();
                this.handle = POSIX.INSTANCE.dlopen(canonicalPath, 1 | RTLD_GLOBAL);
                if (this.handle == Pointer.NULL) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static String dlerror() {
        return POSIX.INSTANCE.dlerror();
    }
}

