/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.ipcUtils;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Producer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.Queue;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtobufServer<T extends GeneratedMessage> {
    private static final Logger LOG = CidrDebuggerLog.LOG;
    private static final Model.Initialized_Message INITIALIZED_MESSAGE = Model.Initialized_Message.getDefaultInstance();
    private static final AtomicInteger ourCount = new AtomicInteger(0);
    private final int myPort;
    private long myDefaultTimeout;
    @NotNull
    private final QueueProcessor<GeneratedMessage> myInboxProcessor;
    @NotNull
    private final QueueProcessor<Pair<GeneratedMessage, Consumer<GeneratedMessage>>> myOutboxProcessor;
    private final Queue<Pair<Consumer, Class>> myResponseHandlers;
    private final Object mySocketLock;
    private final List<Semaphore> myToRelease;
    private final int myUid;
    private final long myInitializationTime;
    private SocketChannel mySocketChannel;
    private ServerSocketChannel myServerSocket;
    private volatile boolean myCancelAcceptAttempts;
    private ProtobufParser<T> myResponseParser;

    public int getPort() {
        return this.myPort;
    }

    private void readerThread(SocketChannel stream) throws IOException {
        try {
            int read2;
            ByteBuffer buffer = ProtobufServer.alloc(66560);
            while ((read2 = stream.read(buffer)) != -1) {
                if (buffer.position() == 0) continue;
                int begin = 0;
                int end = buffer.position();
                buffer.rewind();
                int size = 0;
                while (buffer.position() < end && end - buffer.position() >= 4) {
                    Object compositeResponse;
                    size = buffer.getInt();
                    if (end - buffer.position() < size) break;
                    byte[] array = new byte[size];
                    buffer.get(array);
                    Object finalCompositeResponse = compositeResponse = this.myResponseParser.parse(array);
                    this.debug((Producer<String>)((Producer)() -> "res:" + finalCompositeResponse));
                    GeneratedMessage message = ProtobufServer.unpackComposite(compositeResponse, this.myResponseParser);
                    this.myInboxProcessor.add((Object)message);
                    begin = buffer.position();
                }
                int remaining = end - begin;
                buffer.position(begin);
                byte[] remainingBytes = new byte[remaining];
                buffer.get(remainingBytes);
                if (size > buffer.capacity()) {
                    buffer = ProtobufServer.alloc(size + 4);
                }
                buffer.rewind();
                buffer.put(remainingBytes);
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private static ByteBuffer alloc(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.myDefaultTimeout = defaultTimeout;
    }

    @NotNull
    private static <T extends GeneratedMessage> GeneratedMessage unpackComposite(@NotNull GeneratedMessage compositeResponse, ProtobufParser<T> responseParser) {
        if (compositeResponse == null) {
            ProtobufServer.$$$reportNull$$$0(0);
        }
        if (!responseParser.decompose(compositeResponse)) {
            GeneratedMessage generatedMessage = compositeResponse;
            if (generatedMessage == null) {
                ProtobufServer.$$$reportNull$$$0(1);
            }
            return generatedMessage;
        }
        Map allFields = compositeResponse.getAllFields();
        Collection values = allFields.values();
        assert (values.size() == 1) : "More than 1 message packed in one composite response";
        GeneratedMessage next = (GeneratedMessage)values.iterator().next();
        GeneratedMessage generatedMessage = ProtobufServer.unpackComposite(next, responseParser);
        if (generatedMessage == null) {
            ProtobufServer.$$$reportNull$$$0(2);
        }
        return generatedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSendMessage(@NotNull GeneratedMessage generatedMessage) {
        if (generatedMessage == null) {
            ProtobufServer.$$$reportNull$$$0(3);
        }
        Object object = this.mySocketLock;
        synchronized (object) {
            if (this.mySocketChannel == null) {
                return false;
            }
            byte[] bytes = generatedMessage.toByteArray();
            ByteBuffer buf = ProtobufServer.alloc(bytes.length + 4);
            buf.putInt(bytes.length);
            buf.put(bytes);
            buf.rewind();
            this.debug((Producer<String>)((Producer)() -> {
                if (generatedMessage == null) {
                    ProtobufServer.$$$reportNull$$$0(15);
                }
                return "req(" + (bytes.length + 4) + "): " + generatedMessage;
            }));
            try {
                this.mySocketChannel.write(buf);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
    }

    private void debug(Producer<String> message) {
        if (LOG.isDebugEnabled()) {
            long time = System.currentTimeMillis() - this.myInitializationTime;
            LOG.debug(("[protobuf client " + this.myUid + "] " + time + " " + (String)message.produce()).trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startReaderThread() throws IOException {
        Object object = this.mySocketLock;
        synchronized (object) {
            this.myServerSocket = ServerSocketChannel.open();
            this.myServerSocket.configureBlocking(false);
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            this.myServerSocket.socket().bind(new InetSocketAddress(inetAddress, 0));
            int port = this.myServerSocket.socket().getLocalPort();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    SocketChannel socket;
                    Object object = this.mySocketLock;
                    synchronized (object) {
                        while (this.mySocketChannel == null) {
                            if (this.myCancelAcceptAttempts) {
                                return;
                            }
                            this.mySocketChannel = this.myServerSocket.accept();
                            try {
                                Thread.sleep(5L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        socket = this.mySocketChannel;
                    }
                    this.myInboxProcessor.add((Object)INITIALIZED_MESSAGE);
                    this.readerThread(socket);
                }
                catch (IOException e) {
                    this.handleIOException(e);
                }
            });
            return port;
        }
    }

    protected void handleIOException(IOException e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        this.releaseAll();
        this.myCancelAcceptAttempts = true;
        Object object = this.mySocketLock;
        synchronized (object) {
            try {
                if (this.mySocketChannel != null) {
                    this.mySocketChannel.close();
                }
                if (this.myServerSocket != null) {
                    this.myServerSocket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.mySocketChannel = null;
                this.myServerSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        this.myInboxProcessor.clear();
        this.myOutboxProcessor.clear();
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            for (Semaphore semaphore : this.myToRelease) {
                semaphore.release();
            }
        }
    }

    public ProtobufServer(@NotNull Consumer<GeneratedMessage> inboxConsumer, ProtobufParser<T> responseParser) throws IOException {
        if (inboxConsumer == null) {
            ProtobufServer.$$$reportNull$$$0(4);
        }
        this.myDefaultTimeout = 30000L;
        this.myResponseHandlers = new Queue(100);
        this.mySocketLock = new Object();
        this.myToRelease = new ArrayList<Semaphore>();
        this.myUid = ourCount.incrementAndGet();
        this.myInitializationTime = System.currentTimeMillis();
        this.myResponseParser = responseParser;
        this.myInboxProcessor = new QueueProcessor(generatedMessage -> {
            if (inboxConsumer == null) {
                ProtobufServer.$$$reportNull$$$0(14);
            }
            Queue<Pair<Consumer, Class>> queue = this.myResponseHandlers;
            synchronized (queue) {
                Pair responseHandler;
                Pair pair2 = responseHandler = this.myResponseHandlers.isEmpty() ? null : (Pair)this.myResponseHandlers.peekFirst();
                if (responseHandler != null && responseHandler.second == generatedMessage.getClass()) {
                    ((Consumer)responseHandler.first).consume(generatedMessage);
                    this.myResponseHandlers.pullFirst();
                    return;
                }
            }
            inboxConsumer.consume(generatedMessage);
        }, Conditions.alwaysFalse());
        this.myOutboxProcessor = new QueueProcessor(pair2 -> {
            boolean result = this.doSendMessage((GeneratedMessage)pair2.first);
            if (pair2.second != null) {
                ((Consumer)pair2.second).consume(result ? (GeneratedMessage)pair2.first : null);
            }
        }, Conditions.alwaysFalse());
        this.myPort = this.startReaderThread();
    }

    public <T extends GeneratedMessage> void sendMessageAndWaitUntilSent(GeneratedMessage request, @Nullable Class<T> responseClass, @Nullable Consumer<T> responseHandler) throws ProtobufTimedOutException {
        this.sendMessageAndWaitUntilSent(request, responseClass, responseHandler, this.myDefaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends GeneratedMessage> void sendMessageAndWaitUntilSent(GeneratedMessage request, @Nullable Class<T> responseClass, @Nullable Consumer<T> responseHandler, long msTimeout) throws ProtobufTimedOutException {
        Semaphore semaphore = new Semaphore(0);
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            this.myToRelease.add(semaphore);
        }
        this.sendMessage(request, responseClass, responseHandler, (Consumer<GeneratedMessage>)((Consumer)generatedMessage -> semaphore.release()));
        try {
            if (!semaphore.tryAcquire(msTimeout, TimeUnit.MILLISECONDS)) {
                throw new ProtobufTimedOutException();
            }
        }
        catch (InterruptedException interruptedException) {
            List<Semaphore> list2 = this.myToRelease;
            synchronized (list2) {
                this.myToRelease.remove(semaphore);
            }
        }
        finally {
            list = this.myToRelease;
            synchronized (list) {
                this.myToRelease.remove(semaphore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResponseType extends GeneratedMessage> void sendMessage(@NotNull GeneratedMessage message, @Nullable Class<ResponseType> responseClass, @Nullable Consumer<ResponseType> responseHandler, @Nullable Consumer<GeneratedMessage> sendHandler) {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(5);
        }
        if (responseClass != null && responseHandler != null) {
            Queue<Pair<Consumer, Class>> queue = this.myResponseHandlers;
            synchronized (queue) {
                this.myResponseHandlers.addLast((Object)new Pair(responseHandler, responseClass));
            }
        }
        this.myOutboxProcessor.add((Object)Pair.create((Object)message, sendHandler));
    }

    public <ResponseType extends GeneratedMessage> void sendMessage(@NotNull GeneratedMessage message, @Nullable Class<ResponseType> responseClass, @Nullable Consumer<ResponseType> responseHandler) {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(6);
        }
        this.sendMessage(message, responseClass, responseHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResponseType extends GeneratedMessage> void sendMessageAndWaitForReply(@NotNull GeneratedMessage message, @NotNull Class<ResponseType> responseClass, @NotNull Consumer<ResponseType> responseHandler, long msTimeout) throws ProtobufTimedOutException, ExecutionFinishedException {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(7);
        }
        if (responseClass == null) {
            ProtobufServer.$$$reportNull$$$0(8);
        }
        if (responseHandler == null) {
            ProtobufServer.$$$reportNull$$$0(9);
        }
        Semaphore semaphore = new Semaphore(0);
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            this.myToRelease.add(semaphore);
        }
        boolean[] abandoned = new boolean[]{false};
        boolean[] failedToSend = new boolean[]{false};
        Object object = this.myResponseHandlers;
        synchronized (object) {
            this.myResponseHandlers.addLast((Object)Pair.create(t -> {
                if (responseHandler == null) {
                    ProtobufServer.$$$reportNull$$$0(13);
                }
                if (!abandoned[0]) {
                    responseHandler.consume((Object)((GeneratedMessage)t));
                }
                semaphore.release();
            }, responseClass));
        }
        this.myOutboxProcessor.add((Object)new Pair((Object)message, generatedMessage -> {
            if (generatedMessage == null) {
                failedToSend[0] = true;
                semaphore.release();
            }
        }));
        try {
            if (msTimeout > 0L) {
                if (!semaphore.tryAcquire(msTimeout, TimeUnit.MILLISECONDS)) {
                    abandoned[0] = true;
                    throw new ProtobufTimedOutException();
                }
            } else {
                semaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            abandoned[0] = true;
        }
        finally {
            List<Semaphore> list2 = this.myToRelease;
            synchronized (list2) {
                this.myToRelease.remove(semaphore);
            }
        }
        if (failedToSend[0]) {
            throw new ExecutionFinishedException();
        }
    }

    public <T extends GeneratedMessage> void sendMessageAndWaitForReply(@NotNull GeneratedMessage message, @NotNull Class<T> responseClass, @NotNull Consumer<T> responseHandler) throws ProtobufTimedOutException, ExecutionFinishedException {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(10);
        }
        if (responseClass == null) {
            ProtobufServer.$$$reportNull$$$0(11);
        }
        if (responseHandler == null) {
            ProtobufServer.$$$reportNull$$$0(12);
        }
        this.sendMessageAndWaitForReply(message, responseClass, responseHandler, 0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeResponse";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/ipcUtils/ProtobufServer";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMessage";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inboxConsumer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseClass";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/ipcUtils/ProtobufServer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackComposite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unpackComposite";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSendMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sendMessage";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sendMessageAndWaitForReply";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sendMessageAndWaitForReply$6";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSendMessage$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProtobufParser<T extends GeneratedMessage> {
        public T parse(byte[] var1) throws IOException;

        public boolean decompose(GeneratedMessage var1);
    }
}

